/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4hGe
 */

// forked from fakestar0826's WireFrame
package {
    import flash.media.Video;
    import flash.geom.Matrix3D;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.geom.Vector3D;
    import flash.display.Graphics;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var sp:Sprite;
        private var gr:Graphics;
        private var vertices:Vector.<Vector3D>;
        private var vertices2D:Vector.<Point>;
        private var indices:Vector.<Vector.<uint>>;
        
        private var nUnit:Number = 50;
        private var nD:Number = 0.3;
        private var nF:Number = nUnit * 10;
        
        private var view:Vector3D = new Vector3D(0, 0, 1);
        public function FlashTest() {
            // write as3 code here..
            vertices = new Vector.<Vector3D>();
            indices = new Vector.<Vector.<uint>>();
            
            sp = new Sprite();
            gr = sp.graphics;
            addChild(sp);
            sp.x = stage.stageWidth / 2;
            sp.y = stage.stageHeight / 2;
            
            vertices.push(new Vector3D(-nUnit, -nUnit, 0));
            vertices.push(new Vector3D(nUnit, -nUnit, 0));
            vertices.push(new Vector3D(nUnit, nUnit, 0));
            vertices.push(new Vector3D(-nUnit, nUnit, 0));
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void
        {
            var nR:Number = sp.mouseX * nD;
            
            xTransform(vertices, nR);
            var bF:Boolean = xIsFront(vertices, view);
            var v2D:Vector.<Point> = xGetVertices2D(vertices);
            xDrawLines(v2D, bF);
        }
        
        private function xIsFront(v:Vector.<Vector3D>, myV:Vector3D):Boolean
        {
            var v0:Vector3D = v[0];
            var v1:Vector3D = v[1];
            var v2:Vector3D = v[2];
            var v01:Vector3D = v1.subtract(v0);
            var v02:Vector3D = v2.subtract(v0);
            var d:Vector3D = v02.crossProduct(v01);
            d.normalize();
            var bF:Boolean = (d.dotProduct(myV) < 0);
            return bF;
        }

        private function xTransform(v:Vector.<Vector3D>, r:Number):void
        {
            var nL:uint = v.length;
            var m3D:Matrix3D = new Matrix3D();
            m3D.appendRotation(r, Vector3D.Y_AXIS);
            for(var i:uint = 0;i < nL;i++)
            {
                v[i] = m3D.transformVector(v[i]);
            }

        }


        private function xGetVertices2D(v:Vector.<Vector3D>):Vector.<Point>
        {
            var v2D:Vector.<Point> = new Vector.<Point>();
            var nLength:uint = v.length;
            for(var i:uint = 0;i < nLength;i++)
            {
                var v3D:Vector3D = v[i].clone();
                v3D.w = (nF + v3D.z) / nF;
                v3D.project();
                v2D.push(new Point(v3D.x, v3D.y));
            }
            
            return v2D;

        }
        
        private function xDrawLines(v2D:Vector.<Point>, bF:Boolean):void
        {
            var nL:uint = v2D.length;
            var p:Point = v2D[nL - 1];
            var nC:uint = bF ? 0x00FFFF:0x0000FF;
            
            if(nL < 3)
            {
                --nL;
            }
            
            gr.clear();
            gr.beginFill(nC);
            gr.lineStyle(2, 0);
            gr.moveTo(p.x, p.y);
            for(var i:uint = 0;i < nL;i++)
            {
                p = v2D[i];
                gr.lineTo(p.x, p.y);
            }
            gr.endFill();
        }


    }
}