/**
 * Copyright Hakuhin ( http://wonderfl.net/user/Hakuhin )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4hCw
 */

// -------------------------------------------------
//
// ハッチング風フィルタ
// 
// 画像はぼっさん。
// ラップで手書き風なテクスチャを用意するのが少々手間です。
//
// -------------------------------------------------
package {
	import flash.events.*;
	import flash.display.*;
	import flash.net.*;
	import flash.text.*;
	import flash.utils.*;
	import flash.system.*;
	import flash.geom.*;
	import flash.filters.*;
	import flash.ui.*;
	import flash.media.*;

    public class Main extends Sprite {
        public function Main() {

        
// -------------------------------------------------
// コンストラクタ
// -------------------------------------------------

// フレームレート
stage.frameRate = 30;

// 100%表示
stage.scaleMode = StageScaleMode.NO_SCALE;

// 左上
stage.align = StageAlign.TOP_LEFT;
stage.align = "TL";

// スプライトを作成
var sprite:Sprite = new Sprite();
addChild(sprite);

// 画像のURL
var graphic_url:Array = [
	"http://assets.wonderfl.net/images/related_images/c/ce/ce8e/ce8e6b4743d24cd4049a740967c9181c04e954df",
];

// リソース読み込み開始
load(load_complete_func,graphic_url);

// 読み込み終了
function load_complete_func():void{
	// 初期化へ
	init();
}

// リソースを格納する入れ物
var bitmap_container : Array = new Array();


// -------------------------------------------------
// 読み込み
// -------------------------------------------------
function load(complete_func:Function,url_array:Array):void{

	// URLを取り出す
	var url : String = url_array.shift();

	// URLが無くなればコールバック関数を呼び出して終了
	if(!url){
		// 読み込み終了
		complete_func();
		return;
	}

	// ローダー
	var loader_obj : Loader = new Loader();

	// 読み込み開始
	loader_obj.load(new URLRequest(url));

	// 読み込み終了
	var info : LoaderInfo = loader_obj.contentLoaderInfo;
	info.addEventListener (Event.INIT,LoaderInfoInitFunc);
	function LoaderInfoInitFunc (event : Event):void {

		// メモリからインスタンス化
		var loader_memory : Loader = new Loader();
		loader_memory.contentLoaderInfo.addEventListener (Event.COMPLETE,LoaderInfoCompleteFunc);
		function LoaderInfoCompleteFunc (event : Event):void {

			// キャプチャ
			var bmp : BitmapData = new BitmapData(loader_memory.width,loader_memory.height,true,0);
			stage.addChild(loader_memory);
			bmp.draw(stage);
			stage.removeChild(loader_memory);
	
			// コンテナに格納
			bitmap_container.push(bmp);
  
			// 再帰読み込み
			load(complete_func,url_array);
		}
		
		// 読み込み開始
		loader_memory.loadBytes(loader_obj.contentLoaderInfo.bytes);
	}
}


// -------------------------------------------------
// 初期化
// -------------------------------------------------
function init():void{

	// 画像のURL
	var url:String = "http://assets.wonderfl.net/images/related_images/7/72/7281/7281a430543f0d175158a9bee2b55d2829919f68";

	// ステージサイズ
	var w:uint;
	var h:uint;
	
	// ローダー作成
	var loader_obj : Loader = new Loader();
	var info : LoaderInfo = loader_obj.contentLoaderInfo;
	addChild(loader_obj);
	
	// 読み込み完了
	info.addEventListener (Event.INIT,LoaderInfoInitFunc);
	function LoaderInfoInitFunc (event : Event):void {
		ResizeFunc(null);
	}


	// 読み込み開始
	load(url);

	// リザルト作成
	var result : Sprite = new Sprite();
	addChild(result);
	result.x = 0;

	// ボタン作成
	var button:Button = new Button(stage);
	button.y = 70;
	button.setSize(60,20);
	button.setLabel("開く");
	result.addChild(button);

	// ボタンが押された
	button.addEventListener(MouseEvent.CLICK,function(e:MouseEvent):void{
		load(text.text);
	});
	
	function load(url:String):void{

		// 読み込み
		loader_obj.load(new URLRequest(url));
	}


	// テキストフィールド作成
	var ft_result:TextField = new TextField();
	ft_result.x = 10;
	ft_result.y = 50;
	ft_result.width = 300;
	ft_result.height = 20;
	ft_result.selectable = false;

	// 書式
	var format_result:TextFormat = new TextFormat();
	format_result.font = "ＭＳ ゴシック";	// フォント名
	ft_result.defaultTextFormat = format_result;

	// テキスト表示
	result.addChild(ft_result);

	// 読み込み状況
	addEventListener (Event.ENTER_FRAME,EnterFrameFunc);
	function EnterFrameFunc (event : Event) :void{
		ft_result.text = "読込:" + info.bytesLoaded + " / 全体:" + info.bytesTotal;
	}

	// テキストフィールド作成
	var text:TextField = new TextField();
	text.x = 10;
	text.y = 70;
	text.height = 20;
	text.type = TextFieldType.INPUT;
	text.border = true;

	// 書式
	var format:TextFormat = new TextFormat();
	format.font = "ＭＳ ゴシック";	// フォント名
	text.defaultTextFormat = format;

	// テキスト表示
	text.text = url;
	result.addChild(text);
	
	// 境界線用ラジオボタン
	var radio_outline_off:RadioButton = new RadioButton(stage);
	result.addChild(radio_outline_off);
	radio_outline_off.setLabel("境界線なし");
	radio_outline_off.x = 0;
	radio_outline_off.y = 4;
	radio_outline_off.setSize(100,18);
	radio_outline_off.onClick(function(obj:RadioButton):void{outline = false;});

	var radio_outline_on:RadioButton = new RadioButton(stage);
	result.addChild(radio_outline_on);
	radio_outline_on.setLabel("境界線あり");
	radio_outline_on.x = 0;
	radio_outline_on.y = 22;
	radio_outline_on.setSize(100,18);
	radio_outline_on.onClick(function(obj:RadioButton):void{outline = true;});

	// ラジオボタンを関連付け
	radio_outline_on.attachGroup(radio_outline_off);
	radio_outline_off.select();

	// ノックアウト用ラジオボタン
	var radio_knockout_off:RadioButton = new RadioButton(stage);
	result.addChild(radio_knockout_off);
	radio_knockout_off.setLabel("ノックアウトなし");
	radio_knockout_off.x = 0;
	radio_knockout_off.y = 4;
	radio_knockout_off.setSize(140,18);
	radio_knockout_off.onClick(function(obj:RadioButton):void{knockout = false;});

	var radio_knockout_on:RadioButton = new RadioButton(stage);
	result.addChild(radio_knockout_on);
	radio_knockout_on.setLabel("ノックアウトあり");
	radio_knockout_on.x = 0;
	radio_knockout_on.y = 22;
	radio_knockout_on.setSize(140,18);
	radio_knockout_on.onClick(function(obj:RadioButton):void{knockout = true;});

	// ラジオボタンを関連付け
	radio_knockout_on.attachGroup(radio_knockout_off);
	radio_knockout_on.select();
	
	
	// リサイズ時にフィット
	stage.addEventListener(Event.RESIZE,ResizeFunc);
	function ResizeFunc(e:Event):void{
		w = stage.stageWidth;
		h = stage.stageHeight;
		loader_obj.width = w;
		loader_obj.height = h - 100;

		result.y = h - 100;
	
		// テキストフィールド位置
		text.width = w - 10 - 10 - button.width - 10;
	
		// ボタン位置
		button.x = w - button.width - 10;
		
		// ラジオボタン位置
		radio_knockout_off.x = w - 140;
		radio_knockout_on.x = w - 140;
		radio_outline_off.x = w - 240;
		radio_outline_on.x = w - 240;
	}
	ResizeFunc(null);

	// シェーダバイトコード
	var binary : ByteArray = CustomFilterGetByteArray();
	
	// シェーダ作成
	var shader:Shader = new Shader();
	shader.byteCode = binary;
	var filter:ShaderFilter = new ShaderFilter(shader); 

	// パラメータアクセス用
	var data : ShaderData  = shader.data;
	var param : ShaderParameter;
	var input : ShaderInput;

	// パラメータ
	var coefficient:Number = 0.2;		// 線の係数
	var bits_per_pixel:Number = 8;		// 色深度
	var average_multiplier:Number = 1.0;	// 平均カラーの乗算成分
	var average_offset:Number = 0.0;	// 平均カラーの加算成分
	var knockout:Boolean;			// ノックアウト
	var outline:Boolean;				// 境界線
	var filter_enable:Boolean = true;

	addEventListener(Event.ENTER_FRAME,function(e:Event):void{
		if(!filter_enable){
			loader_obj.filters = null;
			return;
		}
		
		// 画像ソース
		input = data.texture;
		input.input = bitmap_container[0];
		
		// 座標
		param = data.position;
		param.value = [-stage.mouseX,-stage.mouseY];

		// 平均カラーの乗算成分
		param = data.average_multiplier;
		param.value = [average_multiplier];
		
		// 平均カラーの加算成分
		param = data.average_offset;
		param.value = [average_offset];
		
		// 線の係数
		param = data.coefficient;
		if(outline)	param.value = [coefficient];
		else			param.value = [0.0];
		
		// 色深度
		param = data.bits_per_pixel;
		param.value = [bits_per_pixel];

		// ノックアウト
		param = data.knockout;
		param.value = [Number(knockout)];

		// 適応
		loader_obj.filters = [filter];
	});
	
	// テキスト表示
	var tf : TextField = new TextField();
	tf.x = 5;
	tf.y = 5;
	tf.width = 280;
	tf.height = 30;
	tf.border = true;
	tf.background = true;
	tf.alpha = 0.9;
	
	// 書式
	format = new TextFormat();
	format.font = "ＭＳ ゴシック";
	tf.defaultTextFormat = format;

	addChild(tf);
	addEventListener(Event.ENTER_FRAME,function(e:Event):void{
		var str:String = "";
		str += "平均カラーの乗算成分:" + Math.floor(average_multiplier * 100)/100 + "　(1,2キーで変更)\n";
		str += "平均カラーの加算成分:" + Math.floor(average_offset * 100)/100 + "　(3,4キーで変更)\n";

		tf.text = str;
	});
	
	// キー操作
	stage.addEventListener(KeyboardEvent.KEY_DOWN, KeyDown);
	function KeyDown(event:KeyboardEvent):void{
		if(event.keyCode == 49)		average_multiplier -= 0.01;
		if(event.keyCode == 50)		average_multiplier += 0.01;
		if(event.keyCode == 51)		average_offset -= 0.01;
		if(event.keyCode == 52)		average_offset += 0.01;

		if(average_multiplier < -2)	average_multiplier = -2;
		if(average_multiplier >  2)	average_multiplier =  2;
		if(average_offset < -2)		average_offset = -2;
		if(average_offset >  2)		average_offset =  2;
	};
	
	// マウス操作
	loader_obj.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void{
		if(filter_enable)	filter_enable = false;
		else					filter_enable = true;
	});

}



// -------------------------------------------------
// シェーダバイトコード
// -------------------------------------------------
function CustomFilterGetByteArray():ByteArray{

	var a:ByteArray = new ByteArray();
	var f:Function;

	f = a.writeUnsignedInt;
	f(0xa5010000); f(0x00a40e00); f(0x48617463); f(0x68696e67); 
	f(0x46696c74); f(0x6572a00c); f(0x6e616d65); f(0x73706163); 
	f(0x65006861); f(0x74636869); f(0x6e6700a0); f(0x0c76656e); 
	f(0x646f7200); f(0x48616b75); f(0x68696e00); f(0xa0087665); 
	f(0x7273696f); f(0x6e000100); f(0xa00c6465); f(0x73637269); 
	f(0x7074696f); f(0x6e00836e); f(0x83628360); f(0x8393834f); 
	f(0x83748342); f(0x838b835e); f(0x00a10102); f(0x00000c5f); 
	f(0x4f757443); f(0x6f6f7264); f(0x00a30004); f(0x73726300); 
	f(0xa3010474); f(0x65787475); f(0x726500a1); f(0x02040100); 
	f(0x0f647374); f(0x00a10101); f(0x00000277); f(0x69647468); 
	f(0x00a2016d); f(0x696e5661); f(0x6c756500); f(0x3f800000); 
	f(0xa2016465); f(0x6661756c); f(0x7456616c); f(0x75650042); 
	f(0x800000a2); f(0x0c646573); f(0x63726970); f(0x74696f6e); 
	f(0x00836e83); f(0x62836083); f(0x93834f82); f(0xcc959d00); 
	f(0xa1010100); f(0x00016865); f(0x69676874); f(0x00a2016d); 
	f(0x696e5661); f(0x6c756500); f(0x3f800000); f(0xa2016465); 
	f(0x6661756c); f(0x7456616c); f(0x75650042); f(0x800000a2); 
	f(0x0c646573); f(0x63726970); f(0x74696f6e); f(0x00836e83); 
	f(0x62836083); f(0x93834f82); f(0xcc8d8282); f(0xb300a101); 
	f(0x01020008); f(0x62697473); f(0x5f706572); f(0x5f706978); 
	f(0x656c00a2); f(0x016d696e); f(0x56616c75); f(0x65003f80); 
	f(0x0000a201); f(0x6d617856); f(0x616c7565); f(0x00438000); 
	f(0x00a20164); f(0x65666175); f(0x6c745661); f(0x6c756500); 
	f(0x41000000); f(0xa20c6465); f(0x73637269); f(0x7074696f); 
	f(0x6e009046); f(0x905b9378); f(0x8169836e); f(0x83628360); 
	f(0x8393834f); f(0x82cc9094); f(0x816a00a1); f(0x01020200); 
	f(0x06706f73); f(0x6974696f); f(0x6e00a202); f(0x64656661); 
	f(0x756c7456); f(0x616c7565); f(0x00000000); f(0x00000000); 
	f(0x00a20c64); f(0x65736372); f(0x69707469); f(0x6f6e0083); 
	f(0x65834e83); f(0x58836083); f(0x8382cc8d); f(0xc0955700); 
	f(0xa1010102); f(0x00016176); f(0x65726167); f(0x655f6d75); 
	f(0x6c746970); f(0x6c696572); f(0x00a20164); f(0x65666175); 
	f(0x6c745661); f(0x6c756500); f(0x3f800000); f(0xa20c6465); 
	f(0x73637269); f(0x7074696f); f(0x6e0095bd); f(0x8bcf834a); 
	f(0x8389815b); f(0x82cc8fe6); f(0x8e5a90ac); f(0x95aa00a1); 
	f(0x01010300); f(0x08617665); f(0x72616765); f(0x5f6f6666); 
	f(0x73657400); f(0xa2016465); f(0x6661756c); f(0x7456616c); 
	f(0x75650000); f(0x000000a2); f(0x0c646573); f(0x63726970); 
	f(0x74696f6e); f(0x0095bd8b); f(0xcf834a83); f(0x89815b82); 
	f(0xcc89c18e); f(0x5a90ac95); f(0xaa00a101); f(0x0404000f); 
	f(0x636f6c6f); f(0x725f6c69); f(0x6e6500a2); f(0x04646566); 
	f(0x61756c74); f(0x56616c75); f(0x65000000); f(0x00000000); 
	f(0x00000000); f(0x00003f80); f(0x0000a20c); f(0x64657363); 
	f(0x72697074); f(0x696f6e00); f(0x90fc82cc); f(0x904600a1); 
	f(0x01010300); f(0x04636f65); f(0x66666963); f(0x69656e74); 
	f(0x00a2016d); f(0x696e5661); f(0x6c756500); f(0x00000000); 
	f(0xa2016d61); f(0x7856616c); f(0x7565003f); f(0x800000a2); 
	f(0x01646566); f(0x61756c74); f(0x56616c75); f(0x65003f00); 
	f(0x0000a20c); f(0x64657363); f(0x72697074); f(0x696f6e00); 
	f(0x90fc82cc); f(0x8c579094); f(0x00a1010d); f(0x0180086b); 
	f(0x6e6f636b); f(0x6f757400); f(0xa20d6465); f(0x6661756c); 
	f(0x7456616c); f(0x75650000); f(0x00a20c64); f(0x65736372); 
	f(0x69707469); f(0x6f6e0083); f(0x6d836283); f(0x4e834183); 
	f(0x45836700); f(0x1d030031); f(0x00001000); f(0x32050080); 
	f(0x3f800000); f(0x1d050040); f(0x02000000); f(0x02050040); 
	f(0x05000000); f(0x1d050080); f(0x05004000); f(0x32050040); 
	f(0x00000000); f(0x32050020); f(0x00000000); f(0x300600f1); 
	f(0x0300b000); f(0x1d0700f3); f(0x06001b00); f(0x1d0600f3); 
	f(0x07001b00); f(0x030600f3); f(0x0200ff00); f(0x1d0800f3); 
	f(0x06001b00); f(0x010800f3); f(0x03000000); f(0x1d0600f3); 
	f(0x08001b00); f(0x1d050010); f(0x06000000); f(0x01050010); 
	f(0x06004000); f(0x1d080080); f(0x0500c000); f(0x01080080); 
	f(0x06008000); f(0x32050010); f(0x40400000); f(0x04080040); 
	f(0x0500c000); f(0x03080040); f(0x08000000); f(0x1d050010); 
	f(0x08004000); f(0x1d080080); f(0x0500c000); f(0x03080080); 
	f(0x02000000); f(0x1a080040); f(0x08000000); f(0x1d080080); 
	f(0x08004000); f(0x2a050080); f(0x08000000); f(0x1d018040); 
	f(0x00800000); f(0x34000000); f(0x01804000); f(0x1d080080); 
	f(0x05000000); f(0x36000000); f(0x00000000); f(0x32080040); 
	f(0x3f800000); f(0x02030010); f(0x08004000); f(0x300900f1); 
	f(0x0300b000); f(0x1d0600f3); f(0x09001b00); f(0x1d0900f3); 
	f(0x06001b00); f(0x030900f3); f(0x0200ff00); f(0x1d0a00f3); 
	f(0x09001b00); f(0x010a00f3); f(0x03000000); f(0x1d0600f3); 
	f(0x0a001b00); f(0x1d080040); f(0x06000000); f(0x01080040); 
	f(0x06004000); f(0x1d080020); f(0x08004000); f(0x01080020); 
	f(0x06008000); f(0x32080040); f(0x40400000); f(0x04080010); 
	f(0x08004000); f(0x03080010); f(0x08008000); f(0x1d050010); 
	f(0x0800c000); f(0x1d080040); f(0x0500c000); f(0x03080040); 
	f(0x02000000); f(0x1a080020); f(0x08004000); f(0x1d050010); 
	f(0x08008000); f(0x2a050080); f(0x0500c000); f(0x1d018040); 
	f(0x00800000); f(0x34000000); f(0x01804000); f(0x1d050010); 
	f(0x05000000); f(0x36000000); f(0x00000000); f(0x2a080080); 
	f(0x0500c000); f(0x1d018040); f(0x00800000); f(0x34000000); 
	f(0x01804000); f(0x32080040); f(0x3f800000); f(0x1d080020); 
	f(0x05004000); f(0x01050040); f(0x08004000); f(0x36000000); 
	f(0x00000000); f(0x32080040); f(0x3f800000); f(0x01030020); 
	f(0x08004000); f(0x300900f1); f(0x0300b000); f(0x1d0600f3); 
	f(0x09001b00); f(0x1d0900f3); f(0x06001b00); f(0x030900f3); 
	f(0x0200ff00); f(0x1d0a00f3); f(0x09001b00); f(0x010a00f3); 
	f(0x03000000); f(0x1d0600f3); f(0x0a001b00); f(0x1d080040); 
	f(0x06000000); f(0x01080040); f(0x06004000); f(0x1d080020); 
	f(0x08004000); f(0x01080020); f(0x06008000); f(0x32080040); 
	f(0x40400000); f(0x04080010); f(0x08004000); f(0x03080010); 
	f(0x08008000); f(0x1d050010); f(0x0800c000); f(0x1d080040); 
	f(0x0500c000); f(0x03080040); f(0x02000000); f(0x1a080020); 
	f(0x08004000); f(0x1d050010); f(0x08008000); f(0x2a050080); 
	f(0x0500c000); f(0x1d018040); f(0x00800000); f(0x34000000); 
	f(0x01804000); f(0x1d050010); f(0x05000000); f(0x36000000); 
	f(0x00000000); f(0x2a080080); f(0x0500c000); f(0x1d018040); 
	f(0x00800000); f(0x34000000); f(0x01804000); f(0x32080040); 
	f(0x3f800000); f(0x1d080020); f(0x05008000); f(0x01050020); 
	f(0x08004000); f(0x36000000); f(0x00000000); f(0x32080040); 
	f(0x3f800000); f(0x01030010); f(0x08004000); f(0x300900f1); 
	f(0x0300b000); f(0x1d0600f3); f(0x09001b00); f(0x1d0900f3); 
	f(0x06001b00); f(0x030900f3); f(0x0200ff00); f(0x1d0a00f3); 
	f(0x09001b00); f(0x010a00f3); f(0x03000000); f(0x1d0600f3); 
	f(0x0a001b00); f(0x1d080040); f(0x06000000); f(0x01080040); 
	f(0x06004000); f(0x1d080020); f(0x08004000); f(0x01080020); 
	f(0x06008000); f(0x32080040); f(0x40400000); f(0x04080010); 
	f(0x08004000); f(0x03080010); f(0x08008000); f(0x1d050010); 
	f(0x0800c000); f(0x1d080040); f(0x0500c000); f(0x03080040); 
	f(0x02000000); f(0x1a080020); f(0x08004000); f(0x1d050010); 
	f(0x08008000); f(0x2a050080); f(0x0500c000); f(0x1d018040); 
	f(0x00800000); f(0x34000000); f(0x01804000); f(0x1d050010); 
	f(0x05000000); f(0x36000000); f(0x00000000); f(0x2a080080); 
	f(0x0500c000); f(0x1d018040); f(0x00800000); f(0x34000000); 
	f(0x01804000); f(0x32080040); f(0x3f800000); f(0x1d080020); 
	f(0x05004000); f(0x01050040); f(0x08004000); f(0x36000000); 
	f(0x00000000); f(0x32080040); f(0x3f800000); f(0x01030010); 
	f(0x08004000); f(0x300900f1); f(0x0300b000); f(0x1d0600f3); 
	f(0x09001b00); f(0x1d0900f3); f(0x06001b00); f(0x030900f3); 
	f(0x0200ff00); f(0x1d0a00f3); f(0x09001b00); f(0x010a00f3); 
	f(0x03000000); f(0x1d0600f3); f(0x0a001b00); f(0x1d080040); 
	f(0x06000000); f(0x01080040); f(0x06004000); f(0x1d080020); 
	f(0x08004000); f(0x01080020); f(0x06008000); f(0x32080040); 
	f(0x40400000); f(0x04080010); f(0x08004000); f(0x03080010); 
	f(0x08008000); f(0x1d050010); f(0x0800c000); f(0x1d080040); 
	f(0x0500c000); f(0x03080040); f(0x02000000); f(0x1a080020); 
	f(0x08004000); f(0x1d050010); f(0x08008000); f(0x2a050080); 
	f(0x0500c000); f(0x1d018040); f(0x00800000); f(0x34000000); 
	f(0x01804000); f(0x1d050010); f(0x05000000); f(0x36000000); 
	f(0x00000000); f(0x2a080080); f(0x0500c000); f(0x1d018040); 
	f(0x00800000); f(0x34000000); f(0x01804000); f(0x32080040); 
	f(0x3f800000); f(0x1d080020); f(0x05008000); f(0x01050020); 
	f(0x08004000); f(0x36000000); f(0x00000000); f(0x32080040); 
	f(0x3f800000); f(0x02030020); f(0x08004000); f(0x300900f1); 
	f(0x0300b000); f(0x1d0600f3); f(0x09001b00); f(0x1d0900f3); 
	f(0x06001b00); f(0x030900f3); f(0x0200ff00); f(0x1d0a00f3); 
	f(0x09001b00); f(0x010a00f3); f(0x03000000); f(0x1d0600f3); 
	f(0x0a001b00); f(0x1d080040); f(0x06000000); f(0x01080040); 
	f(0x06004000); f(0x1d080020); f(0x08004000); f(0x01080020); 
	f(0x06008000); f(0x32080040); f(0x40400000); f(0x04080010); 
	f(0x08004000); f(0x03080010); f(0x08008000); f(0x1d050010); 
	f(0x0800c000); f(0x1d080040); f(0x0500c000); f(0x03080040); 
	f(0x02000000); f(0x1a080020); f(0x08004000); f(0x1d050010); 
	f(0x08008000); f(0x2a050080); f(0x0500c000); f(0x1d018040); 
	f(0x00800000); f(0x34000000); f(0x01804000); f(0x1d050010); 
	f(0x05000000); f(0x36000000); f(0x00000000); f(0x2a080080); 
	f(0x0500c000); f(0x1d018040); f(0x00800000); f(0x34000000); 
	f(0x01804000); f(0x32080040); f(0x3f800000); f(0x1d080020); 
	f(0x05004000); f(0x01050040); f(0x08004000); f(0x36000000); 
	f(0x00000000); f(0x32080040); f(0x3f800000); f(0x02030020); 
	f(0x08004000); f(0x300900f1); f(0x0300b000); f(0x1d0600f3); 
	f(0x09001b00); f(0x1d0900f3); f(0x06001b00); f(0x030900f3); 
	f(0x0200ff00); f(0x1d0a00f3); f(0x09001b00); f(0x010a00f3); 
	f(0x03000000); f(0x1d0600f3); f(0x0a001b00); f(0x1d080040); 
	f(0x06000000); f(0x01080040); f(0x06004000); f(0x1d080020); 
	f(0x08004000); f(0x01080020); f(0x06008000); f(0x32080040); 
	f(0x40400000); f(0x04080010); f(0x08004000); f(0x03080010); 
	f(0x08008000); f(0x1d050010); f(0x0800c000); f(0x1d080040); 
	f(0x0500c000); f(0x03080040); f(0x02000000); f(0x1a080020); 
	f(0x08004000); f(0x1d050010); f(0x08008000); f(0x2a050080); 
	f(0x0500c000); f(0x1d018040); f(0x00800000); f(0x34000000); 
	f(0x01804000); f(0x1d050010); f(0x05000000); f(0x36000000); 
	f(0x00000000); f(0x2a080080); f(0x0500c000); f(0x1d018040); 
	f(0x00800000); f(0x34000000); f(0x01804000); f(0x32080040); 
	f(0x3f800000); f(0x1d080020); f(0x05008000); f(0x01050020); 
	f(0x08004000); f(0x36000000); f(0x00000000); f(0x32080040); 
	f(0x3f800000); f(0x02030010); f(0x08004000); f(0x300900f1); 
	f(0x0300b000); f(0x1d0600f3); f(0x09001b00); f(0x1d0900f3); 
	f(0x06001b00); f(0x030900f3); f(0x0200ff00); f(0x1d0a00f3); 
	f(0x09001b00); f(0x010a00f3); f(0x03000000); f(0x1d0600f3); 
	f(0x0a001b00); f(0x1d080040); f(0x06000000); f(0x01080040); 
	f(0x06004000); f(0x1d080020); f(0x08004000); f(0x01080020); 
	f(0x06008000); f(0x32080040); f(0x40400000); f(0x04080010); 
	f(0x08004000); f(0x03080010); f(0x08008000); f(0x1d050010); 
	f(0x0800c000); f(0x1d080040); f(0x0500c000); f(0x03080040); 
	f(0x02000000); f(0x1a080020); f(0x08004000); f(0x1d050010); 
	f(0x08008000); f(0x2a050080); f(0x0500c000); f(0x1d018040); 
	f(0x00800000); f(0x34000000); f(0x01804000); f(0x1d050010); 
	f(0x05000000); f(0x36000000); f(0x00000000); f(0x2a080080); 
	f(0x0500c000); f(0x1d018040); f(0x00800000); f(0x34000000); 
	f(0x01804000); f(0x32080040); f(0x3f800000); f(0x1d080020); 
	f(0x05004000); f(0x01050040); f(0x08004000); f(0x36000000); 
	f(0x00000000); f(0x32080040); f(0x3f800000); f(0x02030010); 
	f(0x08004000); f(0x300900f1); f(0x0300b000); f(0x1d0600f3); 
	f(0x09001b00); f(0x1d0900f3); f(0x06001b00); f(0x030900f3); 
	f(0x0200ff00); f(0x1d0a00f3); f(0x09001b00); f(0x010a00f3); 
	f(0x03000000); f(0x1d0600f3); f(0x0a001b00); f(0x1d080040); 
	f(0x06000000); f(0x01080040); f(0x06004000); f(0x1d080020); 
	f(0x08004000); f(0x01080020); f(0x06008000); f(0x32080040); 
	f(0x40400000); f(0x04080010); f(0x08004000); f(0x03080010); 
	f(0x08008000); f(0x1d050010); f(0x0800c000); f(0x1d080040); 
	f(0x0500c000); f(0x03080040); f(0x02000000); f(0x1a080020); 
	f(0x08004000); f(0x1d050010); f(0x08008000); f(0x2a050080); 
	f(0x0500c000); f(0x1d018040); f(0x00800000); f(0x34000000); 
	f(0x01804000); f(0x1d050010); f(0x05000000); f(0x36000000); 
	f(0x00000000); f(0x2a080080); f(0x0500c000); f(0x1d018040); 
	f(0x00800000); f(0x34000000); f(0x01804000); f(0x32080040); 
	f(0x3f800000); f(0x1d080020); f(0x05008000); f(0x01050020); 
	f(0x08004000); f(0x36000000); f(0x00000000); f(0x1d030031); 
	f(0x00001000); f(0x300900f1); f(0x0300b000); f(0x1d0a00f3); 
	f(0x09001b00); f(0x32080040); f(0x00000000); f(0x1d080020); 
	f(0x0a000000); f(0x01080020); f(0x0a004000); f(0x1d080010); 
	f(0x08008000); f(0x01080010); f(0x0a008000); f(0x32080020); 
	f(0x40400000); f(0x04090080); f(0x08008000); f(0x03090080); 
	f(0x0800c000); f(0x1d080040); f(0x09000000); f(0x1d080020); 
	f(0x08004000); f(0x03080020); f(0x0200c000); f(0x1d080010); 
	f(0x08008000); f(0x01080010); f(0x03000000); f(0x1d080040); 
	f(0x0800c000); f(0x1d080020); f(0x08004000); f(0x03080020); 
	f(0x02000000); f(0x1a080010); f(0x08008000); f(0x1d080020); 
	f(0x0800c000); f(0x32080010); f(0x3f800000); f(0x1d090080); 
	f(0x02000000); f(0x02090080); f(0x0800c000); f(0x2a090080); 
	f(0x08008000); f(0x1d018040); f(0x00800000); f(0x34000000); 
	f(0x01804000); f(0x32080010); f(0x3f800000); f(0x1d090080); 
	f(0x02000000); f(0x02090080); f(0x0800c000); f(0x1d080020); 
	f(0x09000000); f(0x36000000); f(0x00000000); f(0x01030020); 
	f(0x02004000); f(0x01030010); f(0x02008000); f(0x1d080010); 
	f(0x03008000); f(0x08080010); f(0x00008000); f(0x1d030020); 
	f(0x0800c000); f(0x1d080010); f(0x0300c000); f(0x08080010); 
	f(0x0000c000); f(0x1d090080); f(0x0000c000); f(0x03090080); 
	f(0x08008000); f(0x1d090040); f(0x0800c000); f(0x01090040); 
	f(0x09000000); f(0x1d030010); f(0x09004000); f(0x300900f1); 
	f(0x0300b001); f(0x1d0b00f3); f(0x09001b00); f(0x34000000); 
	f(0x01800000); f(0x1d0600f3); f(0x0b001b00); f(0x35000000); 
	f(0x00000000); f(0x1d0900f3); f(0x0b001b00); f(0x010900f3); 
	f(0x07001b00); f(0x32080010); f(0x40000000); f(0x040c00f3); 
	f(0x0800ff00); f(0x030c00f3); f(0x09001b00); f(0x1d0600f3); 
	f(0x0c001b00); f(0x36000000); f(0x00000000); f(0x32080010); 
	f(0x00000000); f(0x2a080010); f(0x05004000); f(0x1d018040); 
	f(0x00800000); f(0x34000000); f(0x01804000); f(0x1d050010); 
	f(0x03004000); f(0x32080010); f(0x3f800000); f(0x1d090080); 
	f(0x0800c000); f(0x02090080); f(0x0500c000); f(0x1d0c00f3); 
	f(0x06001b00); f(0x030c00f3); f(0x09000000); f(0x1d0900f3); 
	f(0x04001b00); f(0x030900f3); f(0x0500ff00); f(0x1d0d00f3); 
	f(0x0c001b00); f(0x010d00f3); f(0x09001b00); f(0x1d0600f3); 
	f(0x0d001b00); f(0x36000000); f(0x00000000); f(0x32080010); 
	f(0x00000000); f(0x2a080010); f(0x05008000); f(0x1d018040); 
	f(0x00800000); f(0x34000000); f(0x01804000); f(0x32080010); 
	f(0x40a00000); f(0x04090080); f(0x0800c000); f(0x03090080); 
	f(0x05008000); f(0x1d080010); f(0x09000000); f(0x03080010); 
	f(0x03004000); f(0x1d050010); f(0x0800c000); f(0x32080010); 
	f(0x3f800000); f(0x1d090080); f(0x0800c000); f(0x02090080); 
	f(0x0500c000); f(0x1d0c00f3); f(0x06001b00); f(0x030c00f3); 
	f(0x09000000); f(0x1d0900f3); f(0x04001b00); f(0x030900f3); 
	f(0x0500ff00); f(0x1d0d00f3); f(0x0c001b00); f(0x010d00f3); 
	f(0x09001b00); f(0x1d0600f3); f(0x0d001b00); f(0x36000000); 
	f(0x00000000); f(0x1d0100f3); f(0x06001b00); 

	return a;
	
}


        }
	}
}




// ↓ pbk ファイルのコード
/* -----------------------------------------------------------------------------
	パラメータ
	texture             ハッチングのイメージ
	width               ハッチングの幅
	height              ハッチングの高さ
	bits_per_pixel      色深度（ハッチングの数）
	position            テクスチャの座標
	average_multiplier  平均カラーの乗算成分 (デフォルト 1.0)
	average_offset      平均カラーの加算成分 (デフォルト 0.0)
	color_line          線の色
	coefficient         線の係数
	knockout            ノックアウト
 ----------------------------------------------------------------------------- */
/*
<languageVersion : 1.0;>
kernel HatchingFilter<
	namespace : "hatching";
	vendor : "Hakuhin";
	version : 1;
	description : "ハッチングフィルタ";
>{
	input image4 src;	// 入力イメージ
	input image4 texture;	// テクスチャ
	output pixel4 dst;	// 出力ピクセル


	// -------------------------------------
	// パラメータ
	// -------------------------------------
	parameter float width<
		minValue:float(1.0);
		defaultValue:float(64.0);
		description : "ハッチングの幅";
	>;
	parameter float height<
		minValue:float(1.0);
		defaultValue:float(64.0);
		description : "ハッチングの高さ";
	>;
	parameter float bits_per_pixel<
		minValue:float(1);
		maxValue:float(256);
		defaultValue:float(8);
		description : "色深度（ハッチングの数）";
	>;
	parameter float2 position<
		defaultValue:float2(0.0 , 0.0);
		description : "テクスチャの座標";
	>;
	parameter float average_multiplier<
		defaultValue:float(1.0);
		description : "平均カラーの乗算成分";
	>;
	parameter float average_offset<
		defaultValue:float(0.0);
		description : "平均カラーの加算成分";
	>;
	parameter pixel4 color_line<
		defaultValue:pixel4(0,0,0,1);
		description : "線の色";
	>;
	parameter float coefficient<
		minValue:float(0.0);
		maxValue:float(1.0);
		defaultValue:float(0.5);
		description : "線の係数";
	>;
	parameter bool knockout<
		defaultValue:bool(false);
		description : "ノックアウト";
	>;

	// -------------------------------------
	// ピクセルごとに実行される関数
	// -------------------------------------
	void evaluatePixel(){

		float2 pos = outCoord();

		pixel4 c;
		pixel4 center_color;
		float center;
		float d;
		float de = bits_per_pixel - 1.0;
		float c0 = 0.0; 
		float c1 = 0.0; 

		// 中央カラーの色深度を取得
		center_color = sampleNearest(src,pos);
		c = center_color * average_multiplier + average_offset;
		d = (c[0] + c[1] + c[2]) / 3.0;
		center = floor(d * bits_per_pixel);
		if(center > de) center = de;
		  
		// 上の色深度を取得
		pos.y -= 1.0;
		c = sampleNearest(src,pos);
		c = c * average_multiplier + average_offset;
		d = (c[0] + c[1] + c[2]) / 3.0;
		d = floor(d * bits_per_pixel);
		if(d > de) d = de;
		if(center < d) c0++;
		
		// 右上の色深度を取得
		pos.x += 1.0;
		c = sampleNearest(src,pos);
		c = c * average_multiplier + average_offset;
		d = (c[0] + c[1] + c[2]) / 3.0;
		d = floor(d * bits_per_pixel);
		if(d > de) d = de;
		if(center < d) c1++;
		
		// 右の色深度を取得
		pos.y += 1.0;
		c = sampleNearest(src,pos);
		c = c * average_multiplier + average_offset;
		d = (c[0] + c[1] + c[2]) / 3.0;
		d = floor(d * bits_per_pixel);
		if(d > de) d = de;
		if(center < d) c0++;

		// 右下の色深度を取得
		pos.y += 1.0;
		c = sampleNearest(src,pos);
		c = c * average_multiplier + average_offset;
		d = (c[0] + c[1] + c[2]) / 3.0;
		d = floor(d * bits_per_pixel);
		if(d > de) d = de;
		if(center < d) c1++;

		// 下の色深度を取得
		pos.x -= 1.0;
		c = sampleNearest(src,pos);
		c = c * average_multiplier + average_offset;
		d = (c[0] + c[1] + c[2]) / 3.0;
		d = floor(d * bits_per_pixel);
		if(d > de) d = de;
		if(center < d) c0++;

		// 左下の色深度を取得
		pos.x -= 1.0;
		c = sampleNearest(src,pos);
		c = c * average_multiplier + average_offset;
		d = (c[0] + c[1] + c[2]) / 3.0;
		d = floor(d * bits_per_pixel);
		if(d > de) d = de;
		if(center < d) c1++;

		// 左の色深度を取得
		pos.y -= 1.0;
		c = sampleNearest(src,pos);
		c = c * average_multiplier + average_offset;
		d = (c[0] + c[1] + c[2]) / 3.0;
		d = floor(d * bits_per_pixel);
		if(d > de) d = de;
		if(center < d) c0++;
		
		// 左上の色深度を取得
		pos.y -= 1.0;
		c = sampleNearest(src,pos);
		c = c * average_multiplier + average_offset;
		d = (c[0] + c[1] + c[2]) / 3.0;
		d = floor(d * bits_per_pixel);
		if(d > de) d = de;
		if(center < d) c1++;


		// ピクセルの位置を取得
		pos = outCoord();

		// 色を取得
		pixel4 color = sampleNearest(src,pos); 
	
		// 明度を計算
		float lightness = 0.0;
		lightness = (color[0] + color[1] + color[2]) / 3.0;
		lightness = lightness * average_multiplier + average_offset;


		// 明度から段階に変更
		float id = floor(lightness*bits_per_pixel);
		if(id > bits_per_pixel - 1.0) id = bits_per_pixel - 1.0;
 
		// オフセット
		pos.x += position.x;
		pos.y += position.y;

		// テクスチャのカラーを取得
		pos.x = mod(pos.x , width);
		pos.y = mod(pos.y , height) + height * id;
		pixel4 color_hatching = sampleNearest(texture,pos);


		// ノックアウト
		if(knockout){
			c = color_hatching;
		
		// 元の色と平均
		}else{
			c = (color_hatching + center_color) / 2.0;
		}
		
		// 十字との変化
		if(c0 > 0.0){
			d = coefficient;
			c = c * (1.0 - d) + color_line * d;
		}
		
		// 斜めとの変化
		if(c1 > 0.0){
			d = c1 / 5.0 * coefficient;
			c = c * (1.0 - d) + color_line * d;
		}
		
		// カラーを出力
		dst = c;
	}
}
*/



import flash.events.*;
import flash.display.*;
import flash.text.*;
import flash.geom.*;

// -------------------------------------------------
// ボタン
// -------------------------------------------------
internal class Button extends Sprite {

	private var _width:Number;
	private var _height:Number;
	
	private var _text:TextField;
	private var _background:Sprite;
	

	public function Button(stage:Stage) {
		var slider:Button = this;

		// 背景用スプライト作成
		_background = new Sprite();
		addChild(_background);

		// テキストフィールド
		_text = new TextField();
		addChild(_text);
	
		_text.x = 0;
		_text.y = 0;
		_text.selectable = false;

		// 書式
		var format:TextFormat = new TextFormat();
		format.align = TextFormatAlign.CENTER;	// 整列
		format.font = "ＭＳ ゴシック";	// フォント名
		format.size = 14;				// 文字のポイントサイズ
		format.color = 0x202020;		// 文字の色
		_text.defaultTextFormat = format;
	
		// マウスオーバーで少し明るく
		addEventListener(MouseEvent.MOUSE_OVER,function(e:MouseEvent):void{
			var color : ColorTransform = new ColorTransform(1,1,1,1,8,8,8,0);
			transform.colorTransform = color;
		});

		// マウスアウトで元に戻す
		addEventListener(MouseEvent.MOUSE_OUT,function(e:MouseEvent):void{
			var color : ColorTransform = new ColorTransform(1,1,1,1,0,0,0,0);
			transform.colorTransform = color;														   
		});

		// デフォルト値
		setSize(100,100);
		update();
	}
	// リサイズ
	public function setSize(w:Number,h:Number):void{
		// 背景リサイズ
		_width = w;
		_height = h;
		update();
	}
	// ラベルセット
	public function setLabel(str:String):void{
		_text.text = str;
		update();
	}
	// 描画更新
	private function update():void{
		// 背景描画
		var g:Graphics = _background.graphics;
		
		// 角丸矩形描画
		g.clear();
		g.lineStyle ( 0 , 0x808080 , 1.0,false,LineScaleMode.NONE,CapsStyle.ROUND,JointStyle.ROUND);
		g.beginFill ( 0xF0F0F0 , 1.0 );
		g.drawRoundRect ( 0 , 0 , _width , _height , 5 , 5 );
		g.endFill();
		
		// テキスト位置修正
		_text.width  = _width;
		_text.height = _height;
	}
}




import flash.events.*;
import flash.display.*;
import flash.text.*;
import flash.geom.*;

// -------------------------------------------------
// ラジオボタン
// -------------------------------------------------
internal class RadioButton extends Sprite {

	private var _width:Number;
	private var _height:Number;
	
	private var _text:TextField;
	private var _background:Sprite;
	private var _button:Sprite;
	private var _check:Sprite;
	
	private var _pref:RadioButton;
	private var _post:RadioButton;
	
	private var _selected:Boolean;
	private var _onClick:Function;

	public function RadioButton(stage:Stage) {
		var slider:RadioButton = this;
		
		_onClick = null;
		_selected = false;
		
		// リングリスト作成
		_pref = this;
		_post = this;

		// 背景用スプライト作成
		_background = new Sprite();
		addChild(_background);

		// ボタン用スプライト作成
		_button = new Sprite();
		addChild(_button);

		// チェック用スプライト作成
		_check = new Sprite();
		addChild(_check);

		// テキストフィールド
		_text = new TextField();
		addChild(_text);
	
		_text.x = 20;
		_text.y = 0;
		_text.selectable = false;

		// 書式
		var format:TextFormat = new TextFormat();
		format.align = TextFormatAlign.LEFT;	// 整列
		format.font = "ＭＳ ゴシック";			// フォント名
		format.size = 14;						// 文字のポイントサイズ
		format.color = 0x202020;				// 文字の色
		_text.defaultTextFormat = format;
	
		// マウスオーバーで少し明るく
		addEventListener(MouseEvent.MOUSE_OVER,function(e:MouseEvent):void{
			var color : ColorTransform = new ColorTransform(1,1,1,1,8,8,8,0);
			transform.colorTransform = color;
		});

		// マウスアウトで元に戻す
		addEventListener(MouseEvent.MOUSE_OUT,function(e:MouseEvent):void{
			var color : ColorTransform = new ColorTransform(1,1,1,1,0,0,0,0);
			transform.colorTransform = color;														   
		});

		// クリック
		addEventListener(MouseEvent.CLICK,function(e:MouseEvent):void{
			select();											   
		});

		// デフォルト値
		setSize(100,100);
		update();
	}
	// リサイズ
	public function setSize(w:Number,h:Number):void{
		// 背景リサイズ
		_width = w;
		_height = h;
		update();
	}
	// ラベルセット
	public function setLabel(str:String):void{
		_text.text = str;
		update();
	}
	// 描画更新
	private function update():void{
		// 背景描画
		var g:Graphics;
		var height_half:Number = _height / 2;
		var r:Number;

		
		// 背景描画
		g = _background.graphics;
		g.clear();
		g.beginFill ( 0xFFFFFF , 0.0 );
		g.drawRect ( 0 , 0 , _width , _height );
		g.endFill();

		
		// ボタン描画
		g = _button.graphics;
		g.clear();
		g.lineStyle ( 0 , 0x808080 , 1.0,false,LineScaleMode.NONE,CapsStyle.ROUND,JointStyle.ROUND);
		g.beginFill ( 0xF0F0F0 , 1.0 );
		r = height_half - 4;
		if(r < 4) r = 4;
		g.drawCircle ( height_half , height_half , r );
		g.endFill();

		// 背景描画
		g = _check.graphics;
		g.clear();
		g.lineStyle ( 0 , 0x404040 , 1.0,false,LineScaleMode.NONE,CapsStyle.ROUND,JointStyle.ROUND);
		g.beginFill ( 0x606060 , 1.0 );
		r = height_half - 8;
		if(r < 2) r = 2;
		g.drawCircle ( height_half , height_half , r );
		g.endFill();

		// テキスト位置修正
		_text.x  = _height;
		_text.width  = _width;
		_text.height = _height;

		if(_selected)	_check.visible = true;
		else			_check.visible = false;
	}
	
	// グループにセット
	public function attachGroup(button:RadioButton):void{
		button.removeGroup();

		var pref:RadioButton = this;
		var post:RadioButton = _post;

		pref._post = button;
		post._pref = button;
		button._pref = pref;
		button._post = post;
	}

	// グループから外す
	public function removeGroup():void{
		var pref:RadioButton = _pref;
		var post:RadioButton = _post;
		pref._post = post;
		post._pref = pref;
		_pref = this;
		_post = this;
	}
	
	// 選択
	public function select():void{
		// すべてのチェックを外す
		var list:RadioButton = this._post;
		while(true){
			if(list == this)	break;

			list._selected = false;
			list.update();
			list = list._post;
		}
		// チェック
		list._selected = true;
		list.update();
		
		// コールバック関数呼び出し
		if(_onClick != null){
			_onClick(this);
		}
	}

	// イベント登録
	public function onClick(func:Function):void{
		_onClick = func;
	}
}


// -------------------------------------------------
// 外部画像をサムネイルとしてキャプチャ
// -------------------------------------------------
import flash.net.*;
import flash.events.*;
import flash.display.*;
import flash.geom.*;
function ThumbnailCapture(url:String,time:uint,stage:Stage):void{

	// キャプチャタイミング
	Wonderfl.capture_delay( time );

	// スプライト作成
	var sprite : Sprite = new Sprite();

	// ステージ最前面に配置
	stage.addChildAt(sprite,stage.numChildren);
	
	// ローダー
	var loader_obj : Loader = new Loader();
	loader_obj.contentLoaderInfo.addEventListener (Event.INIT,function(e:Event):void{

		// メモリからインスタンス化
		var loader_memory : Loader = new Loader();
		loader_memory.contentLoaderInfo.addEventListener (Event.INIT,function(e:Event):void{

			// キャプチャ
			var bmp : BitmapData = new BitmapData(loader_memory.width,loader_memory.height,true,0);
			sprite.addChild(loader_memory);
			bmp.draw(sprite);
			sprite.removeChild(loader_memory);
			loader_memory.unload();
			loader_obj.unload();
			loader_memory = null;
			loader_obj = null;
			
			
			// 画像を配置
			var bmp_obj : Bitmap = new Bitmap(bmp);
			bmp_obj .width = stage.stageWidth;
			bmp_obj .height = stage.stageHeight;
			stage.addChild(bmp_obj );
			
		});
		
		// 読み込み開始
		loader_memory.loadBytes(loader_obj.contentLoaderInfo.bytes);
	});
	
	// 読み込み開始
	loader_obj.load(new URLRequest(url));
}