/**
 * Copyright littlepad ( http://wonderfl.net/user/littlepad )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4gSb
 */

package {
    import flash.display.Sprite;
    
    public class Main extends Sprite {       
        private var _ta:Textarea;
        public function Main() {
            init();
        }
        
        private function init():void {
            _ta = new Textarea();
            addChild(_ta);
            
            //var singleton:Singleton;
            //singleton = Singleton.instance;
            //_ta.appendText("初期値のID: " + singleton.testID);
            _ta.appendText("初期値のID: " + Singleton.instance.testID);
            
            // 他のクラスで Singleton 内の変数の値を変更
            _ta.appendText("他のクラス（Updateクラス）で変数を変更");
            var update:Update = new Update();
            update.doAction();
            //_ta.appendText("変更後のID: " + singleton.testID);
            _ta.appendText("変更後のID: " + Singleton.instance.testID);
        }
    }
}

/*-------------------------------
/  Update クラス
/ -------------------------------*/
internal class Update {
    public function Update() {
    }
    
    public function doAction():void {
        //var singleton:Singleton;
        //singleton = Singleton.instance;
        //singleton.testID = "012345";
        Singleton.instance.testID = "012345";
    }
}

/*-------------------------------
/  Singleton クラス
/ -------------------------------*/
internal class Singleton {
    private static var _instance:Singleton;
    
    // テストデータ
    private var _testID:String = "000000";
    
    /* コンストラクタ */
    public function Singleton() {
        if ( _instance ) {
            throw new Error("コンストラクタの直接呼び出しは禁止されています。");
        }
    }
    
    /* インスタンスを返す */
    public static function get instance():Singleton {
        if ( _instance == null ) {
            _instance = new Singleton();
        }
        return _instance;
    }
    
    /* テストデータ用 setter/getter */
    public function set testID(testID:String):void {
        _testID = testID;
    }
    public function get testID():String {
        return _testID;
    }
}

/*-------------------------------
/  Textarea クラス
/ -------------------------------*/
import flash.text.TextField;
internal class Textarea extends TextField {
    public function Textarea():void {
        this.width = 465;
        this.height = 465;
    }
    
    override public function appendText(newText:String):void {
        super.appendText(newText + "\n");
    }
}
