/**
 * Copyright nan05aur ( http://wonderfl.net/user/nan05aur )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4g0f
 */

// forked from nan05aur's forked from: [Alternativa3D] Basic Template_1_プリミティブ
// forked from nan05aur's forked from: [Alternativa3D] Basic Template_1
// forked from clockmaker's [Alternativa3D] Basic Template
package {
    import flash.net.FileReferenceList;
    import alternativ5.engine3d.materials.DevMaterial;
    import alternativ5.engine3d.materials.FillMaterial;
    import alternativ5.engine3d.materials.WireMaterial;
    import alternativ5.engine3d.primitives.Box;
    import alternativ5.types.Point3D;
    import flash.display.Sprite;
    import flash.display.BlendMode;
    
    [SWF(width = 465, height = 465, frameRate = 60)]
    /**
     * Alternativa3D を簡単に扱うためのベーシックテンプレート
     * @author Yasu (clockmaker)
     */
    public class SimpleDemo extends Sprite {
        
        public function SimpleDemo():void {
            // テンプレートを作成します
            var template:BasicTemplate = new BasicTemplate();
            addChild(template);
            
            // マテリアルを作成します
            var materialX1:FillMaterial=new FillMaterial(0xFF0000,1,BlendMode.NORMAL,0,0x0000000);
            var materialX2:FillMaterial=new FillMaterial(0x660000,1,BlendMode.NORMAL,0,0x0000000);
            var materialY1:FillMaterial=new FillMaterial(0x00FF00,1,BlendMode.NORMAL,0,0x0000000);
            var materialY2:FillMaterial=new FillMaterial(0x006600,1,BlendMode.NORMAL,0,0x0000000);
            var materialZ1:FillMaterial=new FillMaterial(0x0000FF,1,BlendMode.NORMAL,0,0x0000000);           
            var materialZ2:FillMaterial=new FillMaterial(0x000066,1,BlendMode.NORMAL,0,0x0000000);
            
            var materialC1:FillMaterial=new FillMaterial(0xCCCCCC,1,BlendMode.NORMAL,0,0x0000000);
            
            // プリミティブを作成します
            var boxX1:Box = new Box(50,50,50, 1, 1, 1, false, false);
            var boxX2:Box = new Box(50,50,50, 1, 1, 1, false, false);
            var boxY1:Box = new Box(50,50,50, 1, 1, 1, false, false);
            var boxY2:Box = new Box(50,50,50, 1, 1, 1, false, false);
            var boxZ1:Box = new Box(50,50,50, 1, 1, 1, false, false);
            var boxZ2:Box = new Box(50,50,50, 1, 1, 1, false, false);
            
            var boxC1:Box = new Box(50,50,50, 1, 1, 1, false, false);
            
            // 3Dオブジェクトの配置
            boxX1.cloneMaterialToAllSurfaces(materialX1);
            boxX1.x=300;
            boxX2.cloneMaterialToAllSurfaces(materialX2);
            boxX2.x=-300;
            boxY1.cloneMaterialToAllSurfaces(materialY1);
            boxY1.y=300;
            boxY2.cloneMaterialToAllSurfaces(materialY2);
            boxY2.y=-300;
            boxZ1.cloneMaterialToAllSurfaces(materialZ1);
            boxZ1.z=300;
            boxZ2.cloneMaterialToAllSurfaces(materialZ2);
            boxZ2.z=-300;
            
            boxC1.cloneMaterialToAllSurfaces(materialC1);
            // 3Dシーンのルートに追加します
            template.scene.root.addChild(boxX1);
            template.scene.root.addChild(boxX2);
            template.scene.root.addChild(boxY1);
            template.scene.root.addChild(boxY2);
            template.scene.root.addChild(boxZ1);
            template.scene.root.addChild(boxZ2);
            
            template.scene.root.addChild(boxC1);
            // Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
            // レンダリング前に実行したい処理を記述します。
            template.onPreRender = function():void {
                // 立方体を回転させます (角度はラジアン)
                /*boxX1.rotationX += 1 * Math.PI / 180;
                boxY1.rotationY += 1 * Math.PI / 180;
                boxZ1.rotationZ += 1 * Math.PI / 180;
                boxX2.rotationX -= 1 * Math.PI / 180;
                boxY2.rotationY -= 1 * Math.PI / 180;
                boxZ2.rotationZ -= 1 * Math.PI / 180;*/
            
                // マウスがステージの高さ何%の位置にあるか算出
                var rateY:Number = mouseY / stage.stageHeight;
                var rateZ:Number = (mouseY - stage.stageHeight/2)/2;
                var rateX:Number = (mouseX - stage.stageWidth/2)/2;
                
                // カメラの高さの座標を調整
                // イージングの公式 対象の値 += (目標値 - 現在の値) * 減速率
                template.camera.y =  - 5500 /*- template.camera.y*/ * 0.1;
                //template.camera.y += ( - 1000 * rateY - template.camera.y) * 0.1;
                //template.camera.y += ( rateY - template.camera.y) * 0.1;
                template.camera.z += ( rateZ - template.camera.z) * 0.1;
                template.camera.x += ( rateX - template.camera.x) * 0.1;
                
                // カメラの座標を中央に向かせる
                template.cameraController.lookAt(new Point3D());
            }
        }
    }
}


/**
 * BasicTemplate for Alternativa3D
 * Alternativa3Dを扱いやすくするためのテンプレートです
 * @author Yasu
 */
import alternativ5.engine3d.controllers.CameraController;
import alternativ5.engine3d.core.Camera3D;
import alternativ5.engine3d.core.Object3D;
import alternativ5.engine3d.core.Scene3D;
import alternativ5.engine3d.display.View;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;
import flash.events.Event;
class BasicTemplate extends Sprite{
    /**
     * シーンインスタンスです。
     */
    public var scene:Scene3D;
    /**
     * ビューインスタンスです。
     */
    public var view:View;
    /**
     * カメラインスタンスです。
     */
    public var camera:Camera3D;
    /**
     * カメラコントローラーです。
     */
    public var cameraController:CameraController;
    
    private var _viewWidth:int;
    private var _viewHeight:int;
    private var _scaleToStage:Boolean;

    /**
     * 新しい BasicTemplate インスタンスを作成します。
     * @param    viewWidth
     * @param    viewHeight
     * @param    scaleToStage
     */
    public function BasicTemplate(viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true) {
        _viewWidth = viewWidth;
        _viewHeight = viewHeight;
        _scaleToStage = scaleToStage;
        
        // Creating scene
        scene = new Scene3D();
        scene.splitAnalysis = false; // not analysis for performance
        scene.root = new Object3D();
        
        // Adding camera
        camera = new Camera3D();
        camera.z = -1000;
        scene.root.addChild(camera);
        
        // camera contoller
        cameraController = new CameraController(this);
        cameraController.camera = camera;
        
        // set view
        view = new View();
        view.camera = camera;
        addChild(view);
        
        // stage
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    /**
     * 初期化されたときに実行されるイベントです。
     * 初期化時に実行したい処理をオーバーライドして記述します。
     */
    protected function atInit():void {}
    
    /**
     * 初期化されたときに実行されるイベントです。
     * 初期化時に実行したい処理を記述します。
     */
    private var _onInit:Function = function():void { };
    public function get onInit():Function { return _onInit; }
    public function set onInit(value:Function):void {
        _onInit = value;
    }
    
    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング前に実行したい処理をオーバーライドして記述します。
     */
    protected function atPreRender():void {}
    
    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング前に実行したい処理を記述します。
     */
    private var _onPreRender:Function = function():void{};
    public function get onPreRender():Function { return _onPreRender; }
    public function set onPreRender(value:Function):void {
        _onPreRender = value;
    }
    
    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング後に実行したい処理をオーバーライドして記述します。
     */
    protected function atPostRender():void {
    }
    
    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング後に実行したい処理を記述します。
     */
    protected var _onPostRender:Function = function():void{};
    public function get onPostRender():Function { return _onPostRender; }
    public function set onPostRender(value:Function):void {
        _onPostRender = value;
    }
    
    /**
     * レンダリングを開始します。
     */
    public function startRendering():void {
        addEventListener(Event.ENTER_FRAME, onRenderTick);
    }
    /**
     * レンダリングを停止します。
     */
    public function stopRendering():void {
        removeEventListener(Event.ENTER_FRAME, onRenderTick);
    }
    
    /**
     * シングルレンダリング(レンダリングを一回だけ)を実行します。
     */
    public function singleRender():void {
        onRenderTick();
    }
    
    /**
     * @private
     */
    private function init(e:Event = null):void {
        stage.scaleMode = StageScaleMode.NO_SCALE;
        stage.align = StageAlign.TOP_LEFT;
        stage.quality = StageQuality.HIGH;

        // resize
        stage.addEventListener(Event.RESIZE, onResize);
        onResize(null);
        
        // render
        startRendering();
        
        atInit();
        _onInit();
        
    }
    
    /**
     * @private
     */
    private function onRenderTick(e:Event = null):void {
        atPreRender();
        _onPreRender();
        scene.calculate();
        atPostRender();
        _onPostRender();
    }
    
    /**
     * @private
     */
    private function onResize(event:Event = null):void {
        if (_scaleToStage) {
            view.width = stage.stageWidth;
            view.height = stage.stageHeight;
        }else {
            view.width = _viewWidth;
            view.height = _viewHeight;
        }
    }
}
