/**
 * Copyright mash ( http://wonderfl.net/user/mash )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4fmQ
 */

/*
available methods for
net.wonderfl.widget.Wanco:

            var methods :Array = [
                "turn",
                "turnFace",
                "jump1",
                "jump2",
                "walk",
                "squat",
                "run",
                "question",
                "exclamation",
                "heart",
                "sing",
                "pout",
                "star",
                "sleep",
                "wakeUp"
            ];
*/

package {
    import flash.display.Sprite;
    import flash.events.*;
    import flash.utils.Timer;
    import net.wonderfl.widget.Wanco;
    import com.bit101.components.Text;

    public class FlashTest extends Sprite {
        private var wanco :Wanco;
        private var textLog :Text;
        public function FlashTest() {

            textLog = new Text(this, 0, 0);
            textLog.width  = 450;
            textLog.height = 450;

            wanco = new Wanco;
            wanco.x = 100;
            wanco.y = 100;
            addChild( wanco );

            startMethodTests();
        }
        private function startMethodTests() :void {
            var iter :Function = getNextMethod();

            var timer :Timer = new Timer(2000);
            timer.addEventListener( TimerEvent.TIMER, function(e :Event) :void {
                var next :String = iter();
                logger( next );

                wanco[ next ]();
            });
            timer.start();
        }
        private function getNextMethod() :Function {
            var methods :Array = [
                "turn",
                "turnFace",
                "jump1",
                "jump2",
                "walk",
                "squat",
                "run",
                "question",
                "exclamation",
                "heart",
                "sing",
                "pout",
                "star",
                "sleep",
                "wakeUp"
            ];
            var index :int = -1;
            return function() :String {
                index++;
                index = (index >= methods.length) ? 0 : index;
                return methods[ index ];
            };
        }
        public function logger( s :String ) :void {
            textLog.text += s+"\n";
        }
    }
}