/**
 * Copyright civet ( http://wonderfl.net/user/civet )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/4ff5
 */

// forked from Susisu's Brainf*ck Interpreter
/*
    「,」以外実装したつもり
    メモリの使用がどうなってるかを表示させてみたけど
    文字列表示だとあんまりおもしろくない
    そんでもって無駄に長い気がしてならない
    最初に表示されるものは以下から引用(4*2)
    http://www.kmonos.net/alang/etc/brainfuck.php
*/
package{
    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
    import flash.geom.Rectangle;
    [SWF(width="320", height="320", backgroundColor="0x000000", frameRate="60")]
    public class Bfi extends Sprite{
        private var mem:uint=32;    //メモリの数 256の約数だといいと思う
        private var den:uint=128;    //濃度(乗算) 数値がによって適当に変えたり 
        private var code:TextField=new TextField();
        private var ext:TextField=new TextField();
        private var button:Sprite=new Sprite();
        private var btf:TextField=new TextField();
        private var a:Array,q:Array,p:uint,n:uint,l:uint,t:uint,j:uint;
        private var rf:Boolean=false;
        private var bmd:BitmapData=new BitmapData(mem,60,true,0x000000);
        private var bmp:Bitmap=new Bitmap(bmd);
        private var bar:Rectangle=new Rectangle(0,0,256/mem,60);
        public function Bfi(){
            code.type=TextFieldType.INPUT;
            code.border=true;
            code.textColor=0x000000;
            code.backgroundColor=0xffffff;
            code.background=true;
            code.text="++++++++++[>+++++++>++++++++++>+++>+<<<<-]>++.>+.+++++++..+++.>++.<<+++++++++++++++.>.+++.------.--------.>+.>.";
            code.x=10;
            code.y=10;
            code.width=300
            code.height=160;
            code.wordWrap=true;
            addChild(code);
            
            ext.type=TextFieldType.INPUT;
            ext.border=true;
            ext.backgroundColor=0xffffff;
            ext.textColor=0x000000;
            ext.background=true;
            ext.text="";
            ext.x=10;
            ext.y=250;
            ext.width=300
            ext.height=60;
            ext.wordWrap=true;
            addChild(ext);

            btf.text="Run";
            btf.selectable=false;
            btf.backgroundColor=0x000080;
            btf.textColor=0xffffff;
            btf.background=true;
            btf.border=true;
            btf.x=140;
            btf.y=170;
            btf.autoSize=TextFieldAutoSize.LEFT;
            button.addChild(btf);
            addChild(button);
            
            bmp.x=32;
            bmp.y=187;
            addChild(bmp);
            button.addEventListener(MouseEvent.CLICK,run);
            addEventListener(Event.ENTER_FRAME,loop);
        }
        private function run(e:MouseEvent):void{
            ext.text="";
            a=new Array(mem);
            for(n=0;n<mem;n++)a[n]=0;
            q=code.text.split("");
            p=0;
            n=0;
            l=q.length;
            rf=true;
        }
        private function loop(e:Event):void{
            for(var k:uint=0;k<4;k++){
            if(rf){
            if(n<l){
                if(q[n]==">")p++;
                else if(q[n]=="<")p--;
                else if(q[n]=="+")a[p]++;
                else if(q[n]=="-")a[p]--;
                else if(q[n]==".")ext.appendText(String.fromCharCode(a[p]));
                else if(q[n]=="["){
                    if(a[p]==0){
                        t=0;
                        for(j=n+1;j<l;j++){
                            if(q[j]=="[")t++;
                            if(q[j]=="]"){
                        if(t>0)t--;
                        else{
                            n=j;
                            break;
                        }
                            }
                        }
                    }
                }
                else if(q[n]=="]"){
                    if(a[p]!=0){
                        t=0;
                        for(j=n-1;j>=0;j--){
                            if(q[j]=="]")t++;
                            if(q[j]=="["){
                        if(t>0)t--;
                        else{
                            n=j;
                            break;
                        }
                            }
                        }
                    }
                }
            }
            n++;
        }
        }
            for(var i:uint=0;i<256;i++){
                bar.x=i*256/mem;
                bmd.fillRect(bar,0xff00ff|(a[i]*den>255?255:a[i])<<24);
            }
        }
    }
}