/**
 * Copyright hacker_3q88gl5n ( http://wonderfl.net/user/hacker_3q88gl5n )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4fOc
 */

// forked from hacker_3q88gl5n's flash on 2010-4-12
package {
	
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.GlowFilter;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	
	[SWF(width="465",height="465",backgroundColor="0x000000",frameRate="30")]
	public class anAnimation extends Sprite {
		
		private var _ball:Sprite;
		private var _timeGage:Sprite;
		private var _locus:Sprite;
		
		private var _startX:Number=0;//xのスタート位置
		private var _endX:Number=stage.stageWidth;//xのエンド位置
		private var _startY:Number=stage.stageHeight / 2;
		private var _frameCount:uint=0;//再生ヘッド（フレーム数カウント用の変数）
		private var _frameCountLimit:uint=150;//コマ数（最終フレームの位置）
		private var _animationFrames:Array;//フレーム格納用の配列
		
		public function anAnimation(){
			init();
		}
            
        public function init():void{//初期化メソッド
			_animationFrames=generate_animationFrames();//アニメーションフレームの生成
			
			_ball=new Sprite();//このコードで唯一のグラフィックオブジェクト。画面に表示される_ballです。
			_ball.graphics.lineStyle(5,0xFFD700);
			//_ball.graphics.beginFill(0x00FFFF,0.2);
			_ball.graphics.drawCircle(0,0,15);
			//_ball.graphics.endFill();
			//_ball.blendMode=BlendMode.ADD;
			
			_timeGage=new Sprite();//画面下部のゲージ用Sprite
			_timeGage.graphics.beginFill(0xFFFFFF,0.5);
			_timeGage.graphics.drawRect(0,0,stage.stageWidth,3);
			_timeGage.graphics.endFill();
			_timeGage.x=-1;
			_timeGage.y=stage.stageHeight-3;
			
			_locus=new Sprite();//軌跡表示用Sprite
			
			_ball.filters=[new GlowFilter(0xFFD700,1,16,16,2,2)];
			
			addChild(_locus);
			addChild(_timeGage);
			addChild(_ball);//_ballをDisplayTreeへ登録
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN,startRec);
			stage.addEventListener(MouseEvent.MOUSE_UP,stopRec);
			
			updateLocus();//軌跡の初期化
			
			start();//レンダリング開始
		}    
		
		
		
		private function generate_animationFrames():Array{//アニメーションフレームを生成するメソッド
			var tmp:Array=new Array();//出力用の一時的な配列
			var easeRatio:Number=0.2;//イージングの比率
			var tmpX:Number=_startX;
			var tmpY:Number=_startY;
			for(var i:uint=0;i<_frameCountLimit;i++){
				tmpX+=(_endX-tmpX)*easeRatio;
				tmp.push(new Point(tmpX,tmpY));//各コマのx座標をコマ数だけ計算して配列に追加
			}
			return tmp;
		}
		
		
		
		private function render(e:Event):void{//レンダリング用のメソッド
			if(_frameCount < _frameCountLimit){//現在のフレーム数が_frameCountLimit以内なら
				_ball.x=_animationFrames[_frameCount].x;//_ballのxに今のコマ数のx座標を代入
			    _ball.y=_animationFrames[_frameCount].y;
			}else{
				//stop();//アニメーション終了
			_frameCount=0;	
			}
			_timeGage.width=(_frameCount/_frameCountLimit)*stage.stageHeight;//画面下部のゲージを連動させる
			_frameCount++;//再生ヘッドを進める
		}
		

		public function start():void{addEventListener(Event.ENTER_FRAME,render);};//スタート用のメソッド。renderがENTER_FRAMEのタイミングで実行されるように設定
		public function stop():void{removeEventListener(Event.ENTER_FRAME,render);};//ストップ用のメソッド。renderがENTER_FRAMEのタイミングで実行されるように設定されているのを解除
	    
	    private function startRec(e:Event):void{addEventListener(Event.ENTER_FRAME,recMouse);};//記録スタート用のメソッド。
		private function stopRec(e:Event):void{removeEventListener(Event.ENTER_FRAME,recMouse);};//記録ストップ用のメソッド。
		
		private function recMouse(e:Event):void{//マウス記録中に呼び出されるメソッド
			if(_frameCount < _frameCountLimit){//フレームが指定フレーム以内じゃないと動作させない
				_animationFrames[_frameCount].x=mouseX;
				_animationFrames[_frameCount].y=mouseY;
				updateLocus();//軌跡を再描画
			}
		}
		
		private function updateLocus():void{//フレーム毎に記録されている座標から軌跡を描画するメソッド
			_locus.graphics.clear();
			_locus.graphics.lineStyle(1,0xFFFFFF,0.2);
			for(var i:uint=0;i<_frameCountLimit;i++){
				_locus.graphics.drawCircle(_animationFrames[i].x,_animationFrames[i].y,15);    
		    }
		}
	}
}
