/**
 * Copyright yuichiroharai ( http://wonderfl.net/user/yuichiroharai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4fAt
 */

package {
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.text.TextFieldAutoSize;
    
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.system.LoaderContext;
    import flash.system.Security;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.text.Font;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.system.ApplicationDomain;
    import flash.system.SecurityDomain;
    
    public class EmbedFontsTest extends Sprite {

        private const FONT_CLASS_KROEGER_LIST:Vector.<String> = Vector.<String>(["Kroeger0555", "Kroeger0655", "Kroeger0665"]);
        private const FONT_NAME_KROEGER_LIST:Vector.<String> = Vector.<String>(["kroeger 05_55", "kroeger 06_55", "kroeger 06_65"]);
        public function EmbedFontsTest() {
            var loader:Loader;

            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;

            Security.loadPolicyFile("http://global.yuichiroharai.com/crossdomain.xml");
            
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, complete);
            loader.load(new URLRequest("http://global.yuichiroharai.com/swf/FontKroeger.swf"), new LoaderContext(true, ApplicationDomain.currentDomain, SecurityDomain.currentDomain));
            
            function complete(e:Event):void {
                var tf:TextField;                
                
                try {
                    Font.registerFont(loader.contentLoaderInfo.applicationDomain.getDefinition(FONT_CLASS_KROEGER_LIST[0]) as Class);
                    Font.registerFont(loader.contentLoaderInfo.applicationDomain.getDefinition(FONT_CLASS_KROEGER_LIST[1]) as Class);
                    Font.registerFont(loader.contentLoaderInfo.applicationDomain.getDefinition(FONT_CLASS_KROEGER_LIST[2]) as Class);
                } catch (e:Error) {
                    tf = new TextField();
                    tf.text = "error...";
                    addChild(tf);
                }
                initTextField();
            }
            
            function initTextField():void {
                var i:uint, textField:TextField;
                
                for (i=0;i<FONT_NAME_KROEGER_LIST.length;i++) {
                    textField = new TextField();
                    textField.defaultTextFormat = new TextFormat(FONT_NAME_KROEGER_LIST[i], 8, 0);
                    textField.autoSize = TextFieldAutoSize.LEFT;
                    textField.multiline = false;
                    textField.selectable = false;
                    textField.x = 100;
                    textField.y = i*20 + 50;
                    textField.embedFonts = true;
                    textField.text = FONT_CLASS_KROEGER_LIST[i].toUpperCase();
                    textField.rotation = 45;
                    addChild(textField);
                }
            }
        }



    }    
}
















