/**
 * Copyright correa_elias ( http://wonderfl.net/user/correa_elias )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4f9p
 */

// forked from demouth's ちりちりな何か
// forked from demouth's forked from: ひも的な何か
// forked from demouth's ひも的な何か
package  
{
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.display.Stage;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	
	[SWF(frameRate='60')] 
	public class Main extends Sprite
	{
		protected var joints:Vector.<Joint> = new Vector.<Joint>();
		protected var fric:Number = 0.01;
		protected var spring:Number = 0.995;//ばね的なもの？
		protected var range:int = 10;//前後に影響を与える範囲
		protected var num:int = 1;
		
		public function Main() 
		{
			if (this.stage) this.init()
			else this.addEventListener(Event.ADDED_TO_STAGE , this.init);
		}
		
		protected function init(event:Event = null):void
		{
			this.stage.align = StageAlign.TOP_LEFT;
			this.stage.scaleMode = StageScaleMode.NO_SCALE;
			this.num = this.stage.stageHeight / 2;
			this.create();
			this.addEventListener(Event.ENTER_FRAME , this.enterFrameHandler);
		}
		
		protected function create():void
		{
			var num:Number = this.num;
			
			for (var i:int = 0; i < num; i++) 
			{
				var j:Joint = new Joint();
				
				j.y = i*2;
				
				this.joints.push(j);
			}
		}
		
		private function enterFrameHandler(event:Event):void
		{
			this.graphics.clear();
			
			this.calc();
			this.move();
			this.draw();
		}
		
		private function calc():void
		{
			var l:int = this.joints.length;
			for (var i:int = 0; i < l; i++) 
			{
				if (i == 0)
				{
					this.joints[0].x = this.stage.mouseX;
					this.joints[0].y = this.stage.mouseY;
					continue;
				}
				
				var b:int = this.range;
				var a:int = this.range;
				var now:Joint = this.joints[i];
				
				for (var j:int = i-b; j < i+a+1; j++) 
				{
					if (j >= 0 && l > j && j != i)
					{
						var t:Joint = this.joints[j];
						
						var angle:Number = Math.atan2(now.y-t.y, now.x-t.x);
						now.sx -= Math.cos(angle) * 6;
						now.sy -= Math.sin(angle) * 6;
					}
				}
			}
		}
		
		private function move():void
		{
			var l:int = this.joints.length;
			for (var i:int = 0; i < l; i++) 
			{
				var now:Joint = this.joints[i];
				if(i!=0)now.sy += 1.5;
				now.x += now.sx * this.fric;
				now.y += now.sy * this.fric;
				
				if (i == 0) continue;
				var b:Joint = this.joints[i-1];
				
				var angle:Number = Math.atan2(b.y - now.y, b.x - now.x);
				now.x = b.x - Math.cos(angle) * 2;
				now.y = b.y - Math.sin(angle) * 2;
				
				now.sx *= this.spring;
				now.sy *= this.spring;
			}
		}
		
		private function draw():void
		{
			var g:Graphics = this.graphics;
			var l:int = this.joints.length;
			
			for (var i:int = 0; i < l; i++) 
			{
				g.beginFill(0xff00ff);
				g.drawCircle(this.joints[i].x, this.joints[i].y, (i<10)?1:this.joints[i].sx*0.005+1);
				g.endFill();
			}
			
		}
	}

}

class Joint
{
	public var x:Number = 0;
	public var y:Number = 0;
	public var sx:Number = 0;
	public var sy:Number = 0;
}