/**
 * Copyright sakef ( http://wonderfl.net/user/sakef )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4ezA
 */

/*
    渦巻きみたいに並べるやつ。
    HSV2RGB()ってのは、HSVからRGBに変換する関数です。
*/
package
{
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Matrix3D;
    
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="40")]
    public class Main extends Sprite
    {
        private var container:Sprite;
        private var planes:Array;
        private var planeN:Number;
        
        public function Main()
        {
            container=new Sprite();
            container.x=465 / 2;
            container.y=465 / 2;
            addChild(container);
            
            // 座標の計算
            planeN=0;
            planes = [];
            var a:Number=140;
            var m:Number=1;
            var n:Number=20;
            for(var i:Number=0; i <= Math.PI; i+=0.018)
            {
                var shape:Shape = container.addChild(new Shape) as Shape;
                var g:Graphics = shape.graphics;
                g.beginFill(HSV2RGB(planeN*2 % 360, 1, 1), 0.7);
                g.drawCircle(0, 0, 4);
                g.endFill();
                shape.x=a * Math.sin(m * i) * Math.cos(n * i);
                shape.y=a * Math.sin(m * i) * Math.sin(n * i);
                shape.z=a * Math.cos(m * i);
                planeN++;
                planes.push(shape);
            }
            
            // イベントの追加
            addEventListener(Event.ENTER_FRAME, onFrame);
        }
        
        private function onFrame(e:Event):void
        {
            container.rotationY++;
            container.rotationX++;
            
            var array:Array=[];
            
            // ソートの準備
            for(var i:int=0; i < planeN; i++)
            {
                var plane:Shape = planes[i];
                var mat:Matrix3D=plane.transform.getRelativeMatrix3D(this);
                array.push({sp:plane, z:mat.position.z});
            }
            
            // ソート
            array.sortOn("z", Array.NUMERIC | Array.DESCENDING);
            
            // ソートを適用
            for(i=0; i < planeN; i++)
            {
                plane = array[i].sp as Shape;
                container.setChildIndex(plane, i);
                
                var blur:Number=(array[i].z as Number) / 20;
                plane.filters=(blur > 4) ? [new BlurFilter(blur, blur, 1)] : [];
            }
        }
        
        // HSV → RGB変換関数
        private function HSV2RGB(h:Number, s:Number, v:Number):uint
        {
            if(s == 0) return uint(v*255<<16) | uint(v*255<<8) | uint(v*255);
            else
            {
                var rgb:uint = 0xffffff;
                var hi:int = (h/60)>>0;
                var f:Number = (h/60 - hi);
                var p:Number = v*(1 - s);
                var q:Number = v*(1 - f*s);
                var t:Number = v*(1-(1-f)*s);
                if(hi==0) rgb = uint(v*255<<16) | uint(t*255<<8) | uint(p*255);
                else if(hi==1) rgb = uint(q*255<<16) | uint(v*255<<8) | uint(p*255);
                else if(hi==2) rgb = uint(p*255<<16) | uint(v*255<<8) | uint(t*255);
                else if(hi==3) rgb = uint(p*255<<16) | uint(q*255<<8) | uint(v*255);
                else if(hi==4) rgb = uint(t*255<<16) | uint(p*255<<8) | uint(v*255);
                else if(hi==5) rgb = uint(v*255<<16) | uint(p*255<<8) | uint(q*255);
                return rgb;
            }
        }
        
    }
}