/**
 * Copyright flashrod ( http://wonderfl.net/user/flashrod )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4dhm
 */

package {
    import flash.display.*;
    import flash.events.*;

    public class Block extends Sprite {
        private static const HEIGHT:int = 240;
        private static const COLS:int = 3+3;
        private static const LINES:int = 2+3+2;
        private static const PW:int = 16*3;
        private static const BW:int = 32;
        private static const BH:int = 8;
        private static const COLOR:Array = [0xFFFF00, 0xFFFF00, 0xFF00FF, 0xFF00FF, 0xFF00FF, 0x00FFFF, 0x00FFFF];
        private var a:Array;
        private var px:Number, py:Number;
        private var vx:Number, vy:Number;
        private var lx:Number, ly:Number;
        private var delta:Number;

        public function Block() {
            lx = BW*3-PW/2;
            ly = HEIGHT-16;
            stage.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void {
                init();
            });
            stage.addEventListener(MouseEvent.MOUSE_MOVE, function(e:MouseEvent):void {
                delta = lx;
                lx = e.localX - (PW/2);
                if (lx < 0) {
                    lx = 0;
                }
                if (lx > BW*COLS - PW) {
                    lx = BW*COLS - PW;
                }
                delta = lx - delta;
            });
            addEventListener(Event.ENTER_FRAME, function(e:Event):void {
                move();
                px += vx;
                py += vy;
                redraw();
            });
            redraw();
        }

        private function init():void {
            a = [];
            for (var j:int = 0; j < LINES; ++j) {
                for (var i:int = 0; i < COLS; ++i) {
                    a.push({x:i*BW+1, y:j*BH+BH*3+1, w:BW-2, h:BH-2, c:COLOR[j]});
                }
            }
            px = lx+PW/2;
            py = ly-8;
            vx = 4;
            vy = -8;
        }

        private function between(a:Number, b:Number, c:Number):Boolean {
            return b <= a && a < c;
        }

        private function intersectsx(y0:Number, x1:Number, y1:Number, x2:Number, y2:Number):Number {
            return x1+(y0-y1)*(x2-x1)/(y2-y1);
        }

        private function intersectsy(x0:Number, x1:Number, y1:Number, x2:Number, y2:Number):Number {
            return y1+(x0-x1)*(y2-y1)/(x2-x1);
        }

        private function collide(b:*, x2:Number, y2:Number, x1:Number, y1:Number):Boolean {
            if (between(b.y, y1, y2) && between(intersectsx(b.y, x1, y1, x2, y2), b.x, b.x+b.w)) {
                vy = -vy;
                return true;
            }
            if (between(b.y+b.h, y2, y1) && between(intersectsx(b.y+b.h, x1, y1, x2, y2), b.x, b.x+b.w)) {
                vy = -vy;
                return true;
            }
            if (between(b.x, x1, x2) && between(intersectsy(b.x, x1, y1, x2, y2), b.y, b.y+b.h)) {
                vx = -vx;
                return true;
            }
            if (between(b.x+b.w, x2, x1) && between(intersectsy(b.x+b.w, x1, y1, x2, y2), b.y, b.y+b.h)) {
                vx = -vx;
                return true;
            }
            return false;
        }

        private function move():void {
            var x2:Number = px + vx;
            var y2:Number = py + vy;
            for each (var b:* in a) {
                if (collide(b, x2, y2, px, py)) {
                    a.splice(a.indexOf(b), 1);
                    return;
                }
            }
            if (x2 < 0 || x2 > COLS*BW) {
                vx = -vx;
                return;
            }
            if (y2 < 0) {
                vy = -vy;
                return;
            }
            if (collide({x:lx, y:ly, w:PW, h:8}, x2, y2, px, py)) {
                vx += delta;
                return;
            }
            if (y2 > HEIGHT) {
                vx = 0;
                vy = 0;
            }
        }

        private function redraw():void {
            graphics.clear();
            graphics.beginFill(0);
            graphics.drawRect(0, 0, BW*COLS, HEIGHT);
            for each (var b:* in a) {
                graphics.beginFill(b.c);
                graphics.drawRect(b.x, b.y, b.w, b.h);
            }
            graphics.beginFill(0xFFFFFF);
            graphics.drawCircle(px, py, 4);
            graphics.beginFill(0xCCCCFF);
            graphics.drawRect(lx, ly, PW, 8);
        }
    }
}
