/**
 * Copyright dopplex ( http://wonderfl.net/user/dopplex )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4cfP
 */

// forked from coppieee's パーティクル崩し
//コードはめっちゃ汚いよ！
//ブロックの数465*100
//がんばってクリアしてください
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import net.hires.debug.Stats;
    import frocessing.color.ColorHSV;
    
    [SWF(width = "350", height = "465", frameRate = "30")]
    public class BlockBreaker extends Sprite 
    {
        private static const HEIGHT:Number = 465;
        private static const MINMOUSEHEIGHT:Number = 220;
        private static const WIDTH:Number = 350;
        private var lastMouseX:Number;
        private var lastMouseY:Number;
        
        private var _canvas:BitmapData;
        private var _blocks:Blocks;
        private var _fallBlocks:Vector.<Particle>;
        private var _balls:Vector.<Particle>;
        private var _bar:Bitmap;
        private var _stateInc:int;
        public function BlockBreaker()
        {
            _canvas = new BitmapData(WIDTH, HEIGHT,false,0x000000);
            addChild(new Bitmap(_canvas));
            
            _blocks = new Blocks(WIDTH, 250, HEIGHT);
            
            _fallBlocks = new Vector.<Particle>();
            
            var b:BitmapData = new BitmapData(50, 10, false, 0x00FF00);
            addChild(_bar = new Bitmap(b));
            _bar.y = WIDTH -b.width;
            var _ball:Particle = new Particle(WIDTH / 2, HEIGHT / 2);
            _ball.vx = Math.random() *10;
            _ball.vy = -Math.random() *9 -1;
            _ball.color = 0xFFFFFF;
            
            _balls = new Vector.<Particle>();
            _balls.push(_ball);
            
            //var stats:Stats = new Stats();
            //stats.y = 200;
            //addChild(stats);
            _stateInc = 0;
            _blocks.pushDownOne(_bar);
            addEventListener(Event.ENTER_FRAME, update);
            lastMouseX = stage.mouseX;
            lastMouseY = stage.mouseY;
        }
        private function update(e:Event):void
        {
          
            var fillPct:Number = (_blocks.count / (WIDTH * HEIGHT));
            _canvas.lock();
            _canvas.colorTransform(_canvas.rect, new ColorTransform (0.9, 0.5, 0.9));
            
            for each(var block:Particle in _blocks.values)
            {
                if (block)
                {
                    _canvas.setPixel(block.x, block.y, block.color);
                }
            }
            var removeBalls:Vector.<Particle> = new Vector.<Particle>();
             for each(var ball:Particle in _balls)
             {
                var bvx:Number = ball.vx;
                var bvy:Number = ball.vy;
                bvy -= 0.02;
                var bspeed:Number = Math.sqrt(bvx * bvx + bvy * bvy);
                var bradius:Number = Math.atan2(bvy, bvx);
                for (var i:int = 0; i < bspeed;i++)
                {
                    ball.x += ball.vx/bspeed;
                    ball.y += ball.vy/bspeed;
                    if (ball.x < HEIGHT)
                    {
                    var hitParticle:Particle = _blocks.getParticle(ball.x, ball.y);
                    var c:ColorHSV = new ColorHSV();
                    var tc:ColorHSV = new ColorHSV();
                    c.value = ball.color;
                    c.v -= 0.02 * Math.pow(fillPct, 4.0);
                    if(hitParticle)
                    {
                         
                            var removedP:Particle = _blocks.removeParticle(ball.x, ball.y);
                            removedP.vx = Math.cos(Math.PI*2/(30*Math.random())-15)*3;
                            removedP.vy = 1;
                            removedP.color = hitParticle.color;
                            tc.value = hitParticle.color;
                            _fallBlocks.push(removedP);
                            if ( c.v > .95)
                            {
                                ball.vy *= 0.8;
                                c.v -= 0.05 * tc.v;
                            }
                            else
                            {
                                ball.vy = -ball.vy;
                                c.v -= 0.15 * tc.v;
                            }
                    }
                        
                        if ((ball.x < 0 && ball.vx < 0) || (ball.x > WIDTH && ball.vx > 0))
                        {
                            ball.vx = -ball.vx;
                        }
                        if (ball.y < 0 && ball.vy < 0)
                        {
                            ball.vy = -ball.vy;
                        }
    
                        if (ball.y > HEIGHT || c.v <= 0.1)
                        {
                            removeBalls.push(ball);
                        }
                        if (_bar.hitTestPoint(ball.x, ball.y))
                        {
                            ball.vy = -Math.abs(ball.vy) * 1.5;
                            c.v *= 2.0;
                            if (ball.vy <= -60.0) ball.vy = -60.0;
                        }
                        ball.color = c.value;
                        _canvas.setPixel(ball.x, ball.y, ball.color);
                    }
                }
            }
            removeBalls.forEach(function(b:Particle, ...args):void {
                var index:int = _balls.indexOf(b);
                if (index != -1)
                {
                    _balls.splice(index, 1);
                }
            });
            
            var removeFallBs:Vector.<Particle> = new Vector.<Particle>();
            _fallBlocks.forEach(function(fallP:Particle, ...args):void {
                fallP.vy += 0.2;
                fallP.x += fallP.vx;
                fallP.y += fallP.vy;
                _canvas.setPixel(fallP.x, fallP.y, fallP.color);
                if (_bar.hitTestPoint(fallP.x,fallP.y))
                {
                    var newball:Particle = new Particle(fallP.x,fallP.y);
                    newball.vx = fallP.vx + Math.random() * 5 - 2.5;
                    newball.vy = -Math.abs(fallP.vy) + Math.random() * 4 + 3.5;
                    var c:ColorHSV = new ColorHSV();
                    c.value = fallP.color;
                    c.v = 3 * c.v;
                    newball.color = c.value;
                    _balls.push(newball);
                    removeFallBs.push(fallP);
                }else if (fallP.y > HEIGHT)
                {
                    removeFallBs.push(fallP);
                }
            });
            
            removeFallBs.forEach(function(b:Particle,...args):void{
                var index:int = _fallBlocks.indexOf(b);
                if (index != -1)
                {
                    _fallBlocks.splice(index, 1);
                }
            });
            _bar.x = stage.mouseX;
            _bar.y = stage.mouseY;

            
            if (_bar.x > WIDTH) _bar.x = WIDTH;
            if (_bar.x < 0) _bar.x = 0;
            if (_bar.y > HEIGHT) _bar.y = HEIGHT;;
            if (_bar.y < MINMOUSEHEIGHT) _bar.y = MINMOUSEHEIGHT;
            
            _canvas.unlock();
            
            if (_blocks.count <= WIDTH)
            {
                removeEventListener(Event.ENTER_FRAME, update);
                var clearTF:TextField = new TextField();
                clearTF.text = "CLEAR!\nおめでと";
                clearTF.textColor = 0xFFFFFF;
                clearTF.autoSize = TextFieldAutoSize.LEFT;
                _canvas.draw(clearTF,new Matrix(5,0,0,5,WIDTH/2-clearTF.width*5/2,HEIGHT/2-clearTF.height*5/2));
            }
            
            if (_bar.width < 2)
            {
                removeEventListener(Event.ENTER_FRAME, update);
                var clearTF2:TextField = new TextField();
                clearTF2.text = "Unicorn Poop has gotten the better of you.";
                clearTF2.textColor = 0xFFFFFF;
                clearTF2.autoSize = TextFieldAutoSize.LEFT;
                _canvas.draw(clearTF2,new Matrix(1,0,0,1,WIDTH/2-clearTF2.width/2,HEIGHT/2-clearTF2.height/2));
            }
              if (fillPct > 0.9 *  Math.random())
            {
               _blocks.pushDownOne(_bar);
               _stateInc = 0;
            }
            
        }
    }
}
import flash.display.Bitmap;
import frocessing.color.ColorHSV;
class Blocks
{
    public function get count():int { return _count;}
    private var _count:int;
    public function get width():Number { return _width; }
    private var _width:Number;
    public function get height():Number { return _height; }
    private var _height:Number;
    private var _killCount:Number;
    public var _totalHeight:Number;
    public var _maxLength:Number;
    public var values:Vector.<Particle>;
    public var curOffset:Number;
    function Blocks(width:Number,height:Number, totalHeight:Number)
    {
        _width = width;
        _height = height;
        _totalHeight = totalHeight;
        _count = width * height;
        values = new Vector.<Particle>(width * totalHeight, false);
        curOffset = totalHeight;
        _maxLength = _totalHeight * _width;
        _killCount = 0;
        var c:ColorHSV = new ColorHSV();
        for (var i:int = 0; i < _width; i++)
        {
            c.h = 360 * i / _width;
            for (var j:int = 0 ; j < _height; j++ )
            {
                var p:Particle = new Particle(i, j);
                p.color = c.value;
                values[i + j * _width] = p;
            }
        }
    }
    public function getParticle(x:int, y:int):Particle
    {
        var index:int = (x + ((y + curOffset) % _totalHeight) * _width) % _maxLength;
        if (index < 0) return null;
        return values[index];
    }
    public function removeParticle(x:int, y:int):Particle
    {
        var index:int = (x + ((y + curOffset) % _totalHeight) * _width) % _maxLength;
        if (index < 0) return null;
        var p:Particle = values[index];
        if (p)
        {
            _count--;
            values[index] = undefined;
        }
        return p;
    }
    
    public function pushDownOne(bar:Bitmap):void
    {
        curOffset--;
        if (curOffset == 0) curOffset = _totalHeight - 1;
        
        for each(var p:Particle in values)
        {
            if(p) p.incY();
        }
        
        var c:ColorHSV = new ColorHSV();
        for(var i:int = 0; i < _width; i++)
        {
           c.h = 360 * i / _width;
           c.v = 0.75 + 0.25 * Math.cos(Math.PI * 2 * curOffset / _totalHeight);
           p = new Particle(i, 0);
           p.color = c.value;
           var count:int = 0;
           if (values[i + curOffset * _width] != undefined) 
           {
                _killCount += 1;                       
           }
           else _count++;
           values[i + curOffset * _width] = p;
           if (_killCount >= 500)
           {
               bar.width -= (_killCount / 500);
               _killCount = _killCount % 500;
           }
        }
       /* var curPart:int = 0;
        var c:ColorHSV = new ColorHSV();
        var p:Particle;
        for (var i:int = _width - 1; i >= 0; i--)
        {
            
            for (var j:int = _totalHeight - 2; j >= 0; j--)
            {
           
                   p = values[i + j  * _width];
                   if(p) p.incY();
                   values[i + (j + 1) * _width] = p;
                   values[i + j * _width] = undefined;
            }
        }
        for (var k:int = 0; k < _width; k++)
        {
           c.h = 360 * k / _width;
           p = new Particle(k, 1);
           p.color = c.value;
           values[k] = p;
        }
        */
    }

}
class Particle
{
    public var x:Number;
    public var y:Number;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var color:uint;
    public function Particle(x:Number=0,y:Number=0 )
    {
        this.x = x;
        this.y = y;
    }
    public function incY():void
    {
        this.y++;
    }

}