/**
 * Copyright publicroots ( http://wonderfl.net/user/publicroots )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4cCK
 */

/*
相対的な時計、見る人間の状態によって相対的に変化することを表現しています。
*/
package {
    import flash.display.*;
    import flash.events.Event;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.*;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.text.TextField; 
    import flash.text.TextFormat; 
    import flash.net.URLRequest;
    
    [SWF(frameRate = "60")]
    
    public class FlashTest extends Sprite {
        
        private var container   :Sprite;
        private var scene       :Scene3D;
        private var camera      :Camera3D;
        private var planeObj    :Plane;
        private var material    :MovieMaterial;
        private var objcontainer:Sprite;
        private var _myclass    :Sprite;
        private var viewport:Viewport3D; 
        private var renderer:BasicRenderEngine;
        
        private var _sec:int;
        private var _shpSec:Shape;
        private var _shpMin:Shape;
        private var _shpHour:Shape;
        private var _pathCommands:Vector.<int> = Vector.<int>([1,1,2,2,2]);
        
        //FONT
        public var textField:TextField = new TextField();
        public var date:Date;
        public var str:String = new String();
        
        public function FlashTest() {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            //時計
            Clock();
            
            //コンテナ生成
            container = new Sprite();
            addChild(container);
            container.x = 0;//235;//465/2;
            container.y = 0;//235;//465 / 2;
            //シーン生成
            scene = new Scene3D();
            viewport = new Viewport3D(800,800, true, true, true);//false, false, false);
            renderer = new BasicRenderEngine();
            //ステージに表示
            stage.addChild(viewport);
            _myclass = new Sprite();
            
            material = new MovieMaterial( _myclass, true, {//false true
                    doubleSided    :false,
                    smooth         :true
                    } );

            material.interactive = true;
            planeObj = new Plane(material,1000,1000,10,10);
            scene.addChild( planeObj );
            
            addEventListener( Event.ENTER_FRAME, onEnterFrame );
                
            //カメラ設定
            camera = new Camera3D(1500,30,3000,true,true);
            
            HumanClock();
        }
        private function Clock():void { 
            var format:TextFormat = new TextFormat();
            format.size = 20; 
            format.color = 0xcccccc; 

            textField.defaultTextFormat = format; 
            textField.x = 10;
            textField.y = 10; 
            textField.width = 200; 
            textField.height = 70; 
            addChild(textField); 
            addEventListener(Event.ENTER_FRAME, onEnterFrameClock); 
        }
        private function onEnterFrameClock(e:Event):void { 
            date = new Date(); 
            str = ""; 
            str += (date.hours < 10 ? "0" : "") + date.hours; 
            str += ":"; 
            str += (date.minutes < 10 ? "0" : "") + date.minutes; 
            str += ":"; 
            str += (date.seconds < 10 ? "0" : "") + date.seconds; 
            textField.text = str; 
        } 
        private function onEnterFrame(e:Event): void {
            planeObj.rotationX += 0.5;//(5 - Math.random()*10);//mouseX/2000;//( mouseX - 465/2 ) / 200;
            planeObj.rotationY += 0.5;//(5 - Math.random()*10);//0.5;//mouseY/2000;//( mouseY - 465/2 ) / 200;
            
            renderer.renderScene( scene, camera, viewport );
        }
        
        
        private function HumanClock():void {
            initView();
            var timer:Timer = new Timer(100);
            timer.addEventListener(TimerEvent.TIMER, onTimer);
            timer.start();
        }
        
        private function drawTrapezium($graphics:Graphics, $right:Number, $top:Number, $left:Number, $bottom:Number):void {
            $graphics.drawPath(_pathCommands, Vector.<Number>([
                $left, $bottom, -$left, $bottom, -$right, $top, $right, $top, $left, $bottom
            ]));
        }
        
        private function initView():void {
            var spContainer:Sprite = new Sprite;
            var shp:Shape;
            var t:Number;
            var layer:int;
            for (var i:int = 0; i < 2; ++i)
                spContainer.addChild(new Sprite);
                
            for (i = 0; i < 360; i += 30) {
                shp = new Shape;
                shp.graphics.beginFill(0);
                layer = 1;
                drawTrapezium(shp.graphics, 2, 16, 4, 0);
                shp.rotation = i;
                shp.alpha = 0.1;
                t = Math.PI / 180 * i - Math.PI / 2;
                shp.x = 180 * Math.cos(t); shp.y = 180 * Math.sin(t);
                Sprite(spContainer.getChildAt(layer)).addChild(shp);
                //spContainer.addChild(shp);
            }
            
            _shpHour = new Shape;
            _shpHour.graphics.beginFill(0xff0000);
            drawTrapezium(_shpHour.graphics, 6, 90, 10, -5);
            _shpHour.graphics.endFill();
           
            _shpMin = new Shape;
            _shpMin.graphics.beginFill(0x00ff00);
            drawTrapezium(_shpMin.graphics, 5, 130, 8, -5);
            _shpMin.graphics.endFill();
            
            _shpSec = new Shape;
            _shpSec.graphics.beginFill(0x0000ff);
            drawTrapezium(_shpSec.graphics, 3, 150, 5, -5);
            _shpSec.graphics.endFill();
            
            addChild(spContainer);
            spContainer.x = spContainer.y = 465 >> 1;
            spContainer.y = 235;
            spContainer = Sprite(spContainer.addChild(new Sprite));
            spContainer.addChild(_shpHour);
            spContainer.addChild(_shpMin);
            spContainer.addChild(_shpSec);
            _shpHour.x = 0; _shpHour.y = 0;
            _shpMin.x = 0; _shpMin.y = 0;
            _shpSec.x = 0; _shpSec.y = 0;
            spContainer.rotation = 360;
            
            onTimer(null);
            _myclass.addChild(spContainer);
            //addChild(spContainer);
        }

        private function onTimer(e:TimerEvent):void {
            var time:Date = new Date;
            var sec:int = time.getSeconds();
            if (_sec == sec) return;
            
            _sec = sec;
            updateView(time.getHours(), time.getMinutes(), sec);
            
            //planeObj.rotationX = Math.random()*180;//mouseX/2000;//( mouseX - 465/2 ) / 200;
            //planeObj.rotationY = Math.random()*180;//mouseY/2000;//( mouseY - 465/2 ) / 200;
            
            //renderer.renderScene( scene, camera, viewport );
        }
        
        private function updateView($hour:int, $min:int, $sec:int):void {
            _shpHour.rotation = ($hour % 12) * 30 + $min / 2;
            _shpMin.rotation = $min * 6;
            _shpSec.rotation = _sec * 6;
        }
    }
}