/**
 * Copyright kjkmr ( http://wonderfl.net/user/kjkmr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4bvV
 */

package {
    
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    
    /*--------------------------------------------------
    * シンプルな破線を描画するクラス（直線のみ）
    * http://github.com/kjkmr/KIMULABOAS3/blob/master/src/jp/kimulabo/display/DashedLine.as
    --------------------------------------------------*/
    public class Line extends Sprite {
        
        public function Line() {
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            //デフォルトの黒い点線、長さ300px、太さ1px
            var line1:DashedLine = new DashedLine( 300 );
            line1.x = 50;
            line1.y = 50;
            addChild( line1 );
            
            //青色、長さ300px、太さ3px
            var line2:DashedLine = new DashedLine( 300, 3, 0x5390CD );
            line2.x = 50;
            line2.y = 100;
            addChild( line2 );
            
            //水色、長さ300px、太さ3px, 線分3px、間隔3px
            var line3:DashedLine = new DashedLine( 300, 3, 0x4CBFDD, 3, 3 );
            line3.x = 50;
            line3.y = 150;
            addChild( line3 );
            
            //青緑色、長さ300px、太さ3px, 線分6px、間隔3px
            var line4:DashedLine = new DashedLine( 300, 3, 0x34B7AF, 6, 3 );
            line4.x = 50;
            line4.y = 200;
            addChild( line4 );
            
            //緑色、長さ300px、太さ3px, 線分3px、間隔6px
            var line5:DashedLine = new DashedLine( 300, 3, 0x8FC31F, 3, 6 );
            line5.x = 50;
            line5.y = 250;
            addChild( line5 );
            
            //斜めの黄色、長さ300px、太さ9px, 線分3px、間隔6px
            var line6:DashedLine = new DashedLine( 300, 9, 0xF4EC2E, 3, 6 );
            line6.x = 50;
            line6.y = 300;
            line6.rotation = 2;
            addChild( line6 );
            
            //斜めのオレンジ色、長さ300px、太さ9px, 線分3px、間隔6px
            var line7:DashedLine = new DashedLine( 300, 6, 0xFABE00, 3, 6 );
            line7.x = 50;
            line7.y = 350;
            line7.rotation = 4;
            addChild( line7 );
            
            //縦の黒色、長さ300px、太さ2px, 線分2px、間隔2px
            var line8:DashedLine = new DashedLine( 300, 2, 0, 2, 2 );
            line8.x = 400;
            line8.y = 50;
            line8.rotation = 90;
            addChild( line8 );
            
        }
    }
}

import flash.display.Shape;
import flash.display.BitmapData;

/*--------------------------------------------------
* シンプルな破線を描画するクラス（直線のみ）
--------------------------------------------------*/
class DashedLine extends Shape {
    /*--------------------------------------------------
    * プロパティ
    --------------------------------------------------*/
    private var _length:Number;
    private var _weight:Number;
    private var _color:uint;
    private var _dash:uint;
    private var _gap:uint;
    
    private var _bitmapData:BitmapData;
    
    /*--------------------------------------------------
    * コンストラクタ
    --------------------------------------------------*/
    public function DashedLine( i_length:Number, i_weight:Number = 0, i_color:uint = 0, i_dash:uint = 1, i_gap:uint = 1 ) {
        
        _length = i_length;
        _weight = i_weight;
        _color = i_color;
        _dash = i_dash;
        _gap = i_gap;
        
        makePattern();
    }
    
    /*--------------------------------------------------
    * パターンビットマップ生成
    --------------------------------------------------*/
    public function makePattern():void {
        _bitmapData = new BitmapData( _dash + _gap, 1, true, 0 );
        _bitmapData.lock();
        var i:uint = 0;
        for ( i=0; i<_dash; i++ ) _bitmapData.setPixel32( i, 0 , 0xff000000 | _color );
        draw();
    }
    
    /*--------------------------------------------------
    * 描画
    --------------------------------------------------*/
    public function draw():void {
        graphics.clear();
        graphics.lineStyle( _weight, 0, 1, true, "normal", "none" );
        graphics.lineBitmapStyle( _bitmapData, null, true, true );
        graphics.moveTo( 0, 0 );
        graphics.lineTo( _length, 0 );
    }
    
    /*--------------------------------------------------
    * lengthプロパティ
    --------------------------------------------------*/
    public function get length():uint { return _length; }
    public function set length( i_value:uint ):void {
        _length = i_value;
        draw();
    }
    
    /*--------------------------------------------------
    * weightプロパティ
    --------------------------------------------------*/
    public function get weight():uint { return _weight; }
    public function set weight( i_value:uint ):void {
        _weight = i_value;
        draw();
    }
    
    /*--------------------------------------------------
    * colorプロパティ
    --------------------------------------------------*/
    public function get color():uint { return _color; }
    public function set color( i_value:uint ):void {
        _color = i_value;
        makePattern();
    }
    
    /*--------------------------------------------------
    * dashプロパティ
    --------------------------------------------------*/
    public function get dash():uint { return _dash; }
    public function set dash( i_value:uint ):void {
        _dash = i_value;
        makePattern();
    }
    
    /*--------------------------------------------------
    * gapプロパティ
    --------------------------------------------------*/
    public function get gap():uint { return _gap; }
    public function set gap( i_value:uint ):void {
        _gap = i_value;
        makePattern();
    }
    
    
}
