/**
 * Copyright rafael1 ( http://wonderfl.net/user/rafael1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4bnX
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.media.Video;
    import flash.geom.Matrix;
    
    public class FlashTest extends Sprite 
    {        
        private var vid:Video;
        private var nc:NetConnection;
        private var ns:NetStream;
        private var meta:Object = new Object();
        
        private var d:Boolean;
        private var count:Number = 0;
        
        private var sw:Number;
        private var sh:Number;
         
        private var tiles:uint;
        private var vw:Number;
        private var vh:Number;
        
        private var bData:BitmapData;
        private var bitmap:Bitmap;
                
        public function FlashTest() 
        {
            if(stage)init(null);
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            stage.frameRate = 12;
            
            sw = stage.stageWidth;
            sh = stage.stageHeight;
            
            nc = new NetConnection();
            nc.connect(null);
            
            ns = new NetStream(nc);
            ns.client = this.meta;
            
            vid = new Video(320, 240);
            addChild(vid);
            vid.visible = false;
            vid.attachNetStream(ns);
            ns.checkPolicyFile = true;
            ns.play("http://www.soho.com.co/media/md_259/Media-259_20091117_105907_High.flv");
            
            bData = new BitmapData(sw, sh, false, 0xeeeeee);
            bitmap = new Bitmap(bData);
            addChild(bitmap);

            addEventListener(Event.ENTER_FRAME, increaseMe);
            addEventListener(Event.ENTER_FRAME, doMath);
        }
        
        private function doMath(e:Event):void
        {
            for (var i:uint=0; i<tiles; i++) {
                for (var j:uint = 0; j < tiles; ++j) {
                    var matrix:Matrix = new Matrix();
                    matrix.translate(j*vw, i*vh);
                    bData.draw(vid, matrix);
                }
            }            
        }
        
        private function increaseMe(e:Event):void
        {
            if(d)--count;
            else ++count;
            
            setTiles();
            
            if(count == 20)d = true
            else if(count == 1)d = false;
        }

        
        private function setTiles():void 
        {
            tiles = count;
            vw = sw/tiles;
            vh = sh/tiles;
            
            vid.width = vw;
            vid.height = vh;
        }
    }
}