/**
 * Copyright yasurageruheya ( http://wonderfl.net/user/yasurageruheya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4aqS
 */

package {
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Rectangle;
	import flash.system.System;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.utils.ByteArray;
	public class FlashTest extends Sprite {
		
		/************************************
		 * ↓ テスト用のメソッドは結構下のほうにあります。 ↓
		 ************************************/
		
		public const LOOP:int = 5000;
		
		public const txt:TextField = new TextField();
		
		public var tests:Vector.<Tester> = new Vector.<Tester>();
		
		public var freeMemory:int;
		
		public var gcCount10byte:int = 0;
		
		public var gcCount100byte:int = 0;
		
		public var gcCount1KB:int = 0;
		
		public var gcCount10KB:int = 0;
		
		public var gcCount100KB:int = 0
		
		public var gcCount1MB:int = 0;
		
		public var gcCount10MB:int = 0;
		
		public var gcCount100MB:int = 0;
		
		public var gcCount:int = 0;
		
		public var totalFrames:Number = 1;
		
		public function FlashTest() {
			
			
			tests[tests.length] = new Tester('1. リスナーを追加せずリスナーチェックして dispatch しない\t: ', emptyListenerCheckDispatch);
			tests[tests.length] = new Tester('2. リスナーを追加せずリスナーチェックせず dispatch する\t\t: ', emptyNoListenerCheckDispatch);
			tests[tests.length] = new Tester('3. リスナーを追加してリスナーチェックして dispatch する\t\t: ', hasListenerCheckDispatch);
			tests[tests.length] = new Tester('4. リスナーを追加してリスナーチェックせず dispatch する\t\t: ', hasListenerNoCheckDispatch);
			tests[tests.length] = new Tester('5. 3.の Event オブジェクト使い回し版\t\t\t\t\t\t: ', hasListenerCheckShareEventDispatch);
			tests[tests.length] = new Tester('6. 4.の Event オブジェクト使い回し版\t\t\t\t\t\t: ', hasListenerNoCheckShareEventDispatch);
			
			tests.reverse();
			var format:TextFormat = txt.getTextFormat();
			format.font = "_等幅";
			txt.defaultTextFormat = format;
			txt.width = 500;
			txt.height = 500;
			addChild(txt);
			
			freeMemory = System.freeMemory;
			
			// write as3 code here..
			addEventListener(Event.ENTER_FRAME, test);
		}
		
		private function test(e:Event):void 
		{
			var str:String = "";
			var i:int = tests.length;
			while (i--)
			{
				str += tests[i].start();
			}
			str += "\nmemory : total " + System.totalMemory + " / private " + System.privateMemory + "\n";
			
			const currentFreeMemory:Number = System.freeMemory;
			
			if (freeMemory < currentFreeMemory)
			{
				gcCount++;
				const gcMemory:Number = currentFreeMemory - freeMemory;
				if (gcMemory > 100000000)
				{
					gcCount100MB++;
				}
				else if (gcMemory > 10000000)
				{
					gcCount10MB++;
				}
				else if (gcMemory > 1000000)
				{
					gcCount1MB++;
				}
				else if (gcMemory > 100000)
				{
					gcCount100KB++;
				}
				else if (gcMemory > 10000)
				{
					gcCount10KB++;
				}
				else if (gcMemory > 1000)
				{
					gcCount1KB++;
				}
				else if (gcMemory > 100)
				{
					gcCount100byte++;
				}
				else if (gcMemory > 10)
				{
					gcCount10byte++;
				}
			}
			freeMemory = System.freeMemory;
			
			str += "\n100MB\tGC発生回数？\t: " + gcCount100MB;
			str += "\n10MB\tGC発生回数？\t: " + gcCount10MB;
			str += "\n1MB\t\tGC発生回数？\t: " + gcCount1MB;
			str += "\n100KB\tGC発生回数？\t: " + gcCount100KB;
			str += "\n10KB\tGC発生回数？\t: " + gcCount10KB;
			str += "\n1KB\t\tGC発生回数？\t: " + gcCount1KB;
			str += "\n100byte\tGC発生回数？\t: " + gcCount100byte;
			str += "\n10byte\tGC発生回数？\t: " + gcCount10byte;
			str += "\n\t\t計GC発生回数？\t: " + gcCount;
			
			str += "\n\t\tGC発生率？\t\t: " + ((gcCount / (totalFrames++)) * 100) + "%";
			
			txt.text = str;
		}
		
		/**************************************
		 * ↓ テスト用メソッドここから ↓
		 **************************************/
		
		[Inline]
		final private function emptyListenerCheckDispatch():void
		{
			var i:int = LOOP;
			while (i--)
			{
				if (hasEventListener(Event.RENDER)) dispatchEvent(new Event(Event.RENDER));
			}
		}
		
		[Inline]
		final private function emptyNoListenerCheckDispatch():void
		{
			var i:int = LOOP;
			while (i--)
			{
				dispatchEvent(new Event(Event.RENDER));
			}
		}
		
		[Inline]
		final private function hasListenerCheckDispatch():void
		{
			addEventListener(Event.RENDER, onRenderHandler);
			var i:int = LOOP;
			while (i--)
			{
				if (hasEventListener(Event.RENDER)) dispatchEvent(new Event(Event.RENDER));
			}
			removeEventListener(Event.RENDER, onRenderHandler);
		}
		
		[Inline]
		final private function hasListenerNoCheckDispatch():void
		{
			addEventListener(Event.RENDER, onRenderHandler);
			var i:int = LOOP;
			while (i--)
			{
				dispatchEvent(new Event(Event.RENDER));
			}
			removeEventListener(Event.RENDER, onRenderHandler);
		}
		
		[Inline]
		final private function hasListenerCheckShareEventDispatch():void
		{
			addEventListener(Event.RENDER, onRenderHandler);
			var i:int = LOOP;
			var e:Event = new Event(Event.RENDER);
			while (i--)
			{
				if (hasEventListener(Event.RENDER)) dispatchEvent(e);
			}
			removeEventListener(Event.RENDER, onRenderHandler);
		}
		
		[Inline]
		final private function hasListenerNoCheckShareEventDispatch():void
		{
			addEventListener(Event.RENDER, onRenderHandler);
			var i:int = LOOP;
			var e:Event = new Event(Event.RENDER);
			while (i--)
			{
				dispatchEvent(e);
			}
			removeEventListener(Event.RENDER, onRenderHandler);
		}
		
		[Inline]
		final private function onRenderHandler(e:Event):void 
		{
			
		}
	}
}

import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.events.EventDispatcher;
import flash.geom.Rectangle;
import flash.system.System;
import flash.utils.ByteArray;
import flash.utils.Dictionary;
import flash.utils.getTimer;
class Tester
{
	public var time:Number = 0;
	
	public var name:String;
	
	public var test:Function;
	
	public var count:Number = 1;
	
	public function start():String
	{
		const startTime:int = getTimer();
		test();
		time += getTimer() - startTime;
		return name + (time / (count++)) + " ms.\n";
	}
	
	public function get timeAverage():Number
	{
		return time / count;
	}
	
	public function Tester(name:String, test:Function)
	{
		this.name = name;
		this.test = test;
	}
}