/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/4ao3
 */

// forked from nutsu's FLARToolKit use flash.geom package test
// forked from mash's FLARToolKit SimpleCube sample
// from flartoolkit SimpleCube example
// print this marker: http://saqoosha.net/lab/FLARToolKit/flarlogo-marker.pdf
//flash.geom.* でFLAR使うテスト。あってるかな、、
//座標系まちごうとったから変えた
package  
{
    import flash.display.*;
    import flash.events.Event;
    import flash.geom.*;
    import org.libspark.flartoolkit.core.FLARMat;
    import org.libspark.flartoolkit.core.param.FLARParam;
    import org.libspark.flartoolkit.core.transmat.FLARTransMatResult;
    import org.libspark.flartoolkit.core.types.FLARIntSize;
    import org.libspark.flartoolkit.example.ARAppBase;
    
    [SWF( width=640, height=480, frameRate=30, backgroundColor=0 )]
    public class ARTest extends ARAppBase
    {
        private var _base:Sprite;
        private var _view:Shape;
        private var g:Graphics;
        
        //
        private var _rmat:FLARTransMatResult = new FLARTransMatResult();
        private var _fr_mat:Matrix3D;
        private var _de_mat:Matrix3D;
        
        //
        private var _mat:Matrix3D;
        private var vert1:Vector.<Number>;
        private var uvt1:Vector.<Number>;
        private var vert2:Vector.<Number>;
        private var uvt2:Vector.<Number>;
        private var vout:Vector.<Number>;
        //
        private var projmat:Matrix3D;
        
        public function ARTest() 
        {
            Wonderfl.capture_delay( 5 );
            addEventListener(Event.INIT, _onInit);
            init('http://assets.wonderfl.net/static/flar/camera_para.dat', 'http://assets.wonderfl.net/static/flar/flarlogo.pat');
        }
        
        private function _onInit(e:Event):void 
        {
            addChild( _base = new Sprite() );
            
            //
            _capture.width = 640;
            _capture.height = 480;
            _base.addChild(_capture);
            //
            g = Shape(addChild( _view = new Shape() )).graphics;
            _view.x = 320;
            _view.y = 240;
            _view.scaleX = _view.scaleY = 2;
            //
            _fr_mat = new Matrix3D();
            _de_mat = new Matrix3D();
            initCamera( this._param );
            
            //
            projmat = new Matrix3D();
            initARObjects();
            
            //
            stage.addEventListener(Event.ENTER_FRAME, _onEnterFrame);
        }
        
        private function initARObjects():void
        {
            // Create Plane with same size of the marker.
            vert1 = new Vector.<Number>();
            uvt1  = new Vector.<Number>();
            var w:Number = 40;
            vert1.push( 0, 0, 0, 
                        -w, -w, 0, w, -w, 0, w, w, 0, -w, w, 0,
                        w, 0, 0, 0, w, 0, 0, 0, w );
            for ( var i:int = 0; i < vert1.length; i++ ) {
                uvt1.push( 0 );
            }
            
            //cube
            vert2 = new Vector.<Number>();
            uvt2  = new Vector.<Number>();
            w /= 2;
            vert2.push( -w, -w, -w,   w, -w, -w,   w, w, -w,   -w, w, -w,
                        -w, -w,  w,   w, -w,  w,   w, w,  w,   -w, w,  w );
            for ( i = 0; i < vert1.length; i++ ) {
                uvt1.push( 0 );
            }
            
            //
            _mat = new Matrix3D();
            //
            vout = new Vector.<Number>();
        }
        
        private function drawObjects():void
        {
            g.clear();
            
            vout.length = 0;
            Utils3D.projectVectors( projmat, vert1, vout, uvt1 );
            g.lineStyle( 2, 0xffffff );
            g.beginFill( 0xff0000, 0.2 );
            quad( vout[2], vout[3], vout[4], vout[5], vout[6], vout[7], vout[8], vout[9] );
            g.endFill();
            //x axis
            g.lineStyle( 2, 0xff0000 );
            line( vout[0], vout[1], vout[10], vout[11] );
            //y axis
            g.lineStyle( 2, 0x0000ff );
            line( vout[0], vout[1], vout[12], vout[13] );
            //z axis
            g.lineStyle( 2, 0x00ff00 );
            line( vout[0], vout[1], vout[14], vout[15] );
            
            //cube
            _mat.identity();
            _mat.appendTranslation( 0, 0, 20 );
            var vert2t:Vector.<Number> = new Vector.<Number>();
            _mat.transformVectors( vert2, vert2t );
            vout.length = 0;
            Utils3D.projectVectors( projmat, vert2t, vout, uvt2 );
            g.lineStyle( 1, 0xffffff );
            quad( vout[0], vout[1], vout[2], vout[3], vout[4], vout[5], vout[6], vout[7] );
            quad( vout[8], vout[9], vout[10], vout[11], vout[12], vout[13], vout[14], vout[15] );
            line( vout[0], vout[1], vout[8], vout[9] );
            line( vout[2], vout[3], vout[10], vout[11] );
            line( vout[4], vout[5], vout[12], vout[13] );
            line( vout[6], vout[7], vout[14], vout[15] );
            
        }
        
        private function line( x0:Number, y0:Number, x1:Number, y1:Number ):void
        {
            g.moveTo( x0, y0 );
            g.lineTo( x1, y1 );
        }
        
        private function quad( x0:Number, y0:Number, x1:Number, y1:Number, x2:Number, y2:Number, x3:Number, y3:Number ):void
        {
            g.moveTo( x0, y0 );
            g.lineTo( x1, y1 );
            g.lineTo( x2, y2 );
            g.lineTo( x3, y3 );
            g.lineTo( x0, y0 );
        }
        
        private function _onEnterFrame(e:Event):void 
        {
            _capture.bitmapData.draw(_video);
            var detected:Boolean = false;
            try {
                detected = _detector.detectMarkerLite(_raster, 80) && _detector.getConfidence() > 0.5;
            } catch (e:Error) {}
            
            if (detected) {
                _detector.getTransformMatrix(_rmat);
                _de_mat.rawData = Vector.<Number>(
                    [  _rmat.m00,   _rmat.m10,   _rmat.m20, 0,
                       _rmat.m01,   _rmat.m11,   _rmat.m21, 0,
                       _rmat.m02,   _rmat.m12,   _rmat.m22, 0,
                       _rmat.m03,   _rmat.m13,   _rmat.m23, 1 ]
                );
                projmat.rawData = Vector.<Number>([0,1,0,0, 1,0,0,0, 0,0,1,0, 0,0,0,1]);
                projmat.append( _de_mat );
                projmat.append( _fr_mat );
                drawObjects();
                _view.visible = true;
            } else {
                _view.visible = false;
            }
        }
        
        //無駄あったから整理した
        private function initCamera( param:FLARParam ):void
        {
            var  size:FLARIntSize = param.getScreenSize();
            var  width:int  = size.w;
            var  height:int = size.h;
            var  tMat:FLARMat = new FLARMat (3, 4);
            var  iMat:FLARMat = new FLARMat (3, 4);
            param.getPerspectiveProjectionMatrix().decompMat(iMat, tMat);
            var icpara:Array = iMat.getArray();
            for (var i:int = 0; i < 4; i++) {
                icpara[1][i] = (height - 1) * (icpara[2][i]) - icpara[1][i];
            }
            var w:Number = icpara[0][0] / icpara[2][2];
            var h:Number = -icpara[1][1] / icpara[2][2];
            _fr_mat.rawData = Vector.<Number>(
                [ w,  0,  0,  0,
                  0,  h,  0,  0,
                  0,  0,  1,  1,
                  0,  0,  0,  0 ]
            );
        }
    }
}
