/**
 * Copyright geko ( http://wonderfl.net/user/geko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4aN3
 */

//http://www.apple.com/jp/itunes/

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import caurina.transitions.Tweener;
    
    public class iTunes10Icon extends Sprite {
        public function iTunes10Icon() {
            this.x = stage.stageHeight/2;
            this.y = stage.stageWidth/2;
            scaleX = scaleY = 2;
            
            addChild(new Sphere(70));
            addChild(new TwinsTadpole(75, 88));
            addChild(new Lightness(67));
            addChild(new Frame(78, 70));
            
            for(var i:int = 0; i < numChildren; i++){
                getChildAt(i).addEventListener(MouseEvent.MOUSE_DOWN, drag);
                getChildAt(i).addEventListener(MouseEvent.MOUSE_UP, drag);
            }

        }
        
        public function drag(event:MouseEvent):void{
            switch(event.type){
                case MouseEvent.MOUSE_DOWN:
                    event.target.startDrag();
                break;
                case MouseEvent.MOUSE_UP:
                    event.target.stopDrag();
                    Tweener.addTween(event.target, {x:0, y:0, time:0.4});
                break;
            }
        }
    }
}

import flash.display.*;
import flash.filters.*;
import flash.geom.Matrix;

//双子のおたまじゃくし
class TwinsTadpole extends Sprite{
    public function TwinsTadpole(width:Number, height:Number):void{
        var _mask:Sprite = new Sprite();
        var tadpoleA:Sprite = createSingleTadpole(width*4/10, height*9/10);
        var tadpoleB:Sprite = createSingleTadpole(width*4/10, height*9/10);
        var bridge:Shape = createBridge(width - tadpoleA.width*3/4, height*1/3);
        tadpoleA.x = -width/2;
        tadpoleA.y = -height*2/5;
        tadpoleB.x = width/2-width*4/10;
        tadpoleB.y = -height/2;
        bridge.x = tadpoleA.x + width*3/10;
        bridge.y = tadpoleB.y;
        
        _mask.addChild(tadpoleA);
        _mask.addChild(tadpoleB);
        _mask.addChild(bridge);
        
        var mtrx:Matrix = new Matrix();
        mtrx.createGradientBox(height, width, Math.PI*4/9, 0, -height/2);
        graphics.beginGradientFill("linear", [0x000000, 0x333333], [1, 1], [127, 255], mtrx);
        graphics.drawRect(-width/2, -height/2, width, height);
        graphics.endFill();
        
        addChild(_mask);
        mask = _mask;
        
        filters = [new DropShadowFilter(1, 90, 0x444444, 1, 5, 5, 3, 1, true),
                   new DropShadowFilter(1, 90, 0x000000, 1, 5, 5, 3, 1),
                   new GlowFilter(0xFFFFFF, 0.8, 8, 8, 2, 3),
                   new GlowFilter(0x52D7F6, 0.8, 50, 70, 3, 3)];
    }
    
    private function createSingleTadpole(width:Number, height:Number):Sprite{
        var tadpole:Sprite = new Sprite();
        var body:Shape = new Shape();
        var tail:Shape = new Shape();
        
        body.graphics.beginFill(0);
        body.graphics.drawEllipse(-width/2, -height*5/32, width, height*5/16);
        body.graphics.endFill();
        body.x = width/2;
        body.y = height*27/32;
        body.rotation = -10;
        
        tail.graphics.beginFill(0);
        tail.graphics.drawRect(width*3/4, 0, width*1/4, height*27/32);
        tail.graphics.endFill();
                
        tadpole.addChild(body);
        tadpole.addChild(tail);
        
        return tadpole;
    }
    
    private function createBridge(width:Number, height:Number):Shape{
        var bridge:Shape = new Shape();
        
        bridge.graphics.beginFill(0);
        bridge.graphics.moveTo(0, height*1/4);
        bridge.graphics.curveTo(width*1/2, 0, width, 0);
        bridge.graphics.lineTo(width, height*3/4);
        bridge.graphics.curveTo(width*1/2, height*3/4, 0, height);
        bridge.graphics.endFill();
        
        return bridge;
    }
}

//球体
class Sphere extends Sprite{
    public function Sphere(radius:Number){
        var mtrx:Matrix = new Matrix();
        mtrx.createGradientBox(radius*2, radius*2, 0, -radius, -radius);
        graphics.beginGradientFill("radial", [0x1D90F9, 0x2020BB], [1, 1], [127, 255], mtrx);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
        
        filters = [new DropShadowFilter(1, 90, 0x000000, 1, 25, 25, 1, 3, true)];
    }
}

//外枠
class Frame extends Sprite{
    public function Frame(outerRadius:Number, innerRadius:Number){
        graphics.lineStyle(0.5, 0x999999);
        graphics.beginFill(0xFFFFFF);
        graphics.drawCircle(0, 0, outerRadius);
        graphics.drawCircle(0, 0, innerRadius);
        graphics.endFill();
        var mtrx:Matrix = new Matrix();
        mtrx.createGradientBox(height, width, Math.PI*4/9, 0, -height/2);
        graphics.beginGradientFill("linear", [0xFFFFFF, 0xCCCCCC], [1, 1], [0, 255], mtrx);
        graphics.drawCircle(0, 0, outerRadius-2);
        graphics.drawCircle(0, 0, innerRadius);
        graphics.endFill();
        
        filters = [new DropShadowFilter(1.5, 90, 0x000000, 1, 8, 6, 1, 3)];//, new GlowFilter(0x333333, 0.6, 12, 12, 1, 3)];
    }
}

//明るいやつ
class Lightness extends Sprite{
    public function Lightness(radius:Number){
        var _mask:Sprite = new Sprite();
        _mask.graphics.beginFill(0xFFFFFF);
        _mask.graphics.drawCircle(0, 0, radius);
        _mask.graphics.drawCircle(0, -radius*3+5, radius*3);
        _mask.graphics.endFill();
        _mask.mouseEnabled = false;
        
        var mtrx:Matrix = new Matrix();
        mtrx.createGradientBox(radius*2, radius*2, 0, -radius, -radius*2);
        graphics.beginGradientFill("radial", [0xFFFFFF, 0xFFFFFF], [0.9, 0.2], [0, 255], mtrx);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
        
        _mask.blendMode = BlendMode.ERASE;
        blendMode = BlendMode.LAYER;
        addChild(_mask);
    }
}