/**
 * Copyright hi.kurosawa ( http://wonderfl.net/user/hi.kurosawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4ZKN
 */

package {
    //------------------------------------------
    //ジュリア集合の画像のスライドショー
    // URL:http://programmingatelier.net/
    //------------------------------------------
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.utils.setTimeout;
    import flash.display.StageScaleMode; 
    import flash.display.StageAlign;
    
    public class JuliaPSS extends Sprite {
        //それなりの画像が出来る位置（中心）と幅（d*2）
        public var arrItiData:Array = new Array(
            {a:-0.23,af:false,b:0.72,bf:true,x:-0.321420118343195,y:-0.430769230769231,d:0.207100591715976},
            {a:0,af:false,b:0.89,bf:true,x:0.00479584775086505,y:-0.00135640138408305,d:0.121107266435986},
            {a:-1,af:false,b:0.17,bf:true,x:0.122123966942149,y:-0.184140495867769,d:0.016435011269722},
            {a:-1,af:false,b:1,bf:true,x:-0.393913035311796,y:-0.306202667167543,d:0.016435011269722},
            {a:-0.16,af:true,b:0.2,bf:true,x:0.690309917355372,y:-0.226053719008265,d:0.016435011269722},
            {a:-0.45,af:true,b:0.08,bf:false,x:0.205617728531856,y:-0.429191135734072,d:0.0969529085872576},
            {a:-0.01,af:true,b:0.29,bf:true,x:-0.186180555555556,y:-0.780208333333333,d:0.121527777777778},
            {a:-0.95,af:false,b:0.26,bf:true,x:-0.407679128643616,y:-0.316017456146001,d:0.000108907017772094},
            //
            {a:-0.95,af:false,b:0.26,bf:true,x:0.5299315457671834,y:-0.03519879928773159,d:0.00010187751172455883},
            {a:0.52,af:true,b:-0.75,bf:true,x:-0.019110689230769227,y:0.7211060338461539,d:0.031534461538461546},
            {a:0.67,af:true,b:-1,bf:true,x:0.0011637565740045,y:0.3939202404207362,d:0.0023905470937777462},
            {a:-0.28,af:true,b:0.1499999999999999,bf:false,x:-0.19712,y:0.6524,d:0.055999999999999994},
            {a:-0.39,af:true,b:-0.1,bf:false,x:0.7546996289201869,y:0.4244190332434237,d:0.01515937374461436},
            {a:0.46,af:false,b:-0.7,bf:true,x:0.3361728395061728,y:0.48135802469135797,d:0.11618655692729768},
            {a:0.59,af:false,b:-0.92,bf:true,x:0.23908422837761453,y:-0.03252685132843415,d:0.0791407574901074},
            {a:-1,af:false,b:0.41,bf:true,x:0.5765772594752187,y:0.2126822157434402,d:0.00932944606413994},
            {a:-1,af:false,b:0.25,bf:true,x:0.588,y:0.126,d:0.39999999999999997},
            {a:-0.97,af:false,b:0.8500000000000001,bf:true,x:0.8619999999999999,y:0.5,d:0.39999999999999997},
            {a:-0.97,af:false,b:0.7,bf:true,x:0.48513818221999333,y:0.46071233924640237,d:0.00021759640965924058},
            {a:-0.06,af:true,b:0.26,bf:true,x:0,y:0,d:1},
            {a:0.43,af:true,b:-0.64,bf:true,x:0.3164,y:1.0429688888888888,d:0.031111111111111107},
            {a:-0.24,af:false,b:0.68,bf:true,x:0.35007363576594347,y:-0.2717527942143327,d:0.05414394554666048},
            {a:-0.01,af:false,b:0.68,bf:true,x:0.3927179487179487,y:0.6224615384615385,d:0.09204470742932282},
            {a:0.24,af:false,b:-0.57,bf:true,x:-0.014,y:-0.044,d:0.5185185185185185},
            {a:0.21,af:false,b:0.55,bf:true,x:-0.04441975308641976,y:-0.5119506172839505,d:0.1920438957475994},
            {a:0.4,af:false,b:0.24,bf:true,x:-0.18190113295737437,y:0.5020269267896154,d:0.005229953587897587},
            {a:-0.04,af:false,b:0.66,bf:true,x:0.21466666666666667,y:0.46459259259259256,d:0.25925925925925924},
            {a:0.39,af:false,b:0.17,bf:true,x:0.28,y:-0.406,d:0.25925925925925924},
            {a:-0.05,af:false,b:0.65,bf:true,x:-0.1372,y:-0.2212,d:0.1456},
            {a:0.49,af:false,b:-0.76,bf:true,x:0,y:0,d:1.4}
        );
        //ジュリア集合の描画エリア
        private var bdMandelbrot:BitmapData;
        public var arrColor:Array;    //グラデーションカラー
        public var uintHassan:uint;    //発散しない時のカラー
        private var intBMw:Number;    //描画サイズ
        private var intBMh:Number;
        private var iloop:int;        //描画状態(0～39)
        private var iTyp:int;        //画像の切り替え時のエフェクト
        private    var xMin:Number;    //ジュリア集合の左上の座標値
        private    var yMin:Number;
        private    var Step:Number;    //ジュリア集合の1ピクセルの値
        private const intKurikaesi:Number = 256;    //最大繰り返し数
        private var numA:Number;
        private var numB:Number;
        private var bolA:Boolean;
        private var bolB:Boolean;

        public function JuliaPSS():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //下の2行を加えるとHTMLで定義したサイズで表示
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align =StageAlign.TOP_LEFT;
            intBMw = stage.stageWidth;    //描画サイズ取得
            intBMh = stage.stageHeight;
            //描画エリアの作成
            bdMandelbrot = new BitmapData(intBMw, intBMh, false, 0xffffff);
            var bm:Bitmap = new Bitmap(bdMandelbrot);
            stage.addChild(bm);
            bm.x = (intBMw-stage.width)/2;
            bm.y = (intBMh-stage.height)/2;
            fncDispSt();        //描画開始
        }
        //描画開始
        private function fncDispSt():void {
            iloop = 0;        //描画位置クリア
            fncSerColor();    //グラデーションカラー
            uintHassan = 0x000000;    //発散しない時のカラー
            //それなりの画像が出来る位置テーブルの選択
            var intItiData:int = getIntRand(0, arrItiData.length - 1);
            var d:Number = arrItiData[intItiData].d;
            numA= arrItiData[intItiData].a;
            numB= arrItiData[intItiData].b;
            bolA= arrItiData[intItiData].af;
            bolB= arrItiData[intItiData].bf;
            //ジュリア集合の1ピクセルの値
            if (intBMh < intBMw) {
                Step = arrItiData[intItiData].d / intBMh;
            } else {
                Step = arrItiData[intItiData].d / intBMw;
            }
            Step = getNumRand(Step , Step * 1.5 );
            //ジュリア集合上の開始位置を決める
            xMin = arrItiData[intItiData].x - d  + getNumRand(0,  2*d-intBMw*Step);
            yMin = arrItiData[intItiData].y - d  + getNumRand(0,  2*d-intBMh*Step);
            
            //画像の切り替え時のエフェクトを指定
            iTyp = getIntRand(0, 5);
            //繰り返しイベントにジュリア集合の描画追加
            this.addEventListener(Event.ENTER_FRAME, fncMandelbroDisp);
        }
        //ジュリア集合の描画(1/40分描画、40回繰り返し）
        private function fncMandelbroDisp(e:*):void {
            var bolEnd:Boolean = false
            var bmItiY:int;
            var bmItiX:int;
            var a:Number;
            var b:Number;
            var xx:int;
            var yy:int;
            //描画時エフェクトする。
            switch (iTyp) {
            case 0 :
                for (bmItiY = iloop; bmItiY < intBMh; bmItiY+=40) {
                    b = yMin + bmItiY * Step;
                    for (bmItiX = 0; bmItiX < intBMw; bmItiX++) {
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, bmItiY, fncGetColor(a, -b));
                    }
                }
                break;
            case 1 :
                for (bmItiY = 0; bmItiY < intBMh; bmItiY++) {
                    b = yMin + bmItiY * Step;
                    for (bmItiX = iloop; bmItiX < intBMw; bmItiX+=40) {
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, bmItiY, fncGetColor(a, -b));
                    }
                }
                break;
            case 2 :
                for (bmItiY = iloop; bmItiY < intBMh; bmItiY+=40) {
                    for (bmItiX = 0; bmItiX < intBMw; bmItiX++) {
                        yy = bmItiY + bmItiX;
                        yy = yy % intBMh;
                        b = yMin + yy * Step;
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, yy, fncGetColor(a, -b));
                    }
                }
                break;
            case 3 :
                for (bmItiY = iloop; bmItiY < intBMh; bmItiY+=40) {
                    for (bmItiX = 0; bmItiX < intBMw; bmItiX++) {
                        yy = bmItiY +intBMw- bmItiX;
                        yy = yy % intBMh;
                        b = yMin + yy * Step;
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, yy, fncGetColor(a, -b));
                    }
                }
                break;
            case 4 :
                for (bmItiY = iloop; bmItiY < intBMh; bmItiY+=40) {
                    for (bmItiX = 0; bmItiX < intBMw; bmItiX++) {
                        yy = bmItiY;
                        if ((bmItiX % 60) < 30) { yy += 30; }
                        if (yy >= intBMh) { yy -= intBMh; }
                        b = yMin + yy * Step;
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, yy, fncGetColor(a, -b));
                    }
                }
                break;
            case 5 :
                for (bmItiY = 0; bmItiY < intBMh; bmItiY++) {
                    b = yMin + bmItiY * Step;
                    for (bmItiX = iloop; bmItiX < intBMw; bmItiX+=40) {
                        xx = bmItiX;
                        if ((bmItiY % 60) < 30) { xx += 30; }
                        if (xx >= intBMw) { xx -= intBMw; }
                        a = xMin + xx * Step;
                        bdMandelbrot.setPixel(xx, bmItiY, fncGetColor(a, -b));
                    }
                }
                break;
            }
            if (iloop >= 39) { bolEnd = true; }
            iloop++;            
            
            if(bolEnd == true) {
                this.removeEventListener(Event.ENTER_FRAME,fncMandelbroDisp);
                var setIDName:Number = setTimeout(fncDispSt, 3000);    //3秒後に実行
            }
        }
        //ジュリア集合の1点でのカラー
        private function fncGetColor(a:Number, b:Number):uint {
            var uiCol:uint = uintHassan;    //発散しないときのカラー
            var x:Number=a;
            var y:Number=b;
            var i:int = 0;
            for(i=0;i<=intKurikaesi;i++){    //最大繰り返し数繰り返し
                var x2:Number=x*x;
                var y2:Number=y*y;
                var zx:Number=x2-y2+numA;
                var zy:Number=2*x*y+numB;
                x=zx;
                y = zy;
                                if (bolA == true) {
                    x = Math.abs(zx);
                }
                if (bolB == true) {
                    y = Math.abs(zy);
                }

                if (x2 + y2 >= 4) {
                    var id:int = i % arrColor.length;
                    uiCol= arrColor[id];
                    break;
                }
            }
            return uiCol;
        }
        //グラデーションカラー取得
        private function fncSerColor():void {
            var arrCl0:Array;
            var arrCl1:Array;
            var icflg:uint = 0;
            while (icflg == 0) {    //256階調異なるRGBがあるか？
                icflg = 0;
                arrCl0 = new Array();
                arrCl1 = new Array();
                for (var ino:int = 0; ino < 3; ino++) {    //2色RGBの各値を求める
                    var icf:int = getIntRand(0, 2);
                    //var icf:int = getIntRand(1, 2);
                    icflg += icf;
                    if (icf == 1) {            //明－＞暗
                        arrCl0.push(255);
                        arrCl1.push(0);
                    } else if (icf == 2) {    //暗ー＞明
                        arrCl0.push(0);
                        arrCl1.push(255);
                    } else {                //適当
                        var icf2:int = getIntRand(0, 3);
                        if (icf2 == 0) {
                            arrCl0.push(0);
                            arrCl1.push(127);
                        } else if (icf2 == 1) {
                            arrCl0.push(127);
                            arrCl1.push(0);
                        } else if (icf2 == 2) {
                            arrCl0.push(255);
                            arrCl1.push(127);
                        } else {
                            arrCl0.push(127);
                            arrCl1.push(255);
                        }
                        //arrCl0.push(getIntRand(0, 255));
                        //arrCl1.push(getIntRand(0, 255));
                    }
                }
            }
            arrColor = new Array();
            var icoln:int = 32;// getIntRand(16, 32);    //intKurikaesi;
            var i:int;
            var ir:uint;
            var ig:uint;
            var ib:uint;
            for(i = 0; i < icoln; i++) {    //グラデーションカラー作成
                ir = arrCl0[0] + (arrCl1[0] - arrCl0[0]) * i / icoln;
                ig = arrCl0[1] + (arrCl1[1] - arrCl0[1]) * i / icoln;
                ib = arrCl0[2] + (arrCl1[2] - arrCl0[2]) * i / icoln;
                arrColor.push(ir * 256 * 256 + ig * 256 + ib);
            }
            for(i = 1; i < icoln-1; i++) {    //グラデーションカラー作成
                ir = arrCl0[0] + (arrCl1[0] - arrCl0[0]) * (icoln-i) / icoln;
                ig = arrCl0[1] + (arrCl1[1] - arrCl0[1]) * (icoln-i) / icoln;
                ib = arrCl0[2] + (arrCl1[2] - arrCl0[2]) * (icoln-i) / icoln;
                arrColor.push(ir * 256 * 256 + ig * 256 + ib);
            }
        }
        //乱数
        private function getIntRand(intMin:int, intMax:int):int {
                return intMin + Math.floor(Math.random() * (intMax + 1 - intMin));
        }
        private function getNumRand(numMin:Number, numMax:Number):Number {
                return numMin + Math.random() * (numMax  - numMin);
        }
    }
}