/**
 * Copyright szbzs2004 ( http://wonderfl.net/user/szbzs2004 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4YGl
 */

// forked from itsukichang's ImageLoaderTest
//http://assets.wonderfl.net/images/related_images/8/81/81ba/81bac8f4c8c4ee6c8bd05560f8ab7c34af5387cem

package {
    
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    public class Main extends Sprite {
        
        private var _img:ImageLoader;
        
        public function Main() {
            init();
        }
    
        private function init():void {
            _img = new ImageLoader("http://assets.wonderfl.net/images/related_images/8/81/81ba/81bac8f4c8c4ee6c8bd05560f8ab7c34af5387cem");
            addChild(_img);
            _img.x = stage.stageWidth / 2;
            _img.y = stage.stageHeight / 2;
            _img.addEventListener(ImageLoader.COMP, onComp);
            
            
        }
        
        private function onComp(e:Event):void {
            _img.addEventListener(Event.ENTER_FRAME, onLoop);
            _img.addEventListener(MouseEvent.CLICK, onClick);
        }
        
        private function onLoop(e:Event):void {
            _img.rotation += 2;        
        }
            
        private function onClick(e:MouseEvent):void {
            _img.centerPos(); //クリックされたら中心点変更
        }
    }
}

    
import flash.display.Bitmap;    
import flash.display.Loader;
import flash.display.Sprite;
import flash.net.URLRequest;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.system.LoaderContext;

class ImageLoader extends Sprite {
    
    private var _url:String;
    private var _urlReq:URLRequest;
    private var _loader:Loader;
    private var _sp:Sprite;
    private var _centerFlag:Boolean;
    
    private var _wid:Number;
    private var _hei:Number;
    private var _comp:Boolean;
    
    public static const COMP:String = "complete";
    
    public function ImageLoader(s:String) {
        _url = s;
        init();
    }
    
    private function init():void {
        _urlReq = new URLRequest(_url);
        _loader = new Loader();
        _loader.load(_urlReq, new LoaderContext(true));
        _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComp);
    }
    
    private function onComp(e:Event):void {
        _comp = true;
        _wid = _loader.width;
        _hei = _loader.height;
        Bitmap(_loader.content).smoothing = true;
       addChild(_loader);
       // _sp = new Sprite();
       // _sp.addChild(_loader);
       //addChild(_sp);
       // _sp.graphics.beginFill(0xff);
       // _sp.graphics.drawRect(0,0,_wid,_hei);
        dispatchEvent(new Event(COMP));
    }
    
    public function centerPos():void { //中心点を画像中央に設定するメソッド
        if (!_centerFlag && _comp) {
            _loader.x = -_wid / 2;
            _loader.y = -_hei / 2;
            //this.x = _wid / 2;
            //this.y = _hei / 2;
           // _sp.x = _wid ;
           // _sp.y = _hei;
            _centerFlag = true;
        }
    }    
        
    public function get wid():Number { //画像の幅
        return _wid;    
    }
    
    public function get hei():Number { //画像の高さ
        return _hei;
    }
    
    public function get comp():Boolean { //画像が完全に読み込まれたか否か．
        return _comp;
    }
}
