/**
 * Copyright hacker_vdjhdzqc ( http://wonderfl.net/user/hacker_vdjhdzqc )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4YGW
 */

// forked from Hakuhin's Pixel Bender (明度差輪郭線フィルタ)
// -------------------------------------------------
//
// 明度差輪郭線フィルタ
// 
// アンチエイリアスが適当です…
//
// 金属製のようなテカテカした所は綺麗ですが
// 水面のような複雑な所は何だかよくわかりません。
//
// -------------------------------------------------
package {
    import flash.events.*;
    import flash.display.*;
    import flash.net.*;
    import flash.text.*;
    import flash.utils.*;
    import flash.system.*;
    import flash.geom.*;
    import flash.filters.*;
    import flash.ui.*;
    import flash.media.*;

    public class Main extends Sprite {
        public function Main() {

        
// -------------------------------------------------
// コンストラクタ
// -------------------------------------------------

// フレームレート
stage.frameRate = 60;

// 100%表示
stage.scaleMode = StageScaleMode.NO_SCALE;

// 左上
stage.align = StageAlign.TOP_LEFT;
stage.align = "TL";

// スプライトを作成
var sprite:Sprite = new Sprite();
addChild(sprite);

// 初期化へ
init();


// -------------------------------------------------
// 初期化
// -------------------------------------------------
function init():void{

    // 画像のURL
    var url:String = "http://actionscript.web.officelive.com/wonderfl/bg003.jpg";

    // ステージサイズ
    var w:uint;
    var h:uint;
    
    // ローダー作成
    var loader_obj : Loader = new Loader();
    var info : LoaderInfo = loader_obj.contentLoaderInfo;
    addChild(loader_obj);
    
    // 読み込み完了
    info.addEventListener (Event.INIT,LoaderInfoInitFunc);
    function LoaderInfoInitFunc (event : Event):void {
        ResizeFunc(null);
    }


    // 読み込み開始
    load(url);

    // リザルト作成
    var result : Sprite = new Sprite();
    addChild(result);
    result.x = 0;

    // ボタン作成
    var button:Button = new Button(stage);
    button.y = 30;
    button.setSize(60,20);
    button.setLabel("開く");
    result.addChild(button);

    // ボタンが押された
    button.addEventListener(MouseEvent.CLICK,function(e:MouseEvent):void{
        load(text.text);
    });
    
    function load(url:String):void{

        // 読み込み
        loader_obj.load(new URLRequest(url));
    }


    // テキストフィールド作成
    var ft_result:TextField = new TextField();
    ft_result.x = 10;
    ft_result.y = 10;
    ft_result.width = 300;
    ft_result.height = 20;
    ft_result.selectable = false;

    // 書式
    var format_result:TextFormat = new TextFormat();
    format_result.font = "ＭＳ ゴシック";    // フォント名
    ft_result.defaultTextFormat = format_result;

    // テキスト表示
    result.addChild(ft_result);

    // 読み込み状況
    addEventListener (Event.ENTER_FRAME,EnterFrameFunc);
    function EnterFrameFunc (event : Event) :void{
        ft_result.text = "読込:" + info.bytesLoaded + " / 全体:" + info.bytesTotal;
    }

    // テキストフィールド作成
    var text:TextField = new TextField();
    text.x = 10;
    text.y = 30;
    text.height = 20;
    text.type = TextFieldType.INPUT;
    text.border = true;

    // 書式
    var format:TextFormat = new TextFormat();
    format.font = "ＭＳ ゴシック";    // フォント名
    text.defaultTextFormat = format;

    // テキスト表示
    text.text = url;
    result.addChild(text);
    
    // リサイズ時にフィット
    stage.addEventListener(Event.RESIZE,ResizeFunc);
    function ResizeFunc(e:Event):void{
        w = stage.stageWidth;
        h = stage.stageHeight;
        loader_obj.width = w;
        loader_obj.height = h - 60;

        result.y = h - 60;
    
        // テキストフィールド位置
        text.width = w - 10 - 10 - button.width - 10;
    
        // ボタン位置
        button.x = w - button.width - 10;
    }
    ResizeFunc(null);

    // シェーダバイトコード
    var binary : ByteArray = CustomFilterGetByteArray();
    
    // シェーダ作成
    var shader:Shader = new Shader();
    shader.byteCode = binary;
    var filter:ShaderFilter = new ShaderFilter(shader); 

    // パラメータアクセス用
    var data : ShaderData  = shader.data;
    var param : ShaderParameter;
    var input : ShaderInput;

    // パラメータ
    var coefficient:Number = 1.0;        // 線の係数
    var bits_per_pixel:Number = 4;        // 色深度
    var average_multiplier:Number = 1.0;    // 平均カラーの乗算成分
    var average_offset:Number = 0.0;    // 平均カラーの加算成分
    var knockout:Boolean = true;    // ノックアウト

    addEventListener(Event.ENTER_FRAME,function(e:Event):void{
        
        // 平均カラーの乗算成分
        param = data.average_multiplier;
        param.value = [average_multiplier];
        
        // 平均カラーの加算成分
        param = data.average_offset;
        param.value = [average_offset];
        
        // 線の係数
        param = data.coefficient;
        param.value = [coefficient];
        
        // 色深度
        param = data.bits_per_pixel;
        param.value = [bits_per_pixel];

        // ノックアウト
        param = data.knockout;
        param.value = [Number(knockout)];
        
        // 適応
        loader_obj.filters = [filter];
    });
    
    // テキスト表示
    var tf : TextField = new TextField();
    tf.x = 5;
    tf.y = 5;
    tf.width = 280;
    tf.height = 60;
    tf.border = true;
    tf.background = true;
    tf.alpha = 0.9;
    
    // 書式
    format = new TextFormat();
    format.font = "ＭＳ ゴシック";
    tf.defaultTextFormat = format;

    addChild(tf);
    addEventListener(Event.ENTER_FRAME,function(e:Event):void{
        var str:String = "";
        str += "線の係数  　　　　　:" + Math.floor(coefficient * 100)/100 + "　(上下キーで変更)\n";
        str += "色深度      　　　　:" + bits_per_pixel + "　(左右キーで変更)\n";
        str += "平均カラーの乗算成分:" + Math.floor(average_multiplier * 100)/100 + "　(1,2キーで変更)\n";
        str += "平均カラーの加算成分:" + Math.floor(average_offset * 100)/100 + "　(3,4キーで変更)\n";

        tf.text = str;
    });
    
    // キー操作
    stage.addEventListener(KeyboardEvent.KEY_DOWN, KeyDown);
    function KeyDown(event:KeyboardEvent):void{
        if(event.keyCode == Keyboard.UP)        coefficient -= 0.1;
        if(event.keyCode == Keyboard.DOWN)        coefficient += 0.1;
        if(event.keyCode == Keyboard.LEFT)        bits_per_pixel -= 1;
        if(event.keyCode == Keyboard.RIGHT)        bits_per_pixel += 1;
        if(event.keyCode == 49)        average_multiplier -= 0.01;
        if(event.keyCode == 50)        average_multiplier += 0.01;
        if(event.keyCode == 51)        average_offset -= 0.01;
        if(event.keyCode == 52)        average_offset += 0.01;

        if(coefficient <  0)        coefficient =  0;
        if(coefficient >  1)        coefficient =  1;
        if(bits_per_pixel < 1)        bits_per_pixel = 1;
        if(bits_per_pixel > 256)    bits_per_pixel = 256;
        if(average_multiplier < -2)    average_multiplier = -2;
        if(average_multiplier >  2)    average_multiplier =  2;
        if(average_offset < -2)        average_offset = -2;
        if(average_offset >  2)        average_offset =  2;
    };
    
    // マウス操作
    loader_obj.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void{
        if(knockout)    knockout = false;
        else            knockout = true;
    });

}



// -------------------------------------------------
// シェーダバイトコード
// -------------------------------------------------
function CustomFilterGetByteArray():ByteArray{

    var a:ByteArray = new ByteArray();
    var f:Function;

    f = a.writeUnsignedInt;
    f(0xa5010000); f(0x00a41600); f(0x4c696768); f(0x746e6573); 
    f(0x734f7574); f(0x6c696e65); f(0x46696c74); f(0x6572a00c); 
    f(0x6e616d65); f(0x73706163); f(0x65006c69); f(0x6768746e); 
    f(0x65737320); f(0x6f75746c); f(0x696e6500); f(0xa00c7665); 
    f(0x6e646f72); f(0x0048616b); f(0x7568696e); f(0x00a00876); 
    f(0x65727369); f(0x6f6e0001); f(0x00a00c64); f(0x65736372); 
    f(0x69707469); f(0x6f6e0096); f(0xbe93788d); f(0xb797d68a); 
    f(0x73837483); f(0x42838b83); f(0x5e00a101); f(0x0200000c); 
    f(0x5f4f7574); f(0x436f6f72); f(0x6400a300); f(0x04737263); 
    f(0x00a10204); f(0x01000f64); f(0x737400a1); f(0x01040200); 
    f(0x0f636f6c); f(0x6f725f6c); f(0x696e6500); f(0xa2046465); 
    f(0x6661756c); f(0x7456616c); f(0x75650000); f(0x00000000); 
    f(0x00000000); f(0x0000003f); f(0x800000a2); f(0x0c646573); 
    f(0x63726970); f(0x74696f6e); f(0x0090fc82); f(0xcc904600); 
    f(0xa1010100); f(0x0002636f); f(0x65666669); f(0x6369656e); 
    f(0x7400a201); f(0x6d696e56); f(0x616c7565); f(0x00000000); 
    f(0x00a2016d); f(0x61785661); f(0x6c756500); f(0x3f800000); 
    f(0xa2016465); f(0x6661756c); f(0x7456616c); f(0x7565003f); 
    f(0x000000a2); f(0x0c646573); f(0x63726970); f(0x74696f6e); 
    f(0x0090fc82); f(0xcc8c5790); f(0x9400a101); f(0x01000001); 
    f(0x62697473); f(0x5f706572); f(0x5f706978); f(0x656c00a2); 
    f(0x016d696e); f(0x56616c75); f(0x65003f80); f(0x0000a201); 
    f(0x6d617856); f(0x616c7565); f(0x00438000); f(0x00a20164); 
    f(0x65666175); f(0x6c745661); f(0x6c756500); f(0x40800000); 
    f(0xa20c6465); f(0x73637269); f(0x7074696f); f(0x6e009046); 
    f(0x905b9378); f(0x00a10101); f(0x03000861); f(0x76657261); 
    f(0x67655f6d); f(0x756c7469); f(0x706c6965); f(0x7200a201); 
    f(0x64656661); f(0x756c7456); f(0x616c7565); f(0x003f8000); 
    f(0x00a20c64); f(0x65736372); f(0x69707469); f(0x6f6e0095); 
    f(0xbd8bcf83); f(0x4a838981); f(0x5b82cc8f); f(0xe68e5a90); 
    f(0xac95aa00); f(0xa1010103); f(0x00046176); f(0x65726167); 
    f(0x655f6f66); f(0x66736574); f(0x00a20164); f(0x65666175); 
    f(0x6c745661); f(0x6c756500); f(0x00000000); f(0xa20c6465); 
    f(0x73637269); f(0x7074696f); f(0x6e0095bd); f(0x8bcf834a); 
    f(0x8389815b); f(0x82cc89c1); f(0x8e5a90ac); f(0x95aa00a1); 
    f(0x010d0180); f(0x086b6e6f); f(0x636b6f75); f(0x7400a20d); 
    f(0x64656661); f(0x756c7456); f(0x616c7565); f(0x000000a2); 
    f(0x0c646573); f(0x63726970); f(0x74696f6e); f(0x00836d83); 
    f(0x62834e83); f(0x41834583); f(0x6700a101); f(0x0404000f); 
    f(0x636f6c6f); f(0x725f6261); f(0x636b6772); f(0x6f756e64); 
    f(0x00a20464); f(0x65666175); f(0x6c745661); f(0x6c756500); 
    f(0x3f800000); f(0x3f800000); f(0x3f800000); f(0x3f800000); 
    f(0xa20c6465); f(0x73637269); f(0x7074696f); f(0x6e009477); 
    f(0x8c6982cc); f(0x9046001d); f(0x03003100); f(0x00100032); 
    f(0x0500803f); f(0x8000001d); f(0x05004000); f(0x00c00002); 
    f(0x05004005); f(0x0000001d); f(0x05008005); f(0x00400032); 
    f(0x05004000); f(0x00000032); f(0x05002000); f(0x00000031); 
    f(0x0600f103); f(0x00b0001d); f(0x0700f306); f(0x001b001d); 
    f(0x0600f307); f(0x001b0003); f(0x0600f303); f(0x0000001d); 
    f(0x0800f306); f(0x001b0001); f(0x0800f303); f(0x0055001d); 
    f(0x0600f308); f(0x001b001d); f(0x05001006); f(0x00000001); 
    f(0x05001006); f(0x0040001d); f(0x08008005); f(0x00c00001); 
    f(0x08008006); f(0x00800032); f(0x05001040); f(0x40000004); 
    f(0x08004005); f(0x00c00003); f(0x08004008); f(0x0000001d); 
    f(0x05001008); f(0x0040001d); f(0x08008005); f(0x00c00003); 
    f(0x08008000); f(0x00c0001a); f(0x08004008); f(0x0000001d); 
    f(0x08008008); f(0x0040002a); f(0x05008008); f(0x0000001d); 
    f(0x01804000); f(0x80000034); f(0x00000001); f(0x8040001d); 
    f(0x08008005); f(0x00000036); f(0x00000000); f(0x00000032); 
    f(0x0800403f); f(0x80000002); f(0x03001008); f(0x00400031); 
    f(0x0900f103); f(0x00b0001d); f(0x0600f309); f(0x001b001d); 
    f(0x0900f306); f(0x001b0003); f(0x0900f303); f(0x0000001d); 
    f(0x0a00f309); f(0x001b0001); f(0x0a00f303); f(0x0055001d); 
    f(0x0600f30a); f(0x001b001d); f(0x08004006); f(0x00000001); 
    f(0x08004006); f(0x0040001d); f(0x08002008); f(0x00400001); 
    f(0x08002006); f(0x00800032); f(0x08004040); f(0x40000004); 
    f(0x08001008); f(0x00400003); f(0x08001008); f(0x0080001d); 
    f(0x05001008); f(0x00c0001d); f(0x08004005); f(0x00c00003); 
    f(0x08004000); f(0x00c0001a); f(0x08002008); f(0x0040001d); 
    f(0x05001008); f(0x0080002a); f(0x05008005); f(0x00c0001d); 
    f(0x01804000); f(0x80000034); f(0x00000001); f(0x8040001d); 
    f(0x05001005); f(0x00000036); f(0x00000000); f(0x0000002a); 
    f(0x08008005); f(0x00c0001d); f(0x01804000); f(0x80000034); 
    f(0x00000001); f(0x80400032); f(0x0800403f); f(0x8000001d); 
    f(0x08002005); f(0x00400001); f(0x05004008); f(0x00400036); 
    f(0x00000000); f(0x00000032); f(0x0800403f); f(0x80000001); 
    f(0x03002008); f(0x00400031); f(0x0900f103); f(0x00b0001d); 
    f(0x0600f309); f(0x001b001d); f(0x0900f306); f(0x001b0003); 
    f(0x0900f303); f(0x0000001d); f(0x0a00f309); f(0x001b0001); 
    f(0x0a00f303); f(0x0055001d); f(0x0600f30a); f(0x001b001d); 
    f(0x08004006); f(0x00000001); f(0x08004006); f(0x0040001d); 
    f(0x08002008); f(0x00400001); f(0x08002006); f(0x00800032); 
    f(0x08004040); f(0x40000004); f(0x08001008); f(0x00400003); 
    f(0x08001008); f(0x0080001d); f(0x05001008); f(0x00c0001d); 
    f(0x08004005); f(0x00c00003); f(0x08004000); f(0x00c0001a); 
    f(0x08002008); f(0x0040001d); f(0x05001008); f(0x0080002a); 
    f(0x05008005); f(0x00c0001d); f(0x01804000); f(0x80000034); 
    f(0x00000001); f(0x8040001d); f(0x05001005); f(0x00000036); 
    f(0x00000000); f(0x0000002a); f(0x08008005); f(0x00c0001d); 
    f(0x01804000); f(0x80000034); f(0x00000001); f(0x80400032); 
    f(0x0800403f); f(0x8000001d); f(0x08002005); f(0x00800001); 
    f(0x05002008); f(0x00400036); f(0x00000000); f(0x00000032); 
    f(0x0800403f); f(0x80000001); f(0x03001008); f(0x00400031); 
    f(0x0900f103); f(0x00b0001d); f(0x0600f309); f(0x001b001d); 
    f(0x0900f306); f(0x001b0003); f(0x0900f303); f(0x0000001d); 
    f(0x0a00f309); f(0x001b0001); f(0x0a00f303); f(0x0055001d); 
    f(0x0600f30a); f(0x001b001d); f(0x08004006); f(0x00000001); 
    f(0x08004006); f(0x0040001d); f(0x08002008); f(0x00400001); 
    f(0x08002006); f(0x00800032); f(0x08004040); f(0x40000004); 
    f(0x08001008); f(0x00400003); f(0x08001008); f(0x0080001d); 
    f(0x05001008); f(0x00c0001d); f(0x08004005); f(0x00c00003); 
    f(0x08004000); f(0x00c0001a); f(0x08002008); f(0x0040001d); 
    f(0x05001008); f(0x0080002a); f(0x05008005); f(0x00c0001d); 
    f(0x01804000); f(0x80000034); f(0x00000001); f(0x8040001d); 
    f(0x05001005); f(0x00000036); f(0x00000000); f(0x0000002a); 
    f(0x08008005); f(0x00c0001d); f(0x01804000); f(0x80000034); 
    f(0x00000001); f(0x80400032); f(0x0800403f); f(0x8000001d); 
    f(0x08002005); f(0x00400001); f(0x05004008); f(0x00400036); 
    f(0x00000000); f(0x00000032); f(0x0800403f); f(0x80000001); 
    f(0x03001008); f(0x00400031); f(0x0900f103); f(0x00b0001d); 
    f(0x0600f309); f(0x001b001d); f(0x0900f306); f(0x001b0003); 
    f(0x0900f303); f(0x0000001d); f(0x0a00f309); f(0x001b0001); 
    f(0x0a00f303); f(0x0055001d); f(0x0600f30a); f(0x001b001d); 
    f(0x08004006); f(0x00000001); f(0x08004006); f(0x0040001d); 
    f(0x08002008); f(0x00400001); f(0x08002006); f(0x00800032); 
    f(0x08004040); f(0x40000004); f(0x08001008); f(0x00400003); 
    f(0x08001008); f(0x0080001d); f(0x05001008); f(0x00c0001d); 
    f(0x08004005); f(0x00c00003); f(0x08004000); f(0x00c0001a); 
    f(0x08002008); f(0x0040001d); f(0x05001008); f(0x0080002a); 
    f(0x05008005); f(0x00c0001d); f(0x01804000); f(0x80000034); 
    f(0x00000001); f(0x8040001d); f(0x05001005); f(0x00000036); 
    f(0x00000000); f(0x0000002a); f(0x08008005); f(0x00c0001d); 
    f(0x01804000); f(0x80000034); f(0x00000001); f(0x80400032); 
    f(0x0800403f); f(0x8000001d); f(0x08002005); f(0x00800001); 
    f(0x05002008); f(0x00400036); f(0x00000000); f(0x00000032); 
    f(0x0800403f); f(0x80000002); f(0x03002008); f(0x00400031); 
    f(0x0900f103); f(0x00b0001d); f(0x0600f309); f(0x001b001d); 
    f(0x0900f306); f(0x001b0003); f(0x0900f303); f(0x0000001d); 
    f(0x0a00f309); f(0x001b0001); f(0x0a00f303); f(0x0055001d); 
    f(0x0600f30a); f(0x001b001d); f(0x08004006); f(0x00000001); 
    f(0x08004006); f(0x0040001d); f(0x08002008); f(0x00400001); 
    f(0x08002006); f(0x00800032); f(0x08004040); f(0x40000004); 
    f(0x08001008); f(0x00400003); f(0x08001008); f(0x0080001d); 
    f(0x05001008); f(0x00c0001d); f(0x08004005); f(0x00c00003); 
    f(0x08004000); f(0x00c0001a); f(0x08002008); f(0x0040001d); 
    f(0x05001008); f(0x0080002a); f(0x05008005); f(0x00c0001d); 
    f(0x01804000); f(0x80000034); f(0x00000001); f(0x8040001d); 
    f(0x05001005); f(0x00000036); f(0x00000000); f(0x0000002a); 
    f(0x08008005); f(0x00c0001d); f(0x01804000); f(0x80000034); 
    f(0x00000001); f(0x80400032); f(0x0800403f); f(0x8000001d); 
    f(0x08002005); f(0x00400001); f(0x05004008); f(0x00400036); 
    f(0x00000000); f(0x00000032); f(0x0800403f); f(0x80000002); 
    f(0x03002008); f(0x00400031); f(0x0900f103); f(0x00b0001d); 
    f(0x0600f309); f(0x001b001d); f(0x0900f306); f(0x001b0003); 
    f(0x0900f303); f(0x0000001d); f(0x0a00f309); f(0x001b0001); 
    f(0x0a00f303); f(0x0055001d); f(0x0600f30a); f(0x001b001d); 
    f(0x08004006); f(0x00000001); f(0x08004006); f(0x0040001d); 
    f(0x08002008); f(0x00400001); f(0x08002006); f(0x00800032); 
    f(0x08004040); f(0x40000004); f(0x08001008); f(0x00400003); 
    f(0x08001008); f(0x0080001d); f(0x05001008); f(0x00c0001d); 
    f(0x08004005); f(0x00c00003); f(0x08004000); f(0x00c0001a); 
    f(0x08002008); f(0x0040001d); f(0x05001008); f(0x0080002a); 
    f(0x05008005); f(0x00c0001d); f(0x01804000); f(0x80000034); 
    f(0x00000001); f(0x8040001d); f(0x05001005); f(0x00000036); 
    f(0x00000000); f(0x0000002a); f(0x08008005); f(0x00c0001d); 
    f(0x01804000); f(0x80000034); f(0x00000001); f(0x80400032); 
    f(0x0800403f); f(0x8000001d); f(0x08002005); f(0x00800001); 
    f(0x05002008); f(0x00400036); f(0x00000000); f(0x00000032); 
    f(0x0800403f); f(0x80000002); f(0x03001008); f(0x00400031); 
    f(0x0900f103); f(0x00b0001d); f(0x0600f309); f(0x001b001d); 
    f(0x0900f306); f(0x001b0003); f(0x0900f303); f(0x0000001d); 
    f(0x0a00f309); f(0x001b0001); f(0x0a00f303); f(0x0055001d); 
    f(0x0600f30a); f(0x001b001d); f(0x08004006); f(0x00000001); 
    f(0x08004006); f(0x0040001d); f(0x08002008); f(0x00400001); 
    f(0x08002006); f(0x00800032); f(0x08004040); f(0x40000004); 
    f(0x08001008); f(0x00400003); f(0x08001008); f(0x0080001d); 
    f(0x05001008); f(0x00c0001d); f(0x08004005); f(0x00c00003); 
    f(0x08004000); f(0x00c0001a); f(0x08002008); f(0x0040001d); 
    f(0x05001008); f(0x0080002a); f(0x05008005); f(0x00c0001d); 
    f(0x01804000); f(0x80000034); f(0x00000001); f(0x8040001d); 
    f(0x05001005); f(0x00000036); f(0x00000000); f(0x0000002a); 
    f(0x08008005); f(0x00c0001d); f(0x01804000); f(0x80000034); 
    f(0x00000001); f(0x80400032); f(0x0800403f); f(0x8000001d); 
    f(0x08002005); f(0x00400001); f(0x05004008); f(0x00400036); 
    f(0x00000000); f(0x00000032); f(0x0800403f); f(0x80000002); 
    f(0x03001008); f(0x00400031); f(0x0900f103); f(0x00b0001d); 
    f(0x0600f309); f(0x001b001d); f(0x0900f306); f(0x001b0003); 
    f(0x0900f303); f(0x0000001d); f(0x0a00f309); f(0x001b0001); 
    f(0x0a00f303); f(0x0055001d); f(0x0600f30a); f(0x001b001d); 
    f(0x08004006); f(0x00000001); f(0x08004006); f(0x0040001d); 
    f(0x08002008); f(0x00400001); f(0x08002006); f(0x00800032); 
    f(0x08004040); f(0x40000004); f(0x08001008); f(0x00400003); 
    f(0x08001008); f(0x0080001d); f(0x05001008); f(0x00c0001d); 
    f(0x08004005); f(0x00c00003); f(0x08004000); f(0x00c0001a); 
    f(0x08002008); f(0x0040001d); f(0x05001008); f(0x0080002a); 
    f(0x05008005); f(0x00c0001d); f(0x01804000); f(0x80000034); 
    f(0x00000001); f(0x8040001d); f(0x05001005); f(0x00000036); 
    f(0x00000000); f(0x0000002a); f(0x08008005); f(0x00c0001d); 
    f(0x01804000); f(0x80000034); f(0x00000001); f(0x80400032); 
    f(0x0800403f); f(0x8000001d); f(0x08002005); f(0x00800001); 
    f(0x05002008); f(0x00400036); f(0x00000000); f(0x00000034); 
    f(0x00000001); f(0x8000001d); f(0x0600f304); f(0x001b0035); 
    f(0x00000000); f(0x0000001d); f(0x0600f307); f(0x001b0036); 
    f(0x00000000); f(0x00000032); f(0x08004000); f(0x0000002a); 
    f(0x08004005); f(0x0040001d); f(0x01804000); f(0x80000034); 
    f(0x00000001); f(0x8040001d); f(0x05001000); f(0x00800032); 
    f(0x0800403f); f(0x8000001d); f(0x08002008); f(0x00400002); 
    f(0x08002005); f(0x00c0001d); f(0x0900f306); f(0x001b0003); 
    f(0x0900f308); f(0x00aa001d); f(0x0a00f302); f(0x001b0003); 
    f(0x0a00f305); f(0x00ff001d); f(0x0b00f309); f(0x001b0001); 
    f(0x0b00f30a); f(0x001b001d); f(0x0600f30b); f(0x001b0036); 
    f(0x00000000); f(0x00000032); f(0x08004000); f(0x0000002a); 
    f(0x08004005); f(0x0080001d); f(0x01804000); f(0x80000034); 
    f(0x00000001); f(0x80400032); f(0x08004040); f(0xa0000004); 
    f(0x08002008); f(0x00400003); f(0x08002005); f(0x0080001d); 
    f(0x08004008); f(0x00800003); f(0x08004000); f(0x0080001d); 
    f(0x05001008); f(0x00400032); f(0x0800403f); f(0x8000001d); 
    f(0x08002008); f(0x00400002); f(0x08002005); f(0x00c0001d); 
    f(0x0900f306); f(0x001b0003); f(0x0900f308); f(0x00aa001d); 
    f(0x0a00f302); f(0x001b0003); f(0x0a00f305); f(0x00ff001d); 
    f(0x0b00f309); f(0x001b0001); f(0x0b00f30a); f(0x001b001d); 
    f(0x0600f30b); f(0x001b0036); f(0x00000000); f(0x0000001d); 
    f(0x0100f306); 

    f = a.writeShort;
    f(0x001b); 

    f = a.writeByte;
    f(0x00); 

    return a;
}


        }
    }
}




// ↓ pbk ファイルのコード
/* -----------------------------------------------------------------------------
    パラメータ
    color_line           線の色
    coefficient            線の係数
    bits_per_pixel      色深度
    average_multiplier  平均カラーの乗算成分 (デフォルト 1.0)
    average_offset        平均カラーの加算成分 (デフォルト 0.0)
    knockout               ノックアウト
    color_background       背景の色
 ----------------------------------------------------------------------------- */
/*
<languageVersion : 1.0;>
kernel LightnessOutlineFilter<
    namespace : "lightness outline";
    vendor : "Hakuhin";
    version : 1;
    description : "明度差輪郭線フィルタ";
>{
    input image4 src;    // 入力イメージ
    output pixel4 dst;    // 出力ピクセル


    // -------------------------------------
    // パラメータ
    // -------------------------------------
    parameter pixel4 color_line<
        defaultValue:pixel4(0,0,0,1);
        description : "線の色";
    >;
    parameter float coefficient<
        minValue:float(0.0);
        maxValue:float(1.0);
        defaultValue:float(0.5);
        description : "線の係数";
    >;
    
    parameter float bits_per_pixel<
        minValue:float(1);
        maxValue:float(256);
        defaultValue:float(4);
        description : "色深度";
    >;
    parameter float average_multiplier<
        defaultValue:float(1.0);
        description : "平均カラーの乗算成分";
    >;
    parameter float average_offset<
        defaultValue:float(0);
        description : "平均カラーの加算成分";
    >;
    parameter bool knockout<
        defaultValue:bool(false);
        description : "ノックアウト";
    >;
    parameter pixel4 color_background<
        defaultValue:pixel4(1,1,1,1);
        description : "背景の色";
    >;

    // -------------------------------------
    // ピクセルごとに実行される関数
    // -------------------------------------
    void evaluatePixel(){

    // ピクセルの位置を取得
    float2 pos = outCoord();
        
        pixel4 c;
        pixel4 center_color;
        float center;
        float d;
        float de = bits_per_pixel - 1.0;
        float c0 = 0.0; 
        float c1 = 0.0; 
      
        // 中央カラーの色深度を取得
        center_color = sampleLinear(src,pos);
        c = center_color * average_multiplier + average_offset;
        d = (c[0] + c[1] + c[2]) / 3.0;
        center = floor(d * bits_per_pixel);
        if(center > de) center = de;
          
        // 上の色深度を取得
        pos.y -= 1.0;
        c = sampleLinear(src,pos);
        c = c * average_multiplier + average_offset;
        d = (c[0] + c[1] + c[2]) / 3.0;
        d = floor(d * bits_per_pixel);
        if(d > de) d = de;
        if(center < d) c0++;
        
        // 右上の色深度を取得
        pos.x += 1.0;
        c = sampleLinear(src,pos);
        c = c * average_multiplier + average_offset;
        d = (c[0] + c[1] + c[2]) / 3.0;
        d = floor(d * bits_per_pixel);
        if(d > de) d = de;
        if(center < d) c1++;
        
        // 右の色深度を取得
        pos.y += 1.0;
        c = sampleLinear(src,pos);
        c = c * average_multiplier + average_offset;
        d = (c[0] + c[1] + c[2]) / 3.0;
        d = floor(d * bits_per_pixel);
        if(d > de) d = de;
        if(center < d) c0++;

        // 右下の色深度を取得
        pos.y += 1.0;
        c = sampleLinear(src,pos);
        c = c * average_multiplier + average_offset;
        d = (c[0] + c[1] + c[2]) / 3.0;
        d = floor(d * bits_per_pixel);
        if(d > de) d = de;
        if(center < d) c1++;

        // 下の色深度を取得
        pos.x -= 1.0;
        c = sampleLinear(src,pos);
        c = c * average_multiplier + average_offset;
        d = (c[0] + c[1] + c[2]) / 3.0;
        d = floor(d * bits_per_pixel);
        if(d > de) d = de;
        if(center < d) c0++;

        // 左下の色深度を取得
        pos.x -= 1.0;
        c = sampleLinear(src,pos);
        c = c * average_multiplier + average_offset;
        d = (c[0] + c[1] + c[2]) / 3.0;
        d = floor(d * bits_per_pixel);
        if(d > de) d = de;
        if(center < d) c1++;

        // 左の色深度を取得
        pos.y -= 1.0;
        c = sampleLinear(src,pos);
        c = c * average_multiplier + average_offset;
        d = (c[0] + c[1] + c[2]) / 3.0;
        d = floor(d * bits_per_pixel);
        if(d > de) d = de;
        if(center < d) c0++;
        
        // 左上の色深度を取得
        pos.y -= 1.0;
        c = sampleLinear(src,pos);
        c = c * average_multiplier + average_offset;
        d = (c[0] + c[1] + c[2]) / 3.0;
        d = floor(d * bits_per_pixel);
        if(d > de) d = de;
        if(center < d) c1++;
        
        // ノックアウト
        if(knockout){
            c = color_background;
        
        // 元の色
        }else{
            c = center_color;
        }
        
        // 十字との変化
        if(c0 > 0.0){
            d = coefficient;
            c = c * (1.0 - d) + color_line * d;
        }
        
        // 斜めとの変化
        if(c1 > 0.0){
            d = c1 / 5.0 * coefficient;
            c = c * (1.0 - d) + color_line * d;
        }
        
        // カラーを出力
        dst = c;

    }
}
*/



import flash.events.*;
import flash.display.*;
import flash.text.*;
import flash.geom.*;

// -------------------------------------------------
// ボタン
// -------------------------------------------------
internal class Button extends Sprite {

    private var _width:Number;
    private var _height:Number;
    
    private var _text:TextField;
    private var _background:Sprite;
    

    public function Button(stage:Stage) {
        var slider:Button = this;

        // 背景用スプライト作成
        _background = new Sprite();
        addChild(_background);

        // テキストフィールド
        _text = new TextField();
        addChild(_text);
    
        _text.x = 0;
        _text.y = 0;
        _text.selectable = false;

        // 書式
        var format:TextFormat = new TextFormat();
        format.align = TextFormatAlign.CENTER;    // 整列
        format.font = "ＭＳ ゴシック";    // フォント名
        format.size = 14;                // 文字のポイントサイズ
        format.color = 0x202020;        // 文字の色
        _text.defaultTextFormat = format;
    
        // マウスオーバーで少し明るく
        addEventListener(MouseEvent.MOUSE_OVER,function(e:MouseEvent):void{
            var color : ColorTransform = new ColorTransform(1,1,1,1,8,8,8,0);
            transform.colorTransform = color;
        });

        // マウスアウトで元に戻す
        addEventListener(MouseEvent.MOUSE_OUT,function(e:MouseEvent):void{
            var color : ColorTransform = new ColorTransform(1,1,1,1,0,0,0,0);
            transform.colorTransform = color;                                                           
        });

        // デフォルト値
        setSize(100,100);
        update();
    }
    // リサイズ
    public function setSize(w:Number,h:Number):void{
        // 背景リサイズ
        _width = w;
        _height = h;
        update();
    }
    // ラベルセット
    public function setLabel(str:String):void{
        _text.text = str;
        update();
    }
    // 描画更新
    private function update():void{
        // 背景描画
        var g:Graphics = _background.graphics;
        
        // 角丸矩形描画
        g.clear();
        g.lineStyle ( 0 , 0x808080 , 1.0,false,LineScaleMode.NONE,CapsStyle.ROUND,JointStyle.ROUND);
        g.beginFill ( 0xF0F0F0 , 1.0 );
        g.drawRoundRect ( 0 , 0 , _width , _height , 5 , 5 );
        g.endFill();
        
        // テキスト位置修正
        _text.width  = _width;
        _text.height = _height;
    }
}



// -------------------------------------------------
// 外部画像をサムネイルとしてキャプチャ
// -------------------------------------------------
import flash.net.*;
import flash.events.*;
import flash.display.*;
import flash.geom.*;
function ThumbnailCapture(url:String,time:uint,stage:Stage):void{

    // キャプチャタイミング
    Wonderfl.capture_delay( time );

    // スプライト作成
    var sprite : Sprite = new Sprite();

    // ステージ最前面に配置
    stage.addChildAt(sprite,stage.numChildren);
    
    // ローダー
    var loader_obj : Loader = new Loader();
    loader_obj.contentLoaderInfo.addEventListener (Event.INIT,function(e:Event):void{

        // メモリからインスタンス化
        var loader_memory : Loader = new Loader();
        loader_memory.contentLoaderInfo.addEventListener (Event.INIT,function(e:Event):void{

            // キャプチャ
            var bmp : BitmapData = new BitmapData(loader_memory.width,loader_memory.height,true,0);
            sprite.addChild(loader_memory);
            bmp.draw(sprite);
            sprite.removeChild(loader_memory);
            loader_memory.unload();
            loader_obj.unload();
            loader_memory = null;
            loader_obj = null;
            
            
            // 画像を配置
            var bmp_obj : Bitmap = new Bitmap(bmp);
            bmp_obj .width = stage.stageWidth;
            bmp_obj .height = stage.stageHeight;
            stage.addChild(bmp_obj );
            
        });
        
        // 読み込み開始
        loader_memory.loadBytes(loader_obj.contentLoaderInfo.bytes);
    });
    
    // 読み込み開始
    loader_obj.load(new URLRequest(url));
}