/**
 * Copyright jamasian ( http://wonderfl.net/user/jamasian )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Xb7
 */

package
{
    import flash.events.Event;
    import flash.display.Sprite;
    import flash.geom.Point;
    
    public class life extends Sprite
    {
        public var p:Array    =    new Array();
        public var center:Point;
        
        public function life()
        {
            this.graphics.beginFill(0x003F87, 1);
            this.graphics.beginFill(0x003F87, 1);
            this.graphics.drawRect(0, 0, 465, 465);
            this.graphics.endFill();
            
            center    =    new Point(stage.width/2, stage.height/2);
            
            for (var i:int=0; i<=100; i++)
            {
                p[i]    =    new flagellum(Math.random()*5, center.x+(i*10), center.y+(i*10));
                addChild(p[i]);
            }
            
            addEventListener(Event.ENTER_FRAME, onRun);
        }
        
        private function onRun(e:Event):void
        {
            for (var i:int=0; i<=p.length-1; i++)
            {
                move(p[i], mouseX, mouseY);
            }
        }

        
        public function move(e:flagellum, x:int, y:int):void
        {
            var dir:Number    =    Math.atan2(y-e.y, x-e.x)*180/Math.PI;

            var perc:Number;
            var getX:Number;
            var getY:Number;
            var disX:Number;
            var disY:Number;
            
            disX=(x-e.x<0)? Math.sqrt((x-e.x)*-1) : Math.sqrt(x-e.x);
            disY=(y-e.y<0)? Math.sqrt((y-e.y)*-1) : Math.sqrt(y-e.y);
            
            perc=Math.pow(disX+disY, 2) / 400;
            perc=(perc>1.2)? 1.2 : perc;
            
            getX = (Math.cos(dir*Math.PI/180) * (perc*e.speed));
            getY = (Math.sin(dir*Math.PI/180) * (perc*e.speed));
            
            var newx:Number    =    e.x + getX;
            var newy:Number    =    e.y + getY;
            
            var hit:Boolean = false;
            
            for (var i:int=0; i<=p.length-1; i++)
            {
                if (e==p[i]) continue;
                if (e.hitTestObject(p[i]))    hit=true;
            }
            
            e.rotation = 90 + dir;
            if (hit && Math.random()>.1)
            {
            }else{
                e.x=newx;
                e.y=newy;
            }
       }
    }
}


import flash.events.Event;
import flash.geom.Point;
import flash.display.Shape;

class flagellum extends Shape
{
    public var size:int      =    1;
    public var color:uint    =    0xFFFFFF;
    public var power:Number  =    0;
    public var speed:int     =    10;
    
    public function flagellum(_size:int=0, _x:int=0, _y:int=0)
    {
        this.size   =    (_size!=0)? _size : this.size;
        
        this.x      =    (_x!=0)? _x : this.x;
        this.y      =    (_y!=0)? _y : this.y;
        
        addEventListener(Event.ENTER_FRAME, function():void { refresh(); });
    }
    
    public function refresh():void
    {
        this.power+=   Math.round(Math.random()*0.7);
        this.power=    (this.power>=360)? 0 : this.power;
        
        this.graphics.clear();
        drawHead();
        drawTail();
    }

    
    public function drawHead():void
    {
        this.graphics.beginFill(this.color, this.alpha);
        this.graphics.drawRoundRect(0, 0, this.size, this.size*2, this.size);
        this.graphics.endFill();
    }

    public function drawTail():void
    {
        var sp:Point    =    new Point(this.size/2, this.size*2);
        var np:Point    =    new Point(this.size/2, this.size*5);
        var pwr:Number  =    Math.sin(this.power)*3;
        
        this.graphics.lineStyle(this.size/10, this.color, this.alpha);
        this.graphics.moveTo(sp.x, sp.y);

        this.graphics.curveTo(np.x-(np.x*pwr), np.y/1.5, np.x, np.y);
        this.graphics.curveTo(np.x+(np.x*pwr), np.y*1.5, np.x, np.y*2);
    }
}




