/**
 * Copyright g3index ( http://wonderfl.net/user/g3index )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4XUD
 */

package 
{	
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	
	import flash.utils.setInterval;
	
	public class Bubbles extends Sprite
	{
		public var _circles:Vector.<Circles>;
		public var _isdown:Boolean;
		
		public function Bubbles()
		{
			super();
			
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;

			_circles = new Vector.<Circles>();
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onUpDown, false, 0, true);
			stage.addEventListener(MouseEvent.MOUSE_UP, onUpDown, false, 0, true);
			
			addEventListener(Event.ENTER_FRAME, update, false, 0, true);
		}
		
		public function onUpDown(e:MouseEvent):void
		{
			if (e.type == MouseEvent.MOUSE_DOWN) {
				_isdown = true;
				createCircle();
				return;
			}
			_isdown = false;
		}
		
		public function createCircle():void
		{
			if (_isdown) {
				_circles[_circles.length] = new Circles();
				addChild(_circles[_circles.length-1]);
				
				ActionDispatcher.delay(100, createCircle);
			}
		}
		
		public function update(e:Event = null):void
		{
			var i:int = _circles.length;
			while (i--) {
				_circles[i].update();
			}
		}

	}
}
	
	
import flash.display.Sprite;
import flash.events.Event;
import flash.filters.DropShadowFilter;

import flash.display.DisplayObject;
import flash.display.MovieClip;
import flash.events.Event;
import flash.utils.setInterval;
import flash.utils.setTimeout;

internal class Circles extends Sprite
{
	public var _total:int;
	public var _radius:int = 50 + int(Math.random()*150);
	public var _items:Vector.<Ball>;
	public var _colors:Vector.<Array> = new Vector.<Array>();;
	public var _shadown:DropShadowFilter = new DropShadowFilter(0, 0, 0, .6, 8, 8);
	public var _dieTime:Number = 1 + int(Math.random()*4);
	public var _endScale:int = 1;
		
	public function Circles()
	{
		_items = new Vector.<Ball>();
			
		_colors[0] = [0xF9D811, 0xEDBA22, 0xFEFFAB, 0xF89843, 0xED7239]; //yellow
		_colors[1] = [0xFC2D3F, 0xFF5075, 0xFAA6AC, 0x9C0C31, 0xFB3D37, 0xEE0484, 0xFDDAD4]; //pink
		_colors[2] = [0x3058C0, 0x7B79F8, 0x4A6086, 0x5DA5E0, 0x4C87B8]; //blue
		_colors[3] = [0x7DF870, 0x49B94A, 0x597856, 0x92FF30]; //green
		_colors[4] = [0x8FC4C8, 0x93CAD2, 0x6FBFBF, 0x078F99, 0x135699]; //water
		_colors[5] = [0x2C036A, 0x5300B7, 0x6C00FB, 0xAB6BDF]; //purple
			
		var color:Array = _colors[int(Math.random()*_colors.length-1)];
		color = shuffleArray(color);
		_total = color.length;
		var i:int = 0;
			
		do {
		_items[i] = new Ball(i, _radius - i*(_radius/_total), color[i]);
		_items[i].scaleX = _items[i].scaleY = 0;
		addChild(_items[i]);
		i++;
		} while (i < _total);
			
		x = mouseX;
		y = mouseY;
			
		ActionDispatcher.delay(_dieTime* 1000, hide);
	}
		
	public var angle:Number = 0;
		
	public function update(e:Event = null):void
	{
		var i:int = 0;
			
		do {
			_items[i].scaleX -= (_items[i].scaleX - _endScale) / ((i+_items[i].ease) * _total);
			_items[i].scaleY = _items[i].scaleX;
				
			_items[i].x = Math.sin(_items[i].index + angle) * _items[i].rangeX;
			_items[i].y = Math.cos(_items[i].index + angle) * _items[i].rangeY;
				
			i++;
		} while (i < _total)
	
		angle += .05;
	}
		
	public function hide():void
	{
		_endScale = 0;
		ActionDispatcher.delay(3000, dispose);
	}
		
	public function dispose():void
	{
		this.parent.removeChild(this);
	}
		
	public function shuffleArray(arr:Array):Array 
	{
		var arr2:Array = [];

		while (arr.length > 0) {
			arr2.push(arr.splice(Math.round(Math.random() * (arr.length - 1)), 1)[0]);
		}
		arr = arr2;
		return arr;
	}
		
}


import flash.display.Sprite;

internal class Ball extends Sprite
{
	public var ease:Number = 2 + int(Math.random() * 8);
	public var rangeX:Number = 2 + int(Math.random() * 5);
	public var rangeY:Number = 2 + int(Math.random() * 5);
	public var index:Number;
	
	public function Ball(id:int, radius:Number, color:uint)
	{
		index = id;
		
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
	}
}

import flash.display.DisplayObject;
import flash.utils.setInterval;
import flash.utils.setTimeout;

internal class ActionDispatcher
{
	
	public static function delay(time:Number, action:Function, target:DisplayObject = null, ...param):void
	{
		var interval:uint = setTimeout(function():void
		{
			if (target != null)
			{
				action.apply(target, [target]);
			} else {
				action();
			}
		}, time, param);
	}
}