/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4X9T
 */

package
{
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;

	[SWF(framerate="30",width="480",height="480",backgroundColor="0xffffff")]
	public class Practice22 extends Sprite {
		private var disk:Disk;
		private var button:STButton;
		private var running:Boolean = false;
		
		public function Practice22(){
			disk = new Disk(200, 80);
			disk.init();
			disk.x = 240;
			disk.y = 240;
			addChild(disk);
			disk.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
			button = new STButton();
			button.x = 240;
			button.y = 240;
			addChild(button);
			button.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown2);
			stage.addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function update(e:Event):void {
			if (running) {
				disk.rotationZ = (disk.rotationZ + 8) % 360;
			}
		}
		
		private function mouseDown(e:MouseEvent):void {
			disk.onClick(e);
		}
		
		private function mouseDown2(e:MouseEvent):void {
			button.onClick(e);
			running = button.isSelected;
		}
	}
}
import flash.display.MovieClip;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.text.TextField;

class STButton extends MovieClip {
	public var isSelected:Boolean = false;
	private var text:TextField;
	
	public function STButton():void {
		this.graphics.beginFill(0x999999);
		this.graphics.drawCircle(0,0,35);
		this.graphics.endFill();
		this.graphics.beginFill(0xcccccc);
		this.graphics.drawCircle(0,0,33);
		this.graphics.endFill();
		text = new TextField();
		text.text = "start";
		text.x = -text.textWidth / 2;
		text.y = -text.textHeight;
		this.addChild(text);
		text.selectable = false;
	}

	public function onClick(e:MouseEvent):void {
		var xx:Number = e.stageX - 240;
		var yy:Number = e.stageY - 240;
		if (Math.sqrt(xx * xx + yy * yy) < 35) {
			isSelected = !isSelected;
			if (isSelected) {
				text.text = "stop";
			}else {
				text.text = "start";
			}
		}
	}
}

class Disk extends MovieClip {
	private var radiusOuter:Number;
	private var radiusInner:Number;

	public function Disk(r0:Number, r1:Number):void {
		radiusOuter = Math.max(r0, r1);
		radiusInner = Math.min(r0, r1);
	}
	
	public function init():void {
		var dx:Number = (radiusOuter - radiusInner) / 8;
		for (var i:int = 0; i < 36; i++) {
			var x0:Number = Math.cos(i*10 / 180 * Math.PI);
			var y0:Number = Math.sin(i*10 / 180 * Math.PI);
			for (var j:int = 0; j < 8; j++) {
				var r0:Number = radiusInner + j * dx;
				var ll:Number = 2 * Math.PI * r0 / 36 / 2;
				var xp:Number = x0 * r0;
				var yp:Number = y0 * r0;
				var c:Number = getColor(i*10, (j + 1) * 0.125);
				var b:BCircle = new BCircle(xp, yp , ll , c, i * 10, j);
				if (Math.random() < 1.1) b.isSelected = true;
				b.update();
				this.addChild(b);
			}
		}
	}

	public function onClick(e:MouseEvent):void {
		var xx:Number = e.stageX - 240;
		var yy:Number = e.stageY - 240;
		var rad:Number = rotationZ / 180 * Math.PI;
		var xp:Number = xx * Math.cos( -rad) - yy * Math.sin( -rad);
		var yp:Number = xx * Math.sin( -rad) + yy * Math.cos( -rad);	
		var p:Point = new Point(xp, yp);
		for (var i:int = 0; i < this.numChildren; i++) {
			var b:BCircle = getChildAt(i) as BCircle;
			if (b.isContain(p)) break;
		}
	}
	
	private function getColor(i:int, saturation:Number):uint {
		var value:Number = 1.0;
		var h:Number = i / 60;
		var ii:Number = Math.floor(h);
		var ff:Number = h - ii;
		var p1:Number = value * (1.0 - saturation);
		var p2:Number = value * (1.0 - saturation * ff);
		var p3:Number = value * (1.0 - saturation * (1.0 - ff));
		var rv:Number;
		var gv:Number;
		var bv:Number;
		switch(ii) {
			case 0:
				rv = value;	gv = p3;	bv = p1;
				break;
			case 1:
				rv = p2;	gv = value;	bv = p1;
				break;
			case 2:
				rv = p1;	gv = value;	bv = p3;
				break;
			case 3:
				rv = p1;	gv = p2;	bv = value;
				break;
			case 4:
				rv = p3;	gv = p1;	bv = value;
				break;
			default:
				rv = value;	gv = p1;	bv = p2;
		}
		var rr:int = Math.max(0, Math.min(255, rv * 255));
		var gg:int = Math.max(0, Math.min(255, gv * 255));
		var bb:int = Math.max(0, Math.min(255, bv * 255));
		var color:uint = (rr << 16) + (gg << 8) + bb;
		return color;
	}
}

class BCircle extends MovieClip{
	private var radius:Number;
	private var color:uint;
	public var isSelected:Boolean = false;
	public var angle:Number;
	public var voice:int;
	public function BCircle(xx:Number, yy:Number, rr:Number, c:uint, a:Number, v:int):void {
		this.x = xx;
		this.y = yy;
		this.radius = rr;
		color = c;
		angle = a;
		voice = v;
	}
	
	public function update():void {
		graphics.clear();
		if (isSelected) {
			graphics.beginFill(color);
		}else {
			graphics.beginFill(0xffffff);
		}
		graphics.drawCircle(0,0,this.radius);
		graphics.endFill();
		graphics.lineStyle(1, 0xbbbbbb);
		graphics.drawCircle(0,0,this.radius);
	}
	
	public function isContain(p:Point):Boolean {
		var l:Number = Math.sqrt(Math.pow(p.x - x, 2) + Math.pow(p.y - y, 2));
		var bb:Boolean = l < radius;
		if (bb) {
			isSelected = !isSelected;
			update();
		}
		return bb;
	}
}