/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Whk
 */

package {
    import flash.display.*;
    import flash.text.*
    import flash.events.*;
    import flash.net.*;

    public class SharedObjectTest extends Sprite {

        private var textField:TextField = new TextField();
        private var mySharedObject:SharedObject;
        private var dateTime:Date;
        private var date2:Date;

        private function InputChar(event:KeyboardEvent):void{
            if (event.keyCode == 27) mySharedObject.clear();//Escでデータリセット
            textField.text = "delete";
            removeEventListener(Event.ENTER_FRAME,onEnter);
        }
        
//main----->
        public function SharedObjectTest(){
            textField.width = 300;

            try {// try : エラー発生予測箇所。この区間でエラーが出ても停止には至らない。エラーが出たらcatchを実行。
                mySharedObject = SharedObject.getLocal("SharedObjectTest");
                var flushStatus:String = mySharedObject.flush();
                
                if (flushStatus == SharedObjectFlushStatus.FLUSHED) {
                    if (mySharedObject.data.id != null) {
                        mySharedObject.data.count++;//カウントアップ
                        var str:String;
                        str = mySharedObject.data.count.toString();
                        textField.text = str;
                        textField.appendText("\n"+String(mySharedObject.data.id));
                        dateTime = mySharedObject.data.date;
                        addEventListener(Event.ENTER_FRAME,onEnter);
                        
                        //textField.appendText("\n"+mySharedObject.data.date.toLocaleString());
                    } else {
                        mySharedObject.data.count = 1;
                        var today:Date = new Date();
                        //today.setUTCFullYear(today.getUTCFullYear);
                        str = today.toUTCString();
                        mySharedObject.data.date = today;
                        mySharedObject.data.id = Math.round(Math.random()*100000);
                        textField.text = "1";
                        textField.appendText("\n"+String(mySharedObject.data.id));
                    }
                } else {
                    textField.text = "容量不足";
                }
            } catch (e:Error) {//tryスコープ内でエラーが発生したとき
                textField.text = "****";
            }
            stage.addEventListener(KeyboardEvent.KEY_DOWN, InputChar);
            addChild(textField);
        }
// <----main  
      
//----> showData: Event=onENter
        private function onEnter(e:Event):void{
            var str:String;
            var now:Date = new Date();
            var ms:int = now.valueOf()-dateTime.valueOf();
            var days:int = ms/(3600000*24);
            var hour:int = (ms/3600000)%24;
            var min:int = (ms/60000)%60;
            var sec:int = (ms/1000)%60;
            str = mySharedObject.data.count.toString();
            textField.text = str;
            textField.appendText("\n"+String(mySharedObject.data.id));
            textField.appendText("\n"+ms.toString());
            textField.appendText("\n"+days.toString()+"days");
            textField.appendText(hour.toString()+":"+min.toString()+":"+sec.toString());
        }
// <----showData

    }
    
}