/**
 * Copyright aaaaaz025 ( http://wonderfl.net/user/aaaaaz025 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Wcl
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.GlowFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
 
    public class Main extends Sprite
    {
        private var bullets:Array;
        private var frame:int = 0;
        private var bd:BitmapData;
        private var image:BitmapData;
 
        public function Main()
        {    
            bd = new BitmapData(465, 465, false);
            addChild(new Bitmap(bd));
            
            var circle:Sprite = new Sprite();
            circle.graphics.lineStyle(0.5);
            circle.graphics.drawCircle(15, 15, 10);
            circle.graphics.endFill();
            circle.filters = [new GlowFilter(0xFF1493)];
 
            image = new BitmapData(30, 30, true, 0x0);
            image.draw(circle);
                        
            bullets = new Array();
 
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
 
        private function onEnterFrame(event:Event):void
        {
            if (frame++ % 0.5 == 0)
            {
                var radian:Number = Math.atan2(mouseY - 232, mouseX - 232);
                var bullet:Bullet = new Bullet(232, 232, Math.cos(radian), Math.sin(radian), 5);
                bullets.push(bullet);
            } 
            bd.colorTransform(bd.rect, new ColorTransform(1, 1, 1, 1, 20, 20, 100));
            
            if (frame++ % 0.5 == 0)
            {
                var radian:Number = Math.atan2(mouseY - 232, mouseX - 232);
                var bullet:Bullet = new Bullet(232, 232, Math.cos(radian), Math.sin(radian), 4);
                bullets.push(bullet);
            } 
            bd.colorTransform(bd.rect, new ColorTransform(1, 1, 1, 1, 20, 20, 100));
            
            if (frame++ % 0.5 == 0)
            {
                var radian:Number = Math.atan2(mouseY - 232, mouseX - 232);
                var bullet:Bullet = new Bullet(232, 232, Math.cos(radian), Math.sin(radian), 3);
                bullets.push(bullet);
            } 
            bd.colorTransform(bd.rect, new ColorTransform(1, 1, 1, 1, 20, 20, 100));
            
            if (frame++ % 0.5 == 0)
            {
                var radian:Number = Math.atan2(mouseY - 232, mouseX - 232);
                var bullet:Bullet = new Bullet(232, 232, Math.cos(radian), Math.sin(radian), 2);
                bullets.push(bullet);
            } 
            bd.colorTransform(bd.rect, new ColorTransform(1, 1, 1, 1, 20, 20, 100));
            
            if (frame++ % 0.5 == 0)
            {
                var radian:Number = Math.atan2(mouseY - 232, mouseX - 232);
                var bullet:Bullet = new Bullet(232, 232, Math.cos(radian), Math.sin(radian), 1);
                bullets.push(bullet);
            } 
            bd.colorTransform(bd.rect, new ColorTransform(1, 1, 1, 1, 20, 20, 100));


            
 
            for (var i:int = 0; i < bullets.length; i++)
            {
                bd.copyPixels(image, image.rect, new Point(bullets[i].px, bullets[i].py));
 
                bullets[i].move();
                if (bullets[i].check())
                {
                    bullets.splice(i--, 1);
                }
            }
        }
    }
}
 
class Bullet
{
    public var px:Number;
    public var py:Number;
    public var vx:Number;
    public var vy:Number;
    public var speed:Number;
 
    public function Bullet(x:int, y:int, vx:Number, vy:Number, speed:Number)
    {

        this.px = x;
        this.py = y;
        this.vx = vx;
        this.vy = vy;
        this.speed = speed;
    }
 
    public function move():void
    {    
        this.px += vx * speed;
        this.py += vy * speed;
    }
 
    public function check():Boolean
    {
        if (px < -50 || 500 < px ||
            py < -50 || 500 < py)
        {
            return true;
        }
 
        return false;
    }
}
