/**
 * Copyright sauronzdev ( http://wonderfl.net/user/sauronzdev )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4WW7
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.text.TextField;
    import flash.utils.getTimer;
    
    /**
     * Website: http://sauronzdev.com
     * Contact: sauronzdev@gmail.com
     * Twitter: https://twitter.com/SaUr0nZ
     * FlashGameLicense: https://www.fgl.com/view_account.php?username=sauronz
     *
     * Main.as
     * @author SaUrOnZ
     */ 
    
    public class Main extends Sprite 
    {
        public static const SMOKE_SIZE:uint = 4;
        public static const SMOKE_COLOR:uint = 0xFFCCCCCC;
        public static const SMOKE_DECAY_AMOUNT:uint = 16;
        
        public static const SMOKE_SPAWN_AMOUNT:uint = 1;
        
        public static const SMOKE_ASCEND_AMOUNT:Number = 0.4;
        public static const SMOKE_ASCEND_MAXIMUM :Number = 4;
        
        public static const SMOKE_TURB_AMOUNT:uint = 4;
        public static const SMOKE_TURB_H_AMOUNT:uint = 2;
        
        public static const SMOKE_MOVE_X_AMOUNT:uint = 4;
        public static const SMOKE_MOVE_XH_AMOUNT:uint = 2;
        
        public static const SMOKE_MOVE_Y_AMOUNT:uint = 8;
        public static const SMOKE_MOVE_YH_AMOUNT:uint = 4;
        
        private var _smokeBuffer:BitmapData;
        private var _smokeBufferContainer:Bitmap;
        
        private var _smokeGraphic:SmokeGraphic;
        private var _smokeEffects:Vector.<SmokeEffect>;
        
        private var _frames:uint;
        private var _startTime:uint;
        private var _currentTime:uint;
        private var _infoTextField:TextField;
        
        private var _mouseDown:Boolean = false;
        private var _screenRect:Rectangle;
        private var _screenPosition:Point;
        
        public function Main():void 
        {
            _smokeBuffer = new BitmapData(stage.stageWidth, stage.stageHeight,
            true, 0x00000000);
            _smokeBufferContainer = new Bitmap(_smokeBuffer);
            stage.addChild(_smokeBufferContainer);
            
            _screenRect = _smokeBuffer.rect;
            _screenPosition = new Point(0, 0);
            
            _smokeGraphic = new SmokeGraphic(SMOKE_SIZE, SMOKE_COLOR);
            _smokeEffects = new Vector.<SmokeEffect>();
            
            _infoTextField = new TextField();
            _infoTextField.selectable = false;
            _infoTextField.width = stage.stageWidth;
            _infoTextField.height = stage.stageHeight;
            _infoTextField.x = 5;
            _infoTextField.y = 5;
            stage.addChild(_infoTextField);
            
            stage.addEventListener(MouseEvent.MOUSE_UP, handleMouseUp, false, 0, true);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, handleMouseDown, false, 0, true);
            stage.addEventListener(Event.ENTER_FRAME, handleEnterFrame, false, 0, true);
        }
        
        private function handleMouseUp(e:MouseEvent):void { _mouseDown = false; }
        private function handleMouseDown(e:MouseEvent):void { _mouseDown = true; }
        
        private function handleEnterFrame(e:Event):void 
        {
            if (_mouseDown)
            {
                for (var j:uint = 0; j < SMOKE_SPAWN_AMOUNT; j++)
                {
                    var sE:SmokeEffect = new SmokeEffect(stage.mouseX, stage.mouseY);
                    _smokeEffects.push(sE);
                }
            }
            
            for (var i:uint = 0; i < _smokeEffects.length; i++)
            {
                _smokeEffects[i].update();
                _smokeEffects[i].draw(_smokeBuffer,
                _smokeGraphic.graphics, _smokeGraphic.clipping);
                
                if (_smokeEffects[i].position.y < -50)
                    _smokeEffects[i] = null, _smokeEffects.splice(i, 1), i--;
            }
            _smokeBuffer.applyFilter(_smokeBuffer, _screenRect, _screenPosition, new BlurFilter(SMOKE_DECAY_AMOUNT, SMOKE_DECAY_AMOUNT));
            
            _frames++;
            _currentTime = getTimer();
            if (_currentTime - _startTime >= 1000)
            {
                _infoTextField.text = "FPS: " + _frames + "\n" + 
                "PARTICLES: " + _smokeEffects.length;
                
                _frames = 0;
                _startTime = _currentTime;
            }
        }
        
    }
    
}

import flash.display.BitmapData;
import flash.geom.Point;
import flash.geom.Rectangle;
class SmokeEffect
{
    private var _position:Point;
    public function get position():Point { return _position; }
    
    private var _velocityY:Number = 0.0;
    private var _velocityX:Number = 0.0;
    
    public function SmokeEffect(tx:int, ty:int)
    {
        _position = new Point(tx, ty);
        _velocityX = Math.random() * Main.SMOKE_MOVE_X_AMOUNT - Main.SMOKE_MOVE_XH_AMOUNT;
        _velocityY = Math.random() * Main.SMOKE_MOVE_Y_AMOUNT - Main.SMOKE_MOVE_YH_AMOUNT;
    }
    
    public function update():void
    {
        _velocityX = Math.random() * Main.SMOKE_TURB_AMOUNT - Main.SMOKE_TURB_H_AMOUNT;
        if(_velocityY > -Main.SMOKE_ASCEND_MAXIMUM)
            _velocityY -= Main.SMOKE_ASCEND_AMOUNT;
        
        _position.x += _velocityX;
        _position.y += _velocityY;
    }
    
    public function draw(tbuffer:BitmapData, tgraphics:BitmapData, tclipping:Rectangle):void
    {
        tbuffer.copyPixels(tgraphics, tclipping, _position, null, null, true);
    }
        
}

class SmokeGraphic
{
    private var _graphics:BitmapData;
    public function get graphics():BitmapData { return _graphics; }
    
    private var _clipping:Rectangle;
    public function get clipping():Rectangle { return _clipping; }
    
    public function SmokeGraphic(tsize:uint, tcolor:uint) 
    {
        _graphics = new BitmapData(tsize, tsize, true, tcolor);        
        
        _clipping = _graphics.rect;
    }
}