/**
 * Copyright alexchirila87 ( http://wonderfl.net/user/alexchirila87 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4WNN
 */

// forked from Wyatt.Barriger's flash on 2012-3-11
package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    public class terrain extends Sprite {
        private const WATER:int=0;
        private const LAND:int=1;
        private var iterations:int=8;
        private var simultaneously:Boolean=false;
        private var landRatio:Number=0.51;
        private var mapWidth:int=465;
        private var mapHeight:int=48;
        private var tileSize:int=1;
        private var canvas:Sprite;
        private var landArray:Array;
        private var newLandArray:Array;
        public function terrain() {
            canvas = new Sprite();
            landArray=new Array();
            newLandArray=new Array();
            addChild(canvas);
            generateMap();
            addEventListener(MouseEvent.CLICK,onClick);
        }
        private function generateMap():void {
            landOrWater();
            drawMap();
        }
        private function drawMap():void {
            for (var i:int=0; i<mapWidth; i++) {
                for (var j:int=0; j<=mapWidth; j++) {
                    switch (landArray[i][j]) {
                        case WATER :
                            drawWater(i,j);
                            break;
                        case LAND :
                            drawLand(i,j);
                            break;
                    }
                }
            }
        }
        private function landOrWater():void {
            for (var i:int=0; i<mapWidth; i++) {
                landArray[i]=new Array();
                newLandArray[i]=new Array();
                for (var j:int=0; j<=mapWidth; j++) {
                    if (Math.random()<landRatio) {
                        landArray[i][j]=LAND;
                    } else {
                        landArray[i][j]=WATER;
                    }
                }
            }
            for (i=1; i<=iterations; i++) {
                iterateLand(LAND,WATER);
            }
        }
        private function drawLand(col:int,row:int):void {
            canvas.graphics.beginFill(0x00ff00);
            canvas.graphics.lineStyle(1,0x00ff00);
            canvas.graphics.drawRect(tileSize*col,tileSize*row,tileSize,tileSize);
            canvas.graphics.endFill();
        }
        private function drawWater(col:int,row:int):void {
            canvas.graphics.beginFill(0x0000ff);
            canvas.graphics.lineStyle(1,0x0000ff);
            canvas.graphics.drawRect(tileSize*col,tileSize*row,tileSize,tileSize);
            canvas.graphics.endFill();
        }
        private function iterateLand(land:int,defaultLand:int):void {
            for (var i:int=0; i<mapWidth; i++) {
                for (var j:int=0; j<=mapWidth; j++) {
                    if (landArray[i][j]==land||landArray[i][j]==defaultLand) {
                        if (adjacentLand(i,j,land)>4) {
                            if (! simultaneously) {
                                landArray[i][j]=land;
                            } else {
                                newLandArray[i][j]=land;
                            }
                        } else {
                            if (! simultaneously) {
                                landArray[i][j]=defaultLand;
                            } else {
                                newLandArray[i][j]=defaultLand;
                            }
                        }
                    }
                }
            }
            if (simultaneously) {
                for (i=0; i<mapWidth; i++) {
                    for (j=0; j<=mapWidth; j++) {
                        landArray[i][j]=newLandArray[i][j];
                    }
                }
            }
        }
        private function adjacentLand(col:int,row:int,lookFor:int):int {
            var found:int=0;
            for (var i:int=-1; i<=1; i++) {
                for (var j:int=-1; j<=1; j++) {
                    if (landArray[col+i]!=undefined&&landArray[col+i][row+j]==lookFor) {
                        found++;
                    }
                }
            }
            return found;
        }
        private function onClick(e:MouseEvent):void {
            canvas.graphics.clear();
            generateMap();
        }
    }
}