/**
 * Copyright J.J ( http://wonderfl.net/user/J.J )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4VVM
 */

package  {
    import flash.utils.ByteArray;
    import flash.net.FileFilter;
    import flash.events.MouseEvent;
    import flash.net.FileReference;
    import flash.media.SoundChannel;
    import flash.net.URLRequest;
    import flash.media.Sound;
    import flash.filters.BlurFilter;
    import flash.geom.Matrix;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;


    public class Equlizer extends Sprite {
        private var canvas : Bitmap;
        private var h : int;
        private var w : int;
        private var container : Sprite;
        private var amplitude:Number,period:Number
        private const TWO_PI:Number=Math.PI*2
        private var mtrx : Matrix;
        private var blurFX : BlurFilter;
        private var sound : Sound;
        private var channel : SoundChannel;
        private var fileRef : FileReference;
        private var fileType : Array;
        public function Equlizer() {
            fileType=[new FileFilter("MP3", "*.mp3")]
            stage.addEventListener(MouseEvent.CLICK, openFile)
            sound=new Sound()
            channel=new SoundChannel()
            w=stage.stageWidth,h=stage.stageHeight
            canvas=new Bitmap()
            canvas.bitmapData=new BitmapData(w, h,false,0x000000);
            addChild(canvas)
            container=new Sprite()
            //addChild(container)
            mtrx=new Matrix()
            mtrx.translate(0, h/2)
            blurFX=new BlurFilter(5,5)
            addEventListener(Event.ENTER_FRAME, loop)
        }
        private function openFile(event : MouseEvent) : void {
            sound=new Sound()
            channel.stop()
            fileRef=new FileReference()
            fileRef.browse(fileType)
            fileRef.addEventListener(Event.SELECT, function ():void{fileRef.load();fileRef.addEventListener(Event.COMPLETE, function ():void{trace('loaded');sound.loadCompressedDataFromByteArray(fileRef.data, fileRef.data.bytesAvailable);channel=sound.play()})})

        }
        private function loop(event : Event) : void {
            amplitude=channel.leftPeak*h/3;
            period=width/(channel.rightPeak*10)
            with(container.graphics){
            clear();
            lineStyle(1,0xffffff*channel.leftPeak+channel.rightPeak);
            moveTo(0, 0)
            for (var i : int = 0; i < w; i++) {
                var _y:Number=amplitude*Math.sin(TWO_PI*i/period)
                lineTo(i, _y)
            }
            canvas.bitmapData.draw(container,mtrx)
            canvas.bitmapData.applyFilter(canvas.bitmapData, canvas.bitmapData.rect, canvas.bitmapData.rect.topLeft, blurFX);
            }
        }
    }
}

