/**
 * Copyright primevision ( http://wonderfl.net/user/primevision )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4VEx
 */

package { 
    import flash.display.*; 
    import flash.events.*; 
    import flash.geom.*; 
    import flash.net.*; 
    import flash.system.LoaderContext; 
     
    public class Begineer extends Sprite{ 
         
         
        //-------------------------------// 
        // Use properties as follows. 
        //-------------------------------// 
        private var _sliceList:Array; 
         
         
         
         
        //-------------------------------// 
        // Change functions as follows. 
        //-------------------------------//
        private var centerX:int = 240;
        private var centerY:int = 240;
        private var showNo:int = -1;
        private var sc:Number = 10.0;
        private var colorList:Array = [];
        public function updateEnterFrame( e:Event ):void {
            var i:int; 
            var bm:Bitmap;
            var total:int = _sliceList.length;
			
            for (i = 0; i < total; i++) {
                bm = Bitmap(_sliceList[i]);
                var i2:int = Math.abs(i - total / 2);
                if (i2 > showNo) {
                    bm.alpha = 0;
                    bm.scaleY = 0;
                    colorList[i] = -200;
                    bm.x = centerX + i - total / 2;
                } else {
                    bm.alpha += (1 - bm.alpha) / 10;
                    bm.scaleY += (1 - bm.scaleY) / 10;
                }
                bm.y = centerY - bm.height / 2; 
                if (i2 + 280 < showNo) {
                    colorList[i] += (0 - colorList[i]) / 20;
                } else if (i2 + 200 < showNo) {
                    colorList[i] += (200 - colorList[i]) / 4;
                }
                bm.transform.colorTransform = new ColorTransform(1, 1, 1, 1, colorList[i], colorList[i], colorList[i], 0);
            }
            showNo += 6;
            sc += (0.8 - sc) / 18;
            this.scaleX = this.scaleY = sc;
            this.x = -((480 * sc-480) / 2);
            this.y = -((480 * sc - 480) / 2);
			
            if (showNo > 900) {
                showNo = -1;
                sc = 10;
            }
        }  
         
         
 
        //-------------------------------// 
        // Do not change following codes. 
        //-------------------------------// 
        public function Begineer(){ 
            var ctxt  :LoaderContext = new LoaderContext(true); 
            var loader:Loader = new Loader(); 
            loader.contentLoaderInfo.addEventListener( Event.COMPLETE, onLoadComplete ); 
            loader.load( new URLRequest("http://swf.wonderfl.net/static/assets/massmedian.png"), ctxt ); 
        } 
         
        public function onLoadComplete(e:Event):void { 
            var loader:Loader = LoaderInfo( e.target ).loader; 
            loader.contentLoaderInfo.removeEventListener( Event.COMPLETE, onLoadComplete ); 
             
            var bitmapdata:BitmapData = new BitmapData( loader.width, loader.height, true, 0xFF0000 ); 
            bitmapdata.draw( loader ); 
             
            _sliceList = sliceBanner( bitmapdata, bitmapdata.width ); 
             
            addEventListener( Event.ENTER_FRAME, updateEnterFrame ); 
        } 
         
         
        private function sliceBanner( banner:BitmapData, length:int = 100 ):Array{ 
            var sliceList:Array = []; 
            var w:int = Math.floor( banner.width/length ); 
            var h:int = Math.floor( banner.height ); 
             
            var t:int = Math.ceil( banner.width - w*length ); 
            var mat:Matrix = new Matrix(); 
                 
            for( var i:int = 0; i<length; i++ ) { 
                var bmpd :BitmapData = new BitmapData( w, h, true, 0xFFFF00 ); 
                mat.tx = -w*i; 
                bmpd.draw( banner, mat ); 
                var part:DisplayObject = addChild( new Bitmap( bmpd ) ); 
                part.x = w*i; 
                sliceList.push( part ); 
            } 
            return sliceList; 
        } 
         
    } 
} 
