/**
 * Copyright mycodingqt ( http://wonderfl.net/user/mycodingqt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4V6d
 */

// forked from jloa's Color scaling (lighten, darken)
package
{
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.Graphics;
    import flash.display.GradientType;
    import flash.geom.Matrix;
    import flash.text.TextField;
    import flash.text.TextFormat;
    
    /**
     * Color scaling (lighten, darken)
     * flat >> glossy color
     */
    public class FlashTest extends Sprite
    {
        private var colors:Array = [0xADD205, 0xFFA01E, 0x028FDB];
        private var n:int = colors.length;
        private var w:int = 50; 
        private var h:int = 50;
        private var s:Shape;
        private var m:Matrix = new Matrix();
        
        public function FlashTest()
        {
            m.createGradientBox(w, h, Math.PI/2);
            
            // labels
            label("flat colors", w, h - 20);
            label("flat >> web 2.0 glossy", w, h*3 - 20);

            // create 3 boxes with flat colors
            for(var i:int = 0; i < n; ++i)
            {
                s = new Shape();
                s.x = w + i*w; s.y = h;
                s.graphics.beginFill(colors[i], 1);
                s.graphics.drawRect(0, 0, w, h);
                s.graphics.endFill();
                addChild(s);
            }        

            // create another 3 boxes with glossy colors web2.0 style
            for(i = 0; i < n; ++i)
            {
                s = new Shape();
                s.x = w + i*w; s.y = h*3;
                s.graphics.beginGradientFill(GradientType.LINEAR,[scaleColor(colors[i], .3), scaleColor(colors[i], -.3)], [1, 1], [0, 255], m);
                s.graphics.drawRect(0, 0, w, h);
                s.graphics.endFill();
                addChild(s);
            }
        }
        
        /**
         * Scales r-g-b channels by 'scale' factor, having the r-g-b proportions saved
         * @param    color:uint        color to be scaled (i.e. lighten or darken)
         * @param    scale:Number    the scale factor (values -1 to 1) -1 = absolute dark; 1 = absolute light;
         * @return    uint            scaled color
         */
        private function scaleColor(color:uint, scale:Number):uint
        {
            var r:int = (color & 0xFF0000) >> 16;
            var g:int = (color & 0x00FF00) >> 8;
            var b:int = color & 0x0000FF;
            r += (255 * scale)*(r/(r+g+b)); r = (r > 255) ? 255 : r; r = (r < 0) ? 0 : r;
            g += (255 * scale)*(g/(r+g+b)); g = (g > 255) ? 255 : g; g = (g < 0) ? 0 : g;
            b += (255 * scale)*(b/(r+g+b)); b = (b > 255) ? 255 : b; b = (b < 0) ? 0 : b;
            return (r << 16 & 0xff0000) + (g << 8 & 0x00ff00) + (b & 0x0000ff);
        }
        
        
        /** creates a tf, positions at x, y **/    
        private function label(str:String, x:int, y:int):void
        {
            var tf:TextField = new TextField();
            tf.text = str; tf.x = x; tf.y = y; tf.autoSize = "left";
            tf.setTextFormat(new TextFormat("verdana", 10));
            addChild(tf);
        }
    }
}