/**
 * Copyright Mae_ITR ( http://wonderfl.net/user/Mae_ITR )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4V4w
 */

package  
{
    //http://hakuhin.hp.infoseek.co.jp/main/as/collision.html
    //参考にしました　てか、まんまです
	import flash.display.Sprite;
	import flash.geom.Point;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	
	import com.bit101.components.*;

	public class LineCrossTest extends Sprite
	{
		
		
		private var a:Point;
		private var b:Point;
		private var c:Point;
		private var d:Point;		
		private var OldMouse:Point;
		
		private var ballA:Ball;
		private var ballB:Ball;
		private var ballC:Ball;
		
		private var txt:Label;
		
		public function LineCrossTest() 
		{
			this.stage.align = StageAlign.TOP_LEFT;
			this.stage.scaleMode = StageScaleMode.NO_SCALE;
			
			init();
		}
		
		private function init():void
		{
			a = new Point(stage.stageWidth*Math.random(),stage.stageHeight*Math.random());
			b = new Point(stage.stageWidth*Math.random(),stage.stageHeight*Math.random());
			c = new Point();
			d = new Point(mouseX,mouseY);
			OldMouse = d.clone();
			
			ballA = new Ball(5, 0x999999);
			ballA.x = a.x;
			ballA.y = a.y;
			
			ballA.addEventListener(MouseEvent.MOUSE_DOWN, onPress);
			ballA.addEventListener(MouseEvent.MOUSE_UP, onRelease);	
			
			ballB = new Ball(5, 0x999999);
			ballB.x = b.x;
			ballB.y = b.y;
			
			ballB.addEventListener(MouseEvent.MOUSE_DOWN, onPress);
			ballB.addEventListener(MouseEvent.MOUSE_UP, onRelease);	
			
			ballC = new Ball(3, 0x00FF99);
			ballC.x = c.x;
			ballC.y = c.y;
			
			txt = new Label(this, 6, 6);
			
			addChild(ballC);
			addChild(ballB);
			addChild(ballA);
			
			draw();
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame(e:Event):void 
		{
			d.x = mouseX - OldMouse.x;
			d.y = mouseY - OldMouse.y;
			
			draw();
			calculation();
			
			OldMouse.x = mouseX;
			OldMouse.y = mouseY;
		}
		
		private function calculation():void {
			var ab:Point = new Point(b.x - a.x, b.y - a.y);
			var n:Point = new Point( -ab.y, ab.x);
			n.normalize(1);
			var dd:Number = -(a.x * n.x + a.y * n.y);
			if (d.x != 0 || d.y != 0) {
				var t:Number = -(n.x * OldMouse.x + n.y * OldMouse.y + dd) / (n.x * d.x + n.y * d.y);
				if (t > 0 && t <= 1) {
					c.x = OldMouse.x + d.x * t;
					c.y = OldMouse.y + d.y * t;
					var ac:Point = new Point(c.x - a.x, c.y - a.y);
					var bc:Point = new Point(c.x - b.x, c.y - b.y);
					var doc:Number = (ac.x * bc.x) + (ac.y * bc.y);
					if (doc < 0) {
						ballC.x = c.x;
						ballC.y = c.y;
						txt.text = "x : " + c.x + "\n" + "y : " + c.y + "\n";
					}					
				}
			}
		}
		
		private function onPress(e:MouseEvent):void 
		{
			e.target.startDrag();
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMove);
			
		}
		
		private function onMove(e:MouseEvent):void 
		{
			a.x = ballA.x;
			a.y = ballA.y;
			b.x = ballB.x; 
			b.y = ballB.y; 
		}
		
		private function onRelease(e:MouseEvent):void 
		{
			e.target.stopDrag();
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMove);			
		}
		
		private function draw():void
		{
			this.graphics.clear();
			this.graphics.lineStyle(1, 0xCCCCCC);
			this.graphics.moveTo(a.x, a.y);
			this.graphics.lineTo(b.x, b.y);	
			this.graphics.lineStyle(1, 0x00FF99, 0.5);
			this.graphics.moveTo(OldMouse.x, OldMouse.y);
			this.graphics.lineTo(mouseX, mouseY);
		}
		
	}
	
}

import flash.display.Sprite

class Ball extends Sprite {
	
	private var radius:Number;
	private var color:uint;
	
	public function Ball(radius:Number = 40, color:uint = 0xff0000) {
		this.radius = radius;
		this.color = color;
		init();
	}
	
	public function init():void {
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
	}
	
}