/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4UrH
 */

package  {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.filters.BlurFilter;
    import flash.utils.Timer;
    import flash.utils.ByteArray;
    import flash.media.SoundMixer;
    import flash.system.Security;
    
    [SWF(width="465", height="465", backgroundColor="#000000", frameRate="30")]
    
    public class Main extends Sprite{
        
        private var _container:Sprite;
        private var _list:Array = new Array();
        private var _xCount:int;;
        private var _yCount:int;;
        private var _size:Number = 8;
        private var _xRepeat:int = stage.stageWidth/_size;
        private var _yRepeat:int = stage.stageHeight/_size;
        private var _repeat:int = _xRepeat*_yRepeat;
        //
        private var _timer:Timer;
        //       
        private var _waveBytes:ByteArray = new ByteArray();
        private var _sound:SoundPlayStop;
        //
        private static const CHENGE_NUM:int = 0x999999;
        private var _color:int = 0xFFFFFF;
        private var _density:int = 1500;
        private var _waveWidth:Number = 0.3;
        
        public function Main() {
            Security.loadPolicyFile("http://www.digifie.jp/crossdomain.xml");
            //
            var base:Sprite = new Base(0x000000, stage.stageWidth, stage.stageHeight)
            addChild(base)
            _container = new Sprite()
            _container.rotation = 90
            _container.x=stage.stageWidth
            addChild(_container)
            var blur:BlurFilter = new BlurFilter(4,4,2);
            for(var i:int;i<_repeat;i++){
                _color += CHENGE_NUM;
                if(_xCount>_xRepeat){
                    _xCount = 0;
                    _yCount+=_size;
                }
                var mc:Sprite = new Rect(_size ,i, _color);
                _container.addChild(mc);
                _list.push(mc);
                _list[i].x = _size*_xCount;
                _list[i].y = _yCount;
                _list[i].cacheAsBitmap = true;
                //_list[i].filters = [blur];
                _list[i].visible = false;
                //
                _xCount++;
            }
            startDelay();
        }
        
        private function startDelay():void{
            _timer = new Timer(1000,1);
            _timer.addEventListener(TimerEvent.TIMER_COMPLETE, go);
            _timer.start();
        }
        
        private function go(e:TimerEvent):void{
            _timer.removeEventListener(TimerEvent.TIMER_COMPLETE, go);
            _timer=null;
            //
            _sound=new SoundPlayStop()
            _sound.soundStart("http://www.digifie.jp/files/test2.mp3", 100);
            addEventListener(Event.ENTER_FRAME,update);
        }
        
        private function update(e:Event):void{
            var num:Number;
            try{
                SoundMixer.computeSpectrum(_waveBytes, true, 0);
                num = Math.floor(_waveBytes.readFloat()*_density);
            }catch(e:Error){
                return;
            }
            //
             for(var i:int;i<_list.length;i++){
                _list[i].visible = false;
             }
             for(var j:int;j<num;j++){
                var n1:int = Math.floor(Math.random()*_list.length*_waveWidth)
                try{
                     _list[j+n1].visible = true;
                }catch(e:Error){
                    return;
                }
             }
             for(var k:int=_list.length-1;k>-(num-_list.length);k--){
                var n2:int = Math.floor(Math.random()*_list.length*_waveWidth)
                 try{
                     _list[k-n2].visible = true;
                }catch(e:Error){
                    return;
                }
             }
        }
        
    }
}
        
        
import flash.display.Sprite;

class Rect extends Sprite{
    
    private var _size:int;
    private var _num:int;

    
    public function Rect(size:int, n:int, color:int=0xFFFFFF){
        _size = size;
        _num = n;
        graphics.beginFill(color,1);
        graphics.drawRect(0,0,_size,_size);
        graphics.endFill();
        graphics.lineStyle(1, 0xFFFFFF, 1);
        graphics.moveTo(0, 0);
        graphics.lineTo(_size, 0);
        graphics.lineTo(_size, _size);
        graphics.lineTo(0, _size);
        graphics.lineTo(0, 0);
    }
    
    public function get num():int{
        return _num;
    }
}


//
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundTransform;
import flash.media.SoundLoaderContext;
import flash.net.URLRequest;
import flash.system.Security;

class SoundPlayStop extends EventDispatcher{
        
    public var my_sc:SoundChannel;
    public var my_sound:Sound;                
    public var _flg:Boolean = true;
    
    public function SoundPlayStop(){
        Security.loadPolicyFile("http://www.digifie.jp/crossdomain.xml");
    }

    public function soundStart(Url:String, ref:uint = 1, vol:Number = 1):void {
        if(_flg){
            var trans:SoundTransform = new SoundTransform(vol,0);
            var context:SoundLoaderContext = new SoundLoaderContext(); 
            context.checkPolicyFile = true;
            //
            if (my_sc != null) {
                my_sc.stop();
                my_sc = null;
            }
            try{
                my_sound = new Sound(new URLRequest(Url),context);
                my_sc = my_sound.play(0,ref);
                my_sc.soundTransform = trans;
            }catch(e:Error){
                trace(e,Url);
            }
        }
    }

    public function soundStop():void {
        if (my_sc != null) {
            my_sc.stop();
            my_sc = null;
            my_sound = null;
        }
    }
}

import flash.display.Sprite
class Base extends Sprite{
    public function Base(color:int,w:int,h:int):void{
        graphics.beginFill(color, 1)
        graphics.drawRect(0,0,w,h)
        graphics.endFill()
    }
}