/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4U4h
 */

// forked from tkinjo's ターゲットの周りを飛ぶキューブ
package  
{
	/**
	 * PV3D でマルチビュー（問題点あり）の問題が起こる過程をマルチビューでみてみる
	 * 
	 * PV3D でマルチビュー（問題点あり）
	 * http://wonderfl.kayac.com/code/3affbb69d1ad490c7e5ba360ec894be9be251d68
	 */
	
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.utils.Timer;
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.core.geom.Lines3D;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.special.LineMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Cone;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.Viewport3D;
	
	[SWF(width=465,height=465,frameRate=60,backgroundColor=0xffffff)]
	/**
	 * ...
	 * @author tkinjo
	 */
	public class Main extends BasicView
	{
		private const radius:Number = -1000;
		private const targetToCubeRadius:Number = - 1000;
		
		private var angleXY:Number = 0;
		private var angleYZ:Number = 0;
		
		private var viewport2:Viewport3D;
		private var camera2:Camera3D;
		
		private var viewport3:Viewport3D;
		private var camera3:Camera3D;
		
		private var textField:TextField;
		private var textField2:TextField;
		private var textField3:TextField;
		
		private var cube:Cube;
		
		public function Main() 
		{
			viewport.viewportWidth = stage.stageWidth / 2;
			viewport.viewportHeight = stage.stageHeight / 2;
			
			var frontCube:Cube = new Cube( new MaterialsList( { all : new ColorMaterial( 0xff0000, 0.5 ) } ), 100, 100, 100 );
			frontCube.z = -200;
			scene.addChild( frontCube );
			
			var backCube:Cube = new Cube( new MaterialsList( { all : new ColorMaterial( 0xffff00, 0.5 ) } ), 100, 100, 100 );
			backCube.z = 200;
			scene.addChild( backCube );
			
			var leftCube:Cube = new Cube( new MaterialsList( { all : new ColorMaterial( 0x00ff00, 0.5 ) } ), 100, 100, 100 );
			leftCube.x = -200;
			scene.addChild( leftCube );
			
			var rightCube:Cube = new Cube( new MaterialsList( { all : new ColorMaterial( 0x00ffff, 0.5 ) } ), 100, 100, 100 );
			rightCube.x = 200;
			scene.addChild( rightCube );
			
			var topCube:Cube = new Cube( new MaterialsList( { all : new ColorMaterial( 0x0000ff, 0.5 ) } ), 100, 100, 100 );
			topCube.y = 200;
			scene.addChild( topCube );
			
			var bottomCube:Cube = new Cube( new MaterialsList( { all : new ColorMaterial( 0xff00ff, 0.5 ) } ), 100, 100, 100 );
			bottomCube.y = -200;
			scene.addChild( bottomCube );
			
			var targetCube:Cube = new Cube( new MaterialsList( { all : new WireframeMaterial( 0 ) } ), 100, 100, 100 );
			scene.addChild( targetCube );
			
			var wireframeMaterial:WireframeMaterial = new WireframeMaterial( 0 );
			wireframeMaterial.doubleSided = true;
			cube = new Cube( new MaterialsList( { all : wireframeMaterial } ), 100, 100, 100 );
			scene.addChild( cube );
			
			/**
			 * viewport2 の設定
			 */
			viewport2 = new Viewport3D( stage.stageWidth / 2, stage.stageHeight / 2 );
			viewport2.x = stage.stageWidth / 2;
			addChild( viewport2 );
			
			camera2 = new Camera3D();
			camera2.target = DisplayObject3D.ZERO;
			
			/**
			 * viewport3 の設定
			 */
			viewport3 = new Viewport3D( stage.stageWidth / 2, stage.stageHeight / 2 );
			viewport3.x = stage.stageWidth / 2;
			viewport3.y = stage.stageWidth / 2;
			addChild( viewport3 );
			
			camera3 = new Camera3D();
			camera3.x = 2000;
			camera3.y = 2000;
			camera3.z = -2000;
			camera3.target = DisplayObject3D.ZERO;
			
			/**
			 * textField の設定
			 */
			textField = new TextField();
			textField.autoSize = TextFieldAutoSize.LEFT;
			textField.text = "問題が起こる過程を再現";
			addChild( textField );
			
			textField2 = new TextField();
			textField2.x = stage.stageWidth / 2;
			textField2.autoSize = TextFieldAutoSize.LEFT;
			addChild( textField2 );
			
			textField3 = new TextField();
			textField3.x = stage.stageWidth / 2;
			textField3.y = stage.stageWidth / 2;
			textField3.autoSize = TextFieldAutoSize.LEFT;
			addChild( textField3 );
			textField3.text = "動いているワイヤーフレームキューブは\nカメラのつもり"
			
			startRendering();
			
			addEventListener( Event.ENTER_FRAME, enterFrameHandler );
		}
		
		/**
		 * 
		 * @param	event
		 */
		private function enterFrameHandler( event:Event ):void {
			
			if ( angleYZ == 90 ) {
				
				if( camera.target )
					camera.target = null;
					
				if ( 180 < camera.rotationY ) {
					
					camera.target = DisplayObject3D.ZERO;
					angleYZ++;
					
				} else 
					camera.rotationY++;
				
			} else if ( angleYZ == 270 ) {
				
				if( camera.target )
					camera.target = null;
					
				if ( 180 < camera.rotationY ) {
					
					camera.target = DisplayObject3D.ZERO;
					angleYZ++;
					
				} else 
					camera.rotationY++;
				
			}  else if ( angleYZ == 360 ) {
				
				angleYZ = 1;
				
			} else {
				
				angleYZ++;
			}
			
			var thetaXZ:Number = angleXY * Math.PI / 180;
			var thetaYZ:Number = angleYZ * Math.PI / 180;
			camera.x = radius * Math.cos( thetaYZ ) * Math.sin( thetaXZ );
			camera.y = -radius * Math.sin( thetaYZ );
			camera.z = radius * Math.cos( thetaYZ ) * Math.cos( thetaXZ );
			camera2.x = camera.x;
			camera2.y = camera.y;
			camera2.z = camera.z;
			
			cube.x = targetToCubeRadius * Math.cos( thetaYZ ) * Math.sin( thetaXZ );
			cube.y = - targetToCubeRadius * Math.sin( thetaYZ );
			cube.z = targetToCubeRadius * Math.cos( thetaYZ ) * Math.cos( thetaXZ );
			cube.rotationX = thetaYZ * 180 / Math.PI;
			cube.rotationY = camera.rotationY;
			
			
			textField.text = "問題が起こる過程を再現";
			if ( angleYZ == 90 || angleYZ == 270 ) {
				
				camera2.z = 0;
				textField.appendText( "\nカメラ反転中\n\nこのとき、カメラはワイヤーフレームキューブに\n囲まれているはずなのに\n右のように何も表示しない" );
			}
			textField2.text = "camera2.z = " + int( camera2.z ) + "\nangleYZ = " + angleYZ;
			
			renderer.renderScene( scene, camera2, viewport2 );
			renderer.renderScene( scene, camera3, viewport3 );
		}
	}
	
}