/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4ShA
 */

package {
  import flash.display.Sprite;

  import funnel.*;
  import funnel.ui.*;

  public class DetectVibration extends Sprite {
    // Arduino
    private var arduino:Arduino;

    // D13に接続されているオンボードのLED
    private var led:LED;

    public function DetectVibration() {
      // LEDに接続したピンのモードを出力にセット
      var config:Configuration = Arduino.FIRMATA;
      config.setDigitalPinMode(13, OUT);
      arduino = new Arduino(config);

      // LEDを表す変数を初期化
      led = new LED(arduino.digitalPin(13));

      // FIRMATA_STRINGイベントに対してイベントリスナをセット
      arduino.addEventListener(FunnelEvent.FIRMATA_STRING, 
                               onStringEvent);
    }

    // FIRMATA_STRINGイベントが発生したら以下を実行
    private function onStringEvent(e:FunnelEvent):void {
      // イベントとして受け取った文字列が"K"であれば以下を実行
      if (e.message == "K") {
        led.blink(100, 1);
      }
    }
  }
}
