/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4SLG
 */

package {
  import flash.display.Sprite;
  import flash.events.*;
  import flash.net.*;
  import flash.text.*;
  import flash.utils.Timer;
  import funnel.*;
  import funnel.ui.*;

  public class DataInFromPachube extends Sprite {
    // Pachubeで使用するenvironment idとAPI key
    private static const ENVIRONMENT_ID:String = "504";
    private static const API_KEY:String = "YOUR_API_KEY";

    private var arduino:Arduino;
    private var led:LED;

    // 一定間隔でPachubeにデータをリクエストするタイマー
    private var pulse:Timer;

    // Pachubeからデータをロードする際に使用するローダ
    private var urlLoader:URLLoader;

    // Pachubeから受取ったデータを表示するテキストフィールド
    private var textField:TextField;

    public function DataInFromPachube() {
      var config:Configuration = Arduino.FIRMATA;
      config.setDigitalPinMode(9, PWM);
      arduino = new Arduino(config);
      led = new LED(arduino.digitalPin(9));

      // Pachubeから受取ったデータを表示するテキストフィールドを追加
      textField = new TextField();
      textField.autoSize = TextFieldAutoSize.LEFT;
      addChild(textField);

      // Pachubeからデータをロードするローダを準備してリスナをセット
      urlLoader = new URLLoader();
      urlLoader.addEventListener(Event.COMPLETE, onComplete);

      // 間隔5000msのタイマーをセットしてスタート
      pulse = new Timer(5000);
      pulse.addEventListener(TimerEvent.TIMER, onPulse);
      pulse.start();
    }

    // タイマーで一定間隔ごとにPachubeに接続して指定したフィードをロード
    private function onPulse(e:TimerEvent):void {
      var url:String = "http://www.pachube.com/api/";
      url += ENVIRONMENT_ID + ".xml?key=" + API_KEY;
      urlLoader.load(new URLRequest(url));
    }

    // ロードが完了したら以下を実行
    private function onComplete(e:Event):void {
      // ロードしたデータからXMLオブジェクトを生成して名前空間を取得
      var xml:XML = new XML(urlLoader.data);
      var ns:Namespace = xml.namespace();

      // ロードしたXML形式のデータからidが"1"となっているデータを読み取る
      // 要素を指定する際には名前空間を忘れずに指定する
      var value:String 
        = xml..ns::data.(@id == "1").ns::value;
      var minValue:String
        = xml..ns::data.(@id == "1").ns::value.@minValue;
      var maxValue:String
        = xml..ns::data.(@id == "1").ns::value.@maxValue;

      // テキストフィールドの表示とLEDの輝度を更新
      textField.text = "val: " + value;
      textField.appendText(" (min: " + minValue + ", ");
      textField.appendText("max: " + maxValue + ")");
      led.intensity = Number(value) / 1023;
    }
  }
}