/**
 * Copyright linktale ( http://wonderfl.net/user/linktale )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4RtN
 */

/*
1. 左上の入力欄に、好きな文字を一文字入力
2. パラメータで激しさ変更
3. Clickで静止

少しづつバグを修正予定
■　エッジ取得方法
■　パスの取得方法
■　文字内のパスの色を白に

【修正】
■　adjustmentPath：パスの最適化

http://linktale.net/

【参考】
http://jsdo.it/tsmallfield/stars2
*/
package {
    import com.bit101.components.HUISlider;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFieldType;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    
    [SWF(width="465", height="465", frameRate="48")]
    
    public class Index extends Sprite {
        
        private static var DEBUG:Boolean = false;
        private static var DEFAULT_TEXT:String = "え";
        private static var TEXT_INPUT_AREA_H:Number = 30;        
        
        private var _updateFlg:Boolean = true; //描画フラグ
        
        private var _fontPlay:FontPlay; //文字解析クラス
        private var _pathBitmap:Bitmap; //パスのビットマップ
        
        private var _clickArea:Sprite; //クリックの範囲
        private var _pathArea:Sprite; //パスの描画領域
        private var _pathViewArea:Sprite = new Sprite();  //パスの描画領域
        private var _viewTextArea:Sprite = new Sprite(); //デバッグ用
        
        private var _basePathLists:Array = []; //パスの元位置
        private var _updatePathLists:Array = []; //パスの現位置
        
        private var _param1:Number = 1000;
        
        public function Index():void {
            trace("Class : Index");
            stage ? init() : addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init():void {
            trace("Method : init");
            
            //Wonderfl.capture_delay(10);
            Wonderfl.disable_capture();
            
            createInputTextArea(); //文字入力エリア生成
            if(DEBUG){ createViewTextArea(); }
            createFontPlay(); //文字解析クラス生成
            createEdge(); //エッジ生成
            createPath(); //パス生成
            setPathList(); //パスリスト初期化
            createController(); //コントローラ生成
            createClickArea(); //クリックエリア設定

            addEventListener(Event.ENTER_FRAME, update);
            _clickArea.addEventListener(MouseEvent.CLICK, click);
        }
        
        private function update(e:Event = null):void {
            //この関数を変更すると動きを変えられる
            
            var point:Point;
            var x:Number, y:Number, mouseXL:Number, mouseYL:Number, theta:Number, dist:Number;
            var mouseDiffX:Number = (stage.stageWidth / 2 - _fontPlay.textField.width / 2);
            var mouseDiffY:Number = (stage.stageHeight / 2 - _fontPlay.textField.height / 2 + TEXT_INPUT_AREA_H);
            for (var i:uint=0; i < _updatePathLists.length; i++ ) {
                for(var j:uint=0; j < _updatePathLists[i].length; j++ ) {
                    x = _updatePathLists[i][j].x;
                    y = _updatePathLists[i][j].y;
                    
                    mouseXL = mouseX - mouseDiffX;
                    mouseYL = mouseY - mouseDiffY;
                    
                    theta = Math.atan2(y - mouseYL, x - mouseXL);
                    dist = _param1 / Math.sqrt( ( mouseXL - x )*( mouseXL - x ) + ( mouseYL - y )*( mouseYL - y ) );
                    
                    _updatePathLists[i][j].x += (Math.cos(theta) * dist + (_basePathLists[i][j].x - x) * 0.2);
                    _updatePathLists[i][j].y += (Math.sin(theta) * dist + (_basePathLists[i][j].y - y) * 0.2);
                }
            }
            
            _fontPlay.drawLines(_updatePathLists);
        }
        
        private function click(e:MouseEvent):void {
            if(_updateFlg){
                removeEventListener(Event.ENTER_FRAME, update);
                _updateFlg = false;
            }else {
                addEventListener(Event.ENTER_FRAME, update);
                _updateFlg = true;
            }
        }
        
        private function createInputTextArea():void {
            trace("Method : createInputTextArea");
            //Config
            var textFieldH:Number = 20, textFieldW:Number = 25;
            
            //BackGround
            var textInputArea:Sprite = new Sprite();
            textInputArea.graphics.beginFill(0xdddddd, 1);
            textInputArea.graphics.drawRect(0, 0, stage.stageWidth, TEXT_INPUT_AREA_H);
            textInputArea.graphics.endFill();
            addChild(textInputArea);
            
            //TextFild
            var textField:TextField = new TextField();
            textField.defaultTextFormat = new TextFormat("小塚ゴシック Pro L", 14, 0x000000, true,null,null,null,null,TextFormatAlign.CENTER);
            textField.x = textField.y = (TEXT_INPUT_AREA_H - textFieldH) / 2;
            textField.width = textFieldW;
            textField.height = textFieldH;
            
            textField.type = TextFieldType.INPUT;
            textField.maxChars = 1;
            textField.border = textField.background = true;
            textField.borderColor = 0x222222;
            textField.backgroundColor = 0xffffff;
            textField.text = DEFAULT_TEXT;
            addChild(textField);
            
            //Event
            textField.addEventListener(Event.CHANGE, function(e:Event):void { onChange(textField.text, e);  } );
        }
        
        private function onChange(text:String, e:Event=null):void {
            trace("Method : onChange");
            if(text){
                _fontPlay.change(text);
                createEdge();
                createPath();
                setPathList();
            }
        }
        
        private function createViewTextArea():void {
            //debug
            trace("Method : createViewTextArea");
            _viewTextArea.y = TEXT_INPUT_AREA_H;
            _viewTextArea.graphics.beginFill(0xffffff);
            _viewTextArea.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight-TEXT_INPUT_AREA_H);
            _viewTextArea.graphics.endFill();
            _viewTextArea.width = stage.stageWidth;
            _viewTextArea.height = stage.stageHeight - TEXT_INPUT_AREA_H;
            addChild(_viewTextArea);
        }
        
        private function createFontPlay():void {
            trace("Method : createFontPlay");
            _fontPlay = new FontPlay(DEFAULT_TEXT);
            
            //debug
            if(DEBUG){
                var textField:TextField = _fontPlay.textField;
                textField.x = stage.stageWidth / 2 - textField.width / 2;
                textField.y = stage.stageHeight / 2 - textField.height / 2;
                _viewTextArea.addChild(textField);
            }
        }
        
        private function createEdge():void {
            trace("Method : createEdge");
            if (_pathBitmap) { _pathViewArea.removeChild(_pathBitmap); } else { addChild(_pathViewArea); }
            
            _pathBitmap = new Bitmap(_fontPlay.pathBitmapData);
            _pathBitmap.x = stage.stageWidth / 2 - _fontPlay.textField.width / 2;
            _pathBitmap.y = stage.stageHeight / 2 - _fontPlay.textField.height / 2 + TEXT_INPUT_AREA_H;
            _pathBitmap.alpha = 0.2;
            _pathViewArea.addChild(_pathBitmap);
        }
        
        private function createPath():void {
            trace("Method : createPath");
            if (_pathArea) { _pathViewArea.removeChild(_pathArea); }
            
            _pathArea = _fontPlay.pathArea;
            _pathArea.x = stage.stageWidth / 2 - _fontPlay.textField.width / 2;
            _pathArea.y = stage.stageHeight / 2 - _fontPlay.textField.height / 2 + TEXT_INPUT_AREA_H;
            
            _pathViewArea.addChild(_pathArea);
        }
        
        private function setPathList():void {
            _basePathLists = _fontPlay.basePointLists.concat();
            _updatePathLists = [];
            for (var i:uint = 0; i < _basePathLists.length; i++ ) {
                _updatePathLists[i] = []
                for (var j:uint = 0; j < _basePathLists[i].length; j++ ) {
                    _updatePathLists[i][j] = new Point(_basePathLists[i][j].x, _basePathLists[i][j].y);
                }
            }
        }
        
        
        private function createClickArea():void {
            //Click Area
            _clickArea = new Sprite();
            _clickArea.graphics.beginFill(0x000000, 0);
            _clickArea.graphics.drawRect(0, TEXT_INPUT_AREA_H, stage.stageWidth, stage.stageHeight - TEXT_INPUT_AREA_H);
            _clickArea.graphics.endFill();
            addChild(_clickArea);
        }
        

        
        private function createController():void {        
            var slider:HUISlider = new HUISlider(this, 40, 7, "Param1", onSlide1);
            slider.width = 440;
            slider.minimum = 0;
            slider.maximum = 2000;
            slider.value = _param1;
            slider.labelPrecision = 0;
        }
        
        private function onSlide1(e:Event):void {
            _param1 = e.target.value;
        }
    }
}





import flash.display.BitmapData;
import flash.display.GraphicsPathCommand;
import flash.display.GraphicsPathWinding;
import flash.display.Sprite;
import flash.filters.ConvolutionFilter;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class FontPlay {
    
    private var _text:String= "";
    private var _textField:TextField = new TextField();
    
    private var _pathArea:Sprite = new Sprite();
    private var _bitmapData:BitmapData;
    private var _pathBitmapData:BitmapData;
    
    private var _edgeList:Array = [];
    private var _commandsLists:Array = [];
    private var _basePointLists:Array = [];
    private var _pathLists:Array = [];

    
    public function FontPlay(string:String):void {
        trace("Class : FontPlay");
        
        _text = string;
        //解析
        analyze(_text);
    }
    
    public function analyze(str:String):void {
        trace("Method : analyze");
        
        //TextFiled生成
        createTextFiled(str);
        //パスデータ生成
        createPathLists();
    }
    
    private function createTextFiled(str:String):void {
        trace("Method : createTextFiled");
        //TextFild
        _textField = new TextField();
        _textField.defaultTextFormat = new TextFormat("小塚ゴシック Pro L", 127, 0x000000, true,null,null,null,null,TextFormatAlign.CENTER);
        _textField.text = str;
        _textField.autoSize = TextFieldAutoSize.LEFT;
        _textField.scaleX = _textField.scaleY = 2;
    }
    

    private function createPathLists():void {
        //文字のビットマップ生成
        createBitmapData();
        //ビットマップの解析
        analyzeBitmapData();
        //エッジのビットマップデータ生成
        crateEdgeBitmapData(_edgeList);
        //パスデータの生成
        createPath(_edgeList);
    }
    
    private function createBitmapData():void {
        trace("Method : createBitmapData");
        
        var scale:Number = 2.0;
        var matrix:Matrix = new Matrix(scale, 0, 0, scale);
        _bitmapData = new BitmapData(_textField.width*scale, _textField.height*scale, true);
        _bitmapData.draw(_textField, matrix);
    }
    
    private function analyzeBitmapData():void {
        trace("Method : analyzeBitmapData");
        _edgeList = [];
        var edgeBitmapData:BitmapData = edgeDetection(_bitmapData);
        
        var color:uint;
        for (var x:uint = 0; x < edgeBitmapData.width; x++ ) {
            _edgeList[x] = [];
            for (var y:uint = 0; y < edgeBitmapData.height; y++ ) {
                color = edgeBitmapData.getPixel(x, y);
                if (color != 0x000000) {
                    _edgeList[x][y] = 0x000000;
                }else {
                    _edgeList[x][y] = 0xffffff;
                }
            }
        }
        //エッジの線を補足する
        _edgeList = slimLine(_edgeList);
    }
    
    private function edgeDetection(bitmapData:BitmapData):BitmapData {
        //今いち精度が...
        var edgeBitmapData:BitmapData = new BitmapData(bitmapData.width, bitmapData.height, true);
        var cf1:ConvolutionFilter = new ConvolutionFilter(3, 3, [ 0, 1, 0, 1, -4, 1, 0, 1, 0]);
        //var cf2:ConvolutionFilter = new ConvolutionFilter(3, 3, [ -1, -1, -1, -1, 8, -1, -1, -1, -1]);
        
        edgeBitmapData.applyFilter(bitmapData, bitmapData.rect, new Point(), cf1); 
        //edgeBitmapData.applyFilter(edgeBitmapData, edgeBitmapData.rect, new Point(), cf2); 
        
        return edgeBitmapData;
    }
    
    //エッジの線を補足する
    private function slimLine(baseList:Array):Array {
        // 0 1 2
        // 7   3
        // 6 5 4
        //
        // possible pattern #1
        // ? 1 ?    ? 1 ?
        // 1 1 ? -> 1 0 ?
        // ? ? 0    ? ? 0
        //
        // possible pattern #2
        // ? 1 ?    ? 1 ?
        // ? 1 ? -> ? 0 ?
        // 0 0 0    0 0 0
        //
        // possible pattern #3
        // 1 ? 0    1 ? 0
        // ? 1 0 -> ? 0 0
        // 0 0 0    0 0 0
        var newList:Array = baseList.concat();
        var p:uint, p0:uint, p1:uint, p2:uint, p3:uint, p4:uint, p5:uint, p6:uint, p7:uint;
        for (var x:uint = 0; x < newList.length; x++ ) {
            for (var y:uint = 0; y < newList[x].length; y++ ) {
                p = newList[x][y];
                p0 = p1 = p2 = p3 = p4 = p5 = p6 = p7 = 0xffffff;
                if(newList[x - 1] && newList[x - 1][y - 1]!=undefined){
                    p0 = newList[x - 1][y - 1];
                }
                if(newList[x][y - 1]!=undefined){
                    p1 = newList[x][y - 1];
                }
                if(newList[x + 1] && newList[x + 1][y - 1]!=undefined){
                    p2 = newList[x + 1][y - 1];
                }
                if(newList[x + 1]){
                    p3 = newList[x + 1][y];
                }
                if(newList[x + 1] && newList[x + 1][y + 1]!=undefined){
                    p4 = newList[x + 1][y + 1];
                }
                if(newList[x][y + 1]!=undefined){
                    p5 = newList[x][y + 1];
                }
                if(newList[x - 1] && newList[x - 1][y + 1]!=undefined){
                    p6 = newList[x - 1][y + 1];
                }
                if (newList[x - 1]) {
                    p7 = newList[x - 1][y];
                }
                
                if ((p1 == 0x000000 && p7 == 0x000000 && p4 != 0x000000) || 
                    (p1 == 0x000000 && p4 != 0x000000 && p5 != 0x000000 && p6 != 0x000000) || 
                    (p0 == 0x000000 && p2 != 0x000000 && p3 != 0x000000 && p4 != 0x000000 && p5 != 0x000000 && p6 != 0x000000) ) {
                    newList[x][y] = 0xffffff;
                }

            }
        }
        
        return newList;
    }
    
    private function crateEdgeBitmapData(edgeList:Array):void {
        trace("Method : cratePathList");
        
        _pathBitmapData = new BitmapData(_bitmapData.width, _bitmapData.height, false);
        _pathBitmapData.lock();
        for (var x:uint = 0; x < edgeList.length; x++ ) {
            for (var y:uint = 0; y < edgeList[x].length; y++ ) {
                _pathBitmapData.setPixel(x, y, edgeList[x][y]);
            }
        }
        _pathBitmapData.unlock();
    }
    
    private function createPath(edgeList:Array):void {
        trace("Method : createPath");
        var count:uint = 0;
        _pathLists = [];
        _pathLists[count] = [];
        
        var currentEdge:Point = getFirstPath(edgeList);
        if (currentEdge) {
            _pathLists[count].push(currentEdge);
        }
        
        while(true){
            var nextPoint:Point = getNext(edgeList, currentEdge);
            if (nextPoint) {
                _pathLists[count].push(nextPoint);
                edgeList[nextPoint.x][nextPoint.y] = 0xffffff;
                currentEdge = nextPoint;
            }else {
                currentEdge = getFirstPath(edgeList);
                if (currentEdge) {
                    count++;
                    _pathLists[count] = [];
                    _pathLists[count].push(currentEdge);
                    //break;
                }else {
                    break;
                }
            }
        }
        
        //パスデータの調整
        _pathLists = adjustmentPath(_pathLists, 0.70);
        
        _basePointLists = _pathLists;
        drawLines(_pathLists);
    }
    
    
    private function adjustmentPath(pathLists:Array, threshold:Number=0):Array {
        trace("Method : adjustmentPath");
        
        var newList:Array = [];
        var preList:Array = [];
        var preAngle:Number, nowAngle:Number;
        
        for (var i:uint = 0; i < pathLists.length; i++ ) {
            if (pathLists[i].length < 3) {
                newList[i] = pathLists[i];
                continue;
            }
            
            newList[i] = [];
            preList = [];
            preList[0] = pathLists[i][0];
            preList[1] = pathLists[i][1];
            preAngle = Math.atan2(preList[0].y - preList[1].y, preList[0].x - preList[1].x);
            newList[i].push(pathLists[i][0]);
            for (var j:uint = 1; j < pathLists[i].length; j++ ) {
                var p:Point;
                if (j == pathLists[i].length - 1) {
                    nowAngle = Math.atan2(pathLists[i][0].y-pathLists[i][j].y, pathLists[i][0].x-pathLists[i][j].x);
                    p = pathLists[i][0];
                }else{
                    nowAngle = Math.atan2(pathLists[i][j].y - pathLists[i][j+1].y, pathLists[i][j].x - pathLists[i][j+1].x);
                    p = pathLists[i][j + 1];
                }
                
                //角度が大きいPathを残す
                if (Math.abs(Math.abs(nowAngle) - Math.abs(preAngle)) > threshold) {
                    newList[i].push(p);
                    preAngle = Math.abs(nowAngle);
                }
                
            }
            
        }
        return newList;
    }
    
    //開始点を取得
    private function getFirstPath(edgeList:Array):Point {
        var firstEdge:Point;
        
        out :for (var x:uint = 0; x < edgeList.length; x++ ) {
            for (var y:uint = 0; y < edgeList[x].length; y++ ) {
                if (edgeList[x][y] == 0x000000) {
                    firstEdge = new Point(x, y);
                    edgeList[x][y] = 0xffffff;
                    break out;
                }
            }
        }
        
        return firstEdge;
    }
    
    //次の点を取得
    private function getNext(edgeList:Array, currentPoint:Point):Point {
        //エッジ抽出の精度が悪いので、それなりの範囲を調査
        var nextPoint:Point;
        var x:uint = currentPoint.x;
        var y:uint = currentPoint.y;
        
        if(edgeList[x - 1][y - 1]==0x000000){
            nextPoint = new Point(x - 1, y - 1);
        }else if (edgeList[x][y - 1]==0x000000) {
            nextPoint = new Point(x, y - 1);
        }else if (edgeList[x + 1][y - 1]==0x000000) {
            nextPoint = new Point(x + 1, y - 1);
        }else if (edgeList[x + 1][y]==0x000000) {
            nextPoint = new Point(x + 1, y);
        }else if (edgeList[x + 1][y + 1] == 0x000000) {
            nextPoint = new Point(x + 1, y + 1);
        }else if (edgeList[x][y + 1]==0x000000) {
            nextPoint = new Point(x, y + 1);
        }else if (edgeList[x - 1][y + 1]==0x000000) {
            nextPoint = new Point(x - 1, y + 1);
        }else if (edgeList[x - 1][y] == 0x000000) {
            nextPoint = new Point(x - 1, y);
        }
        
        if (!nextPoint) {
            if(edgeList[x - 2][y - 2]==0x000000){
                nextPoint = new Point(x - 2, y - 2);
            }else if(edgeList[x - 1][y - 2]==0x000000){
                nextPoint = new Point(x - 1, y - 2);
            }else if(edgeList[x][y - 2]==0x000000){
                nextPoint = new Point(x, y - 2);
            }else if(edgeList[x + 1][y - 2]==0x000000){
                nextPoint = new Point(x + 1, y - 2);
            }else if(edgeList[x + 2][y - 2]==0x000000){
                nextPoint = new Point(x + 2, y - 2);
            }else if(edgeList[x + 2][y - 1]==0x000000){
                nextPoint = new Point(x + 2, y - 1);
            }else if(edgeList[x + 2][y]==0x000000){
                nextPoint = new Point(x + 2, y);
            }else if(edgeList[x + 2][y + 1]==0x000000){
                nextPoint = new Point(x + 2, y + 1);
            }else if(edgeList[x + 2][y + 2]==0x000000){
                nextPoint = new Point(x + 2, y + 2);
            }else if(edgeList[x + 1][y + 2]==0x000000){
                nextPoint = new Point(x + 1, y + 2);
            }else if(edgeList[x][y + 2]==0x000000){
                nextPoint = new Point(x, y + 2);
            }else if(edgeList[x - 1][y + 2]==0x000000){
                nextPoint = new Point(x - 1, y + 2);
            }else if(edgeList[x - 2][y + 2]==0x000000){
                nextPoint = new Point(x - 2, y + 2);
            }else if(edgeList[x - 2][y + 1]==0x000000){
                nextPoint = new Point(x - 2, y + 1);
            }else if(edgeList[x - 2][y]==0x000000){
                nextPoint = new Point(x - 2, y);
            }else if(edgeList[x - 2][y - 1]==0x000000){
                nextPoint = new Point(x - 2, y - 1);
            }
        }
        
        if (!nextPoint) {
            if(edgeList[x - 3][y - 3]==0x000000){
                nextPoint = new Point(x - 3, y - 3);
            }else if(edgeList[x - 2][y - 3]==0x000000){
                nextPoint = new Point(x - 2, y - 3);
            }else if(edgeList[x - 1][y - 3]==0x000000){
                nextPoint = new Point(x - 1, y - 3);
            }else if(edgeList[x][y - 3]==0x000000){
                nextPoint = new Point(x, y - 3);
            }else if(edgeList[x + 1][y - 3]==0x000000){
                nextPoint = new Point(x + 1, y - 3);
            }else if(edgeList[x + 2][y - 3]==0x000000){
                nextPoint = new Point(x + 2, y - 3);
            }else if(edgeList[x + 3][y - 3]==0x000000){
                nextPoint = new Point(x + 3, y - 3);
            }else if(edgeList[x + 3][y - 2]==0x000000){
                nextPoint = new Point(x + 3, y - 2);
            }else if(edgeList[x + 3][y - 1]==0x000000){
                nextPoint = new Point(x + 3, y - 1);
            }else if(edgeList[x + 3][y]==0x000000){
                nextPoint = new Point(x + 3, y);
            }else if(edgeList[x + 3][y + 1]==0x000000){
                nextPoint = new Point(x + 3, y + 1);
            }else if(edgeList[x + 3][y + 2]==0x000000){
                nextPoint = new Point(x + 3, y + 2);
            }else if(edgeList[x + 3][y + 3]==0x000000){
                nextPoint = new Point(x + 3, y + 3);
            }else if(edgeList[x + 2][y - 3]==0x000000){
                nextPoint = new Point(x + 2, y - 3);
            }else if(edgeList[x + 1][y - 3]==0x000000){
                nextPoint = new Point(x + 1, y - 3);
            }else if(edgeList[x][y - 3]==0x000000){
                nextPoint = new Point(x, y - 3);
            }else if(edgeList[x - 1][y - 3]==0x000000){
                nextPoint = new Point(x - 1, y - 3);
            }else if(edgeList[x - 2][y - 3]==0x000000){
                nextPoint = new Point(x - 2, y - 3);
            }else if(edgeList[x - 3][y - 3]==0x000000){
                nextPoint = new Point(x - 3, y - 3);
            }else if(edgeList[x - 3][y + 2]==0x000000){
                nextPoint = new Point(x - 3, y + 2);
            }else if(edgeList[x - 3][y + 1]==0x000000){
                nextPoint = new Point(x - 3, y + 1);
            }else if(edgeList[x - 3][y]==0x000000){
                nextPoint = new Point(x - 3, y);
            }else if(edgeList[x - 3][y - 1]==0x000000){
                nextPoint = new Point(x - 3, y - 1);
            }else if(edgeList[x - 3][y - 2]==0x000000){
                nextPoint = new Point(x - 3, y - 2);
            }
        }
        
        if (!nextPoint) {
            if(edgeList[x - 4][y - 4]==0x000000){
                nextPoint = new Point(x - 4, y - 4);
            }else if(edgeList[x - 3][y - 4]==0x000000){
                nextPoint = new Point(x - 3, y - 4);
            }else if(edgeList[x - 2][y - 4]==0x000000){
                nextPoint = new Point(x - 2, y - 4);
            }else if(edgeList[x - 1][y - 4]==0x000000){
                nextPoint = new Point(x - 1, y - 4);
            }else if(edgeList[x][y - 4]==0x000000){
                nextPoint = new Point(x, y - 4);
            }else if(edgeList[x + 1][y - 4]==0x000000){
                nextPoint = new Point(x + 1, y - 4);
            }else if(edgeList[x + 2][y - 4]==0x000000){
                nextPoint = new Point(x + 2, y - 4);
            }else if(edgeList[x + 3][y - 4]==0x000000){
                nextPoint = new Point(x + 3, y - 4);
            }else if(edgeList[x + 4][y - 4]==0x000000){
                nextPoint = new Point(x + 4, y - 4);
            }
            
            else if(edgeList[x + 4][y - 3]==0x000000){
                nextPoint = new Point(x + 4, y - 3);
            }else if(edgeList[x + 4][y - 2]==0x000000){
                nextPoint = new Point(x + 4, y - 2);
            }else if(edgeList[x + 4][y - 1]==0x000000){
                nextPoint = new Point(x + 4, y - 1);
            }else if(edgeList[x + 4][y]==0x000000){
                nextPoint = new Point(x + 4, y);
            }else if(edgeList[x + 4][y + 1]==0x000000){
                nextPoint = new Point(x + 4, y + 1);
            }else if(edgeList[x + 4][y + 2]==0x000000){
                nextPoint = new Point(x + 4, y + 2);
            }else if(edgeList[x + 4][y + 3]==0x000000){
                nextPoint = new Point(x + 4, y + 3);
            }else if(edgeList[x + 4][y + 4]==0x000000){
                nextPoint = new Point(x + 4, y + 4);
            }
            
            else if(edgeList[x + 3][y + 4]==0x000000){
                nextPoint = new Point(x + 3, y + 4);
            }else if(edgeList[x + 2][y + 4]==0x000000){
                nextPoint = new Point(x + 2, y + 4);
            }else if(edgeList[x + 1][y + 4]==0x000000){
                nextPoint = new Point(x + 1, y + 4);
            }else if(edgeList[x][y + 4]==0x000000){
                nextPoint = new Point(x, y + 4);
            }else if(edgeList[x - 1][y + 4]==0x000000){
                nextPoint = new Point(x - 1, y + 4);
            }else if(edgeList[x - 2][y + 4]==0x000000){
                nextPoint = new Point(x - 2, y + 4);
            }else if(edgeList[x - 3][y + 4]==0x000000){
                nextPoint = new Point(x - 3, y + 4);
            }else if(edgeList[x - 4][y + 4]==0x000000){
                nextPoint = new Point(x - 4, y + 4);
            }
            
            else if(edgeList[x - 4][y + 3]==0x000000){
                nextPoint = new Point(x - 4, y  + 3);
            }else if(edgeList[x - 4][y + 2]==0x000000){
                nextPoint = new Point(x - 4, y  + 2);
            }else if(edgeList[x - 4][y + 1]==0x000000){
                nextPoint = new Point(x - 4, y  + 1);
            }else if(edgeList[x - 4][y]==0x000000){
                nextPoint = new Point(x - 4, y);
            }else if(edgeList[x - 4][y - 1]==0x000000){
                nextPoint = new Point(x - 4, y  - 1);
            }else if(edgeList[x - 4][y - 2]==0x000000){
                nextPoint = new Point(x - 4, y  - 2);
            }else if(edgeList[x - 4][y - 3]==0x000000){
                nextPoint = new Point(x - 4, y  - 3);
            }            }
                
        return nextPoint;
    }
    
    //複数パスの線の描画
    public function drawLines(pathLists:Array):void {
        _pathArea.graphics.clear();
        
        for (var i:uint = 0; i < pathLists.length; i++ ){
            var datas:Array = createGraphicCommands(pathLists[i]);
            drawLine(datas);
        }
    }
    
    //GraphicCommandsを設定
    private function createGraphicCommands(pathList:Array):Array {
        _commandsLists = [];
        
        var commands:Vector.<int> = new Vector.<int>();
        var anchor:Vector.<Number> = new Vector.<Number>();
        
        for (var i:uint = 0; i < pathList.length; i++ ) {
            anchor.push(pathList[i].x, pathList[i].y);
            
            if (i == 0) {
                commands[0] = GraphicsPathCommand.MOVE_TO;
            }else {
                commands[i] = GraphicsPathCommand.LINE_TO;
            }
        }
        anchor.push(pathList[0].x, pathList[0].y);
        commands[i] = GraphicsPathCommand.LINE_TO;
        
        _commandsLists[0] = commands;
        _commandsLists[1] = anchor;
        
        return _commandsLists;
    }

    //線の描画
    private function drawLine(datas:Array):void {
        _pathArea.graphics.beginFill(0x000000, 1);
        _pathArea.graphics.lineStyle(1, 0xffffff, 0.8);
        _pathArea.graphics.drawPath(datas[0], datas[1], GraphicsPathWinding.NON_ZERO);
        _pathArea.graphics.endFill();
        _pathArea.graphics.lineStyle();
        
        var radius:Number = 2;
        for (var i:uint = 0; i < datas[1].length; i += 2) {
            _pathArea.graphics.beginFill(0xdd4422, 1.0);
            _pathArea.graphics.drawCircle( datas[1][i]-radius/2, datas[1][i+1]-radius/2, radius);
            _pathArea.graphics.endFill();
        }
    }
    
    //文字変更
    public function change(str:String):void {
        analyze(str);
    }
    
    public function get textField():TextField { return _textField; }
    
    public function get pathBitmapData():BitmapData { return _pathBitmapData; }
    
    public function get pathArea():Sprite { return _pathArea; }
    
    public function get commandsLists():Array { return _commandsLists; }
    
    public function get basePointLists():Array { return _basePointLists; }
    
}