/**
 * Copyright makc3d ( http://wonderfl.net/user/makc3d )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Rrn
 */

// forked from kousho's Countdown_WIF2010
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.text.TextField;

	public class CountdownClock extends Sprite
	{
                // March 31, 2017 at 2:00 p.m.(JST) is 5:00 a.m. UTC
                // https://savvytime.com/converter/jst-to-utc/mar-31-2017/2pm
		private const END_TIME_UTC:Array = [2017, 3, 31, 5, 0, 0];
		
		private var endTime:Number;
		private var textField:TextField;
		private var date:Date = new Date();
		private var tmpsec:int;
		
		public function CountdownClock() 
		{
			
			init();
			setView();
			startCountdown();
		}
		
		private function init():void
		{
			endTime = new Date(
				END_TIME_UTC[0],
				END_TIME_UTC[1] - 1,
				END_TIME_UTC[2],
				END_TIME_UTC[3],
				END_TIME_UTC[4],
				END_TIME_UTC[5],
				0
			).getTime();
			
			textField = new TextField();
			textField.width = 465;
			textField.y = 210;
                        
			addChild(textField);
		}
		
		private function setView():void
		{
			var nowTime:Number = date.getTime() + date.timezoneOffset * 60 * 1000;
			
			if (nowTime > endTime)
			{
				textField.htmlText = "<font size='40'>END</font>";
			}
			else
			{
				var restTime:Number = endTime - nowTime;
				textField.htmlText = "<font size='28'>" +
                                    str2(int(restTime / 86400000)) + " days " +
                                    str2(int(restTime / 3600000) % 24) + " hours " +
                                    str2(int(restTime / 60000) % 60) + " minutes " +
                                    str2(int(restTime / 1000) % 60) + " seconds</font>";
			}
		}

		private function str2(val:*):String
		{
			var str:String = String(val);
			while(str.length < 2) { str = "0" + str; }
			return str;
		}
		
		private function checkUpdate(e:Event):void 
		{
			date = new Date();
			if (sec != tmpsec)
			{
				tmpsec = sec;
				setView();
			}
		}
		
		private function startCountdown():void
		{
			tmpsec = sec;
			addEventListener(Event.ENTER_FRAME, checkUpdate);
		}
		
		private function get sec():int { return int(date.seconds);}
		
	}

}