/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4RPE
 */

package
{
	import flash.display.Sprite;
	import flash.display.BitmapData;
    import flash.display.Bitmap;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;

	[SWF(width=480,height=480,backgroundColor=0x000000,frameRate=60)]
	public class Practice25 extends Sprite{
		private var bmpdata:BitmapData;
		private var bmp:Bitmap;
        private var colortrans:ColorTransform;
        private var filter:BlurFilter;

		public function Practice25(){
			bmpdata = new BitmapData( stage.stageWidth, stage.stageWidth, false, 0x000000);
			bmp = new Bitmap(bmpdata);
			addChild(bmp);
			colortrans = new ColorTransform( 0.95, 0.99, 0.99 );
			filter = new BlurFilter(2, 2, 1);
			addEventListener(Event.ENTER_FRAME, update);
			stage.addEventListener(MouseEvent.MOUSE_DOWN,mouseDown);
		}
		
		private function update(e:Event):void {
			bmpdata.lock();
			bmpdata.applyFilter( bmpdata, bmpdata.rect, bmpdata.rect.topLeft, filter );
            bmpdata.colorTransform( bmpdata.rect, colortrans );
			bmpdata.draw(this);
			bmpdata.unlock();
			if (Math.random() < 0.01) {
				var x0:Number = Math.random() * 480;
				var y0:Number = 0;
				var x1:Number = Math.random() * 480;
				var y1:Number = 480;
				var p:Particle = new Particle(x0, y0, x1, y1, 1);
				addChild(p);
			}
		}
		
		private function mouseDown(e:MouseEvent):void {
			var p:Particle = new Particle(240, 480, e.stageX, e.stageY, 6);
			addChild(p);
		}
		
	}
}
import flash.display.MovieClip;
import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Point;

class Particle extends MovieClip{
	private var target:Point;
	private var source:Point;
	public var pos:Point;
	private var vec:Point;
	private var speed:Number;
	private var len:Number;
	
	public function Particle(x0:Number, y0:Number, x1:Number, y1:Number, s:Number):void {
		source = new Point(x0, y0);
		target = new Point(x1, y1);
		pos = new Point(x0, y0);
		len = dist(source, target);
		vec = getVec(source, target);
		speed = s;
		addEventListener(Event.ENTER_FRAME, update);
	}
	
	private function dist(a:Point, b:Point):Number {
		var xx:Number = b.x - a.x;
		var yy:Number = b.y - a.y;
		return Math.sqrt(xx * xx + yy * yy);
	}
	
	private function getVec(s:Point, t:Point):Point {
		var xx:Number = t.x - s.x;
		var yy:Number = t.y - s.y;
		xx /= len;
		yy /= len;
		return new Point(xx, yy);
	}
	
	public function expl(xx:Number,yy:Number):void {
		removeEventListener(Event.ENTER_FRAME, update);
		parent.addChild(new Expl(xx, yy));
		parent.removeChild(this);
	}
	
	private function update(e:Event):void {
		pos.x += vec.x * speed;
		pos.y += vec.y * speed;
		if (dist(source, pos) > len) {
			expl(target.x, target.y);
		}
		graphics.clear();
		graphics.lineStyle(1, 0xffff00);
		graphics.moveTo(source.x, source.y);
		graphics.lineTo(pos.x, pos.y);
	}
}
class Expl extends MovieClip {
	private var max_radius:Number = 40;
	private var radius:Number;
	private var gen:Number = 1.0;
	public function Expl(x:Number, y:Number):void {
		this.x = x;
		this.y = y;
		radius = 1;
		addEventListener(Event.ENTER_FRAME, update);
	}
	private function update(e:Event):void {
		graphics.clear();
		graphics.beginFill(0xffff00);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
		radius += 1 * gen;
		if (radius > max_radius && gen > 0) gen = -1;
		if (radius < 0) {
			removeEventListener(Event.ENTER_FRAME, update);
			parent.removeChild(this);
		}
		for (var i:int = 0; i < parent.numChildren; i++) {
			var obj:Object = parent.getChildAt(i);
			if (obj is Particle) {
				var pp:Particle = obj as Particle;
				var len:Number = dist(pp);
				if (len < radius) pp.expl(pp.pos.x,pp.pos.y);
			}
		}
	}
	private function dist(p:Particle):Number {
		var xx:Number = x - p.pos.x;
		var yy:Number = y - p.pos.y;
		return Math.sqrt(xx * xx + yy * yy);
	}
}