/**
 * Copyright TodaTakuya ( http://wonderfl.net/user/TodaTakuya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4R6x
 */

// forked from DanYuya's Shooter Game 応用形
// forked from DanYuya's Shooter Game 基本形
// シューティングゲーム
package {
    // 使用するパッケージをインポートする
    import fl.controls.*;
    import flash.text.*;
    import flash.display.Sprite;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.events.MouseEvent;
        
    public class ShooterGame extends Sprite {
        public var timer:Timer;        // タイマー
        public var enemyTimer:Timer;   // タイマー（敵機）
        public var myCombat:Sprite;    // 自機
        public var myBullet:Array;     // 自機の弾丸（複数）
        public var vy:Array;           // 自機の弾丸の速度（y方向）
        public var enemy:Sprite;       // 敵機
        public var theta:Number = 0.0;       // 敵機の位相
        public var myCombathitFlag:Boolean = false;  // 自機衝突判定
        public var enemyhitFlag:Boolean = false;  // 敵機衝突判定
        public var compBubble:Array;     // 敵機の弾丸（すべて）
        public var bubbleVelocity:Array; // 敵機の弾丸とビームの速度（y方向）
        public var tf:TextFormat;      // ラベル
        public var fld:TextField;      // ラベル
        
        public function ShooterGame() {
            // 配列（Array型）のインスタンス生成
            myBullet = new Array();
            vy = new Array();
            compBubble = new Array();
            bubbleVelocity = new Array();
            
            // Sprite 型の自機グラフィックスの生成
            myCombat = new Sprite();
            myCombat.graphics.beginFill( 0x0000FF, 1.0 );
            myCombat.graphics.drawRect( -2, 0, 4, 10 );
            myCombat.graphics.beginFill( 0x0000FF, 1.0 );
            myCombat.graphics.drawRect( -6, 2, 12, 2 );
            myCombat.graphics.beginFill( 0x0000FF, 1.0 );
            myCombat.graphics.drawRect( -3, 8, 6, 2 );
            myCombat.x = stage.mouseX;
            myCombat.y = stage.stageHeight - 50;
            stage.addChild( myCombat );
            
            // 敵機の生成
            enemy = new Sprite();
            enemy.graphics.beginFill( 0x999999, 1 );
            enemy.graphics.drawCircle( 0, 0, 15 );
            enemy.graphics.beginFill( 0x999999, 1 );
            enemy.graphics.drawCircle( -75, -55, 20 );
            enemy.graphics.beginFill( 0x999999, 1 );
            enemy.graphics.drawCircle( +75, -55, 20 );
            enemy.graphics.beginFill( 0x999999, 1 );
            enemy.graphics.drawCircle( -75, +55, 20 );
            enemy.graphics.beginFill( 0x999999, 1 );
            enemy.graphics.drawCircle( +75, +55, 20 );
            enemy.graphics.lineStyle( 5, 0x999999, 0.7 );
            enemy.graphics.moveTo( -75, -55 );
            enemy.graphics.lineTo( +75, 55 );
            enemy.graphics.moveTo( +75, -55 );
            enemy.graphics.lineTo( -75, 55 );
            enemy.x = stage.stageWidth / 2;
            enemy.y = 125;
            stage.addChild( enemy );
            
            // マウス操作に関するイベントハンドラの登録
            stage.addEventListener( MouseEvent.MOUSE_MOVE, mMove );
            stage.addEventListener( MouseEvent.CLICK, mClick );
            
            // タイマーに関するイベントハンドラの登録とタイマーの開始
            timer = new Timer( 50 );
            timer.addEventListener( TimerEvent.TIMER, loop );
            timer.start();
                        
            // 敵機（左前）の攻撃に関するタイマー
            enemyTimer = new Timer( 500 );
            enemyTimer.addEventListener( TimerEvent.TIMER, leftfront );
            enemyTimer.start();
            
            // 敵機（右前）の攻撃に関するタイマー
            enemyTimer = new Timer( 750 );
            enemyTimer.addEventListener( TimerEvent.TIMER, rightfront );
            enemyTimer.start();
            
            // 敵機（左後ろ）の攻撃に関するタイマー
            enemyTimer = new Timer( 1000 );
            enemyTimer.addEventListener( TimerEvent.TIMER, leftback );
            enemyTimer.start();
            
            // 敵機（右後ろ）の攻撃に関するタイマー
            enemyTimer = new Timer( 1250 );
            enemyTimer.addEventListener( TimerEvent.TIMER, rightback );
            enemyTimer.start();            
        }
        　　
        public function mMove( event:MouseEvent ): void{
            // 自機の位置をマウスの位置（座標）に合わせる
            myCombat.x = stage.mouseX;
            myCombat.y = stage.mouseY;            
        }

        public function mClick( event:MouseEvent ): void{
            // 弾丸のグラフィックスを生成する
            var bullet:Sprite = new Sprite();
            bullet.graphics.beginFill( 0xFF0000, 1.0 );
            bullet.graphics.drawCircle( 0, 0, 5 );
            bullet.graphics.beginFill( 0xFF0000, 0.5 );
            bullet.graphics.drawCircle( 0, 4, 4 );
            bullet.graphics.beginFill( 0xFF0000, 0.25 );
            bullet.graphics.drawCircle( 0, 8, 3 );
            bullet.x = myCombat.x;
            bullet.y = myCombat.y - 10;
            myBullet.push( bullet );    // 弾丸を配列 myBullet に追加する
            vy.push( -10 );   // 弾丸の y 方向の速度
            stage.addChild( myBullet[myBullet.length - 1] );
        }

        public function loop( event:TimerEvent ): void{ // 繰り返し処理
            // 自機の全ての弾丸について
            for( var i:int = 0; i < myBullet.length; i++ ){
                // 位置の計算
                myBullet[i].y += vy[i];
                
                // 衝突の判定
                if( enemy.x - 10 < myBullet[i].x && myBullet[i].x < enemy.x + 10
                 && enemy.y - 10 < myBullet[i].y && myBullet[i].y < enemy.y + 10 ){
                    enemyhitFlag = true;
                }
            }
            // 敵機の移動
            if( !enemyhitFlag ){
                theta += 0.05;
                if( theta > 2 * Math.PI ){
                    theta -= 2 * Math.PI;
                }
                enemy.x = 0.5 * stage.stageWidth * ( 1 + Math.sin( theta ) );
            }
            else{
                // 敵機に自機の弾丸に当たったら（ゲームクリア処理）
                if( enemy.alpha > 0 ){
                    enemy.alpha -= 0.05; // フェードアウト
                }
                else{
                    // 終了処理（ゲームクリア）
                    stage.removeChild( enemy );
                    stage.removeEventListener( MouseEvent.MOUSE_MOVE, mMove );
                    stage.removeEventListener( MouseEvent.CLICK, mClick );
                    timer.stop();
                    enemyTimer.stop();
                    
                    // ゲーム終了ラベルの表示
                     tf = new TextFormat();
                     tf.align = "center";
                     tf.font = "Times New Roman";
                     tf.size = 16;
                     tf.color = 0x000000;
                    
                     fld = new TextField();
                     fld.defaultTextFormat = tf;
                     fld.text = "Mission Accomplished!";
                     fld.x = stage.stageWidth / 2 - 60;
                     fld.y = stage.stageHeight / 2 - 16;
                     fld.width = 150;
                     stage.addChild( fld );
                }
            }
                        
            // 敵機（左前）の弾丸の移動
            for( var j:int; j < compBubble.length; j++ ){
                compBubble[j].y += bubbleVelocity[j];
                            
            // 自機に敵機の弾丸が当たったら（ゲームオーバー処理）         
                if( myCombat.x - 95 < compBubble[j].x && compBubble[j].x < myCombat.x + 95
                 && myCombat.y - 75 < compBubble[j].y && compBubble[j].y < myCombat.y + 75 ){
                    myCombathitFlag = true;
                }
                
                if( myCombathitFlag ){
                    // 終了処理（ゲームオーバー）
                    stage.removeChild( myCombat );
                    stage.removeEventListener( MouseEvent.MOUSE_MOVE, mMove );
                    stage.removeEventListener( MouseEvent.CLICK, mClick );
                    timer.stop();
                    enemyTimer.stop();
                     
                    // ゲーム終了ラベルの表示
                     tf = new TextFormat();
                     tf.align = "center";
                     tf.font = "Times New Roman";
                     tf.size = 16;
                     tf.color = 0x000000;
                    
                     fld = new TextField();
                     fld.defaultTextFormat = tf;
                     fld.text = "Mission Failed...";
                     fld.x = stage.stageWidth / 2 - 100;
                     fld.y = stage.stageHeight / 2 - 16;
                     fld.width = 200;
                     stage.addChild( fld );
                }
            }
            
            // 敵機（右前）の弾丸の移動
            for( var k:int; k < compBubble.length; k++ ){
                compBubble[k].y += bubbleVelocity[k];
                            
            // 自機に敵機の弾丸が当たったら（ゲームオーバー処理）         
                if( myCombat.x - 75 < compBubble[k].x && compBubble[k].x < myCombat.x + 75
                 && myCombat.y - 55 < compBubble[k].y && compBubble[k].y < myCombat.y + 55 ){
                    myCombathitFlag = true;
                }
                
                if( myCombathitFlag ){
                    // 終了処理（ゲームオーバー）
                    stage.removeChild( myCombat );
                    stage.removeEventListener( MouseEvent.MOUSE_MOVE, mMove );
                    stage.removeEventListener( MouseEvent.CLICK, mClick );
                    timer.stop();
                    enemyTimer.stop();
                     
                    // ゲーム終了ラベルの表示
                     tf = new TextFormat();
                     tf.align = "center";
                     tf.font = "Times New Roman";
                     tf.size = 16;
                     tf.color = 0x000000;
                    
                     fld = new TextField();
                     fld.defaultTextFormat = tf;
                     fld.text = "Mission Failed...";
                     fld.x = stage.stageWidth / 2 - 100;
                     fld.y = stage.stageHeight / 2 - 16;
                     fld.width = 200;
                     stage.addChild( fld );
                }
            }
            
            // 敵機（左後ろ）の弾丸の移動
            for( var m:int; m < compBubble.length; m++ ){
                compBubble[m].y += bubbleVelocity[m];
                            
            // 自機に敵機の弾丸が当たったら（ゲームオーバー処理）         
                if( myCombat.x - 75 < compBubble[m].x && compBubble[m].x < myCombat.x + 75
                 && myCombat.y - 55 < compBubble[m].y && compBubble[m].y < myCombat.y + 55 ){
                    myCombathitFlag = true;
                }
                
                if( myCombathitFlag ){
                    // 終了処理（ゲームオーバー）
                    stage.removeChild( myCombat );
                    stage.removeEventListener( MouseEvent.MOUSE_MOVE, mMove );
                    stage.removeEventListener( MouseEvent.CLICK, mClick );
                    timer.stop();
                    enemyTimer.stop();
                     
                    // ゲーム終了ラベルの表示
                     tf = new TextFormat();
                     tf.align = "center";
                     tf.font = "Times New Roman";
                     tf.size = 16;
                     tf.color = 0x000000;
                    
                     fld = new TextField();
                     fld.defaultTextFormat = tf;
                     fld.text = "Mission Failed...";
                     fld.x = stage.stageWidth / 2 - 100;
                     fld.y = stage.stageHeight / 2 - 16;
                     fld.width = 200;
                     stage.addChild( fld );
                }
            }
            
            // 敵機（右後ろ）の弾丸の移動
            for( var n:int; n < compBubble.length; n++ ){
                compBubble[n].y += bubbleVelocity[n];
                            
            // 自機に敵機の弾丸が当たったら（ゲームオーバー処理）         
                if( myCombat.x - 75 < compBubble[n].x && compBubble[n].x < myCombat.x + 75
                 && myCombat.y - 55 < compBubble[n].y && compBubble[n].y < myCombat.y + 55 ){
                    myCombathitFlag = true;
                }
                
                if( myCombathitFlag ){
                    // 終了処理（ゲームオーバー）
                    stage.removeChild( myCombat );
                    stage.removeEventListener( MouseEvent.MOUSE_MOVE, mMove );
                    stage.removeEventListener( MouseEvent.CLICK, mClick );
                    timer.stop();
                    enemyTimer.stop();
                     
                    // ゲーム終了ラベルの表示
                     tf = new TextFormat();
                     tf.align = "center";
                     tf.font = "Times New Roman";
                     tf.size = 16;
                     tf.color = 0x000000;
                    
                     fld = new TextField();
                     fld.defaultTextFormat = tf;
                     fld.text = "Mission Failed...";
                     fld.x = stage.stageWidth / 2 - 100;
                     fld.y = stage.stageHeight / 2 - 16;
                     fld.width = 200;
                     stage.addChild( fld );
                }
            }
        }
                
        public function leftfront( event:TimerEvent ): void{
            // 敵機（左前）から放出される弾丸の処理
            var bubble:Sprite = new Sprite();
            bubble.graphics.beginFill( 0x00FF00, 0.8 );
            bubble.graphics.drawCircle( -75, +55, 10 );            
            bubble.x = enemy.x;
            bubble.y = enemy.y + 10;
            compBubble.push( bubble );   // 敵機から放出される弾丸を配列 compBubble に追加する
            bubbleVelocity.push( +5 );   // 弾丸の y 方向の速度
            stage.addChild( compBubble[compBubble.length - 1] );
        }
        
        public function rightfront( event:TimerEvent ): void{
            // 敵機（右前）から放出される弾丸の処理
            var bubble:Sprite = new Sprite();
            bubble.graphics.beginFill( 0x00FF00, 0.8 ); 
            bubble.graphics.drawCircle( +75, +55, 10 );
            bubble.x = enemy.x;
            bubble.y = enemy.y + 10;
            compBubble.push( bubble );   // 敵機から放出される弾丸を配列 compBubble に追加する
            bubbleVelocity.push( +10 );   // 弾丸の y 方向の速度
            stage.addChild( compBubble[compBubble.length - 1] );
        }
        
        public function leftback( event:TimerEvent ): void{
            // 敵機（左後ろ）から放出される弾丸の処理
            var bubble:Sprite = new Sprite();
            bubble.graphics.beginFill( 0x00FF00, 0.8 );
            bubble.graphics.drawCircle( -75, -55, 10 );
            bubble.x = enemy.x;
            bubble.y = enemy.y + 10;
            compBubble.push( bubble );   // 敵機から放出される弾丸を配列 compBubble に追加する
            bubbleVelocity.push( +15 );   // 弾丸の y 方向の速度
            stage.addChild( compBubble[compBubble.length - 1] );
        }
        
        public function rightback( event:TimerEvent ): void{
            // 敵機（右後ろ）から放出される弾丸の処理
            var bubble:Sprite = new Sprite();
            bubble.graphics.beginFill( 0x00FF00, 0.8 );
            bubble.graphics.drawCircle( +75, -55, 10 );
            bubble.x = enemy.x;
            bubble.y = enemy.y + 10;
            compBubble.push( bubble );   // 敵機から放出される弾丸を配列 compBubble4 に追加する
            bubbleVelocity.push( +20 );   // 弾丸の y 方向の速度
            stage.addChild( compBubble[compBubble.length - 1] );
        }
    }
}