/**
 * Copyright RobotCaleb ( http://wonderfl.net/user/RobotCaleb )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Qst
 */

package
{
    import flash.display.Sprite;
    import flash.geom.Point;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import Box2D.Common.Math.b2Vec2;
    import flash.text.TextField;
    
    public class FlashTest extends Sprite
    {
        private var isMouseDown:Boolean = false;
        private var point1:b2Vec2;
        private var point2:b2Vec2;
	private var t:TextField;
        
        public function FlashTest()
        {
            // write as3 code here..
            point1 = new b2Vec2;
            point2 = new b2Vec2;
            
	    t = new TextField();
	    t.textColor = 0;
	    t.mouseEnabled = false;
	    t.text = "Black is 1-2\nRed is 2-3\nGreen is 3-4\nBlue is 4-1";

            addChild(t);
            
            stage.frameRate = 60;
            stage.addEventListener(MouseEvent.MOUSE_DOWN, MouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, MouseUp);
            stage.addEventListener(Event.MOUSE_LEAVE, MouseLeave);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, MouseMove);
            addEventListener(Event.ENTER_FRAME, Tick);
        }
        
        private function MouseDown(e:MouseEvent = null):void
        {
            point1.x = e.stageX;
            point1.y = e.stageY;
            
            isMouseDown = true;
        }

        private function MouseUp(e:MouseEvent = null):void
        {
            if (isMouseDown)
            {
                point2.x = e.stageX;
                point2.y = e.stageY;
            }
            isMouseDown = false;
        }

        private function MouseLeave(e:Event = null):void
        {
            isMouseDown = false;
        }

        private function MouseMove(e:MouseEvent = null):void
        {
            if (isMouseDown)
            {
                point2.x = e.stageX;
                point2.y = e.stageY;
            }
            else
            {
                point1.x = e.stageX;
                point1.y = e.stageY;
                point2.x = e.stageX;
                point2.y = e.stageY;
            }
        }
        
        private function ttrace(s:String):void
        {
            t.text = "Black is 1-2\nRed is 2-3\nGreen is 3-4\nBlue is 4-1\n";
            t.text += s;
        }
        
        private function Tick(e:Event = null):void
        {
            graphics.clear();
            CalcDrawRect(point1, point2);   
        }
        
        private function DrawRect(p1:Point, p2:Point, p3:Point, p4:Point):void
        {
            graphics.moveTo(p1.x, p1.y);
            graphics.lineStyle(1, 0);
            graphics.lineTo(p2.x, p2.y);
            graphics.lineStyle(1, 0xff0000);
            graphics.lineTo(p3.x, p3.y);
            graphics.lineStyle(1, 0x00ff00);
            graphics.lineTo(p4.x, p4.y);
            graphics.lineStyle(1, 0x0000ff);
            graphics.lineTo(p1.x, p1.y);
        }
        
        private function CalcDrawRect(o1:b2Vec2, o2:b2Vec2):void
        {
            var angle:Number = 0;
            var sinAngle:Number = 0;
            var cosAngle:Number = 0;
            var hyp:Number = 2;
            var adj:Number = 0;
            var opp:Number = 0;
            
            angle = Math.atan2(o2.y - o1.y, o2.x - o1.x);

            sinAngle = Math.sin(angle);
            cosAngle = Math.cos(angle);
            
            opp = hyp * sinAngle;
            adj = hyp * cosAngle;
            
            ttrace(("opp: " + opp.toString() + "\nadj: " + adj.toString()));
            
            var p1:Point = new Point();
            var p2:Point = new Point();
            var p3:Point = new Point();
            var p4:Point = new Point();
            
            p1.x = o1.x + opp;
            p1.y = o1.y - adj;
            p4.x = o1.x - opp;
            p4.y = o1.y + adj;
            
            p2.x = o2.x + opp;
            p2.y = o2.y - adj;
            p3.x = o2.x - opp;
            p3.y = o2.y + adj;
            
            DrawRect(p1, p2, p3, p4);
        }
    }
}







