/**
 * Copyright geko ( http://wonderfl.net/user/geko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Qie
 */

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Matrix;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import com.bit101.components.*;
    
    public class FlashTest extends Sprite {
        private static var PIG_IMAGE:String = "http://assets.wonderfl.net/images/related_images/d/d3/d3b4/d3b433219e53b955f0e99b4cdb8f80cc2f1635f8";
        private var window:LockWindow;
        private var canvas:Sprite;
        private var imgSprite:Sprite = new Sprite();
        private var imgLoader:ImageLoader;
        private var _bmp:BitmapData;
        private var _gray:BitmapData;
        private var _mask:BitmapData;
        
        public function FlashTest() {
            window = new LockWindow(this, 5, 5);
            window.setSize(stage.stageWidth-10, stage.stageHeight-10);
            canvas = new Sprite();
            canvas.x = 35;
            canvas.y = 30;
            window.addChild(canvas);
            _bmp = new BitmapData(window.width-70,window.width-70,false,0);
            canvas.addChild(new Bitmap(_bmp));
            //canvas.addChildAt(imgSprite,0);
            var loadBt:PushButton = new PushButton(window,window.width-134,425,"load Image",loadImage);
            var saveBt:PushButton = new PushButton(window,window.width-250,425,"default Image",defaultImage);
            
            imgLoader = new ImageLoader(this, PIG_IMAGE);
            imgLoader.addEventListener(ImageLoader.LOAD_COMPLETE, drawImage);
            imgSprite.addChild(imgLoader.loader);
        }
        private function drawImage(event:Event):void{
            //canvas.addChild(imgLoader);
            //window.title = "complete";
            //_bmp.fillRect(_bmp.rect,0xffffff);
            //canvas.addChild(imgLoader.content);
            _bmp.draw(imgLoader.loader.content);
        }
        private function loadImage(event:MouseEvent):void{
            imgLoader.getLocalFile();
        }
        private function defaultImage():void{
        		imgLoader.load(PIG_IMAGE);
        }
    }
}


import com.bit101.components.*;
import flash.display.DisplayObjectContainer;
import flash.events.MouseEvent;

//動かないWindow
class LockWindow extends Window{
    public function LockWindow(parent:DisplayObjectContainer=null, xpos:Number=0, ypos:Number=0, title:String="Window"):void{
        super(parent, xpos, ypos, title);
    }
    //dragできないようにする
    protected override function onMouseDown(event:MouseEvent):void{}
}


import flash.display.DisplayObject;
import flash.display.Sprite;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.FileReference;
import flash.net.FileFilter;
import flash.net.URLRequest;
import flash.events.Event;
import flash.events.ProgressEvent;
import flash.events.EventDispatcher;
import caurina.transitions.Tweener;

//ImageLoader
class ImageLoader extends EventDispatcher{
    public static const LOAD_COMPLETE:String = "loadComplete";
    //public var content:DisplayObject;
    public var loader:Loader = new Loader();
    private var fr:FileReference = new FileReference();
    private var progressPanel:Panel;
    private var progress:ProgressBar;
    private var label:Label;
    private var _parent:DisplayObjectContainer;
    
    public function ImageLoader(parent:DisplayObjectContainer,url:String = null){
        _parent = parent;
        init();
        loader.contentLoaderInfo.addEventListener(Event.OPEN, imageLoad);
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, imageLoad);
        loader.contentLoaderInfo.addEventListener(Event.INIT, imageLoad);
        fr.addEventListener(Event.SELECT, imageLoad);
        fr.addEventListener(Event.OPEN, imageLoad);
        fr.addEventListener(Event.COMPLETE, imageLoad);
        if(url) load(url);
    }
    private function init():void{
        if(!progressPanel){
            progressPanel = new Panel(null, 152.5, 202.5);
            label = new Label(progressPanel, 10, 0, "Now Loading...");
            progress = new ProgressBar(progressPanel, 10, 22);
            progressPanel.setSize(160,40);
            progress.setSize(140,10);
            progressPanel.color = 0xdadada;
            progressPanel.shadow = false;
        }
    }
    public function getLocalFile():void{
        fr.browse([new FileFilter("Images", "*.jpg;*.gif;*.png")]); 
    }
    public function load(url:String):void{
        loader.load(new URLRequest(url));
    }
    
    private function imageLoad(event:Event):void{
        switch(event.type){
            case Event.OPEN:
                progressPanel.alpha = 1;
                _parent.addChild(progressPanel);
                if(event.target == loader) loader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, progressHandler);
                else fr.addEventListener(ProgressEvent.PROGRESS, progressHandler);
            break;
            case Event.COMPLETE:
                Tweener.addTween(progressPanel, {alpha:0,transition:"easeInSine",time:1,onComplete:loadComplete});
                label.text = ImageLoader.LOAD_COMPLETE;
                if(event.target == loader) {
                    loader.contentLoaderInfo.removeEventListener(ProgressEvent.PROGRESS, progressHandler);
                    dispatchEvent(new Event("loadComplete"));
                }else{
                    fr.removeEventListener(ProgressEvent.PROGRESS, progressHandler);
                    loader.loadBytes(fr.data);//content = loader;
                }
                
            break;
            case Event.SELECT:
                fr.load();
            break;
            case Event.INIT:
                dispatchEvent(new Event("loadComplete"));
            break;
        }
    }
    private function loadComplete():void{
        _parent.removeChild(progressPanel);
    }
    private function progressHandler(event:ProgressEvent):void{
        progress.value = event.bytesLoaded/event.bytesTotal;
    }
}