/**
 * Copyright WaveF ( http://wonderfl.net/user/WaveF )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4QBk
 */

package {
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.ProgressEvent;
    import flash.utils.*;
    import org.papervision3d.cameras.*;
    import org.papervision3d.events.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.objects.parsers.*;
    import org.papervision3d.render.*;
    import org.papervision3d.scenes.*;
    import org.papervision3d.view.*;
    import com.greensock.TweenMax;
    import com.greensock.easing.Cubic;

    [SWF(width="465", height="465", frameRate="30", backgroundColor="#FFFFFF")]
    
    public class miniCG extends Sprite {
        private var _camera:Camera3D;
        private var _viewPort:Viewport3D;
        private var _dae:DAE;
        private var _scene:Scene3D;
        private var _daeXML:XML;
        private var _rollOver:Boolean;
        private var _materials:MaterialsList;
        private var _render:BasicRenderEngine;
        private var btn:MovieClip;
        private var delay:uint;
        private var wheel_boolean:Boolean;

        public function miniCG() {
            _viewPort = new Viewport3D(465,465);
            _scene = new Scene3D();
            _camera = new Camera3D();
            _render = new BasicRenderEngine();
            addChild(_viewPort);

            _materials = new MaterialsList();

            init_daeXML();

            _dae = new DAE();
            _dae.addEventListener(FileLoadEvent.LOAD_COMPLETE, onloadCompleteHandler);
            _dae.addEventListener(FileLoadEvent.LOAD_ERROR, onloadErrorHandler);
            _dae.load(_daeXML);
            _dae.scale = 2;

            _camera.moveBackward(10);
            _camera.lookAt(_dae);

            btn = new MovieClip();
            btn.graphics.beginFill(0, 0);

            btn.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            btn.graphics.endFill();
            addChild(btn);

            btn.doubleClickEnabled = true;
            btn.addEventListener(MouseEvent.ROLL_OVER, mouse_over);
            btn.addEventListener(MouseEvent.ROLL_OUT, mouse_out);
            btn.addEventListener(MouseEvent.MOUSE_MOVE, mouse_move);
            stage.addEventListener(MouseEvent.MOUSE_WHEEL, mouse_wheel);
        }

        private function onloadErrorHandler(e:FileLoadEvent):void {
            trace("error");
        }

        private function onloadCompleteHandler(e:FileLoadEvent):void {
            _scene.addChild(_dae);
            addEventListener(Event.ENTER_FRAME, enterHand);
        }

        private function enterHand(e:Event):void {
            if (! _rollOver) {
                if (_dae.rotationY < 3598) {
                    _dae.rotationY +=  2;
                } else {
                    _dae.rotationY = 0;
                }
            }
            _render.renderScene(_scene, _camera, _viewPort);
        }

        private function mouse_move(e:MouseEvent):void {
            if (e.delta == 0) {
                TweenMax.to(_dae,1.5,{rotationX: -btn.mouseY * 4,rotationY: -btn.mouseX,ease:Cubic.easeOut});
            }
        }
        private function mouse_wheel(e:MouseEvent):void {
            var maxScale:uint = 6;
            var minScale:uint = 2;

            if (e.delta > 0 && ! wheel_boolean) {
                wheel_boolean = true;
                TweenMax.to(_dae,1,{scale:maxScale,ease:Cubic.easeInOut,overwrite:2});
            } else if (e.delta<0 && wheel_boolean) {
                wheel_boolean = false;
                TweenMax.to(_dae,1,{scale:minScale,ease:Cubic.easeInOut,overwrite:2});
            }
        }

        private function mouse_out(e:MouseEvent):void {
            delay = setTimeout(resetRotation,1000);
        }

        private function mouse_over(e:MouseEvent):void {
            clearTimeout(delay);
            _rollOver = true;
        }
        private function resetRotation():void {
            TweenMax.to(_dae,5,{rotationX:-20,rotationY:180,ease:Cubic.easeOut,overwrite:1});
            _rollOver = false;
        }
        private function init_daeXML():void {
            _daeXML = <COLLADA xmlns="http://www.collada.org/2005/11/COLLADASchema" version="1.4.1">
                <asset>
                    <contributor>
                        <authoring_tool>CINEMA4D 11.008 COLLADA Exporter</authoring_tool>
                    </contributor>
                    <created>2010-03-26T07:47:50Z</created>
                    <modified>2010-03-26T07:47:50Z</modified>
                    <unit name="meter"/>
                    <up_axis>Y_UP</up_axis>
                </asset>
                <library_effects>
                    <effect id="ID2">
                        <profile_COMMON>
                            <technique sid="COMMON">
                                <blinn>
                                    <diffuse>
                                        <color>0.8 0.8 0.8 1</color>
                                    </diffuse>
                                    <specular>
                                        <color>0.2 0.2 0.2 1</color>
                                    </specular>
                                    <shininess>
                                        <float>0.5</float>
                                    </shininess>
                                </blinn>
                            </technique>
                        </profile_COMMON>
                    </effect>
                    <effect id="ID4">
                        <profile_COMMON>
                            <technique sid="COMMON">
                                <blinn>
                                    <emission>
                                        <color>1 1 1 1</color>
                                    </emission>
                                </blinn>
                            </technique>
                        </profile_COMMON>
                    </effect>
                    <effect id="ID6">
                        <profile_COMMON>
                            <technique sid="COMMON">
                                <blinn>
                                    <emission>
                                        <color>0.713726 0.854902 0.0784314 1</color>
                                    </emission>
                                </blinn>
                            </technique>
                        </profile_COMMON>
                    </effect>
                    <effect id="ID8">
                        <profile_COMMON>
                            <technique sid="COMMON">
                                <blinn>
                                    <emission>
                                        <color>0.72043 0.72043 0.72043 1</color>
                                    </emission>
                                </blinn>
                            </technique>
                        </profile_COMMON>
                    </effect>
                </library_effects>
                <library_materials>
                    <material id="ID1" name="Mat">
                        <instance_effect url="#ID2"/>
                    </material>
                    <material id="ID3" name="White">
                        <instance_effect url="#ID4"/>
                    </material>
                    <material id="ID5" name="Green">
                        <instance_effect url="#ID6"/>
                    </material>
                    <material id="ID7" name="Gray">
                        <instance_effect url="#ID8"/>
                    </material>
                </library_materials>
                <library_geometries>
                    <geometry id="ID11">
                        <mesh>
                            <source id="ID12">
                                <float_array id="ID13" count="5460">-167.885 6.345 -0 -167.885 15.505 -0 -184.985 15.505 -0 -184.985 11.085 -0 -177.705 11.085 -0 -177.705 -28.835 -0 -184.985 -28.835 -0 -184.985 -33.255 -0 -160.595 -33.255 -0 -160.595 -28.835 -0 -167.885 -28.835 -0 -167.885 2.205 -0 -164.739 4.8798 -0 -162.301 6.59765 -0 -161.018 7.37112 -0 -159.745 8.045 -0 -157.856 8.86307 -0 -156.147 9.41796 -0 -154.612 9.75998 -0 -153.397 9.92188 -0 -152.045 9.985 -0 -151.061 9.93914 -0 -150.275 9.82682 -0 -149.543 9.64711 -0 -148.973 9.44587 -0 -148.441 9.19783 -0 -147.945 8.90299 -0 -147.486 8.56135 -0 -147.063 8.17291 -0 -146.828 7.91738 -0 -146.605 7.645 -0 -146.263 7.1536 -0 -145.958 6.6154 -0 -145.64 5.90779 -0 -145.334 4.99706 -0 -145.072 3.84391 -0 -144.886 2.4034 -0 -144.815 0.625004 -0 -144.815 -28.835 -0 -152.095 -28.835 -0 -152.095 -33.255 -0 -127.705 -33.255 -0 -127.705 -28.835 -0 -134.995 -28.835 -0 -134.995 2.205 -0 -132.01 4.7529 -0 -129.407 6.59765 -0 -128.124 7.37112 -0 -126.855 8.045 -0 -125.133 8.80337 -0 -123.427 9.37524 -0 -121.891 9.73275 -0 -120.522 9.92188 -0 -119.165 9.985 -0 -118.181 9.93914 -0 -117.395 9.82682 -0 -116.663 9.64711 -0 -116.093 9.44587 -0 -115.561 9.19783 -0 -115.065 8.90299 -0 -114.606 8.56135 -0 -114.183 8.17291 -0 -113.948 7.91738 -0 -113.725 7.645 -0 -113.383 7.1536 -0 -113.077 6.6154 -0 -112.757 5.90779 -0 -112.45 4.99706 -0 -112.185 3.84391 -0 -111.997 2.4034 -0 -111.925 0.625004 -0 -111.925 -28.835 -0 -119.205 -28.835 -0 -119.205 -33.255 -0 -94.815 -33.255 -0 -94.815 -28.835 -0 -102.105 -28.835 -0 -102.105 2.225 -0 -102.203 4.29353 -0 -102.451 5.98466 -0 -102.783 7.34567 -0 -103.226 8.62474 -0 -103.781 9.82166 -0 -104.327 10.7562 -0 -104.951 11.6334 -0 -105.363 12.1322 -0 -105.955 12.765 -0 -106.754 13.4946 -0 -107.61 14.1474 -0 -108.522 14.7234 -0 -109.69 15.3132 -0 -110.939 15.7925 -0 -112.269 16.1611 -0 -113.923 16.4514 -0 -115.171 16.5666 -0 -116.475 16.605 -0 -118.276 16.5223 -0 -120.049 16.2741 -0 -121.796 15.8598 -0 -123.515 15.2794 -0 -124.833 14.7127 -0 -126.135 14.045 -0 -127.964 12.9159 -0 -129.944 11.436 -0 -132.239 9.36675 -0 -133.627 7.92128 -0 -134.995 6.345 -0 -135.635 6.345 -0 -136.014 7.92128 -0 -136.448 9.19323 -0 -136.978 10.3649 -0 -137.508 11.2892 -0 -138.108 12.1395 -0 -138.779 12.9159 -0 -139.393 13.5062 -0 -140.055 14.045 -0 -140.911 14.6235 -0 -141.838 15.1277 -0 -142.836 15.5579 -0 -144.089 15.9663 -0 -145.638 16.3098 -0 -147.312 16.5223 -0 -149.345 16.605 -0 -151.142 16.5223 -0 -152.915 16.2741 -0 -154.662 15.8598 -0 -156.383 15.2794 -0 -157.703 14.7127 -0 -159.005 14.045 -0 -160.843 12.9159 -0 -162.83 11.436 -0 -164.953 9.53823 -0 -166.344 8.10912 -0 -79.705 24.335 -0 -69.885 24.335 -0 -69.885 33.265 -0 -79.705 33.265 -0 -69.885 15.505 -0 -86.985 15.505 -0 -86.985 11.085 -0 -79.705 11.085 -0 -79.705 -28.835 -0 -86.985 -28.835 -0 -86.985 -33.255 -0 -62.595 -33.255 -0 -62.595 -28.835 -0 -69.885 -28.835 -0 -35.785 6.345 -0 -35.785 15.505 -0 -52.885 15.505 -0 -52.885 11.085 -0 -45.595 11.085 -0 -45.595 -28.835 -0 -52.885 -28.835 -0 -52.885 -33.255 -0 -28.495 -33.255 -0 -28.495 -28.835 -0 -35.785 -28.835 -0 -35.785 2.215 -0 -33.2637 4.50205 -0 -31.0474 6.17716 -0 -29.4586 7.18812 -0 -27.865 8.045 -0 -26.1131 8.80337 -0 -24.5154 9.33097 -0 -22.9129 9.70397 -0 -21.4666 9.90708 -0 -19.855 9.985 -0 -18.2625 9.91119 -0 -17.1513 9.75186 -0 -16.2875 9.54445 -0 -15.6301 9.32173 -0 -15.0293 9.05374 -0 -14.4852 8.74053 -0 -14.0906 8.45745 -0 -13.7322 8.14549 -0 -13.5666 7.9787 -0 -13.335 7.715 -0 -13.0517 7.32831 -0 -12.731 6.78334 -0 -12.4474 6.16986 -0 -12.156 5.34316 -0 -11.8832 4.25376 -0 -11.6387 2.65514 -0 -11.5309 1.25761 -0 -11.495 -0.274998 -0 -11.495 -28.835 -0 -18.785 -28.835 -0 -18.785 -33.255 -0 5.605 -33.255 -0 5.605 -28.835 -0 -1.675 -28.835 -0 -1.675 1.095 -0 -1.77561 3.33357 -0 -2.0287 5.16147 -0 -2.43585 6.86742 -0 -2.90745 8.23273 -0 -3.49223 9.50866 -0 -4.1902 10.6953 -0 -4.8583 11.6161 -0 -5.605 12.475 -0 -6.41827 13.2613 -0 -7.29196 13.9644 -0 -8.22589 14.5842 -0 -9.21988 15.1211 -0 -10.4917 15.6558 -0 -11.8494 16.0714 -0 -13.2928 16.368 -0 -14.8214 16.5458 -0 -16.435 16.605 -0 -18.7775 16.5029 -0 -21.0292 16.1964 -0 -22.9787 15.7452 -0 -24.8553 15.1277 -0 -26.0662 14.6235 -0 -27.245 14.045 -0 -28.9478 13.0381 -0 -30.5783 11.8643 -0 -32.3047 10.3649 -0 -33.9411 8.66038 -0 -34.8794 7.53946 -0 21.295 24.335 -0 31.115 24.335 -0 31.115 33.265 -0 21.295 33.265 -0 31.115 15.505 -0 14.015 15.505 -0 14.015 11.085 -0 21.295 11.085 -0 21.295 -28.835 -0 14.015 -28.835 -0 14.015 -33.255 -0 38.405 -33.255 -0 38.405 -28.835 -0 31.115 -28.835 -0 108.125 -29.575 -0 108.125 -24.335 -0 104.665 -26.2613 -0 101.491 -27.6537 -0 98.2262 -28.745 -0 94.8698 -29.5353 -0 91.4222 -30.0245 -0 87.435 -30.215 -0 84.6311 -30.0936 -0 81.9506 -29.7296 -0 79.3933 -29.1229 -0 76.9588 -28.2738 -0 75.0239 -27.3811 -0 73.174 -26.3201 -0 71.0664 -24.8249 -0 69.4033 -23.394 -0 67.825 -21.795 -0 66.0956 -19.7048 -0 64.5866 -17.4808 -0 63.2981 -15.1228 -0 62.2303 -12.6308 -0 61.3832 -10.005 -0 60.674 -6.77226 -0 60.3055 -3.85626 -0 60.155 -0.284996 -0 60.3786 4.56701 -0 60.953 8.57635 -0 61.7459 11.8502 -0 62.8097 14.9052 -0 63.9375 17.3498 -0 65.2646 19.6336 -0 66.003 20.7153 -0 67.065 22.095 -0 68.7875 23.9904 -0 70.3244 25.3857 -0 71.9534 26.6133 -0 73.6745 27.6731 -0 75.4874 28.5649 -0 77.3922 29.2888 -0 79.3885 29.8445 -0 81.905 30.2893 -0 83.6558 30.4511 -0 85.465 30.505 -0 87.9123 30.3951 -0 90.5305 30.0403 -0 93.165 29.445 -0 96.1355 28.4791 -0 98.5072 27.4941 -0 101.065 26.225 -0 101.925 19.365 -0 107.415 19.365 -0 107.415 31.585 -0 94.765 34.085 -0 89.3837 34.7063 -0 84.625 34.915 -0 79.4241 34.6823 -0 75.1921 34.0966 -0 71.8015 33.3108 -0 68.6294 32.2628 -0 65.676 30.9525 -0 63.3818 29.6602 -0 61.2394 28.1857 -0 60.0268 27.2134 -0 58.495 25.815 -0 56.7337 23.9223 -0 55.1578 21.8804 -0 53.7673 19.6892 -0 52.5622 17.3491 -0 51.3608 14.3443 -0 50.4264 11.1253 -0 49.6737 7.09935 -0 49.3585 4.04546 -0 49.225 0.185001 -0 49.4143 -4.24824 -0 49.9821 -8.40897 -0 50.77 -11.7587 -0 51.8357 -14.9086 -0 53.1791 -17.859 -0 54.5108 -20.1654 -0 56.0352 -22.3335 -0 57.3934 -23.9684 -0 58.875 -25.515 -0 60.8715 -27.3018 -0 63.0089 -28.9003 -0 65.2872 -30.3105 -0 68.2071 -31.7542 -0 71.3296 -32.9271 -0 74.6547 -33.8291 -0 78.7899 -34.5393 -0 81.9122 -34.8211 -0 85.175 -34.915 -0 90.7851 -34.6565 -0 95.6106 -33.973 -0 99.7298 -32.9926 -0 103.637 -31.6661 -0 105.716 -30.7797 -0 180.125 -31.605 -0 180.125 -8.875 -0 184.985 -8.875 -0 184.985 -4.455 -0 161.205 -4.455 -0 161.205 -8.875 -0 169.805 -8.875 -0 169.805 -29.005 -0 164.629 -29.9137 -0 162.408 -30.1337 -0 160.195 -30.215 -0 156.766 -30.0551 -0 153.979 -29.6636 -0 151.332 -29.0372 -0 148.825 -28.1762 -0 146.458 -27.0807 -0 144.592 -25.9886 -0 142.481 -24.4632 -0 141.152 -23.3162 -0 139.885 -22.065 -0 138.142 -20.0319 -0 136.621 -17.8493 -0 135.323 -15.5172 -0 134.246 -13.0356 -0 133.393 -10.4046 -0 132.762 -7.6241 -0 132.307 -4.19127 -0 132.155 -0.554996 -0 132.381 4.31521 -0 132.96 8.34428 -0 133.759 11.6383 -0 134.83 14.7165 -0 135.966 17.1833 -0 137.303 19.4918 -0 138.046 20.5867 -0 139.115 21.985 -0 140.85 23.9071 -0 142.395 25.3214 -0 144.03 26.5654 -0 145.754 27.6389 -0 147.567 28.542 -0 149.47 29.2747 -0 151.463 29.837 -0 153.971 30.2869 -0 155.715 30.4505 -0 157.515 30.505 -0 160.028 30.3943 -0 162.73 30.0322 -0 164.259 29.7178 -0 165.965 29.275 -0 168.896 28.2899 -0 171.68 27.0924 -0 174.665 25.535 -0 175.295 18.905 -0 180.735 18.905 -0 180.735 31.585 -0 174.307 33.0413 -0 167.985 34.085 -0 161.753 34.7063 -0 155.625 34.915 -0 150.661 34.6784 -0 146.607 34.0831 -0 143.348 33.2843 -0 140.287 32.219 -0 137.425 30.8872 -0 135.192 29.5736 -0 133.096 28.0747 -0 131.906 27.0865 -0 130.395 25.665 -0 128.654 23.7417 -0 127.095 21.6797 -0 125.72 19.479 -0 124.311 16.655 -0 123.167 13.631 -0 122.286 10.407 -0 121.592 6.39268 -0 121.317 3.35841 -0 121.225 0.185001 -0 121.413 -4.19224 -0 121.975 -8.31076 -0 122.756 -11.635 -0 123.813 -14.7692 -0 125.145 -17.7132 -0 126.753 -20.4672 -0 128.303 -22.617 -0 129.325 -23.8436 -0 130.795 -25.405 -0 133.187 -27.5505 -0 135.769 -29.422 -0 138.541 -31.0197 -0 141.503 -32.3435 -0 144.655 -33.3934 -0 147.997 -34.1694 -0 152.137 -34.7286 -0 156.535 -34.915 -0 162.689 -34.6158 -0 170.62 -33.5563 -0 197.187 30.5297 -0 197.187 14.0297 -0 197.216 13.3987 -0 197.3 12.7888 -0 197.438 12.2025 -0 197.627 11.642 -0 197.864 11.1097 -0 198.148 10.6081 -0 198.476 10.1394 -0 198.845 9.70593 -0 199.254 9.31017 -0 199.699 8.95443 -0 200.179 8.64107 -0 200.691 8.37244 -0 201.233 8.15092 -0 201.802 7.97885 -0 202.397 7.85859 -0 202.806 7.80837 -0 203.437 7.77971 -0 208.977 7.77971 -0 209.09 7.31277 -0 209.16 6.83353 -0 209.18 6.55856 -0 209.187 6.27971 -0 209.154 5.67376 -0 209.057 5.08703 -0 208.9 4.52298 -0 208.686 3.98509 -0 208.419 3.47683 -0 208.102 3.00167 -0 207.739 2.56308 -0 207.333 2.16454 -0 206.887 1.80951 -0 206.406 1.50147 -0 205.891 1.24388 -0 205.487 1.0859 -0 205.067 0.959709 -0 205.668 0.848902 -0 206.156 0.798141 -0 206.687 0.779709 -0 207.393 0.812591 -0 208.081 0.909274 -0 208.748 1.06682 -0 209.391 1.28228 -0 210.006 1.55272 -0 210.591 1.87519 -0 211.143 2.24676 -0 211.659 2.66447 -0 212.135 3.1254 -0 212.569 3.62659 -0 212.958 4.1651 -0 213.299 4.738 -0 213.589 5.34234 -0 213.825 5.97518 -0 214.004 6.63358 -0 214.09 7.08526 -0 214.167 7.77971 -0 239.937 7.77971 -0 240.568 7.80837 -0 241.178 7.89277 -0 241.764 8.03056 -0 242.325 8.21938 -0 242.857 8.45687 -0 243.359 8.74067 -0 243.827 9.06842 -0 244.261 9.43776 -0 244.656 9.84633 -0 245.012 10.2918 -0 245.326 10.7718 -0 245.594 11.2839 -0 245.816 11.8258 -0 245.988 12.3952 -0 246.108 12.9896 -0 246.158 13.3987 -0 246.187 14.0297 -0 246.187 30.5297 -0 246.158 31.1607 -0 246.074 31.7706 -0 245.936 32.3569 -0 245.747 32.9174 -0 245.51 33.4497 -0 245.226 33.9513 -0 244.898 34.4201 -0 244.529 34.8535 -0 244.12 35.2492 -0 243.675 35.605 -0 243.195 35.9184 -0 242.683 36.187 -0 242.141 36.4085 -0 241.571 36.5806 -0 240.977 36.7008 -0 240.568 36.751 -0 239.937 36.7797 -0 203.437 36.7797 -0 202.806 36.751 -0 202.196 36.6666 -0 201.61 36.5289 -0 201.049 36.34 -0 200.517 36.1026 -0 200.015 35.8187 -0 199.547 35.491 -0 199.113 35.1217 -0 198.717 34.7131 -0 198.362 34.2676 -0 198.048 33.7877 -0 197.78 33.2755 -0 197.558 32.7336 -0 197.386 32.1642 -0 197.266 31.5698 -0 197.216 31.1607 -0 203.225 17.7842 -0 205.565 17.7842 -0 205.565 20.1242 -0 203.225 20.1242 -0 214.605 17.9742 -0 214.605 19.3742 -0 214.15 19.2033 -0 213.684 19.0736 -0 213.206 18.9859 -0 212.851 18.9488 -0 212.445 18.9342 -0 212.112 18.9489 -0 211.847 18.9849 -0 211.6 19.0425 -0 211.408 19.107 -0 211.228 19.1865 -0 211.06 19.281 -0 210.904 19.3905 -0 210.761 19.515 -0 210.68 19.5969 -0 210.605 19.6842 -0 210.488 19.8414 -0 210.384 20.0132 -0 210.275 20.2386 -0 210.184 20.4853 -0 210.101 20.8003 -0 210.035 21.1966 -0 210.006 21.5195 -0 209.995 21.9242 -0 210.017 22.4485 -0 210.076 22.8831 -0 210.159 23.2394 -0 210.255 23.5278 -0 210.372 23.7942 -0 210.449 23.9365 -0 210.555 24.1042 -0 210.697 24.2902 -0 210.823 24.4267 -0 210.956 24.5465 -0 211.098 24.6498 -0 211.246 24.7365 -0 211.402 24.8067 -0 211.566 24.8605 -0 211.737 24.8979 -0 211.879 24.9161 -0 212.065 24.9242 -0 212.298 24.9138 -0 212.514 24.885 -0 212.619 24.8637 -0 212.734 24.8342 -0 212.943 24.7674 -0 213.145 24.6822 -0 213.256 24.6261 -0 213.365 24.5642 -0 213.454 23.5742 -0 214.645 23.5742 -0 214.645 25.6442 -0 213.971 25.8017 -0 213.305 25.9142 -0 212.63 25.9817 -0 211.954 26.0042 -0 211.338 25.9759 -0 210.836 25.9046 -0 210.431 25.8092 -0 210.052 25.6821 -0 209.697 25.5236 -0 209.367 25.3337 -0 209.11 25.1515 -0 208.824 24.9042 -0 208.608 24.6771 -0 208.414 24.4338 -0 208.243 24.1743 -0 208.095 23.8986 -0 207.947 23.5464 -0 207.832 23.1709 -0 207.75 22.772 -0 207.701 22.3498 -0 207.685 21.9042 -0 207.708 21.3699 -0 207.778 20.8671 -0 207.876 20.4612 -0 208.008 20.0782 -0 208.173 19.7182 -0 208.373 19.3809 -0 208.607 19.0663 -0 208.875 18.7742 -0 209.171 18.5103 -0 209.49 18.28 -0 209.833 18.0835 -0 210.2 17.9206 -0 210.59 17.7914 -0 211.005 17.696 -0 211.518 17.6272 -0 212.065 17.6042 -0 212.893 17.6414 -0 213.657 17.745 -0 214.109 17.8397 -0 220.865 17.6042 -0 221.463 17.6327 -0 221.953 17.7044 -0 222.347 17.8008 -0 222.718 17.9295 -0 223.066 18.0906 -0 223.338 18.2498 -0 223.594 18.4315 -0 223.739 18.5515 -0 223.924 18.7242 -0 224.175 19.0063 -0 224.36 19.2598 -0 224.554 19.5859 -0 224.715 19.936 -0 224.845 20.3099 -0 224.942 20.7074 -0 225.015 21.201 -0 225.037 21.4974 -0 225.044 21.8042 -0 225.015 22.4075 -0 224.942 22.9011 -0 224.845 23.2986 -0 224.715 23.6725 -0 224.554 24.0225 -0 224.36 24.3487 -0 224.175 24.6022 -0 223.924 24.8842 -0 223.691 25.0978 -0 223.442 25.2887 -0 223.177 25.4569 -0 222.837 25.6289 -0 222.473 25.7684 -0 222.087 25.8755 -0 221.606 25.9597 -0 221.243 25.9931 -0 220.865 26.0042 -0 220.262 25.9758 -0 219.77 25.9041 -0 219.375 25.8077 -0 219.003 25.679 -0 218.656 25.5178 -0 218.386 25.3587 -0 218.132 25.1769 -0 217.987 25.0569 -0 217.805 24.8842 -0 217.591 24.6508 -0 217.4 24.4007 -0 217.232 24.1339 -0 217.06 23.7918 -0 216.92 23.4259 -0 216.813 23.0362 -0 216.729 22.5517 -0 216.696 22.1861 -0 216.685 21.8042 -0 216.713 21.201 -0 216.785 20.7074 -0 216.881 20.3099 -0 217.01 19.936 -0 217.171 19.5859 -0 217.33 19.3125 -0 217.512 19.0557 -0 217.632 18.9096 -0 217.805 18.7242 -0 218.035 18.5106 -0 218.282 18.3197 -0 218.546 18.1516 -0 218.827 18.006 -0 219.186 17.8611 -0 219.569 17.7486 -0 219.977 17.6683 -0 220.409 17.6202 -0 220.865 18.6842 -0 220.7 18.6929 -0 220.573 18.7124 -0 220.45 18.7429 -0 220.331 18.7844 -0 220.216 18.837 -0 220.106 18.9005 -0 219.973 18.9953 -0 219.847 19.1071 -0 219.727 19.2359 -0 219.613 19.3816 -0 219.505 19.5442 -0 219.372 19.7979 -0 219.259 20.0716 -0 219.154 20.4094 -0 219.068 20.8215 -0 219.015 21.2677 -0 218.995 21.8042 -0 219.019 22.392 -0 219.084 22.8815 -0 219.178 23.286 -0 219.289 23.6171 -0 219.389 23.8481 -0 219.505 24.0642 -0 219.635 24.2573 -0 219.774 24.4261 -0 219.897 24.5481 -0 220.025 24.6532 -0 220.133 24.7249 -0 220.245 24.7857 -0 220.36 24.8355 -0 220.48 24.8743 -0 220.604 24.902 -0 220.732 24.9187 -0 220.865 24.9242 -0 221.027 24.9155 -0 221.152 24.8961 -0 221.273 24.8656 -0 221.391 24.8241 -0 221.505 24.7715 -0 221.615 24.708 -0 221.747 24.6132 -0 221.872 24.5014 -0 221.992 24.3726 -0 222.107 24.2268 -0 222.215 24.0642 -0 222.348 23.8106 -0 222.477 23.4961 -0 222.58 23.1549 -0 222.665 22.7391 -0 222.717 22.289 -0 222.734 21.8042 -0 222.709 21.2165 -0 222.641 20.7269 -0 222.544 20.3225 -0 222.431 19.9913 -0 222.33 19.7604 -0 222.215 19.5442 -0 222.084 19.3511 -0 221.945 19.1824 -0 221.823 19.0603 -0 221.694 18.9553 -0 221.56 18.8673 -0 221.448 18.8093 -0 221.333 18.7623 -0 221.213 18.7262 -0 221.09 18.7013 -0 220.995 18.6898 -0 229.665 24.2942 -0 229.665 25.8242 -0 226.505 25.8242 -0 226.505 24.7442 -0 227.585 24.7442 -0 227.585 18.8642 -0 226.505 18.8642 -0 226.505 17.7842 -0 230.574 17.7842 -0 230.574 18.8642 -0 229.665 18.8642 -0 229.665 23.2542 -0 230.025 23.6522 -0 230.317 23.9207 -0 230.472 24.0428 -0 230.645 24.1642 -0 230.816 24.2617 -0 230.986 24.3384 -0 231.136 24.3898 -0 231.283 24.4259 -0 231.43 24.4472 -0 231.574 24.4542 -0 231.701 24.4483 -0 231.802 24.4338 -0 231.896 24.4104 -0 231.97 24.384 -0 232.039 24.3514 -0 232.104 24.3124 -0 232.151 24.2766 -0 232.196 24.2366 -0 232.237 24.1925 -0 232.275 24.1442 -0 232.325 24.0643 -0 232.37 23.9756 -0 232.415 23.861 -0 232.45 23.7341 -0 232.48 23.574 -0 232.498 23.3974 -0 232.505 23.2042 -0 232.505 18.8642 -0 231.605 18.8642 -0 231.605 17.7842 -0 235.484 17.7842 -0 235.484 18.8642 -0 234.595 18.8642 -0 234.595 23.2542 -0 234.909 23.6123 -0 235.18 23.8713 -0 235.372 24.0283 -0 235.565 24.1642 -0 235.736 24.2617 -0 235.906 24.3384 -0 236.056 24.3898 -0 236.203 24.4259 -0 236.35 24.4472 -0 236.495 24.4542 -0 236.62 24.4483 -0 236.72 24.4338 -0 236.799 24.4149 -0 236.872 24.3898 -0 236.942 24.3584 -0 237.007 24.3207 -0 237.067 24.2766 -0 237.123 24.226 -0 237.155 24.1925 -0 237.195 24.1442 -0 237.245 24.0643 -0 237.29 23.9756 -0 237.335 23.861 -0 237.37 23.7341 -0 237.4 23.574 -0 237.418 23.3974 -0 237.424 23.2042 -0 237.424 18.8642 -0 236.525 18.8642 -0 236.525 17.7842 -0 240.595 17.7842 -0 240.595 18.8642 -0 239.514 18.8642 -0 239.514 23.6942 -0 239.497 24.0916 -0 239.452 24.4137 -0 239.391 24.6717 -0 239.322 24.875 -0 239.238 25.0619 -0 239.157 25.2052 -0 239.084 25.3115 -0 238.984 25.4342 -0 238.874 25.5425 -0 238.753 25.6394 -0 238.621 25.7249 -0 238.478 25.799 -0 238.325 25.8617 -0 238.126 25.9219 -0 237.912 25.9657 -0 237.682 25.9931 -0 237.395 26.0042 -0 237.112 25.9906 -0 236.867 25.9553 -0 236.628 25.898 -0 236.395 25.8184 -0 236.166 25.7163 -0 235.915 25.5742 -0 235.669 25.4085 -0 235.404 25.1906 -0 235.121 24.9104 -0 234.873 24.6194 -0 234.635 24.2942 -0 234.505 24.2942 -0 234.434 24.5884 -0 234.353 24.8267 -0 234.268 25.0172 -0 234.183 25.1669 -0 234.088 25.304 -0 233.983 25.4284 -0 233.906 25.5042 -0 233.824 25.5742 -0 233.719 25.6567 -0 233.581 25.744 -0 233.433 25.8184 -0 233.274 25.8802 -0 233.074 25.9364 -0 232.86 25.9757 -0 232.665 25.996 -0 232.424 26.0042 -0 232.177 25.9934 -0 231.932 25.9609 -0 231.693 25.9064 -0 231.459 25.8296 -0 231.23 25.7303 -0 231.091 25.6567 -0 230.954 25.5742 -0 230.709 25.4085 -0 230.443 25.1906 -0 230.159 24.9104 -0 229.908 24.6194 -0 -167.885 6.345 -6 -167.885 15.505 -6 -184.985 15.505 -6 -184.985 11.085 -6 -177.705 11.085 -6 -177.705 -28.835 -6 -184.985 -28.835 -6 -184.985 -33.255 -6 -160.595 -33.255 -6 -160.595 -28.835 -6 -167.885 -28.835 -6 -167.885 2.205 -6 -164.739 4.8798 -6 -162.301 6.59765 -6 -161.018 7.37112 -6 -159.745 8.045 -6 -157.856 8.86307 -6 -156.147 9.41796 -6 -154.612 9.75998 -6 -153.397 9.92188 -6 -152.045 9.985 -6 -151.061 9.93914 -6 -150.275 9.82682 -6 -149.543 9.64711 -6 -148.973 9.44587 -6 -148.441 9.19783 -6 -147.945 8.90299 -6 -147.486 8.56135 -6 -147.063 8.17291 -6 -146.828 7.91738 -6 -146.605 7.645 -6 -146.263 7.1536 -6 -145.958 6.6154 -6 -145.64 5.90779 -6 -145.334 4.99706 -6 -145.072 3.84391 -6 -144.886 2.4034 -6 -144.815 0.625004 -6 -144.815 -28.835 -6 -152.095 -28.835 -6 -152.095 -33.255 -6 -127.705 -33.255 -6 -127.705 -28.835 -6 -134.995 -28.835 -6 -134.995 2.205 -6 -132.01 4.7529 -6 -129.407 6.59765 -6 -128.124 7.37112 -6 -126.855 8.045 -6 -125.133 8.80337 -6 -123.427 9.37524 -6 -121.891 9.73275 -6 -120.522 9.92188 -6 -119.165 9.985 -6 -118.181 9.93914 -6 -117.395 9.82682 -6 -116.663 9.64711 -6 -116.093 9.44587 -6 -115.561 9.19783 -6 -115.065 8.90299 -6 -114.606 8.56135 -6 -114.183 8.17291 -6 -113.948 7.91738 -6 -113.725 7.645 -6 -113.383 7.1536 -6 -113.077 6.6154 -6 -112.757 5.90779 -6 -112.45 4.99706 -6 -112.185 3.84391 -6 -111.997 2.4034 -6 -111.925 0.625004 -6 -111.925 -28.835 -6 -119.205 -28.835 -6 -119.205 -33.255 -6 -94.815 -33.255 -6 -94.815 -28.835 -6 -102.105 -28.835 -6 -102.105 2.225 -6 -102.203 4.29353 -6 -102.451 5.98466 -6 -102.783 7.34567 -6 -103.226 8.62474 -6 -103.781 9.82166 -6 -104.327 10.7562 -6 -104.951 11.6334 -6 -105.363 12.1322 -6 -105.955 12.765 -6 -106.754 13.4946 -6 -107.61 14.1474 -6 -108.522 14.7234 -6 -109.69 15.3132 -6 -110.939 15.7925 -6 -112.269 16.1611 -6 -113.923 16.4514 -6 -115.171 16.5666 -6 -116.475 16.605 -6 -118.276 16.5223 -6 -120.049 16.2741 -6 -121.796 15.8598 -6 -123.515 15.2794 -6 -124.833 14.7127 -6 -126.135 14.045 -6 -127.964 12.9159 -6 -129.944 11.436 -6 -132.239 9.36675 -6 -133.627 7.92128 -6 -134.995 6.345 -6 -135.635 6.345 -6 -136.014 7.92128 -6 -136.448 9.19323 -6 -136.978 10.3649 -6 -137.508 11.2892 -6 -138.108 12.1395 -6 -138.779 12.9159 -6 -139.393 13.5062 -6 -140.055 14.045 -6 -140.911 14.6235 -6 -141.838 15.1277 -6 -142.836 15.5579 -6 -144.089 15.9663 -6 -145.638 16.3098 -6 -147.312 16.5223 -6 -149.345 16.605 -6 -151.142 16.5223 -6 -152.915 16.2741 -6 -154.662 15.8598 -6 -156.383 15.2794 -6 -157.703 14.7127 -6 -159.005 14.045 -6 -160.843 12.9159 -6 -162.83 11.436 -6 -164.953 9.53823 -6 -166.344 8.10912 -6 -79.705 24.335 -6 -69.885 24.335 -6 -69.885 33.265 -6 -79.705 33.265 -6 -69.885 15.505 -6 -86.985 15.505 -6 -86.985 11.085 -6 -79.705 11.085 -6 -79.705 -28.835 -6 -86.985 -28.835 -6 -86.985 -33.255 -6 -62.595 -33.255 -6 -62.595 -28.835 -6 -69.885 -28.835 -6 -35.785 6.345 -6 -35.785 15.505 -6 -52.885 15.505 -6 -52.885 11.085 -6 -45.595 11.085 -6 -45.595 -28.835 -6 -52.885 -28.835 -6 -52.885 -33.255 -6 -28.495 -33.255 -6 -28.495 -28.835 -6 -35.785 -28.835 -6 -35.785 2.215 -6 -33.2637 4.50205 -6 -31.0474 6.17716 -6 -29.4586 7.18812 -6 -27.865 8.045 -6 -26.1131 8.80337 -6 -24.5154 9.33097 -6 -22.9129 9.70397 -6 -21.4666 9.90708 -6 -19.855 9.985 -6 -18.2625 9.91119 -6 -17.1513 9.75186 -6 -16.2875 9.54445 -6 -15.6301 9.32173 -6 -15.0293 9.05374 -6 -14.4852 8.74053 -6 -14.0906 8.45745 -6 -13.7322 8.14549 -6 -13.5666 7.9787 -6 -13.335 7.715 -6 -13.0517 7.32831 -6 -12.731 6.78334 -6 -12.4474 6.16986 -6 -12.156 5.34316 -6 -11.8832 4.25376 -6 -11.6387 2.65514 -6 -11.5309 1.25761 -6 -11.495 -0.274998 -6 -11.495 -28.835 -6 -18.785 -28.835 -6 -18.785 -33.255 -6 5.605 -33.255 -6 5.605 -28.835 -6 -1.675 -28.835 -6 -1.675 1.095 -6 -1.77561 3.33357 -6 -2.0287 5.16147 -6 -2.43585 6.86742 -6 -2.90745 8.23273 -6 -3.49223 9.50866 -6 -4.1902 10.6953 -6 -4.8583 11.6161 -6 -5.605 12.475 -6 -6.41827 13.2613 -6 -7.29196 13.9644 -6 -8.22589 14.5842 -6 -9.21988 15.1211 -6 -10.4917 15.6558 -6 -11.8494 16.0714 -6 -13.2928 16.368 -6 -14.8214 16.5458 -6 -16.435 16.605 -6 -18.7775 16.5029 -6 -21.0292 16.1964 -6 -22.9787 15.7452 -6 -24.8553 15.1277 -6 -26.0662 14.6235 -6 -27.245 14.045 -6 -28.9478 13.0381 -6 -30.5783 11.8643 -6 -32.3047 10.3649 -6 -33.9411 8.66038 -6 -34.8794 7.53946 -6 21.295 24.335 -6 31.115 24.335 -6 31.115 33.265 -6 21.295 33.265 -6 31.115 15.505 -6 14.015 15.505 -6 14.015 11.085 -6 21.295 11.085 -6 21.295 -28.835 -6 14.015 -28.835 -6 14.015 -33.255 -6 38.405 -33.255 -6 38.405 -28.835 -6 31.115 -28.835 -6 108.125 -29.575 -6 108.125 -24.335 -6 104.665 -26.2613 -6 101.491 -27.6537 -6 98.2262 -28.745 -6 94.8698 -29.5353 -6 91.4222 -30.0245 -6 87.435 -30.215 -6 84.6311 -30.0936 -6 81.9506 -29.7296 -6 79.3933 -29.1229 -6 76.9588 -28.2738 -6 75.0239 -27.3811 -6 73.174 -26.3201 -6 71.0664 -24.8249 -6 69.4033 -23.394 -6 67.825 -21.795 -6 66.0956 -19.7048 -6 64.5866 -17.4808 -6 63.2981 -15.1228 -6 62.2303 -12.6308 -6 61.3832 -10.005 -6 60.674 -6.77226 -6 60.3055 -3.85626 -6 60.155 -0.284996 -6 60.3786 4.56701 -6 60.953 8.57635 -6 61.7459 11.8502 -6 62.8097 14.9052 -6 63.9375 17.3498 -6 65.2646 19.6336 -6 66.003 20.7153 -6 67.065 22.095 -6 68.7875 23.9904 -6 70.3244 25.3857 -6 71.9534 26.6133 -6 73.6745 27.6731 -6 75.4874 28.5649 -6 77.3922 29.2888 -6 79.3885 29.8445 -6 81.905 30.2893 -6 83.6558 30.4511 -6 85.465 30.505 -6 87.9123 30.3951 -6 90.5305 30.0403 -6 93.165 29.445 -6 96.1355 28.4791 -6 98.5072 27.4941 -6 101.065 26.225 -6 101.925 19.365 -6 107.415 19.365 -6 107.415 31.585 -6 94.765 34.085 -6 89.3837 34.7063 -6 84.625 34.915 -6 79.4241 34.6823 -6 75.1921 34.0966 -6 71.8015 33.3108 -6 68.6294 32.2628 -6 65.676 30.9525 -6 63.3818 29.6602 -6 61.2394 28.1857 -6 60.0268 27.2134 -6 58.495 25.815 -6 56.7337 23.9223 -6 55.1578 21.8804 -6 53.7673 19.6892 -6 52.5622 17.3491 -6 51.3608 14.3443 -6 50.4264 11.1253 -6 49.6737 7.09935 -6 49.3585 4.04546 -6 49.225 0.185001 -6 49.4143 -4.24824 -6 49.9821 -8.40897 -6 50.77 -11.7587 -6 51.8357 -14.9086 -6 53.1791 -17.859 -6 54.5108 -20.1654 -6 56.0352 -22.3335 -6 57.3934 -23.9684 -6 58.875 -25.515 -6 60.8715 -27.3018 -6 63.0089 -28.9003 -6 65.2872 -30.3105 -6 68.2071 -31.7542 -6 71.3296 -32.9271 -6 74.6547 -33.8291 -6 78.7899 -34.5393 -6 81.9122 -34.8211 -6 85.175 -34.915 -6 90.7851 -34.6565 -6 95.6106 -33.973 -6 99.7298 -32.9926 -6 103.637 -31.6661 -6 105.716 -30.7797 -6 180.125 -31.605 -6 180.125 -8.875 -6 184.985 -8.875 -6 184.985 -4.455 -6 161.205 -4.455 -6 161.205 -8.875 -6 169.805 -8.875 -6 169.805 -29.005 -6 164.629 -29.9137 -6 162.408 -30.1337 -6 160.195 -30.215 -6 156.766 -30.0551 -6 153.979 -29.6636 -6 151.332 -29.0372 -6 148.825 -28.1762 -6 146.458 -27.0807 -6 144.592 -25.9886 -6 142.481 -24.4632 -6 141.152 -23.3162 -6 139.885 -22.065 -6 138.142 -20.0319 -6 136.621 -17.8493 -6 135.323 -15.5172 -6 134.246 -13.0356 -6 133.393 -10.4046 -6 132.762 -7.6241 -6 132.307 -4.19127 -6 132.155 -0.554996 -6 132.381 4.31521 -6 132.96 8.34428 -6 133.759 11.6383 -6 134.83 14.7165 -6 135.966 17.1833 -6 137.303 19.4918 -6 138.046 20.5867 -6 139.115 21.985 -6 140.85 23.9071 -6 142.395 25.3214 -6 144.03 26.5654 -6 145.754 27.6389 -6 147.567 28.542 -6 149.47 29.2747 -6 151.463 29.837 -6 153.971 30.2869 -6 155.715 30.4505 -6 157.515 30.505 -6 160.028 30.3943 -6 162.73 30.0322 -6 164.259 29.7178 -6 165.965 29.275 -6 168.896 28.2899 -6 171.68 27.0924 -6 174.665 25.535 -6 175.295 18.905 -6 180.735 18.905 -6 180.735 31.585 -6 174.307 33.0413 -6 167.985 34.085 -6 161.753 34.7063 -6 155.625 34.915 -6 150.661 34.6784 -6 146.607 34.0831 -6 143.348 33.2843 -6 140.287 32.219 -6 137.425 30.8872 -6 135.192 29.5736 -6 133.096 28.0747 -6 131.906 27.0865 -6 130.395 25.665 -6 128.654 23.7417 -6 127.095 21.6797 -6 125.72 19.479 -6 124.311 16.655 -6 123.167 13.631 -6 122.286 10.407 -6 121.592 6.39268 -6 121.317 3.35841 -6 121.225 0.185001 -6 121.413 -4.19224 -6 121.975 -8.31076 -6 122.756 -11.635 -6 123.813 -14.7692 -6 125.145 -17.7132 -6 126.753 -20.4672 -6 128.303 -22.617 -6 129.325 -23.8436 -6 130.795 -25.405 -6 133.187 -27.5505 -6 135.769 -29.422 -6 138.541 -31.0197 -6 141.503 -32.3435 -6 144.655 -33.3934 -6 147.997 -34.1694 -6 152.137 -34.7286 -6 156.535 -34.915 -6 162.689 -34.6158 -6 170.62 -33.5563 -6 197.187 30.5297 -6 197.187 14.0297 -6 197.216 13.3987 -6 197.3 12.7888 -6 197.438 12.2025 -6 197.627 11.642 -6 197.864 11.1097 -6 198.148 10.6081 -6 198.476 10.1394 -6 198.845 9.70593 -6 199.254 9.31017 -6 199.699 8.95443 -6 200.179 8.64107 -6 200.691 8.37244 -6 201.233 8.15092 -6 201.802 7.97885 -6 202.397 7.85859 -6 202.806 7.80837 -6 203.437 7.77971 -6 208.977 7.77971 -6 209.09 7.31277 -6 209.16 6.83353 -6 209.18 6.55856 -6 209.187 6.27971 -6 209.154 5.67376 -6 209.057 5.08703 -6 208.9 4.52298 -6 208.686 3.98509 -6 208.419 3.47683 -6 208.102 3.00167 -6 207.739 2.56308 -6 207.333 2.16454 -6 206.887 1.80951 -6 206.406 1.50147 -6 205.891 1.24388 -6 205.487 1.0859 -6 205.067 0.959709 -6 205.668 0.848902 -6 206.156 0.798141 -6 206.687 0.779709 -6 207.393 0.812591 -6 208.081 0.909274 -6 208.748 1.06682 -6 209.391 1.28228 -6 210.006 1.55272 -6 210.591 1.87519 -6 211.143 2.24676 -6 211.659 2.66447 -6 212.135 3.1254 -6 212.569 3.62659 -6 212.958 4.1651 -6 213.299 4.738 -6 213.589 5.34234 -6 213.825 5.97518 -6 214.004 6.63358 -6 214.09 7.08526 -6 214.167 7.77971 -6 239.937 7.77971 -6 240.568 7.80837 -6 241.178 7.89277 -6 241.764 8.03056 -6 242.325 8.21938 -6 242.857 8.45687 -6 243.359 8.74067 -6 243.827 9.06842 -6 244.261 9.43776 -6 244.656 9.84633 -6 245.012 10.2918 -6 245.326 10.7718 -6 245.594 11.2839 -6 245.816 11.8258 -6 245.988 12.3952 -6 246.108 12.9896 -6 246.158 13.3987 -6 246.187 14.0297 -6 246.187 30.5297 -6 246.158 31.1607 -6 246.074 31.7706 -6 245.936 32.3569 -6 245.747 32.9174 -6 245.51 33.4497 -6 245.226 33.9513 -6 244.898 34.4201 -6 244.529 34.8535 -6 244.12 35.2492 -6 243.675 35.605 -6 243.195 35.9184 -6 242.683 36.187 -6 242.141 36.4085 -6 241.571 36.5806 -6 240.977 36.7008 -6 240.568 36.751 -6 239.937 36.7797 -6 203.437 36.7797 -6 202.806 36.751 -6 202.196 36.6666 -6 201.61 36.5289 -6 201.049 36.34 -6 200.517 36.1026 -6 200.015 35.8187 -6 199.547 35.491 -6 199.113 35.1217 -6 198.717 34.7131 -6 198.362 34.2676 -6 198.048 33.7877 -6 197.78 33.2755 -6 197.558 32.7336 -6 197.386 32.1642 -6 197.266 31.5698 -6 197.216 31.1607 -6 203.225 17.7842 -6 205.565 17.7842 -6 205.565 20.1242 -6 203.225 20.1242 -6 214.605 17.9742 -6 214.605 19.3742 -6 214.15 19.2033 -6 213.684 19.0736 -6 213.206 18.9859 -6 212.851 18.9488 -6 212.445 18.9342 -6 212.112 18.9489 -6 211.847 18.9849 -6 211.6 19.0425 -6 211.408 19.107 -6 211.228 19.1865 -6 211.06 19.281 -6 210.904 19.3905 -6 210.761 19.515 -6 210.68 19.5969 -6 210.605 19.6842 -6 210.488 19.8414 -6 210.384 20.0132 -6 210.275 20.2386 -6 210.184 20.4853 -6 210.101 20.8003 -6 210.035 21.1966 -6 210.006 21.5195 -6 209.995 21.9242 -6 210.017 22.4485 -6 210.076 22.8831 -6 210.159 23.2394 -6 210.255 23.5278 -6 210.372 23.7942 -6 210.449 23.9365 -6 210.555 24.1042 -6 210.697 24.2902 -6 210.823 24.4267 -6 210.956 24.5465 -6 211.098 24.6498 -6 211.246 24.7365 -6 211.402 24.8067 -6 211.566 24.8605 -6 211.737 24.8979 -6 211.879 24.9161 -6 212.065 24.9242 -6 212.298 24.9138 -6 212.514 24.885 -6 212.619 24.8637 -6 212.734 24.8342 -6 212.943 24.7674 -6 213.145 24.6822 -6 213.256 24.6261 -6 213.365 24.5642 -6 213.454 23.5742 -6 214.645 23.5742 -6 214.645 25.6442 -6 213.971 25.8017 -6 213.305 25.9142 -6 212.63 25.9817 -6 211.954 26.0042 -6 211.338 25.9759 -6 210.836 25.9046 -6 210.431 25.8092 -6 210.052 25.6821 -6 209.697 25.5236 -6 209.367 25.3337 -6 209.11 25.1515 -6 208.824 24.9042 -6 208.608 24.6771 -6 208.414 24.4338 -6 208.243 24.1743 -6 208.095 23.8986 -6 207.947 23.5464 -6 207.832 23.1709 -6 207.75 22.772 -6 207.701 22.3498 -6 207.685 21.9042 -6 207.708 21.3699 -6 207.778 20.8671 -6 207.876 20.4612 -6 208.008 20.0782 -6 208.173 19.7182 -6 208.373 19.3809 -6 208.607 19.0663 -6 208.875 18.7742 -6 209.171 18.5103 -6 209.49 18.28 -6 209.833 18.0835 -6 210.2 17.9206 -6 210.59 17.7914 -6 211.005 17.696 -6 211.518 17.6272 -6 212.065 17.6042 -6 212.893 17.6414 -6 213.657 17.745 -6 214.109 17.8397 -6 220.865 17.6042 -6 221.463 17.6327 -6 221.953 17.7044 -6 222.347 17.8008 -6 222.718 17.9295 -6 223.066 18.0906 -6 223.338 18.2498 -6 223.594 18.4315 -6 223.739 18.5515 -6 223.924 18.7242 -6 224.175 19.0063 -6 224.36 19.2598 -6 224.554 19.5859 -6 224.715 19.936 -6 224.845 20.3099 -6 224.942 20.7074 -6 225.015 21.201 -6 225.037 21.4974 -6 225.044 21.8042 -6 225.015 22.4075 -6 224.942 22.9011 -6 224.845 23.2986 -6 224.715 23.6725 -6 224.554 24.0225 -6 224.36 24.3487 -6 224.175 24.6022 -6 223.924 24.8842 -6 223.691 25.0978 -6 223.442 25.2887 -6 223.177 25.4569 -6 222.837 25.6289 -6 222.473 25.7684 -6 222.087 25.8755 -6 221.606 25.9597 -6 221.243 25.9931 -6 220.865 26.0042 -6 220.262 25.9758 -6 219.77 25.9041 -6 219.375 25.8077 -6 219.003 25.679 -6 218.656 25.5178 -6 218.386 25.3587 -6 218.132 25.1769 -6 217.987 25.0569 -6 217.805 24.8842 -6 217.591 24.6508 -6 217.4 24.4007 -6 217.232 24.1339 -6 217.06 23.7918 -6 216.92 23.4259 -6 216.813 23.0362 -6 216.729 22.5517 -6 216.696 22.1861 -6 216.685 21.8042 -6 216.713 21.201 -6 216.785 20.7074 -6 216.881 20.3099 -6 217.01 19.936 -6 217.171 19.5859 -6 217.33 19.3125 -6 217.512 19.0557 -6 217.632 18.9096 -6 217.805 18.7242 -6 218.035 18.5106 -6 218.282 18.3197 -6 218.546 18.1516 -6 218.827 18.006 -6 219.186 17.8611 -6 219.569 17.7486 -6 219.977 17.6683 -6 220.409 17.6202 -6 220.865 18.6842 -6 220.7 18.6929 -6 220.573 18.7124 -6 220.45 18.7429 -6 220.331 18.7844 -6 220.216 18.837 -6 220.106 18.9005 -6 219.973 18.9953 -6 219.847 19.1071 -6 219.727 19.2359 -6 219.613 19.3816 -6 219.505 19.5442 -6 219.372 19.7979 -6 219.259 20.0716 -6 219.154 20.4094 -6 219.068 20.8215 -6 219.015 21.2677 -6 218.995 21.8042 -6 219.019 22.392 -6 219.084 22.8815 -6 219.178 23.286 -6 219.289 23.6171 -6 219.389 23.8481 -6 219.505 24.0642 -6 219.635 24.2573 -6 219.774 24.4261 -6 219.897 24.5481 -6 220.025 24.6532 -6 220.133 24.7249 -6 220.245 24.7857 -6 220.36 24.8355 -6 220.48 24.8743 -6 220.604 24.902 -6 220.732 24.9187 -6 220.865 24.9242 -6 221.027 24.9155 -6 221.152 24.8961 -6 221.273 24.8656 -6 221.391 24.8241 -6 221.505 24.7715 -6 221.615 24.708 -6 221.747 24.6132 -6 221.872 24.5014 -6 221.992 24.3726 -6 222.107 24.2268 -6 222.215 24.0642 -6 222.348 23.8106 -6 222.477 23.4961 -6 222.58 23.1549 -6 222.665 22.7391 -6 222.717 22.289 -6 222.734 21.8042 -6 222.709 21.2165 -6 222.641 20.7269 -6 222.544 20.3225 -6 222.431 19.9913 -6 222.33 19.7604 -6 222.215 19.5442 -6 222.084 19.3511 -6 221.945 19.1824 -6 221.823 19.0603 -6 221.694 18.9553 -6 221.56 18.8673 -6 221.448 18.8093 -6 221.333 18.7623 -6 221.213 18.7262 -6 221.09 18.7013 -6 220.995 18.6898 -6 229.665 24.2942 -6 229.665 25.8242 -6 226.505 25.8242 -6 226.505 24.7442 -6 227.585 24.7442 -6 227.585 18.8642 -6 226.505 18.8642 -6 226.505 17.7842 -6 230.574 17.7842 -6 230.574 18.8642 -6 229.665 18.8642 -6 229.665 23.2542 -6 230.025 23.6522 -6 230.317 23.9207 -6 230.472 24.0428 -6 230.645 24.1642 -6 230.816 24.2617 -6 230.986 24.3384 -6 231.136 24.3898 -6 231.283 24.4259 -6 231.43 24.4472 -6 231.574 24.4542 -6 231.701 24.4483 -6 231.802 24.4338 -6 231.896 24.4104 -6 231.97 24.384 -6 232.039 24.3514 -6 232.104 24.3124 -6 232.151 24.2766 -6 232.196 24.2366 -6 232.237 24.1925 -6 232.275 24.1442 -6 232.325 24.0643 -6 232.37 23.9756 -6 232.415 23.861 -6 232.45 23.7341 -6 232.48 23.574 -6 232.498 23.3974 -6 232.505 23.2042 -6 232.505 18.8642 -6 231.605 18.8642 -6 231.605 17.7842 -6 235.484 17.7842 -6 235.484 18.8642 -6 234.595 18.8642 -6 234.595 23.2542 -6 234.909 23.6123 -6 235.18 23.8713 -6 235.372 24.0283 -6 235.565 24.1642 -6 235.736 24.2617 -6 235.906 24.3384 -6 236.056 24.3898 -6 236.203 24.4259 -6 236.35 24.4472 -6 236.495 24.4542 -6 236.62 24.4483 -6 236.72 24.4338 -6 236.799 24.4149 -6 236.872 24.3898 -6 236.942 24.3584 -6 237.007 24.3207 -6 237.067 24.2766 -6 237.123 24.226 -6 237.155 24.1925 -6 237.195 24.1442 -6 237.245 24.0643 -6 237.29 23.9756 -6 237.335 23.861 -6 237.37 23.7341 -6 237.4 23.574 -6 237.418 23.3974 -6 237.424 23.2042 -6 237.424 18.8642 -6 236.525 18.8642 -6 236.525 17.7842 -6 240.595 17.7842 -6 240.595 18.8642 -6 239.514 18.8642 -6 239.514 23.6942 -6 239.497 24.0916 -6 239.452 24.4137 -6 239.391 24.6717 -6 239.322 24.875 -6 239.238 25.0619 -6 239.157 25.2052 -6 239.084 25.3115 -6 238.984 25.4342 -6 238.874 25.5425 -6 238.753 25.6394 -6 238.621 25.7249 -6 238.478 25.799 -6 238.325 25.8617 -6 238.126 25.9219 -6 237.912 25.9657 -6 237.682 25.9931 -6 237.395 26.0042 -6 237.112 25.9906 -6 236.867 25.9553 -6 236.628 25.898 -6 236.395 25.8184 -6 236.166 25.7163 -6 235.915 25.5742 -6 235.669 25.4085 -6 235.404 25.1906 -6 235.121 24.9104 -6 234.873 24.6194 -6 234.635 24.2942 -6 234.505 24.2942 -6 234.434 24.5884 -6 234.353 24.8267 -6 234.268 25.0172 -6 234.183 25.1669 -6 234.088 25.304 -6 233.983 25.4284 -6 233.906 25.5042 -6 233.824 25.5742 -6 233.719 25.6567 -6 233.581 25.744 -6 233.433 25.8184 -6 233.274 25.8802 -6 233.074 25.9364 -6 232.86 25.9757 -6 232.665 25.996 -6 232.424 26.0042 -6 232.177 25.9934 -6 231.932 25.9609 -6 231.693 25.9064 -6 231.459 25.8296 -6 231.23 25.7303 -6 231.091 25.6567 -6 230.954 25.5742 -6 230.709 25.4085 -6 230.443 25.1906 -6 230.159 24.9104 -6 229.908 24.6194 -6</float_array>
                                <technique_common>
                                    <accessor count="1820" source="#ID13" stride="3">
                                        <param name="X" type="float"/>
                                        <param name="Y" type="float"/>
                                        <param name="Z" type="float"/>
                                    </accessor>
                                </technique_common>
                            </source>
                            <source id="ID14">
                                <float_array id="ID15" count="5151">0.293986 0.155107 0.943141 0.333333 0.666667 0.666667 0.666667 0.333333 -0.666667 -0.666667 0.333333 0.666667 -0.333333 0.666667 -0.666667 -0.408248 -0.816497 0.408248 -0.816497 -0.408248 -0.408248 -0.365148 -0.182574 0.912871 -0.182574 -0.365148 -0.912871 -0.218218 0.436436 0.872872 -0.436436 0.218218 -0.872872 -0.816497 0.408248 0.408248 -0.408248 0.816497 -0.408248 -0.267261 -0.534522 0.801784 -0.534522 -0.267261 -0.801784 0.666667 -0.333333 0.666667 0.333333 -0.666667 -0.666667 0.408248 0.816497 0.408248 0.816497 0.408248 -0.408248 0.436436 0.218218 0.872872 0.218218 0.436436 -0.872872 0.472588 -0.313733 0.823548 0.545125 -0.156867 -0.823548 0.424432 -0.565156 0.707429 0.441313 -0.552075 -0.707429 0.379196 -0.596594 0.707308 0.393339 -0.587366 -0.707308 0.342309 -0.618591 0.707227 0.35366 -0.612172 -0.707227 0.297777 -0.641084 0.707347 0.314395 -0.6331 -0.707347 0.239365 -0.664984 0.70746 0.260285 -0.657078 -0.70746 0.175384 -0.684647 0.707459 0.196915 -0.678768 -0.707459 0.0963656 -0.591886 0.800241 0.113445 -0.588851 -0.800241 0.0531389 -0.704817 0.707396 0.0732946 -0.703007 -0.707396 -0.0109601 -0.70668 0.707448 0.0110128 -0.70668 -0.707448 -0.0914775 -0.826746 0.555089 -0.065119 -0.829238 -0.555089 -0.145784 -0.691525 0.707489 -0.122955 -0.695946 -0.707489 -0.213322 -0.673758 0.707492 -0.190968 -0.680431 -0.707492 -0.326778 -0.764909 0.555095 -0.302072 -0.774998 -0.555095 -0.340625 -0.619202 0.707505 -0.319642 -0.63029 -0.707505 -0.402159 -0.581098 0.707526 -0.381889 -0.594615 -0.707526 -0.460122 -0.536367 0.70753 -0.441276 -0.551975 -0.70753 -0.506202 -0.493342 0.707371 -0.49253 -0.506992 -0.707371 -0.53836 -0.458222 0.707249 -0.529072 -0.468916 -0.707249 -0.483389 -0.355003 0.800192 -0.474052 -0.367379 -0.800192 -0.512308 -0.311625 0.800269 -0.502541 -0.327142 -0.800269 -0.538947 -0.262851 0.800278 -0.530514 -0.279481 -0.800278 -0.662252 -0.246731 0.707492 -0.653737 -0.268482 -0.707492 -0.579865 -0.152472 0.800318 -0.574473 -0.171673 -0.800318 -0.821151 -0.132606 0.555091 -0.816503 -0.158738 -0.555091 -0.705103 -0.0489546 0.707413 -0.703354 -0.0697078 -0.707413 -0.706982 -0.00939724 0.707169 -0.706794 -0.0187945 -0.707169 -0.267261 0.534522 0.801784 -0.534522 0.267261 -0.801784 0.365148 0.182574 0.912871 0.182574 0.365148 -0.912871 0.402572 -0.266441 0.875754 0.464012 -0.13322 -0.875754 0.425776 -0.564149 0.707425 0.442524 -0.55111 -0.707425 0.379844 -0.596167 0.707321 0.394406 -0.586635 -0.707321 0.342839 -0.618301 0.707224 0.354036 -0.611958 -0.707224 0.300641 -0.639779 0.707317 0.316163 -0.632252 -0.707317 0.244957 -0.662972 0.707435 0.265061 -0.655193 -0.707435 0.181868 -0.682953 0.70746 0.203364 -0.676863 -0.70746 0.100089 -0.591231 0.800268 0.118073 -0.587903 -0.800268 0.0541767 -0.704704 0.70743 0.0754747 -0.702742 -0.70743 -0.0109951 -0.706681 0.707447 0.0109422 -0.706682 -0.707447 -0.0914781 -0.826746 0.555089 -0.065119 -0.829238 -0.555089 -0.145786 -0.691524 0.707489 -0.122956 -0.695946 -0.707489 -0.213327 -0.673756 0.707492 -0.190971 -0.68043 -0.707492 -0.27765 -0.64992 0.70747 -0.256663 -0.658491 -0.70747 -0.340623 -0.619203 0.707505 -0.319638 -0.630292 -0.707505 -0.402152 -0.581102 0.707526 -0.381886 -0.594617 -0.707526 -0.460131 -0.536358 0.70753 -0.441277 -0.551974 -0.70753 -0.506208 -0.493337 0.70737 -0.492543 -0.50698 -0.70737 -0.53835 -0.458234 0.707248 -0.529067 -0.468922 -0.707248 -0.569616 -0.418577 0.707341 -0.558661 -0.433091 -0.707341 -0.603536 -0.367809 0.707432 -0.592092 -0.385962 -0.707432 -0.461782 -0.226035 0.857709 -0.454577 -0.240197 -0.857709 -0.561471 -0.210358 0.800312 -0.554237 -0.228739 -0.800312 -0.683131 -0.181051 0.707497 -0.676733 -0.203668 -0.707497 -0.591779 -0.0965661 0.800296 -0.588378 -0.115489 -0.800296 -0.705052 -0.0495811 0.70742 -0.703264 -0.0705458 -0.70742 -0.706978 -0.00953547 0.707171 -0.706785 -0.0190709 -0.707171 0.706663 0.022391 0.707195 0.706929 0.0111955 -0.707195 0.702245 0.0795034 0.707483 0.704464 0.0565518 -0.707483 0.813856 0.171833 0.555078 0.818848 0.146205 -0.555078 0.674733 0.210342 0.707455 0.681002 0.18906 -0.707455 0.650841 0.275408 0.7075 0.659674 0.253523 -0.7075 0.73096 0.396952 0.555091 0.74326 0.373413 -0.555091 0.587817 0.392469 0.707417 0.599199 0.374861 -0.707417 0.654114 0.514004 0.554919 0.666186 0.498259 -0.554919 0.619181 0.555643 0.554866 0.630581 0.542671 -0.554866 0.490121 0.509349 0.70735 0.50333 0.4963 -0.70735 0.445068 0.549075 0.707412 0.46101 0.535759 -0.707412 0.394914 0.586182 0.707414 0.41202 0.574287 -0.707414 0.338496 0.620411 0.707468 0.358166 0.609267 -0.707468 0.275221 0.65091 0.707509 0.297032 0.641251 -0.707509 0.210444 0.674686 0.707468 0.23192 0.667609 -0.707468 0.144546 0.6918 0.707473 0.166758 0.686785 -0.707473 0.0841113 0.701822 0.707369 0.103214 0.699268 -0.707369 0.0355437 0.706059 0.707261 0.0502713 0.705163 -0.707261 -0.0146878 0.706731 0.70733 0.00306519 0.706877 -0.70733 -0.0646474 0.596134 0.800278 -0.0460876 0.597856 -0.800278 -0.141536 0.692444 0.707452 -0.119805 0.696533 -0.707452 -0.205305 0.676292 0.707445 -0.184286 0.68232 -0.707445 -0.307946 0.772769 0.554976 -0.287134 0.780741 -0.554976 -0.308286 0.636163 0.707288 -0.293805 0.642979 -0.707288 -0.355352 0.611045 0.707354 -0.339075 0.620225 -0.707354 -0.406236 0.57839 0.707416 -0.38895 0.590153 -0.707416 -0.456968 0.539178 0.707438 -0.440252 0.552911 -0.707438 -0.498012 0.501692 0.707311 -0.485806 0.513521 -0.707311 -0.526089 0.472324 0.707206 -0.518116 0.481057 -0.707206 -0.185227 0.65134 0.735831 -0.370453 0.566848 -0.735831 0.349619 0.263869 0.898966 0.17481 0.401624 -0.898966 0.795183 0.2441 0.555067 0.802353 0.219386 -0.555067 0.652979 0.270386 0.707467 0.661279 0.2494 -0.707467 0.624032 0.331768 0.70747 0.634357 0.311571 -0.70747 0.694156 0.458295 0.555079 0.708212 0.43626 -0.555079 0.549445 0.444497 0.707483 0.563666 0.426319 -0.707483 0.594887 0.581394 0.555059 0.612377 0.562942 -0.555059 0.461094 0.535729 0.707381 0.47583 0.522684 -0.707381 0.485833 0.675205 0.555036 0.505587 0.660543 -0.555036 0.357402 0.609715 0.707468 0.376728 0.597967 -0.707468 0.299431 0.640219 0.707433 0.318745 0.630825 -0.707433 0.239512 0.664953 0.70744 0.259816 0.657286 -0.70744 0.175183 0.684682 0.707475 0.197202 0.678668 -0.707475 0.110433 0.698093 0.707439 0.131795 0.694377 -0.707439 0.0414503 0.598253 0.800234 0.0585081 0.596826 -0.800234 -0.0120894 0.706708 0.707402 0.00833057 0.706763 -0.707402 -0.0646905 0.59613 0.800278 -0.0461368 0.597852 -0.800278 -0.141492 0.692454 0.707451 -0.119805 0.696534 -0.707451 -0.205138 0.676345 0.707443 -0.184158 0.682356 -0.707443 -0.3077 0.772867 0.554976 -0.286889 0.780831 -0.554976 -0.308151 0.636228 0.707289 -0.293632 0.643057 -0.707289 -0.354359 0.611637 0.70734 -0.338525 0.620541 -0.70734 -0.405183 0.579121 0.707422 -0.387709 0.590962 -0.707422 -0.455138 0.540749 0.707418 -0.438896 0.554013 -0.707418 -0.495013 0.504671 0.707297 -0.483156 0.516033 -0.707297 -0.52404 0.474574 0.707221 -0.515428 0.483914 -0.707221 -0.119384 0.310215 -0.943141 -0.333333 -0.666667 0.666667 0.816497 -0.408248 0.408248 0.408248 -0.816497 -0.408248 0.333333 0.666667 0.666667 0.666667 0.333333 -0.666667 -0.816497 0.408248 0.408248 -0.408248 0.816497 -0.408248 -0.666667 -0.333333 -0.666667 -0.436436 -0.218218 0.872872 -0.218218 -0.436436 -0.872872 0.28507 0.143149 0.947757 0.481554 -0.304371 0.821866 0.548977 -0.152186 -0.821866 0.442798 -0.550895 0.707421 0.459041 -0.537435 -0.707421 0.335417 -0.497155 0.800207 0.348647 -0.487968 -0.800207 0.349887 -0.614231 0.707318 0.364802 -0.605492 -0.707318 0.299012 -0.640462 0.707389 0.317009 -0.631748 -0.707389 0.241563 -0.66423 0.707422 0.261296 -0.656718 -0.707422 0.153446 -0.579687 0.800261 0.170827 -0.574805 -0.800261 0.119044 -0.696697 0.707419 0.139709 -0.692849 -0.707419 0.0555697 -0.704592 0.707434 0.0769752 -0.702576 -0.707434 -0.010449 -0.706678 0.707458 0.0118582 -0.706655 -0.707459 -0.0778635 -0.702442 0.70747 -0.0553101 -0.704576 -0.70747 -0.16899 -0.814456 0.555071 -0.143584 -0.819317 -0.555071 -0.206382 -0.675978 0.707432 -0.185776 -0.681929 -0.707432 -0.267808 -0.654063 0.707446 -0.2474 -0.662052 -0.707446 -0.33139 -0.624175 0.707521 -0.309818 -0.635159 -0.707521 -0.392597 -0.587632 0.7075 -0.372774 -0.600403 -0.7075 -0.447103 -0.547366 0.707453 -0.429747 -0.561095 -0.707453 -0.489357 -0.510134 0.707314 -0.476862 -0.521833 -0.707314 -0.613776 -0.561612 0.554861 -0.602151 -0.574058 -0.554861 -0.473101 -0.368478 0.800249 -0.462047 -0.382248 -0.800249 -0.596749 -0.37859 0.707503 -0.583737 -0.398361 -0.707503 -0.631377 -0.317521 0.707491 -0.620564 -0.338167 -0.707491 -0.558981 -0.216995 0.800283 -0.551897 -0.234427 -0.800283 -0.679913 -0.192956 0.707451 -0.673557 -0.214088 -0.707451 -0.589619 -0.109091 0.80028 -0.585929 -0.127435 -0.80028 -0.70322 -0.0719124 0.707327 -0.701207 -0.0894277 -0.707327 -0.706392 -0.0291691 0.70722 -0.705759 -0.041779 -0.70722 -0.707064 -0.00551906 0.707128 -0.706999 -0.0110381 -0.707128 -0.333333 -0.666667 0.666667 -0.666667 -0.333333 -0.666667 0.534522 -0.267261 0.801784 0.267261 -0.534522 -0.801784 0.436436 0.218218 0.872872 0.218218 0.436436 -0.872872 0.706711 0.0211673 0.707186 0.706948 0.0105837 -0.707186 0.702749 0.0752723 0.707444 0.70474 0.0535174 -0.707444 0.692361 0.141834 0.707474 0.696575 0.119433 -0.707474 0.794667 0.245671 0.555113 0.802294 0.219484 -0.555113 0.651667 0.273505 0.707478 0.660188 0.252244 -0.707478 0.620958 0.337392 0.707515 0.63207 0.316087 -0.707515 0.688517 0.466706 0.555094 0.703109 0.44442 -0.555094 0.54677 0.447899 0.707411 0.559668 0.431673 -0.707411 0.505762 0.493749 0.707402 0.519813 0.478933 -0.707402 0.459578 0.536962 0.707432 0.475655 0.522774 -0.707432 0.480938 0.678681 0.555058 0.50145 0.66367 -0.555058 0.300783 0.518756 0.800264 0.316348 0.509413 -0.800264 0.29488 0.642278 0.707478 0.315539 0.632385 -0.707478 0.229456 0.668418 0.707508 0.251844 0.660309 -0.707508 0.163946 0.687479 0.707456 0.1855 0.681979 -0.707457 0.101946 0.69942 0.707403 0.122164 0.696173 -0.707403 0.0445348 0.705456 0.707353 0.0631282 0.704036 -0.707353 -0.0100822 0.599641 0.800206 0.00596395 0.599696 -0.800206 -0.0738882 0.702903 0.707438 -0.0523436 0.704835 -0.707438 -0.138144 0.693141 0.70744 -0.116789 0.697057 -0.70744 -0.200573 0.677728 0.707428 -0.180035 0.683471 -0.707428 -0.254982 0.659286 0.707338 -0.238032 0.665593 -0.707338 -0.351095 0.754228 0.554862 -0.335532 0.761279 -0.554862 -0.343901 0.617572 0.707345 -0.327757 0.62629 -0.707345 -0.395566 0.585729 0.707424 -0.377826 0.597326 -0.707424 -0.447022 0.547457 0.707433 -0.430167 0.560798 -0.707433 -0.494843 0.504652 0.70743 -0.479358 0.519383 -0.70743 -0.625642 0.548325 0.554898 -0.613041 0.562378 -0.554898 -0.556454 0.436153 0.707198 -0.549366 0.445047 -0.707198 -0.140678 0.286298 -0.947757 -0.333333 -0.666667 0.666667 0.816497 -0.408248 0.408248 0.408248 -0.816497 -0.408248 -0.816497 0.408248 0.408248 -0.408248 0.816497 -0.408248 -0.666667 -0.333333 -0.666667 0.745066 -0.272284 0.608883 0.0135092 0.867855 0.496634 0.751706 0.433927 -0.496634 -0.304202 0.637938 0.707458 -0.324154 0.628035 -0.707458 -0.207228 0.562702 0.800264 -0.224191 0.556161 -0.800264 -0.18284 0.682719 0.707434 -0.20355 0.676834 -0.707434 -0.141583 0.81968 0.555048 -0.166197 0.815046 -0.555048 -0.0556399 0.704572 0.707448 -0.0775154 0.702502 -0.707448 0.00914198 0.706722 0.707432 -0.0123108 0.706674 -0.707432 0.0736699 0.702926 0.707437 0.0521325 0.704851 -0.707437 0.140598 0.692603 0.707483 0.117906 0.696825 -0.707483 0.209772 0.674841 0.707521 0.186536 0.681629 -0.707521 0.323955 0.766106 0.555099 0.299086 0.776153 -0.555099 0.333426 0.623211 0.707414 0.314892 0.632778 -0.707414 0.390226 0.589244 0.707471 0.371106 0.601469 -0.707471 0.444056 0.549844 0.70745 0.426694 0.563424 -0.70745 0.489405 0.510014 0.707367 0.475384 0.523108 -0.707367 0.531172 0.466293 0.707409 0.517314 0.481621 -0.707409 0.485272 0.352205 0.800289 0.473858 0.367418 -0.800289 0.609032 0.358562 0.707469 0.597235 0.377885 -0.707469 0.543369 0.253546 0.80029 0.535041 0.270678 -0.80029 0.665604 0.237684 0.707445 0.65793 0.258166 -0.707445 0.685125 0.173465 0.70747 0.679213 0.195337 -0.70747 0.698229 0.109655 0.707427 0.694612 0.130619 -0.707427 0.705103 0.0494178 0.707381 0.703451 0.0690513 -0.707381 0.599585 -0.00999794 0.800249 0.59962 0.00763645 -0.800249 0.702453 -0.0777465 0.707471 0.704587 -0.0551591 -0.707471 0.586954 -0.122557 0.800291 0.590553 -0.10384 -0.800291 0.67462 -0.210616 0.70748 0.681112 -0.188568 -0.70748 0.552296 -0.233423 0.800302 0.559568 -0.215408 -0.800302 0.621918 -0.335746 0.707455 0.632154 -0.316051 -0.707455 0.593311 -0.384304 0.707314 0.602435 -0.369837 -0.707314 0.568325 -0.420506 0.707235 0.576223 -0.409617 -0.707235 0.454631 -0.391114 0.800213 0.465105 -0.378598 -0.800213 0.491545 -0.50781 0.707469 0.507559 -0.491804 -0.707469 0.442334 -0.55125 0.707435 0.458921 -0.53752 -0.707435 0.458078 -0.694302 0.555076 0.47958 -0.679627 -0.555076 0.331846 -0.624002 0.707459 0.351399 -0.613205 -0.70746 0.271644 -0.652471 0.707454 0.291968 -0.643633 -0.707454 0.210247 -0.674781 0.707437 0.230781 -0.668037 -0.707437 0.171038 -0.81401 0.555098 0.197164 -0.808079 -0.555098 0.0844299 -0.701777 0.707376 0.10377 -0.699179 -0.707376 0.0420643 -0.830876 0.554866 0.0593245 -0.829822 -0.554866 -0.0166344 -0.831725 0.554938 0.00408644 -0.831882 -0.554938 -0.0739065 -0.702915 0.707423 -0.0528265 -0.704813 -0.707424 -0.135608 -0.693675 0.707408 -0.115296 -0.697338 -0.707408 -0.232812 -0.798564 0.555063 -0.208162 -0.805341 -0.555063 -0.298667 -0.776407 0.554968 -0.278043 -0.784029 -0.554968 -0.3 -0.640118 0.707283 -0.285641 -0.646653 -0.707283 -0.60329 -0.284287 0.745132 -0.467236 -0.475888 -0.745132 -0.389259 -0.833411 0.392306 -0.778519 -0.489903 -0.392306 0.666667 -0.333333 0.666667 0.333333 -0.666667 -0.666667 0.361029 0.510433 0.780459 0.570744 0.255217 -0.780459 0.0726006 0.509075 0.857655 0.0861845 0.506952 -0.857655 0.0477041 0.705297 0.707305 0.0644112 0.703968 -0.707305 -0.00782022 0.514107 0.857691 0.00736613 0.514113 -0.857691 -0.0637929 0.59623 0.800275 -0.045313 0.597918 -0.800275 -0.138807 0.693022 0.707427 -0.117889 0.696886 -0.707427 -0.201195 0.677537 0.707435 -0.180462 0.683352 -0.707435 -0.225038 0.555753 0.80031 -0.206668 0.562843 -0.80031 -0.327104 0.626496 0.707465 -0.306998 0.636589 -0.707465 -0.383115 0.593948 0.707424 -0.365152 0.605158 -0.707424 -0.504443 0.661508 0.554928 -0.488186 0.673595 -0.554928 -0.465385 0.532155 0.707268 -0.453907 0.541978 -0.707268 -0.504199 0.495394 0.707367 -0.490564 0.508899 -0.707367 -0.545996 0.448794 0.707441 -0.531942 0.465366 -0.707441 -0.584891 0.39678 0.707438 -0.57247 0.4145 -0.707438 -0.72778 0.402816 0.555045 -0.715372 0.424461 -0.555045 -0.647589 0.283064 0.707463 -0.638277 0.303479 -0.707463 -0.671931 0.219037 0.707483 -0.664425 0.240846 -0.707483 -0.812203 0.179393 0.555107 -0.805928 0.205758 -0.555107 -0.700863 0.0917471 0.707371 -0.698093 0.110874 -0.707371 -0.705763 0.0404986 0.70729 -0.704658 0.0565551 -0.70729 -0.831761 -0.0140872 0.554955 -0.831848 0.00733981 -0.554955 -0.7029 -0.0738332 0.707446 -0.704851 -0.0520075 -0.707446 -0.692771 -0.139868 0.707464 -0.696869 -0.117765 -0.707464 -0.676323 -0.205141 0.707463 -0.682498 -0.183556 -0.707463 -0.652662 -0.271045 0.707508 -0.661427 -0.248892 -0.707508 -0.623075 -0.333559 0.707471 -0.633469 -0.31337 -0.707471 -0.694378 -0.458007 0.55504 -0.707694 -0.43715 -0.55504 -0.555611 -0.436963 0.707361 -0.567128 -0.421908 -0.707361 -0.521855 -0.476854 0.707303 -0.532953 -0.464417 -0.707303 -0.570465 -0.605474 0.554952 -0.585789 -0.590661 -0.554952 -0.4397 -0.553385 0.70741 -0.455733 -0.540257 -0.70741 -0.38943 -0.589844 0.70741 -0.406548 -0.578178 -0.70741 -0.333165 -0.623297 0.707461 -0.352752 -0.612425 -0.707461 -0.270381 -0.652947 0.707499 -0.291988 -0.643575 -0.707499 -0.206401 -0.675946 0.707457 -0.22758 -0.669113 -0.707457 -0.120113 -0.587463 0.800288 -0.138629 -0.583371 -0.800288 -0.0822949 -0.702048 0.707359 -0.101014 -0.6996 -0.707359 -0.0347541 -0.706105 0.707254 -0.0491604 -0.705248 -0.707254 0.0149178 -0.706729 0.707327 -0.00271606 -0.706882 -0.707327 0.0769993 -0.702548 0.707459 0.0547786 -0.704628 -0.707459 0.120709 -0.587356 0.800276 0.102443 -0.590816 -0.800276 0.206214 -0.67601 0.707451 0.18501 -0.682118 -0.707451 0.306838 -0.773231 0.554945 0.287214 -0.780733 -0.554945 0.30337 -0.638562 0.707252 0.290372 -0.644576 -0.707252 0.576807 -0.544569 -0.608883 0.702956 -0.312844 0.638735 0.218218 -0.436436 0.872872 0.436436 -0.218218 -0.872872 0.816497 -0.408248 0.408248 0.408248 -0.816497 -0.408248 0.267261 0.534522 0.801784 0.534522 0.267261 -0.801784 -0.666667 0.333333 0.666667 -0.333333 0.666667 -0.666667 -0.408248 -0.816497 0.408248 -0.816497 -0.408248 -0.408248 -0.288965 0.422953 0.858842 -0.466548 0.211476 -0.858842 -0.0872544 0.70148 0.707328 -0.104782 0.699076 -0.707328 -0.047715 0.830571 0.554864 -0.0648806 0.829407 -0.554864 0.0133165 0.706708 0.70738 -0.00632389 0.706806 -0.70738 0.0901482 0.826905 0.555069 0.0644697 0.829302 -0.555069 0.141393 0.692481 0.707445 0.119904 0.696523 -0.707445 0.207489 0.675581 0.707488 0.18519 0.682031 -0.707488 0.27471 0.651113 0.707521 0.252254 0.660138 -0.707521 0.337305 0.621057 0.70747 0.317225 0.63155 -0.70747 0.395396 0.585788 0.707471 0.376391 0.598177 -0.707471 0.525141 0.645123 0.555017 0.506396 0.659939 -0.555017 0.485324 0.514014 0.707284 0.473695 0.52475 -0.707284 0.523703 0.474713 0.707377 0.51036 0.489029 -0.707377 0.566034 0.423141 0.707501 0.551586 0.441809 -0.707501 0.513775 0.30906 0.800323 0.503128 0.326107 -0.800323 0.541926 0.256545 0.800313 0.533171 0.274278 -0.800313 0.664969 0.239395 0.707464 0.657014 0.260436 -0.707464 0.684215 0.177184 0.707429 0.678553 0.197763 -0.707429 0.697498 0.114157 0.707435 0.693691 0.135381 -0.707435 0.704972 0.0506334 0.707425 0.703133 0.0717821 -0.707425 0.599584 -0.0101691 0.800248 0.599624 0.00742297 -0.800248 0.702423 -0.0780053 0.707472 0.704569 -0.0553645 -0.707472 0.586907 -0.122787 0.80029 0.59051 -0.104087 -0.80029 0.674601 -0.210689 0.707477 0.681071 -0.188729 -0.707477 0.552415 -0.233155 0.800297 0.559628 -0.215267 -0.800298 0.622374 -0.334913 0.707448 0.632486 -0.315402 -0.707448 0.594176 -0.382975 0.707309 0.603159 -0.368665 -0.707309 0.569606 -0.418775 0.707231 0.577367 -0.408008 -0.707231 0.455921 -0.389609 0.800213 0.466353 -0.37706 -0.800213 0.493527 -0.505893 0.707462 0.509333 -0.489977 -0.707462 0.444845 -0.549231 0.707431 0.461272 -0.535509 -0.707431 0.392093 -0.588027 0.707451 0.410261 -0.575499 -0.707451 0.39412 -0.732496 0.555085 0.417103 -0.719657 -0.555085 0.274581 -0.651237 0.707457 0.294962 -0.642263 -0.707457 0.212843 -0.673961 0.707443 0.233519 -0.667079 -0.707443 0.173382 -0.813508 0.555107 0.199782 -0.80743 -0.555107 0.0856775 -0.701618 0.707383 0.105273 -0.698947 -0.707383 0.0427147 -0.830839 0.554871 0.0602333 -0.829753 -0.554871 -0.0136188 -0.706759 0.707324 0.00389686 -0.706879 -0.707324 -0.085941 -0.827372 0.55504 -0.061294 -0.829562 -0.55504 -0.148604 -0.818533 0.554907 -0.129583 -0.821758 -0.554907 -0.165901 -0.687264 0.70721 -0.154161 -0.689992 -0.707209 -0.246479 -0.794558 0.554911 -0.227778 -0.800119 -0.554911 -0.26146 -0.656708 0.707371 -0.243409 -0.66361 -0.707371 -0.366333 -0.746889 0.554938 -0.347626 -0.755778 -0.554938 -0.509648 -0.223456 0.830859 -0.398946 -0.387963 -0.830859 -0.394178 -0.829364 0.395954 -0.788356 -0.470866 -0.395954 0.45865 0.620435 0.63616 0.706445 0.310218 -0.63616 0.10936 0.589797 0.800112 0.120979 0.587524 -0.800112 0.0722633 0.595455 0.800132 0.0850036 0.59377 -0.800132 0.0286925 0.513516 0.857601 0.0398655 0.512769 -0.8576 -0.0122351 0.59959 0.800213 0.00409945 0.599701 -0.800213 -0.0676623 0.595759 0.800308 -0.0481177 0.597655 -0.800308 -0.146526 0.6914 0.707458 -0.124656 0.695675 -0.707458 -0.179154 0.572229 0.800286 -0.161012 0.577596 -0.800286 -0.276524 0.650363 0.707504 -0.254544 0.659276 -0.707504 -0.338623 0.620339 0.70747 -0.318556 0.630879 -0.70747 -0.393951 0.586822 0.70742 -0.376308 0.598289 -0.70742 -0.515808 0.652692 0.55492 -0.500053 0.664839 -0.55492 -0.473678 0.524798 0.707259 -0.462669 0.534529 -0.707259 -0.51115 0.488232 0.707358 -0.497953 0.501685 -0.707358 -0.551036 0.442632 0.707415 -0.537713 0.458724 -0.707415 -0.588055 0.392116 0.707415 -0.576207 0.409328 -0.707415 -0.732096 0.394851 0.555093 -0.719095 0.41806 -0.555093 -0.652164 0.272244 0.707506 -0.642642 0.294017 -0.707506 -0.675521 0.207768 0.707463 -0.668584 0.229112 -0.707463 -0.814718 0.167658 0.55509 -0.808962 0.193533 -0.55509 -0.701989 0.082766 0.707362 -0.69951 0.101609 -0.707362 -0.706094 0.0349369 0.707256 -0.705228 0.0494253 -0.707256 -0.831755 -0.015736 0.55492 -0.831893 0.00416506 -0.55492 -0.702889 -0.0739418 0.707446 -0.704843 -0.052115 -0.707446 -0.692792 -0.139782 0.707461 -0.69687 -0.117776 -0.707461 -0.676497 -0.204589 0.707457 -0.682603 -0.183188 -0.707457 -0.653198 -0.269776 0.707498 -0.661814 -0.24789 -0.707498 -0.62222 -0.335033 0.707528 -0.633415 -0.313354 -0.707528 -0.689925 -0.46462 0.555097 -0.704501 -0.442206 -0.555097 -0.553472 -0.439769 0.707299 -0.563577 -0.426743 -0.707299 -0.617129 -0.55793 0.554856 -0.628257 -0.545369 -0.554856 -0.48658 -0.512683 0.707387 -0.500821 -0.498781 -0.707387 -0.434312 -0.55747 0.707531 -0.453374 -0.542081 -0.707531 -0.37396 -0.599623 0.707535 -0.394607 -0.586243 -0.707535 -0.263191 -0.538694 0.800337 -0.281467 -0.529375 -0.800337 -0.245271 -0.662797 0.70749 -0.266971 -0.654358 -0.70749 -0.181188 -0.683145 0.707449 -0.202373 -0.677171 -0.707449 -0.116472 -0.697097 0.707453 -0.138238 -0.693109 -0.707453 -0.0515375 -0.704893 0.707439 -0.0731212 -0.702982 -0.707439 0.0109559 -0.599547 0.800265 -0.00722856 -0.599604 -0.800265 0.0627017 -0.59641 0.800227 0.0459203 -0.597936 -0.800227 0.126043 -0.695589 0.707297 0.109857 -0.698328 -0.707297 0.44781 -0.625687 -0.638735 -0.316126 0.00478212 0.948705 -0.706702 -0.0213882 0.707188 -0.706945 -0.0106941 -0.707188 -0.827067 -0.0886919 0.555063 -0.829402 -0.0632317 -0.555063 -0.815267 -0.165029 0.555071 -0.820006 -0.139591 -0.555071 -0.796208 -0.24071 0.555079 -0.803373 -0.215589 -0.555079 -0.769928 -0.314791 0.555083 -0.779488 -0.290311 -0.555083 -0.736594 -0.386404 0.555087 -0.748484 -0.362838 -0.555087 -0.696488 -0.454732 0.555088 -0.710598 -0.432352 -0.555088 -0.64995 -0.519076 0.55509 -0.666166 -0.498095 -0.55509 -0.597453 -0.578727 0.55509 -0.615594 -0.559391 -0.55509 -0.539491 -0.633107 0.55509 -0.559402 -0.615584 -0.55509 -0.476658 -0.681669 0.555089 -0.498119 -0.666148 -0.555089 -0.409566 -0.72397 0.555088 -0.432381 -0.71058 -0.555088 -0.338949 -0.759601 0.555085 -0.362848 -0.748479 -0.555085 -0.265601 -0.788251 0.555082 -0.290325 -0.779484 -0.555082 -0.190351 -0.809726 0.555076 -0.215614 -0.803368 -0.555076 -0.122644 -0.822789 0.554956 -0.143848 -0.819348 -0.554956 -0.0589913 -0.829788 0.554952 -0.0802148 -0.828006 -0.554952 -0.0106952 -0.706945 0.707188 -0.0213903 -0.706702 -0.707188 -0.232454 -0.175763 0.956594 -0.116227 -0.267243 -0.956594 -0.6959 -0.123491 0.707441 -0.691769 -0.144853 -0.707441 -0.59693 -0.0584585 0.800161 -0.595382 -0.0725469 -0.800161 -0.831282 -0.0340761 0.554805 -0.830606 -0.0478028 -0.554805 -0.599497 0.0168787 0.800199 -0.599733 0.00110184 -0.800199 -0.594656 0.076002 0.80038 -0.597026 0.0543324 -0.80038 -0.68715 0.164852 0.707565 -0.692643 0.13999 -0.707565 -0.564646 0.201469 0.800366 -0.571471 0.181208 -0.800366 -0.636711 0.306561 0.707544 -0.647109 0.283957 -0.707544 -0.601174 0.371462 0.707535 -0.61374 0.350312 -0.707535 -0.474621 0.366314 0.800343 -0.486992 0.349699 -0.800343 -0.511958 0.487143 0.707524 -0.528406 0.469251 -0.707524 -0.459063 0.537279 0.707525 -0.477287 0.521158 -0.707525 -0.401106 0.581823 0.707529 -0.420974 0.567613 -0.707529 -0.338378 0.620397 0.707536 -0.35981 0.608218 -0.707536 -0.277107 0.650183 0.707442 -0.297006 0.641337 -0.707442 -0.260694 0.789964 0.554973 -0.281678 0.782727 -0.554973 -0.416196 -0.645909 0.639986 -0.484527 0.596365 -0.639986 -0.0915975 -0.700906 0.707348 -0.109879 -0.698273 -0.707348 -0.0407813 -0.705742 0.707295 -0.0570462 -0.704613 -0.707295 0.0137528 -0.706714 0.707366 -0.00538307 -0.706827 -0.707366 0.0765881 -0.702604 0.707447 0.0547403 -0.704643 -0.707447 0.141251 -0.692513 0.707442 0.119843 -0.696537 -0.707442 0.204164 -0.676647 0.707436 0.183411 -0.682565 -0.707436 0.311578 -0.771258 0.55505 0.288141 -0.780317 -0.55505 0.32255 -0.628899 0.707422 0.303603 -0.638262 -0.707422 0.377231 -0.597711 0.707417 0.359363 -0.608621 -0.707417 0.428571 -0.562044 0.707413 0.411834 -0.574421 -0.707413 0.560608 -0.61454 0.55503 0.542343 -0.630719 -0.55503 0.520374 -0.47831 0.707411 0.506121 -0.493368 -0.707411 0.560465 -0.430634 0.707413 0.547547 -0.446944 -0.707413 0.701881 -0.446427 0.555037 0.688348 -0.467023 -0.555037 0.627846 -0.324597 0.707422 0.617866 -0.343213 -0.707422 0.770334 -0.313855 0.55505 0.7605 -0.336984 -0.55505 0.573631 -0.174695 0.800269 0.568025 -0.192139 -0.800269 0.812947 -0.176478 0.554953 0.808149 -0.197286 -0.554953 0.700311 -0.0960677 0.707344 0.697588 -0.114173 -0.707344 0.0579224 -0.122978 0.990718 0.115845 -0.0711241 -0.990718 0.0119158 -0.393663 0.919178 0.0059579 -0.393798 -0.919178 0.0886843 -0.827068 0.555062 0.0632306 -0.829402 -0.555063 0.16503 -0.815267 0.555072 0.139585 -0.820007 -0.555072 0.240701 -0.796211 0.555078 0.215589 -0.803374 -0.555078 0.314784 -0.769931 0.555083 0.290299 -0.779493 -0.555083 0.386406 -0.736593 0.555087 0.362839 -0.748483 -0.555087 0.454743 -0.696481 0.555088 0.432359 -0.710593 -0.555088 0.51908 -0.649947 0.55509 0.498104 -0.666158 -0.55509 0.578734 -0.597447 0.55509 0.559395 -0.615591 -0.55509 0.633104 -0.539495 0.55509 0.615588 -0.559398 -0.55509 0.681675 -0.47665 0.555089 0.666147 -0.49812 -0.555089 0.723967 -0.409572 0.555088 0.710584 -0.432375 -0.555088 0.759592 -0.33897 0.555085 0.74847 -0.362868 -0.555085 0.788254 -0.265593 0.555082 0.779481 -0.290331 -0.555082 0.809728 -0.190344 0.555076 0.803373 -0.215598 -0.555076 0.822785 -0.122676 0.554956 0.819345 -0.143866 -0.554956 0.829788 -0.0589916 0.554952 0.828003 -0.0802391 -0.554952 0.706945 -0.0106884 0.707188 0.706703 -0.0213769 -0.707188 0.195983 0.00592826 0.980589 0.196051 0.00296413 -0.980589 0.827066 0.088699 0.555063 0.829402 0.0632253 -0.555063 0.815266 0.165036 0.555071 0.820004 0.139605 -0.555071 0.796212 0.240697 0.555078 0.803375 0.215583 -0.555078 0.769926 0.314796 0.555084 0.779491 0.290304 -0.555084 0.736591 0.386409 0.555086 0.748478 0.362849 -0.555086 0.591785 0.386374 0.707464 0.603774 0.367357 -0.707464 0.64995 0.519076 0.55509 0.666165 0.498096 -0.55509 0.597445 0.578735 0.55509 0.61559 0.559396 -0.55509 0.539496 0.633103 0.55509 0.559398 0.615588 -0.55509 0.476657 0.68167 0.555089 0.498125 0.666143 -0.555089 0.409568 0.723969 0.555088 0.432378 0.710582 -0.555088 0.33895 0.7596 0.555086 0.362853 0.748477 -0.555086 0.265605 0.78825 0.555082 0.290324 0.779485 -0.555082 0.190354 0.809726 0.555077 0.215619 0.803367 -0.555077 0.122638 0.82279 0.554956 0.143846 0.819349 -0.554956 0.0589896 0.829788 0.554952 0.0802093 0.828007 -0.554952 0.00235885 0.15591 0.987768 0.0047177 0.155856 -0.987768 -0.00497278 0.164287 0.9864 -0.00248639 0.164344 -0.9864 -0.0639327 0.59622 0.800272 -0.0455826 0.597903 -0.800272 -0.140222 0.692715 0.707449 -0.118603 0.696742 -0.707449 -0.204524 0.676519 0.707455 -0.183183 0.682606 -0.707455 -0.267465 0.65419 0.707459 -0.246666 0.662312 -0.707459 -0.328315 0.625865 0.707462 -0.30829 0.635967 -0.707462 -0.386388 0.591776 0.707464 -0.367364 0.60377 -0.707464 -0.441042 0.552245 0.707465 -0.423227 0.566014 -0.707465 -0.659984 0.68135 0.316517 -0.637928 0.702043 -0.316517 -0.633101 0.539498 0.55509 -0.615582 0.559405 -0.55509 -0.5792 0.404994 0.707465 -0.566006 0.423237 -0.707465 -0.615139 0.347993 0.707464 -0.603766 0.367371 -0.707464 -0.645406 0.288009 0.707461 -0.635958 0.308311 -0.707461 -0.669759 0.225668 0.707458 -0.662305 0.246687 -0.707458 -0.688004 0.161742 0.707453 -0.682606 0.183194 -0.707453 -0.699147 0.104213 0.707343 -0.696221 0.122241 -0.707343 -0.829789 0.0589847 0.554952 -0.828007 0.0802054 -0.554952 -0.316018 0.00956424 -0.948705 0.0522708 0.104542 0.993146 0.104542 0.0522708 -0.993146 -0.0890871 0.178174 -0.979958 -0.178174 0.0890871 0.979958 -0.215666 -0.107833 -0.970495 -0.107833 -0.215666 0.970495 0.136083 -0.272166 -0.952579 0.272166 -0.136083 0.952579 -0.219648 0.0937167 0.971068 -0.147975 0.187433 -0.971068 -0.161918 -0.0919631 -0.98251 -0.0290834 -0.183926 0.98251 0.269731 -0.786882 -0.555034 0.246408 -0.794494 0.555034 0.198844 -0.807705 -0.555043 0.174597 -0.813291 0.555044 0.129079 -0.821805 -0.554956 0.10783 -0.824862 0.554956 0.0676211 -0.829164 -0.5549 0.0486695 -0.830492 0.5549 0.00640908 -0.706827 -0.707358 -0.012437 -0.706746 0.707358 -0.0525837 -0.704825 -0.70743 -0.0738811 -0.702911 0.70743 -0.116972 -0.697013 -0.707454 -0.138762 -0.693004 0.707454 -0.181998 -0.68292 -0.707458 -0.203443 -0.676841 0.707458 -0.245164 -0.662889 -0.707441 -0.265445 -0.655031 0.707441 -0.2598 -0.540389 -0.800302 -0.277176 -0.531686 0.800302 -0.367174 -0.603842 -0.707501 -0.387153 -0.591231 0.707501 -0.571772 -0.756882 -0.316554 -0.597063 -0.737095 0.316554 -0.561834 -0.613468 -0.554977 -0.578117 -0.598148 0.554977 -0.514527 -0.484835 -0.707246 -0.524063 -0.47451 0.707246 -0.641506 -0.529616 -0.554956 -0.654962 -0.512882 0.554956 -0.58033 -0.403402 -0.707449 -0.592601 -0.385149 0.707449 -0.615735 -0.34692 -0.707472 -0.626577 -0.326932 0.707472 -0.646297 -0.285976 -0.707473 -0.655173 -0.265008 0.707473 -0.670659 -0.223003 -0.70745 -0.677289 -0.201974 0.70745 -0.584196 -0.135138 -0.800283 -0.588145 -0.116759 0.800283 -0.823799 -0.115737 -0.554942 -0.826443 -0.0950344 0.554942 -0.829949 -0.0576278 -0.554855 -0.830939 -0.0409353 0.554855 -0.831891 -0.00415188 -0.554924 -0.831748 0.015942 0.554924 -0.829542 0.0613902 -0.555059 -0.827276 0.0867358 0.555059 -0.820342 0.137598 -0.555073 -0.815652 0.163112 0.555073 -0.804013 0.213234 -0.555063 -0.797079 0.237844 0.555063 -0.780776 0.286839 -0.555079 -0.771384 0.311215 0.555079 -0.752191 0.355274 -0.554968 -0.742541 0.375024 0.554968 -0.723322 0.410969 -0.554896 -0.713846 0.427216 0.554896 -0.690265 0.464172 -0.555049 -0.675965 0.484759 0.555049 -0.644849 0.52541 -0.55508 -0.627994 0.545444 0.55508 -0.592705 0.583607 -0.555071 -0.574282 0.601744 0.555071 -0.534552 0.637257 -0.555119 -0.513196 0.654578 0.555119 -0.467865 0.687679 -0.555157 -0.443857 0.703414 0.555157 -0.393833 0.732581 -0.555176 -0.367804 0.745989 0.555176 -0.314561 0.769957 -0.555173 -0.287349 0.780521 0.555173 -0.232678 0.798543 -0.555149 -0.20523 0.806034 0.555149 -0.153643 0.817517 -0.555032 -0.129542 0.82168 0.555032 -0.0824322 0.827759 -0.554996 -0.05943 0.829727 0.554996 -0.0119495 0.831743 -0.555033 0.0125312 0.831734 0.555033 0.0613833 0.829561 -0.555032 0.0857548 0.827397 0.555032 0.128525 0.821933 -0.554894 0.146952 0.818839 0.554894 0.178997 0.812494 -0.554809 0.192641 0.809368 0.554809 0.222337 0.801687 -0.554855 0.238372 0.797067 0.554855 0.277562 0.784152 -0.555036 0.300633 0.775599 0.555036 0.340903 0.758861 -0.554901 0.358179 0.750861 0.554901 0.387237 0.736372 -0.5548 0.399087 0.730018 0.5548 0.689226 0.635785 -0.347483 0.863697 0.36508 0.347483 0.0567841 0.0336711 -0.997819 0.028392 0.0595992 0.997819 -0.120386 0.240772 -0.963087 -0.240772 0.120386 0.963087 -0.18194 -0.0795298 -0.980088 -0.118857 -0.15906 0.980088 -0.124371 -0.586799 -0.800124 -0.112142 -0.589258 0.800124 -0.119995 -0.823221 -0.554895 -0.10141 -0.825716 0.554895 -0.0644577 -0.829424 -0.554888 -0.0460924 -0.830647 0.554888 -0.00572343 -0.831851 -0.554969 0.0162843 -0.831712 0.554969 0.064479 -0.829292 -0.555084 0.0906581 -0.826839 0.555084 0.141674 -0.81966 -0.555055 0.166517 -0.814976 0.555055 0.215686 -0.803364 -0.555055 0.240012 -0.796435 0.555055 0.289469 -0.779787 -0.555103 0.314578 -0.770001 0.555103 0.364825 -0.747477 -0.555141 0.389941 -0.734687 0.555141 0.437336 -0.70754 -0.55509 0.459654 -0.693249 0.55509 0.502931 -0.662519 -0.555094 0.523886 -0.646076 0.555094 0.479274 -0.51941 -0.707467 0.495614 -0.503843 0.707467 0.61872 -0.555983 -0.555039 0.634965 -0.537356 0.555039 0.66589 -0.498512 -0.555046 0.680561 -0.478289 0.555046 0.707924 -0.436776 -0.555041 0.720622 -0.415492 0.555041 0.632895 -0.314533 -0.70747 0.64265 -0.294088 0.70747 0.777339 -0.295933 -0.555129 0.786795 -0.269788 0.555129 0.802626 -0.21836 -0.555077 0.809074 -0.193101 0.555077 0.696136 -0.122374 -0.707404 0.69939 -0.102147 0.707404 0.828529 -0.0744959 -0.554968 0.830208 -0.0525901 0.554968 0.831823 -0.00827351 -0.554979 0.831744 0.014138 0.554979 0.829415 0.0628445 -0.555087 0.827003 0.0891324 0.555087 0.819615 0.141763 -0.555099 0.814621 0.168103 0.555099 0.802197 0.219899 -0.55509 0.79478 0.245357 0.55509 0.777053 0.296679 -0.55513 0.766687 0.322524 0.55513 0.631326 0.317547 -0.707525 0.62002 0.339091 0.707525 0.700456 0.448504 -0.555162 0.684466 0.472547 0.555162 0.650315 0.518554 -0.555151 0.632167 0.54053 0.555151 0.594036 0.582189 -0.555136 0.574069 0.601887 0.555136 0.531707 0.639599 -0.555158 0.50929 0.657589 0.555158 0.46259 0.691234 -0.555163 0.438303 0.706883 0.555163 0.388666 0.735357 -0.555148 0.363328 0.7482 0.555148 0.265514 0.654953 -0.707487 0.24387 0.663317 0.707487 0.236676 0.797422 -0.555069 0.211827 0.80438 0.555069 0.1615 0.815973 -0.555072 0.136022 0.820605 0.555072 0.0853306 0.827425 -0.555055 0.0601209 0.829638 0.555055 0.00920334 0.706751 -0.707403 -0.0112555 0.706721 0.707403 -0.0621652 0.829494 -0.555045 -0.0870046 0.827258 0.555045 -0.131505 0.821443 -0.554922 -0.151191 0.818049 0.554922 -0.186564 0.810766 -0.554845 -0.202276 0.806989 0.554845 -0.0166277 0.83169 0.554991 0.00628648 0.831832 -0.554991 -0.0665872 0.829108 -0.555109 -0.093624 0.826491 0.555109 -0.124322 0.695737 -0.707456 -0.146128 0.691486 0.707456 -0.222707 0.80143 -0.555079 -0.24777 0.794039 0.555079 -0.298593 0.776322 -0.555127 -0.324329 0.765927 0.555127 -0.373525 0.743205 -0.55509 -0.397009 0.730931 0.55509 -0.441078 0.705257 -0.555035 -0.461705 0.691929 0.555035 -0.49786 0.666487 -0.554915 -0.513491 0.65452 0.554915 -0.54193 0.631221 -0.554862 -0.554787 0.619951 0.554862 -0.58598 0.590357 -0.555073 -0.604099 0.571802 0.555073 -0.542908 0.452481 -0.707469 -0.557116 0.434867 0.707469 -0.687056 0.468855 -0.555093 -0.701705 0.446634 0.555093 -0.72964 0.399294 -0.555148 -0.742855 0.374135 0.555148 -0.766252 0.323581 -0.555115 -0.776479 0.298206 0.555115 -0.793971 0.248003 -0.555071 -0.801299 0.223196 0.555071 -0.813643 0.172847 -0.555076 -0.818653 0.147302 0.555076 -0.701612 0.0862661 -0.707318 -0.703511 0.0690967 0.707318 -0.830634 0.0473098 -0.554806 -0.831304 0.0335234 0.554806 -0.706903 -0.000176744 -0.70731 -0.706696 -0.0171283 0.70731 -0.704406 -0.0572054 -0.707488 -0.702146 -0.0803223 0.707488 -0.818652 -0.147305 -0.555077 -0.813636 -0.172877 0.555077 -0.801288 -0.223235 -0.555071 -0.793965 -0.248024 0.555071 -0.776483 -0.298198 -0.555115 -0.76626 -0.323562 0.555115 -0.742864 -0.374117 -0.555148 -0.729644 -0.399286 0.555148 -0.701705 -0.446634 -0.555093 -0.687057 -0.468854 0.555093 -0.557117 -0.434866 -0.707469 -0.542908 -0.45248 0.707469 -0.602401 -0.57352 -0.555146 -0.582503 -0.59372 0.555146 -0.5437 -0.629546 -0.555034 -0.524909 -0.645297 0.555034 -0.485925 -0.675138 -0.555036 -0.465728 -0.689225 0.555036 -0.422332 -0.716592 -0.555097 -0.399083 -0.729795 0.555097 -0.350071 -0.754499 -0.555142 -0.324277 -0.765939 0.555142 -0.273093 -0.785677 -0.555096 -0.247727 -0.79404 0.555096 -0.196157 -0.808323 -0.5551 -0.169952 -0.814236 0.5551 -0.103015 -0.699297 -0.707369 -0.0839117 -0.701846 0.707369 -0.0501085 -0.705176 -0.70726 -0.0354189 -0.706066 0.70726 -0.00317386 -0.831878 -0.55495 0.0180502 -0.831688 0.55495 0.066232 -0.829138 -0.555107 0.0931786 -0.826544 0.555107 0.123879 -0.695816 -0.707456 0.145695 -0.691577 0.707456 0.188921 -0.681037 -0.707459 0.210329 -0.674732 0.707459 0.298738 -0.77626 -0.555135 0.324713 -0.765758 0.555135 0.374426 -0.742745 -0.555099 0.398188 -0.730282 0.555099 0.442832 -0.704148 -0.555046 0.463755 -0.690547 0.555046 0.500432 -0.664551 -0.554923 0.516292 -0.652306 0.554923 0.545172 -0.628417 -0.554869 0.558243 -0.616835 0.554869 0.585596 -0.590874 -0.554928 0.599817 -0.576432 0.554928 0.630071 -0.543083 -0.555041 0.645979 -0.524062 0.555041 0.676022 -0.48469 -0.555041 0.690158 -0.46434 0.555041 0.717557 -0.420687 -0.555099 0.730745 -0.397337 0.555099 0.641782 -0.295876 -0.707512 0.651434 -0.273971 0.707512 0.786286 -0.271341 -0.555093 0.794567 -0.246037 0.555093 0.80868 -0.194698 -0.555095 0.814508 -0.168662 0.555095 0.823122 -0.120275 -0.554981 0.826076 -0.0979532 0.554981 0.829884 -0.0584767 -0.554864 0.830914 -0.0413381 0.554864 0.706874 -0.00260007 -0.707335 0.706711 0.015366 0.707335 0.829155 0.0660568 -0.555103 0.82658 0.092876 0.555103 0.819031 0.14519 -0.555074 0.814099 0.170691 0.555074 0.801869 0.221129 -0.555075 0.794571 0.246066 0.555075 0.777032 0.296744 -0.555126 0.766718 0.322458 0.555126 0.744117 0.371704 -0.555091 0.731879 0.395257 0.555091 0.600074 0.373459 -0.707417 0.588733 0.391094 0.707417 0.667335 0.496718 -0.554919 0.655287 0.512508 0.554919 0.631766 0.54129 -0.554867 0.620355 0.55433 0.554867 0.594648 0.581764 -0.554929 0.580283 0.596092 0.554929 0.546971 0.626695 -0.555046 0.527903 0.642839 0.555046 0.488338 0.673386 -0.555048 0.467838 0.687786 0.555048 0.425948 0.714494 -0.555038 0.404566 0.726815 0.555038 0.30531 0.637406 -0.70746 0.285013 0.646737 0.70746 0.285889 0.781102 -0.55511 0.260214 0.790026 0.55511 0.209963 0.804879 -0.555055 0.18541 0.810887 0.555054 0.137938 0.820335 -0.554998 0.115037 0.823859 0.554998 0.0711502 0.828838 -0.554946 0.0501743 0.830372 0.554946 -0.0147702 -0.706594 0.707465 0.00773064 -0.706706 -0.707465 -0.0605188 -0.704125 -0.707493 -0.083765 -0.701739 0.707493 -0.12814 -0.695065 -0.707435 -0.149277 -0.690834 0.707435 -0.225353 -0.800695 -0.555071 -0.250138 -0.793301 0.555071 -0.340839 -0.885243 -0.316502 -0.368154 -0.874236 0.316502 -0.31388 -0.633254 -0.707438 -0.333112 -0.623352 0.707438 -0.37203 -0.600873 -0.707493 -0.391688 -0.588247 0.707493 -0.313192 -0.407613 -0.857766 -0.327153 -0.396495 0.857766 -0.485022 -0.51405 -0.707465 -0.501139 -0.498351 0.707465 -0.530485 -0.467085 -0.707402 -0.54376 -0.451562 0.707402 -0.567727 -0.42113 -0.707345 -0.578464 -0.406255 0.707345 -0.601835 -0.370398 -0.707531 -0.614313 -0.349312 0.707531 -0.635839 -0.308614 -0.707436 -0.64497 -0.289046 0.707436 -0.661347 -0.249321 -0.707431 -0.668598 -0.229167 0.707431 -0.681389 -0.187681 -0.70745 -0.686909 -0.166344 0.70745 -0.695735 -0.124604 -0.707409 -0.69908 -0.10421 0.707409 -0.703871 -0.0648337 -0.707363 -0.705362 -0.0458567 0.707363 -0.70681 -0.00802443 -0.707358 -0.706772 0.0108307 0.707358 -0.704945 0.0509618 -0.707429 -0.703083 0.0722349 0.707429 -0.697247 0.115523 -0.707461 -0.693242 0.137534 0.707461 -0.683089 0.181322 -0.707469 -0.676934 0.203097 0.707469 -0.663412 0.243863 -0.7074 -0.656111 0.262876 0.7074 -0.640644 0.298707 -0.707354 -0.632522 0.315542 0.707354 -0.611851 0.353597 -0.707537 -0.599141 0.37473 0.707537 -0.57291 0.413845 -0.707464 -0.55945 0.431868 0.707464 -0.530325 0.467133 -0.70749 -0.51464 0.484358 0.70749 -0.481645 0.51718 -0.707491 -0.464335 0.532776 0.707491 -0.363822 0.476616 -0.800294 -0.348396 0.488005 0.800294 -0.374387 0.599491 -0.707421 -0.356334 0.610394 0.707421 -0.31874 0.630819 -0.707441 -0.29919 0.640322 0.707441 -0.347718 0.882563 -0.316503 -0.320111 0.892947 0.316503 -0.231617 0.798907 -0.555069 -0.206743 0.805702 0.555069 -0.133446 0.694071 -0.707431 -0.112364 0.697794 0.707431 -0.0707579 0.703256 -0.707407 -0.0502361 0.705019 0.707407 -0.00609132 0.599579 -0.800292 0.0130292 0.599468 0.800292 0.061423 0.704037 -0.707502 0.0849497 0.701587 0.707502 0.129768 0.694757 -0.707441 0.151069 0.690439 0.707441 0.259643 0.912365 -0.316504 0.287935 0.903836 0.316504 0.301251 0.775334 -0.555071 0.325211 0.765594 0.555071 0.315785 0.63231 -0.707434 0.334894 0.622401 0.707434 0.373562 0.599926 -0.707489 0.393094 0.587313 0.707489 0.366221 0.474695 -0.800341 0.382358 0.461797 0.800341 0.485657 0.513456 -0.70746 0.50165 0.497843 0.70746 0.530781 0.466754 -0.707398 0.543964 0.451321 0.707398 0.567803 0.42103 -0.707343 0.578501 0.406205 0.707343 0.601642 0.370736 -0.707518 0.61394 0.349995 0.707518 0.635666 0.308911 -0.707462 0.645144 0.288594 0.707462 0.662087 0.247272 -0.707458 0.669556 0.226269 0.707458 0.682345 0.184209 -0.70744 0.687683 0.163157 0.70744 0.69626 0.121623 -0.707411 0.699528 0.101146 0.707411 0.704121 0.0622224 -0.707348 0.705508 0.0437831 0.707348 0.706826 0.00651251 -0.707358 0.706749 -0.0123191 0.707358 0.704761 -0.0531489 -0.707452 0.702756 -0.0751429 0.707452 0.696589 -0.119378 -0.707469 0.692411 -0.141618 0.707469 0.68199 -0.185431 -0.707463 0.675754 -0.207007 0.707463 0.662198 -0.247174 -0.707389 0.654948 -0.265789 0.707389 0.639739 -0.300676 -0.707339 0.631825 -0.316969 0.707339 0.611531 -0.354173 -0.707525 0.598987 -0.374999 0.707525 0.573002 -0.413725 -0.707461 0.559614 -0.431661 0.707461 0.530641 -0.466779 -0.707487 0.515035 -0.483943 0.707487 0.482277 -0.516599 -0.707484 0.465127 -0.532093 0.707484 0.362954 -0.477165 -0.800361 0.345819 -0.489726 0.800361 0.366903 -0.604002 -0.707505 0.346405 -0.615987 0.707505 0.306092 -0.63705 -0.707443 0.286306 -0.646184 0.707443 0.329819 -0.889407 -0.316505 0.301921 -0.89926 0.316505 0.215265 -0.803467 -0.555069 0.190246 -0.809756 0.555069 0.121809 -0.696282 -0.707357 0.103246 -0.699276 0.707357 0.0665294 -0.703734 -0.707341 0.0483778 -0.705215 0.707341 -0.717112 -0.358409 0.59774 0.358996 -0.716818 -0.59774 -0.163846 -0.0819232 -0.983078 -0.0819232 -0.163846 0.983078 0.0890871 -0.178174 -0.979958 0.178174 -0.0890871 0.979958 0.240772 0.120386 -0.963087 0.120386 0.240772 0.963087 0.267261 0.534522 -0.801784 0.534522 0.267261 0.801784 0.120386 -0.240772 -0.963087 0.240772 -0.120386 0.963087 0.163846 0.0819232 -0.983078 0.0819232 0.163846 0.983078 -0.218218 0.436436 -0.872872 -0.534522 0.267261 0.801784 -0.436436 -0.218218 -0.872872 -0.182574 -0.365148 0.912871 -0.408248 -0.816497 -0.408248 -0.816497 -0.408248 0.408248 -0.66555 0.16294 -0.72835 -0.602751 0.325881 0.72835 -0.599168 0.576975 -0.555065 -0.581104 0.595165 0.555065 -0.547473 0.626361 -0.554928 -0.532046 0.639517 0.554928 -0.503765 0.662097 -0.554841 -0.490992 0.671624 0.554841 -0.455853 0.695749 -0.555096 -0.433267 0.710034 0.555096 -0.329697 0.625168 -0.707436 -0.310469 0.634936 0.707436 -0.318826 0.768277 -0.555068 -0.294882 0.777781 0.555068 -0.209435 0.675032 -0.707438 -0.188662 0.68113 0.707438 -0.171746 0.81387 -0.555085 -0.145894 0.818899 0.555085 -0.079375 0.70227 -0.707472 -0.0567523 0.704459 0.707472 -0.0117161 0.706654 -0.707462 0.0106969 0.706671 0.707462 0.0556277 0.704552 -0.707468 0.0781451 0.702411 0.707468 0.123697 0.695808 -0.707496 0.146727 0.691318 0.707496 0.192468 0.679995 -0.707504 0.215177 0.673154 0.707504 0.305289 0.773721 -0.555116 0.330606 0.763246 0.555116 0.324129 0.62796 -0.707536 0.345823 0.616278 0.707536 0.454895 0.696368 -0.555105 0.477279 0.681222 0.555105 0.518504 0.650456 -0.555032 0.53741 0.634925 0.555032 0.654445 0.68669 -0.316477 0.674472 0.66703 0.316477 0.450379 0.395939 -0.800245 0.461729 0.382642 0.800244 0.484122 0.353779 -0.800291 0.495137 0.338191 0.800291 0.608226 0.359877 -0.707496 0.619835 0.33949 0.707496 0.640893 0.297852 -0.707489 0.650346 0.276603 0.707489 0.666864 0.234072 -0.707462 0.673954 0.212799 0.707462 0.685793 0.17101 -0.70742 0.690583 0.150504 0.70742 0.592299 0.0939939 -0.800217 0.594656 0.077699 0.800217 0.597921 0.04725 -0.800161 0.598871 0.0331001 0.800161 0.316126 0.00665716 -0.948694 0.316179 0.00332858 0.948694 0.816497 -0.408248 -0.408248 0.408248 -0.816497 0.408248 0.218218 -0.436436 -0.872872 0.534522 -0.267261 0.801784 0.534522 0.267261 -0.801784 0.218218 0.436436 0.872872 -0.436436 -0.218218 -0.872872 -0.182574 -0.365148 0.912871 -0.408248 -0.816497 -0.408248 -0.816497 -0.408248 0.408248 -0.667268 0.159893 -0.727453 -0.607083 0.319785 0.727453 -0.608897 0.566728 -0.555035 -0.591881 0.584476 0.555035 -0.558559 0.616467 -0.55496 -0.542329 0.630792 0.55496 -0.510959 0.656512 -0.554899 -0.495876 0.667977 0.554899 -0.457562 0.694601 -0.555127 -0.434133 0.70948 0.555127 -0.329704 0.625164 -0.707435 -0.310483 0.634929 0.707435 -0.318835 0.768273 -0.555069 -0.294875 0.777784 0.555069 -0.209426 0.675035 -0.707438 -0.188665 0.681129 0.707438 -0.171755 0.813868 -0.555085 -0.145892 0.818899 0.555085 -0.0793681 0.702271 -0.707472 -0.0567488 0.704459 0.707472 -0.0116706 0.706654 -0.707463 0.010788 0.706668 0.707463 0.0560497 0.70451 -0.707478 0.0788522 0.702323 0.707478 0.12299 0.695989 -0.707441 0.14433 0.691879 0.707441 0.219338 0.802373 -0.555057 0.243699 0.795313 0.555057 0.293214 0.778385 -0.555105 0.318346 0.768449 0.555105 0.265683 0.537478 -0.800331 0.28376 0.528158 0.800331 0.504976 0.802985 -0.316567 0.532394 0.785075 0.316567 0.513109 0.654615 -0.555156 0.535355 0.636551 0.555156 0.487243 0.512087 -0.707362 0.500835 0.498802 0.707362 0.617766 0.557185 -0.554897 0.630212 0.543068 0.554897 0.756101 0.572727 -0.316693 0.778641 0.541686 0.316693 0.338697 0.200422 -0.919301 0.345154 0.189086 0.919301 0.640875 0.297885 -0.707491 0.650353 0.276582 0.707491 0.666891 0.233995 -0.707462 0.673978 0.212723 0.707462 0.685807 0.170959 -0.707419 0.690589 0.150479 0.707419 0.592301 0.0939769 -0.800217 0.59466 0.077665 0.800217 0.597925 0.0472159 -0.80016 0.598873 0.033083 0.80016 -0.0522708 0.104542 -0.993146 -0.104542 0.0522708 0.993146 -0.218218 -0.436436 0.872872 -0.408248 -0.816497 -0.408248 -0.816497 -0.408248 0.408248 -0.706956 -0.0103372 -0.707182 -0.706729 -0.0206744 0.707182 -0.829457 -0.0624002 -0.555075 -0.827102 -0.0882883 0.555075 -0.819878 -0.140266 -0.555091 -0.814985 -0.166352 0.555091 -0.802892 -0.217388 -0.555074 -0.795715 -0.242343 0.555074 -0.778883 -0.291921 -0.555088 -0.769208 -0.316537 0.555088 -0.74766 -0.36454 -0.555082 -0.735795 -0.387931 0.555082 -0.711806 -0.430492 -0.554985 -0.699808 -0.449733 0.554985 -0.673757 -0.487871 -0.555008 -0.659675 -0.506749 0.555008 -0.624997 -0.548723 -0.555232 -0.604139 -0.571606 0.555232 -0.562119 -0.613059 -0.555139 -0.541054 -0.631728 0.555139 -0.497555 -0.666541 -0.555124 -0.475136 -0.682703 0.555124 -0.429614 -0.712251 -0.555095 -0.406534 -0.725672 0.555095 -0.152057 -0.316177 -0.936435 -0.142393 -0.320645 0.936435 -0.078407 -0.210526 -0.974439 -0.071819 -0.212864 0.974439 -0.2166 -0.80311 -0.555067 -0.191677 -0.80942 0.555067 -0.143979 -0.819299 -0.554995 -0.121225 -0.822973 0.554995 -0.0764144 -0.828352 -0.554972 -0.054362 -0.830091 0.554972 -0.00812429 -0.831794 -0.555025 0.0160641 -0.831679 0.555025 0.0664334 -0.829137 -0.555084 0.0926101 -0.826623 0.555084 0.143864 -0.819274 -0.555062 0.168946 -0.814471 0.555062 0.157721 -0.578517 -0.800276 0.17557 -0.573353 0.800276 0.248142 -0.661783 -0.707439 0.26831 -0.653866 0.707439 0.308358 -0.63594 -0.707457 0.328232 -0.625914 0.707457 0.308817 -0.51411 -0.800202 0.322329 -0.505748 0.800202 0.350862 -0.48626 -0.80028 0.365851 -0.475085 0.80028 0.394769 -0.451339 -0.800282 0.408696 -0.438768 0.800282 0.434044 -0.413815 -0.800227 0.445494 -0.401462 0.800227 0.549057 -0.44525 -0.707311 0.559598 -0.431927 0.707311 0.478159 -0.647671 -0.5932 0.239079 -0.768736 0.5932 -0.369515 -0.848018 -0.3799 -0.739031 -0.556336 0.3799 -0.682034 -0.185334 -0.707446 -0.675961 -0.20639 0.707446 -0.661728 -0.24823 -0.707459 -0.653556 -0.26901 0.707459 -0.748074 -0.363725 -0.555058 -0.736615 -0.386405 0.555058 -0.604572 -0.366083 -0.707443 -0.592984 -0.38457 0.707443 -0.667672 -0.496048 -0.555113 -0.651032 -0.517693 0.555113 -0.525179 -0.47305 -0.707397 -0.511409 -0.487905 0.707397 -0.571223 -0.604796 -0.554911 -0.556895 -0.618014 0.554911 -0.452204 -0.543491 -0.707198 -0.443431 -0.550673 0.707198 -0.490015 -0.672129 -0.555093 -0.468273 -0.687454 0.555093 -0.358746 -0.608881 -0.707506 -0.338067 -0.620601 0.707506 -0.29686 -0.641382 -0.707463 -0.276351 -0.650482 0.707463 -0.234518 -0.666705 -0.707464 -0.213192 -0.673828 0.707464 -0.170455 -0.685902 -0.707448 -0.149047 -0.69087 0.707448 -0.128877 -0.821835 -0.554957 -0.107563 -0.824895 0.554957 -0.0670083 -0.82921 -0.554906 -0.0477752 -0.83054 0.554906 -0.0069637 -0.831849 -0.554959 0.0146173 -0.83175 0.554958 0.0608104 -0.829599 -0.555039 0.0854173 -0.827427 0.555039 0.114663 -0.697416 -0.707434 0.135837 -0.693603 0.707434 0.209619 -0.804959 -0.555068 0.234446 -0.798082 0.555068 0.283522 -0.78199 -0.555073 0.307768 -0.772769 0.555073 0.350887 -0.754264 -0.554945 0.369837 -0.745155 0.554945 0.402663 -0.72802 -0.554843 0.41661 -0.720129 0.554843 0.442226 -0.704716 -0.554807 0.453923 -0.69724 0.554807 0.486482 -0.674711 -0.555068 0.507126 -0.659336 0.555068 0.546688 -0.62693 -0.555059 0.565615 -0.609909 0.555059 0.59985 -0.576346 -0.554982 0.615241 -0.559887 0.554982 0.6424 -0.528592 -0.554899 0.654262 -0.513837 0.554899</float_array>
                                <technique_common>
                                    <accessor count="1717" source="#ID15" stride="3">
                                        <param name="X" type="float"/>
                                        <param name="Y" type="float"/>
                                        <param name="Z" type="float"/>
                                    </accessor>
                                </technique_common>
                            </source>
                            <source id="ID16">
                                <float_array id="ID17" count="3572">0 1 0.017519 1 0.017519 0 0.0502237 1 0.0502237 0 0.0586772 1 0.0586772 0 0.0726006 1 0.0726006 0 0.14895 1 0.14895 0 0.162873 1 0.162873 0 0.171327 1 0.171327 0 0.217974 1 0.217974 0 0.226428 1 0.226428 0 0.24037 1 0.24037 0 0.299736 1 0.299736 0 0.307634 1 0.307634 0 0.313337 1 0.313337 0 0.316204 1 0.316204 0 0.318958 1 0.318958 0 0.322894 1 0.322894 0 0.326331 1 0.326331 0 0.329339 1 0.329339 0 0.331683 1 0.331683 0 0.334272 1 0.334272 0 0.336156 1 0.336156 0 0.337674 1 0.337674 0 0.339116 1 0.339116 0 0.340272 1 0.340272 0 0.341396 1 0.341396 0 0.342499 1 0.342499 0 0.343593 1 0.343593 0 0.344691 1 0.344691 0 0.345356 1 0.345356 0 0.346028 1 0.346028 0 0.347173 1 0.347173 0 0.348356 1 0.348356 0 0.34984 1 0.34984 0 0.351678 1 0.351678 0 0.35394 1 0.35394 0 0.356717 1 0.356717 0 0.360121 1 0.360121 0 0.416465 1 0.416465 0 0.430389 1 0.430389 0 0.438842 1 0.438842 0 0.48549 1 0.48549 0 0.493943 1 0.493943 0 0.507886 1 0.507886 0 0.567251 1 0.567251 0 0.574757 1 0.574757 0 0.580859 1 0.580859 0 0.583724 1 0.583724 0 0.586472 1 0.586472 0 0.59007 1 0.59007 0 0.593512 1 0.593512 0 0.596528 1 0.596528 0 0.599172 1 0.599172 0 0.60177 1 0.60177 0 0.603654 1 0.603654 0 0.605172 1 0.605172 0 0.606614 1 0.606614 0 0.60777 1 0.60777 0 0.608893 1 0.608893 0 0.609997 1 0.609997 0 0.611091 1 0.611091 0 0.612188 1 0.612188 0 0.612853 1 0.612853 0 0.613526 1 0.613526 0 0.614671 1 0.614671 0 0.615855 1 0.615855 0 0.61734 1 0.61734 0 0.619179 1 0.619179 0 0.621442 1 0.621442 0 0.62422 1 0.62422 0 0.627624 1 0.627624 0 0.683968 1 0.683968 0 0.697891 1 0.697891 0 0.706345 1 0.706345 0 0.752992 1 0.752992 0 0.761446 1 0.761446 0 0.775388 1 0.775388 0 0.834792 1 0.834792 0 0.838753 1 0.838753 0 0.842022 1 0.842022 0 0.844701 1 0.844701 0 0.84729 1 0.84729 0 0.849813 1 0.849813 0 0.851884 1 0.851884 0 0.853943 1 0.853943 0 0.855179 1 0.855179 0 0.856837 1 0.856837 0 0.858907 1 0.858907 0 0.860965 1 0.860965 0 0.863027 1 0.863027 0 0.865531 1 0.865531 0 0.86809 1 0.86809 0 0.870729 1 0.870729 0 0.87394 1 0.87394 0 0.876337 1 0.876337 0 0.878833 1 0.878833 0 0.88228 1 0.88228 0 0.885706 1 0.885706 0 0.889138 1 0.889138 0 0.892609 1 0.892609 0 0.895353 1 0.895353 0 0.898151 1 0.898151 0 0.902262 1 0.902262 0 0.906989 1 0.906989 0 0.9129 1 0.9129 0 0.916732 1 0.916732 0 0.920724 1 0.920724 0 0.921948 1 0.921948 0 0.925049 1 0.925049 0 0.927619 1 0.927619 0 0.930078 1 0.930078 0 0.932116 1 0.932116 0 0.934107 1 0.934107 0 0.93607 1 0.93607 0 0.937698 1 0.937698 0 0.939331 1 0.939331 0 0.941307 1 0.941307 0 0.943326 1 0.943326 0 0.945403 1 0.945403 0 0.947924 1 0.947924 0 0.950959 1 0.950959 0 0.954187 1 0.954187 0 0.958078 1 0.958078 0 0.961518 1 0.961518 0 0.964942 1 0.964942 0 0.968377 1 0.968377 0 0.97185 1 0.97185 0 0.974597 1 0.974597 0 0.977396 1 0.977396 0 0.981522 1 0.981522 0 0.986259 1 0.986259 0 0.991706 1 0.991706 0 0.99552 1 0.99552 0 1 1 1 0 0.261867 1 0.261867 0 0.5 1 0.5 0 0.761867 1 0.761867 0 0.106304 1 0.106304 0 0.133781 1 0.133781 0 0.179038 1 0.179038 0 0.427204 1 0.427204 0 0.472461 1 0.472461 0 0.499938 1 0.499938 0 0.65156 1 0.65156 0 0.679038 1 0.679038 0 0.724357 1 0.724357 0 0.0266447 1 0.0266447 0 0.0763854 1 0.0763854 0 0.0892423 1 0.0892423 0 0.110448 1 0.110448 0 0.226567 1 0.226567 0 0.247773 1 0.247773 0 0.26063 1 0.26063 0 0.331575 1 0.331575 0 0.344432 1 0.344432 0 0.365638 1 0.365638 0 0.455956 1 0.455956 0 0.465858 1 0.465858 0 0.473939 1 0.473939 0 0.479417 1 0.479417 0 0.48468 1 0.48468 0 0.490233 1 0.490233 0 0.495127 1 0.495127 0 0.499913 1 0.499913 0 0.504161 1 0.504161 0 0.508855 1 0.508855 0 0.513492 1 0.513492 0 0.516757 1 0.516757 0 0.519341 1 0.519341 0 0.52136 1 0.52136 0 0.523274 1 0.523274 0 0.5251 1 0.5251 0 0.526513 1 0.526513 0 0.527895 1 0.527895 0 0.528579 1 0.528579 0 0.529599 1 0.529599 0 0.530994 1 0.530994 0 0.532833 1 0.532833 0 0.534799 1 0.534799 0 0.537349 1 0.537349 0 0.540616 1 0.540616 0 0.54532 1 0.54532 0 0.549397 1 0.549397 0 0.553856 1 0.553856 0 0.636932 1 0.636932 0 0.658137 1 0.658137 0 0.670994 1 0.670994 0 0.74194 1 0.74194 0 0.754797 1 0.754797 0 0.775973 1 0.775973 0 0.863034 1 0.863034 0 0.869552 1 0.869552 0 0.87492 1 0.87492 0 0.880021 1 0.880021 0 0.884223 1 0.884223 0 0.888306 1 0.888306 0 0.89231 1 0.89231 0 0.89562 1 0.89562 0 0.89893 1 0.89893 0 0.902221 1 0.902221 0 0.905483 1 0.905483 0 0.908743 1 0.908743 0 0.912029 1 0.912029 0 0.916043 1 0.916043 0 0.920173 1 0.920173 0 0.924459 1 0.924459 0 0.928935 1 0.928935 0 0.933632 1 0.933632 0 0.940452 1 0.940452 0 0.947063 1 0.947063 0 0.952883 1 0.952883 0 0.95863 1 0.95863 0 0.962445 1 0.962445 0 0.966265 1 0.966265 0 0.972019 1 0.972019 0 0.977863 1 0.977863 0 0.984515 1 0.984515 0 0.991388 1 0.991388 0 0.99564 1 0.99564 0 0.261867 1 0.261867 0 0.761867 1 0.761867 0 0.106304 1 0.106304 0 0.133781 1 0.133781 0 0.179038 1 0.179038 0 0.427204 1 0.427204 0 0.472461 1 0.472461 0 0.499938 1 0.499938 0 0.0164575 1 0.0164575 0 0.0288958 1 0.0288958 0 0.0397799 1 0.0397799 0 0.0505923 1 0.0505923 0 0.0614224 1 0.0614224 0 0.0723589 1 0.0723589 0 0.0848959 1 0.0848959 0 0.0937104 1 0.0937104 0 0.102206 1 0.102206 0 0.110461 1 0.110461 0 0.118559 1 0.118559 0 0.125252 1 0.125252 0 0.13195 1 0.13195 0 0.140066 1 0.140066 0 0.146956 1 0.146956 0 0.154013 1 0.154013 0 0.162533 1 0.162533 0 0.170975 1 0.170975 0 0.179414 1 0.179414 0 0.187929 1 0.187929 0 0.196594 1 0.196594 0 0.206989 1 0.206989 0 0.21622 1 0.21622 0 0.227447 1 0.227447 0 0.242702 1 0.242702 0 0.255423 1 0.255423 0 0.266002 1 0.266002 0 0.276163 1 0.276163 0 0.284618 1 0.284618 0 0.292914 1 0.292914 0 0.297027 1 0.297027 0 0.302496 1 0.302496 0 0.31054 1 0.31054 0 0.317059 1 0.317059 0 0.323465 1 0.323465 0 0.329814 1 0.329814 0 0.336159 1 0.336159 0 0.342559 1 0.342559 0 0.349067 1 0.349067 0 0.357094 1 0.357094 0 0.362616 1 0.362616 0 0.3683 1 0.3683 0 0.375995 1 0.375995 0 0.384293 1 0.384293 0 0.392776 1 0.392776 0 0.402586 1 0.402586 0 0.410652 1 0.410652 0 0.41962 1 0.41962 0 0.441334 1 0.441334 0 0.458577 1 0.458577 0 0.496957 1 0.496957 0 0.537456 1 0.537456 0 0.554469 1 0.554469 0 0.569429 1 0.569429 0 0.585781 1 0.585781 0 0.599199 1 0.599199 0 0.61013 1 0.61013 0 0.620622 1 0.620622 0 0.63077 1 0.63077 0 0.63904 1 0.63904 0 0.647209 1 0.647209 0 0.65209 1 0.65209 0 0.658605 1 0.658605 0 0.666725 1 0.666725 0 0.674826 1 0.674826 0 0.682976 1 0.682976 0 0.691243 1 0.691243 0 0.701407 1 0.701407 0 0.711934 1 0.711934 0 0.724798 1 0.724798 0 0.734441 1 0.734441 0 0.746572 1 0.746572 0 0.760509 1 0.760509 0 0.773698 1 0.773698 0 0.784505 1 0.784505 0 0.794949 1 0.794949 0 0.805131 1 0.805131 0 0.813496 1 0.813496 0 0.82182 1 0.82182 0 0.828496 1 0.828496 0 0.835222 1 0.835222 0 0.843637 1 0.843637 0 0.85202 1 0.85202 0 0.860435 1 0.860435 0 0.870666 1 0.870666 0 0.881142 1 0.881142 0 0.891963 1 0.891963 0 0.90514 1 0.90514 0 0.914987 1 0.914987 0 0.925238 1 0.925238 0 0.942877 1 0.942877 0 0.958184 1 0.958184 0 0.971483 1 0.971483 0 0.984443 1 0.984443 0 0.991541 1 0.991541 0 0.0577749 1 0.0577749 0 0.0701279 1 0.0701279 0 0.0813626 1 0.0813626 0 0.141806 1 0.141806 0 0.153041 1 0.153041 0 0.174901 1 0.174901 0 0.226067 1 0.226067 0 0.239425 1 0.239425 0 0.245096 1 0.245096 0 0.250726 1 0.250726 0 0.25945 1 0.25945 0 0.266604 1 0.266604 0 0.273518 1 0.273518 0 0.280256 1 0.280256 0 0.286886 1 0.286886 0 0.292381 1 0.292381 0 0.299 1 0.299 0 0.303463 1 0.303463 0 0.30799 1 0.30799 0 0.314796 1 0.314796 0 0.321558 1 0.321558 0 0.328343 1 0.328343 0 0.335218 1 0.335218 0 0.342249 1 0.342249 0 0.349496 1 0.349496 0 0.358298 1 0.358298 0 0.367548 1 0.367548 0 0.379941 1 0.379941 0 0.390287 1 0.390287 0 0.398902 1 0.398902 0 0.407187 1 0.407187 0 0.41409 1 0.41409 0 0.42087 1 0.42087 0 0.424234 1 0.424234 0 0.428708 1 0.428708 0 0.43529 1 0.43529 0 0.440613 1 0.440613 0 0.445834 1 0.445834 0 0.450997 1 0.450997 0 0.456147 1 0.456147 0 0.46133 1 0.46133 0 0.466592 1 0.466592 0 0.473069 1 0.473069 0 0.47752 1 0.47752 0 0.482099 1 0.482099 0 0.488491 1 0.488491 0 0.495421 1 0.495421 0 0.499389 1 0.499389 0 0.503869 1 0.503869 0 0.511729 1 0.511729 0 0.519432 1 0.519432 0 0.52799 1 0.52799 0 0.544918 1 0.544918 0 0.558745 1 0.558745 0 0.590975 1 0.590975 0 0.607727 1 0.607727 0 0.624014 1 0.624014 0 0.639935 1 0.639935 0 0.655519 1 0.655519 0 0.668151 1 0.668151 0 0.678565 1 0.678565 0 0.687095 1 0.687095 0 0.695333 1 0.695333 0 0.703356 1 0.703356 0 0.709942 1 0.709942 0 0.71649 1 0.71649 0 0.720423 1 0.720423 0 0.725696 1 0.725696 0 0.732291 1 0.732291 0 0.73886 1 0.73886 0 0.745456 1 0.745456 0 0.753478 1 0.753478 0 0.761696 1 0.761696 0 0.770191 1 0.770191 0 0.780546 1 0.780546 0 0.78829 1 0.78829 0 0.79636 1 0.79636 0 0.807496 1 0.807496 0 0.818062 1 0.818062 0 0.826741 1 0.826741 0 0.835148 1 0.835148 0 0.843362 1 0.843362 0 0.851467 1 0.851467 0 0.858204 1 0.858204 0 0.862263 1 0.862263 0 0.867713 1 0.867713 0 0.87588 1 0.87588 0 0.883986 1 0.883986 0 0.892118 1 0.892118 0 0.900365 1 0.900365 0 0.90881 1 0.90881 0 0.917531 1 0.917531 0 0.928148 1 0.928148 0 0.939338 1 0.939338 0 0.955 1 0.955 0 0.975336 1 0.975336 0 0.101896 1 0.101896 0 0.105797 1 0.105797 0 0.109599 1 0.109599 0 0.113319 1 0.113319 0 0.116971 1 0.116971 0 0.120571 1 0.120571 0 0.12413 1 0.12413 0 0.127662 1 0.127662 0 0.131179 1 0.131179 0 0.134691 1 0.134691 0 0.138212 1 0.138212 0 0.141752 1 0.141752 0 0.145323 1 0.145323 0 0.148939 1 0.148939 0 0.152612 1 0.152612 0 0.156357 1 0.156357 0 0.158902 1 0.158902 0 0.162803 1 0.162803 0 0.197016 1 0.197016 0 0.199982 1 0.199982 0 0.202973 1 0.202973 0 0.204676 1 0.204676 0 0.206399 1 0.206399 0 0.210146 1 0.210146 0 0.213818 1 0.213818 0 0.217434 1 0.217434 0 0.221009 1 0.221009 0 0.224555 1 0.224555 0 0.228082 1 0.228082 0 0.231599 1 0.231599 0 0.235113 1 0.235113 0 0.238632 1 0.238632 0 0.242163 1 0.242163 0 0.245714 1 0.245714 0 0.248397 1 0.248397 0 0.251103 1 0.251103 0 0.25488 1 0.25488 0 0.257904 1 0.257904 0 0.261188 1 0.261188 0 0.265556 1 0.265556 0 0.269847 1 0.269847 0 0.274078 1 0.274078 0 0.278264 1 0.278264 0 0.282414 1 0.282414 0 0.286539 1 0.286539 0 0.290648 1 0.290648 0 0.294746 1 0.294746 0 0.29884 1 0.29884 0 0.302935 1 0.302935 0 0.307038 1 0.307038 0 0.311155 1 0.311155 0 0.315295 1 0.315295 0 0.319465 1 0.319465 0 0.323678 1 0.323678 0 0.326518 1 0.326518 0 0.330833 1 0.330833 0 0.489976 1 0.489976 0 0.493877 1 0.493877 0 0.497679 1 0.497679 0 0.501399 1 0.501399 0 0.505051 1 0.505051 0 0.50865 1 0.50865 0 0.51221 1 0.51221 0 0.515742 1 0.515742 0 0.519258 1 0.519258 0 0.522771 1 0.522771 0 0.526292 1 0.526292 0 0.529831 1 0.529831 0 0.533403 1 0.533403 0 0.537018 1 0.537018 0 0.540692 1 0.540692 0 0.544437 1 0.544437 0 0.546982 1 0.546982 0 0.550883 1 0.550883 0 0.652779 1 0.652779 0 0.65668 1 0.65668 0 0.660482 1 0.660482 0 0.664202 1 0.664202 0 0.667854 1 0.667854 0 0.671454 1 0.671454 0 0.675013 1 0.675013 0 0.678545 1 0.678545 0 0.682062 1 0.682062 0 0.685574 1 0.685574 0 0.689095 1 0.689095 0 0.692635 1 0.692635 0 0.696206 1 0.696206 0 0.699822 1 0.699822 0 0.703495 1 0.703495 0 0.70724 1 0.70724 0 0.709786 1 0.709786 0 0.713686 1 0.713686 0 0.939093 1 0.939093 0 0.942994 1 0.942994 0 0.946796 1 0.946796 0 0.950516 1 0.950516 0 0.954168 1 0.954168 0 0.957767 1 0.957767 0 0.961327 1 0.961327 0 0.964859 1 0.964859 0 0.968375 1 0.968375 0 0.971888 1 0.971888 0 0.975409 1 0.975409 0 0.978949 1 0.978949 0 0.98252 1 0.98252 0 0.986135 1 0.986135 0 0.989809 1 0.989809 0 0.993554 1 0.993554 0 0.996099 1 0.996099 0 0 0 0.25 0 0.25 1 0.75 0 0.75 1 0.0381785 0 0.0381785 1 0.0514238 0 0.0514238 1 0.0646207 0 0.0646207 1 0.0778699 0 0.0778699 1 0.0875981 0 0.0875981 1 0.0986904 0 0.0986904 1 0.107755 0 0.107755 1 0.115052 0 0.115052 1 0.121973 0 0.121973 1 0.127506 0 0.127506 1 0.132874 0 0.132874 1 0.138126 0 0.138126 1 0.143315 0 0.143315 1 0.148495 0 0.148495 1 0.151623 0 0.151623 1 0.154779 0 0.154779 1 0.160118 0 0.160118 1 0.165596 0 0.165596 1 0.172419 0 0.172419 1 0.179587 0 0.179587 1 0.188473 0 0.188473 1 0.199427 0 0.199427 1 0.208267 0 0.208267 1 0.21931 0 0.21931 1 0.233622 0 0.233622 1 0.245581 0 0.245581 1 0.255556 0 0.255556 1 0.263844 0 0.263844 1 0.271783 0 0.271783 1 0.276191 0 0.276191 1 0.281595 0 0.281595 1 0.287975 0 0.287975 1 0.293047 0 0.293047 1 0.297943 0 0.297943 1 0.30271 0 0.30271 1 0.3074 0 0.3074 1 0.312066 0 0.312066 1 0.316761 0 0.316761 1 0.321541 0 0.321541 1 0.325459 0 0.325459 1 0.330512 0 0.330512 1 0.336894 0 0.336894 1 0.342832 0 0.342832 1 0.345757 0 0.345757 1 0.349001 0 0.349001 1 0.354962 0 0.354962 1 0.360941 0 0.360941 1 0.364329 0 0.364329 1 0.367747 0 0.367747 1 0.394856 0 0.394856 1 0.427308 0 0.427308 1 0.483757 0 0.483757 1 0.502625 0 0.502625 1 0.521052 0 0.521052 1 0.539551 0 0.539551 1 0.557969 0 0.557969 1 0.57479 0 0.57479 1 0.588638 0 0.588638 1 0.599961 0 0.599961 1 0.610873 0 0.610873 1 0.621471 0 0.621471 1 0.631862 0 0.631862 1 0.640445 0 0.640445 1 0.650749 0 0.650749 1 0.659307 0 0.659307 1 0.66779 0 0.66779 1 0.676264 0 0.676264 1 0.6848 0 0.6848 1 0.695216 0 0.695216 1 0.705926 0 0.705926 1 0.717032 0 0.717032 1 0.728623 0 0.728623 1 0.740782 0 0.740782 1 0.755368 0 0.755368 1 0.769212 0 0.769212 1 0.780596 0 0.780596 1 0.79164 0 0.79164 1 0.80245 0 0.80245 1 0.813141 0 0.813141 1 0.823829 0 0.823829 1 0.83463 0 0.83463 1 0.845448 0 0.845448 1 0.856188 0 0.856188 1 0.866969 0 0.866969 1 0.877911 0 0.877911 1 0.889126 0 0.889126 1 0.900719 0 0.900719 1 0.91485 0 0.91485 1 0.929763 0 0.929763 1 0.952386 0 0.952386 1 0.973411 0 0.973411 1 0.985998 0 0.985998 1 0.0223132 0 0.0223132 1 0.0407439 0 0.0407439 1 0.0558644 0 0.0558644 1 0.0704927 0 0.0704927 1 0.0847677 0 0.0847677 1 0.0965033 0 0.0965033 1 0.10819 0 0.10819 1 0.115219 0 0.115219 1 0.12465 0 0.12465 1 0.138707 0 0.138707 1 0.150397 0 0.150397 1 0.164516 0 0.164516 1 0.178875 0 0.178875 1 0.193612 0 0.193612 1 0.208857 0 0.208857 1 0.22744 0 0.22744 1 0.238509 0 0.238509 1 0.249939 0 0.249939 1 0.272431 0 0.272431 1 0.291014 0 0.291014 1 0.306259 0 0.306259 1 0.320996 0 0.320996 1 0.335355 0 0.335355 1 0.349473 0 0.349473 1 0.361163 0 0.361163 1 0.375221 0 0.375221 1 0.386996 0 0.386996 1 0.398689 0 0.398689 1 0.410394 0 0.410394 1 0.424584 0 0.424584 1 0.439078 0 0.439078 1 0.45402 0 0.45402 1 0.472191 0 0.472191 1 0.485756 0 0.485756 1 0.499873 0 0.499873 1 0.522337 0 0.522337 1 0.54085 0 0.54085 1 0.556008 0 0.556008 1 0.570642 0 0.570642 1 0.584892 0 0.584892 1 0.596587 0 0.596587 1 0.608217 0 0.608217 1 0.615206 0 0.615206 1 0.624577 0 0.624577 1 0.63636 0 0.63636 1 0.648077 0 0.648077 1 0.659824 0 0.659824 1 0.674084 0 0.674084 1 0.68867 0 0.68867 1 0.70372 0 0.70372 1 0.722033 0 0.722033 1 0.735707 0 0.735707 1 0.749936 0 0.749936 1 0.772427 0 0.772427 1 0.791003 0 0.791003 1 0.806238 0 0.806238 1 0.820963 0 0.820963 1 0.835315 0 0.835315 1 0.847099 0 0.847099 1 0.858817 0 0.858817 1 0.865856 0 0.865856 1 0.875292 0 0.875292 1 0.886994 0 0.886994 1 0.898625 0 0.898625 1 0.910283 0 0.910283 1 0.922062 0 0.922062 1 0.936486 0 0.936486 1 0.951364 0 0.951364 1 0.966833 0 0.966833 1 0.983011 0 0.983011 1 0.0102388 0 0.0102388 1 0.0182166 0 0.0182166 1 0.0260774 0 0.0260774 1 0.0338871 0 0.0338871 1 0.0417185 0 0.0417185 1 0.0496353 0 0.0496353 1 0.0597552 0 0.0597552 1 0.0702285 0 0.0702285 1 0.0811644 0 0.0811644 1 0.0926521 0 0.0926521 1 0.104768 0 0.104768 1 0.122539 0 0.122539 1 0.140919 0 0.140919 1 0.162866 0 0.162866 1 0.188998 0 0.188998 1 0.216897 0 0.216897 1 0.250222 0 0.250222 1 0.286738 0 0.286738 1 0.317393 0 0.317393 1 0.343164 0 0.343164 1 0.364842 0 0.364842 1 0.380472 0 0.380472 1 0.395673 0 0.395673 1 0.410133 0 0.410133 1 0.423709 0 0.423709 1 0.434449 0 0.434449 1 0.444767 0 0.444767 1 0.452793 0 0.452793 1 0.460683 0 0.460683 1 0.468503 0 0.468503 1 0.476319 0 0.476319 1 0.484203 0 0.484203 1 0.492221 0 0.492221 1 0.50044 0 0.50044 1 0.510511 0 0.510511 1 0.518381 0 0.518381 1 0.526152 0 0.526152 1 0.533895 0 0.533895 1 0.541673 0 0.541673 1 0.549553 0 0.549553 1 0.559641 0 0.559641 1 0.570098 0 0.570098 1 0.581025 0 0.581025 1 0.59251 0 0.59251 1 0.604627 0 0.604627 1 0.622413 0 0.622413 1 0.643514 0 0.643514 1 0.66564 0 0.66564 1 0.691989 0 0.691989 1 0.720112 0 0.720112 1 0.750222 0 0.750222 1 0.786742 0 0.786742 1 0.817418 0 0.817418 1 0.843227 0 0.843227 1 0.864946 0 0.864946 1 0.880603 0 0.880603 1 0.895815 0 0.895815 1 0.910275 0 0.910275 1 0.923845 0 0.923845 1 0.934575 0 0.934575 1 0.94487 0 0.94487 1 0.954841 0 0.954841 1 0.962662 0 0.962662 1 0.970415 0 0.970415 1 0.978163 0 0.978163 1 0.985976 0 0.985976 1 0.991918 0 0.991918 1 0.0188983 0 0.0188983 1 0.0579303 0 0.0579303 1 0.0712703 0 0.0712703 1 0.0846101 0 0.0846101 1 0.157239 0 0.157239 1 0.170579 0 0.170579 1 0.183919 0 0.183919 1 0.234191 0 0.234191 1 0.247531 0 0.247531 1 0.25877 0 0.25877 1 0.312995 0 0.312995 1 0.319627 0 0.319627 1 0.32453 0 0.32453 1 0.326961 0 0.326961 1 0.32957 0 0.32957 1 0.33201 0 0.33201 1 0.334313 0 0.334313 1 0.336264 0 0.336264 1 0.338144 0 0.338144 1 0.33997 0 0.33997 1 0.34176 0 0.34176 1 0.343319 0 0.343319 1 0.344582 0 0.344582 1 0.345787 0 0.345787 1 0.346755 0 0.346755 1 0.347699 0 0.347699 1 0.348626 0 0.348626 1 0.349363 0 0.349363 1 0.350101 0 0.350101 1 0.350846 0 0.350846 1 0.351603 0 0.351603 1 0.352773 0 0.352773 1 0.354001 0 0.354001 1 0.355519 0 0.355519 1 0.357147 0 0.357147 1 0.359159 0 0.359159 1 0.361351 0 0.361351 1 0.363739 0 0.363739 1 0.417346 0 0.417346 1 0.428463 0 0.428463 1 0.441803 0 0.441803 1 0.489727 0 0.489727 1 0.503067 0 0.503067 1 0.51406 0 0.51406 1 0.568285 0 0.568285 1 0.574168 0 0.574168 1 0.578801 0 0.578801 1 0.58187 0 0.58187 1 0.584776 0 0.584776 1 0.587216 0 0.587216 1 0.589518 0 0.589518 1 0.59147 0 0.59147 1 0.59335 0 0.59335 1 0.595176 0 0.595176 1 0.596966 0 0.596966 1 0.598518 0 0.598518 1 0.599769 0 0.599769 1 0.600766 0 0.600766 1 0.601729 0 0.601729 1 0.602668 0 0.602668 1 0.603595 0 0.603595 1 0.604519 0 0.604519 1 0.605452 0 0.605452 1 0.606021 0 0.606021 1 0.606793 0 0.606793 1 0.607964 0 0.607964 1 0.609191 0 0.609191 1 0.61071 0 0.61071 1 0.612337 0 0.612337 1 0.61435 0 0.61435 1 0.616542 0 0.616542 1 0.618929 0 0.618929 1 0.672536 0 0.672536 1 0.683653 0 0.683653 1 0.696993 0 0.696993 1 0.747265 0 0.747265 1 0.760605 0 0.760605 1 0.773945 0 0.773945 1 0.833605 0 0.833605 1 0.838517 0 0.838517 1 0.842535 0 0.842535 1 0.84581 0 0.84581 1 0.848462 0 0.848462 1 0.850993 0 0.850993 1 0.853027 0 0.853027 1 0.854617 0 0.854617 1 0.856572 0 0.856572 1 0.858482 0 0.858482 1 0.860398 0 0.860398 1 0.862341 0 0.862341 1 0.864328 0 0.864328 1 0.866377 0 0.866377 1 0.86894 0 0.86894 1 0.87164 0 0.87164 1 0.874497 0 0.874497 1 0.878053 0 0.878053 1 0.881544 0 0.881544 1 0.884599 0 0.884599 1 0.887636 0 0.887636 1 0.890686 0 0.890686 1 0.893779 0 0.893779 1 0.897345 0 0.897345 1 0.901003 0 0.901003 1 0.905245 0 0.905245 1 0.910161 0 0.910161 1 0.914882 0 0.914882 1 0.919864 0 0.919864 1 0.92147 0 0.92147 1 0.925205 0 0.925205 1 0.928314 0 0.928314 1 0.930893 0 0.930893 1 0.933016 0 0.933016 1 0.935077 0 0.935077 1 0.937093 0 0.937093 1 0.938424 0 0.938424 1 0.939752 0 0.939752 1 0.94141 0 0.94141 1 0.943419 0 0.943419 1 0.945469 0 0.945469 1 0.947579 0 0.947579 1 0.950139 0 0.950139 1 0.952828 0 0.952828 1 0.955249 0 0.955249 1 0.958224 0 0.958224 1 0.961289 0 0.961289 1 0.964331 0 0.964331 1 0.967366 0 0.967366 1 0.970412 0 0.970412 1 0.973486 0 0.973486 1 0.975432 0 0.975432 1 0.977402 0 0.977402 1 0.981061 0 0.981061 1 0.985307 0 0.985307 1 0.990237 0 0.990237 1 0.994982 0 0.994982 1</float_array>
                                <technique_common>
                                    <accessor count="1786" source="#ID17" stride="2">
                                        <param name="S" type="float"/>
                                        <param name="T" type="float"/>
                                    </accessor>
                                </technique_common>
                            </source>
                            <vertices id="ID18">
                                <input semantic="POSITION" source="#ID12"/>
                            </vertices>
                            <polylist count="2852" material="Material1">
                                <input offset="0" semantic="VERTEX" source="#ID18"/>
                                <input offset="1" semantic="NORMAL" source="#ID14"/>
                                <input offset="2" semantic="TEXCOORD" source="#ID16" set="0"/>
                                <vcount>3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3</vcount>
                                <p>911 2 2 1 1 1 0 0 0 912 4 4 2 3 3 1 1 1 913 6 6 3 5 5 2 3 3 914 8 8 4 7 7 3 5 5 915 10 10 5 9 9 4 7 7 916 12 12 6 11 11 5 9 9 917 14 14 7 13 13 6 11 11 918 16 16 8 15 15 7 13 13 919 18 18 9 17 17 8 15 15 920 20 20 10 19 19 9 17 17 921 22 22 11 21 21 10 19 19 922 24 24 12 23 23 11 21 21 923 26 26 13 25 25 12 23 23 924 28 28 14 27 27 13 25 25 925 30 30 15 29 29 14 27 27 926 32 32 16 31 31 15 29 29 927 34 34 17 33 33 16 31 31 928 36 36 18 35 35 17 33 33 929 38 38 19 37 37 18 35 35 930 40 40 20 39 39 19 37 37 931 42 42 21 41 41 20 39 39 932 44 44 22 43 43 21 41 41 933 46 46 23 45 45 22 43 43 934 48 48 24 47 47 23 45 45 935 50 50 25 49 49 24 47 47 936 52 52 26 51 51 25 49 49 937 54 54 27 53 53 26 51 51 938 56 56 28 55 55 27 53 53 939 58 58 29 57 57 28 55 55 940 60 60 30 59 59 29 57 57 941 62 62 31 61 61 30 59 59 942 64 64 32 63 63 31 61 61 943 66 66 33 65 65 32 63 63 944 68 68 34 67 67 33 65 65 945 70 70 35 69 69 34 67 67 946 72 72 36 71 71 35 69 69 947 74 74 37 73 73 36 71 71 948 76 76 38 75 75 37 73 73 949 12 78 39 11 77 38 75 75 950 14 80 40 13 79 39 11 77 951 16 82 41 15 81 40 13 79 952 18 84 42 17 83 41 15 81 953 78 86 43 77 85 42 17 83 954 80 88 44 79 87 43 77 85 955 82 90 45 81 89 44 79 87 956 84 92 46 83 91 45 81 89 957 86 94 47 85 93 46 83 91 958 88 96 48 87 95 47 85 93 959 90 98 49 89 97 48 87 95 960 92 100 50 91 99 49 89 97 961 94 102 51 93 101 50 91 99 962 96 104 52 95 103 51 93 101 963 98 106 53 97 105 52 95 103 964 100 108 54 99 107 53 97 105 965 102 110 55 101 109 54 99 107 966 104 112 56 103 111 55 101 109 967 106 114 57 105 113 56 103 111 968 108 116 58 107 115 57 105 113 969 110 118 59 109 117 58 107 115 970 112 120 60 111 119 59 109 117 971 114 122 61 113 121 60 111 119 972 116 124 62 115 123 61 113 121 973 118 126 63 117 125 62 115 123 974 120 128 64 119 127 63 117 125 975 122 130 65 121 129 64 119 127 976 124 132 66 123 131 65 121 129 977 126 134 67 125 133 66 123 131 978 128 136 68 127 135 67 125 133 979 130 138 69 129 137 68 127 135 980 132 140 70 131 139 69 129 137 981 76 142 71 75 141 70 131 139 982 12 144 72 11 143 71 75 141 983 14 146 73 13 145 72 11 143 984 16 148 74 15 147 73 13 145 985 18 150 75 17 149 74 15 147 986 78 152 76 77 151 75 17 149 987 134 154 77 133 153 76 77 151 988 136 156 78 135 155 77 133 153 989 138 158 79 137 157 78 135 155 990 140 160 80 139 159 79 137 157 991 142 162 81 141 161 80 139 159 992 144 164 82 143 163 81 141 161 993 146 166 83 145 165 82 143 163 994 148 168 84 147 167 83 145 165 995 150 170 85 149 169 84 147 167 996 152 172 86 151 171 85 149 169 997 154 174 87 153 173 86 151 171 998 156 176 88 155 175 87 153 173 999 158 178 89 157 177 88 155 175 1000 160 180 90 159 179 89 157 177 1001 162 182 91 161 181 90 159 179 1002 164 184 92 163 183 91 161 181 1003 166 186 93 165 185 92 163 183 1004 168 188 94 167 187 93 165 185 1005 170 190 95 169 189 94 167 187 1006 172 192 96 171 191 95 169 189 1007 174 194 97 173 193 96 171 191 1008 176 196 98 175 195 97 173 193 1009 178 198 99 177 197 98 175 195 1010 180 200 100 179 199 99 177 197 1011 182 202 101 181 201 100 179 199 1012 184 204 102 183 203 101 181 201 1013 186 206 103 185 205 102 183 203 1014 188 208 104 187 207 103 185 205 1015 190 210 105 189 209 104 187 207 1016 192 212 106 191 211 105 189 209 1017 194 214 107 193 213 106 191 211 1018 196 216 108 195 215 107 193 213 1019 198 218 109 197 217 108 195 215 1020 200 220 110 199 219 109 197 217 1021 202 222 111 201 221 110 199 219 1022 204 224 112 203 223 111 201 221 1023 206 226 113 205 225 112 203 223 1024 208 228 114 207 227 113 205 225 1025 210 230 115 209 229 114 207 227 1026 212 232 116 211 231 115 209 229 1027 214 234 117 213 233 116 211 231 1028 216 236 118 215 235 117 213 233 1029 218 238 119 217 237 118 215 235 1030 220 240 120 219 239 119 217 237 1031 222 242 121 221 241 120 219 239 1032 224 244 122 223 243 121 221 241 1033 226 246 123 225 245 122 223 243 1034 228 248 124 227 247 123 225 245 1035 230 250 125 229 249 124 227 247 1036 232 252 126 231 251 125 229 249 1037 234 254 127 233 253 126 231 251 1038 236 256 128 235 255 127 233 253 1039 238 258 129 237 257 128 235 255 1040 240 260 130 239 259 129 237 257 1041 242 262 131 241 261 130 239 259 1042 244 264 132 243 263 131 241 261 910 245 266 0 0 265 132 243 263 1044 248 268 134 247 267 133 246 0 1045 250 270 135 249 269 134 247 267 1046 252 272 136 251 271 135 249 269 1043 253 266 133 246 265 136 251 271 1048 4 274 138 3 273 137 1 0 1049 6 276 139 5 275 138 3 273 1050 255 278 140 254 277 139 5 275 1051 76 280 141 75 279 140 254 277 1052 12 282 142 11 281 141 75 279 1053 14 284 143 13 283 142 11 281 1054 16 286 144 15 285 143 13 283 1055 18 288 145 17 287 144 15 285 1056 78 290 146 77 289 145 17 287 1047 2 266 137 1 265 146 77 289 1058 2 292 148 1 291 147 256 0 1059 4 294 149 3 293 148 1 291 1060 6 296 150 5 295 149 3 293 1061 8 298 151 7 297 150 5 295 1062 10 300 152 9 299 151 7 297 1063 12 302 153 11 301 152 9 299 1064 14 304 154 13 303 153 11 301 1065 16 306 155 15 305 154 13 303 1066 18 308 156 17 307 155 15 305 1067 20 310 157 19 309 156 17 307 1068 258 312 158 257 311 157 19 309 1069 260 314 159 259 313 158 257 311 1070 262 316 160 261 315 159 259 313 1071 264 318 161 263 317 160 261 315 1072 266 320 162 265 319 161 263 317 1073 268 322 163 267 321 162 265 319 1074 270 324 164 269 323 163 267 321 1075 272 326 165 271 325 164 269 323 1076 274 328 166 273 327 165 271 325 1077 276 330 167 275 329 166 273 327 1078 278 332 168 277 331 167 275 329 1079 280 334 169 279 333 168 277 331 1080 282 336 170 281 335 169 279 333 1081 284 338 171 283 337 170 281 335 1082 286 340 172 285 339 171 283 337 1083 288 342 173 287 341 172 285 339 1084 290 344 174 289 343 173 287 341 1085 292 346 175 291 345 174 289 343 1086 294 348 176 293 347 175 291 345 1087 296 350 177 295 349 176 293 347 1088 298 352 178 297 351 177 295 349 1089 300 354 179 299 353 178 297 351 1090 302 356 180 301 355 179 299 353 1091 304 358 181 303 357 180 301 355 1092 306 360 182 305 359 181 303 357 1093 308 362 183 307 361 182 305 359 1094 310 364 184 309 363 183 307 361 1095 312 366 185 311 365 184 309 363 1096 10 368 186 9 367 185 311 365 1097 12 370 187 11 369 186 9 367 1098 314 372 188 313 371 187 11 369 1099 316 374 189 315 373 188 313 371 1100 18 376 190 17 375 189 315 373 1101 318 378 191 317 377 190 17 375 1102 320 380 192 319 379 191 317 377 1103 322 382 193 321 381 192 319 379 1104 324 384 194 323 383 193 321 381 1105 326 386 195 325 385 194 323 383 1106 328 388 196 327 387 195 325 385 1107 330 390 197 329 389 196 327 387 1108 332 392 198 331 391 197 329 389 1109 334 394 199 333 393 198 331 391 1110 336 396 200 335 395 199 333 393 1111 338 398 201 337 397 200 335 395 1112 340 400 202 339 399 201 337 397 1113 342 402 203 341 401 202 339 399 1114 344 404 204 343 403 203 341 401 1115 346 406 205 345 405 204 343 403 1116 348 408 206 347 407 205 345 405 1117 350 410 207 349 409 206 347 407 1118 352 412 208 351 411 207 349 409 1119 354 414 209 353 413 208 351 411 1120 356 416 210 355 415 209 353 413 1121 358 418 211 357 417 210 355 415 1122 360 420 212 359 419 211 357 417 1123 362 422 213 361 421 212 359 419 1124 364 424 214 363 423 213 361 421 1125 366 426 215 365 425 214 363 423 1126 368 428 216 367 427 215 365 425 1127 370 430 217 369 429 216 367 427 1128 372 432 218 371 431 217 369 429 1129 374 434 219 373 433 218 371 431 1130 376 436 220 375 435 219 373 433 1057 377 266 147 256 265 220 375 435 1132 380 438 222 379 437 221 378 0 1133 2 270 223 1 269 222 379 437 1134 382 440 224 381 439 223 1 269 1131 383 266 221 378 265 224 381 439 1136 4 442 226 3 441 225 1 0 1137 6 444 227 5 443 226 3 441 1138 255 446 228 254 445 227 5 443 1139 76 448 229 75 447 228 254 445 1140 12 450 230 11 449 229 75 447 1141 14 452 231 13 451 230 11 449 1142 16 286 232 15 285 231 13 451 1143 18 288 233 17 287 232 15 285 1144 78 290 234 77 289 233 17 287 1135 2 266 225 1 265 234 77 289 1339 768 836 429 767 835 428 766 0 1340 770 838 430 769 837 429 767 835 1341 772 840 431 771 839 430 769 837 1342 774 842 432 773 841 431 771 839 1343 776 844 433 775 843 432 773 841 1344 778 846 434 777 845 433 775 843 1345 780 848 435 779 847 434 777 845 1346 782 850 436 781 849 435 779 847 1347 784 852 437 783 851 436 781 849 1348 786 854 438 785 853 437 783 851 1349 788 856 439 787 855 438 785 853 1350 790 858 440 789 857 439 787 855 1351 792 860 441 791 859 440 789 857 1352 794 862 442 793 861 441 791 859 1353 796 864 443 795 863 442 793 861 1354 798 866 444 797 865 443 795 863 1355 800 868 445 799 867 444 797 865 1356 802 870 446 801 869 445 799 867 1357 804 872 447 803 871 446 801 869 1358 806 874 448 805 873 447 803 871 1359 808 876 449 807 875 448 805 873 1360 810 878 450 809 877 449 807 875 1361 812 880 451 811 879 450 809 877 1362 814 882 452 813 881 451 811 879 1363 816 884 453 815 883 452 813 881 1364 818 886 454 817 885 453 815 883 1365 820 888 455 819 887 454 817 885 1366 822 890 456 821 889 455 819 887 1367 824 892 457 823 891 456 821 889 1368 826 894 458 825 893 457 823 891 1369 828 896 459 827 895 458 825 893 1370 830 898 460 829 897 459 827 895 1371 832 900 461 831 899 460 829 897 1372 834 902 462 833 901 461 831 899 1373 836 904 463 835 903 462 833 901 1374 838 906 464 837 905 463 835 903 1375 840 908 465 839 907 464 837 905 1376 842 910 466 841 909 465 839 907 1377 844 912 467 843 911 466 841 909 1378 846 914 468 845 913 467 843 911 1379 848 916 469 847 915 468 845 913 1380 850 918 470 849 917 469 847 915 1381 852 920 471 851 919 470 849 917 1382 854 922 472 853 921 471 851 919 1383 856 924 473 855 923 472 853 921 1384 858 926 474 857 925 473 855 923 1385 860 928 475 859 927 474 857 925 1386 862 930 476 861 929 475 859 927 1387 864 932 477 863 931 476 861 929 1388 866 934 478 865 933 477 863 931 1389 868 936 479 867 935 478 865 933 1390 870 938 480 869 937 479 867 935 1391 872 940 481 871 939 480 869 937 1392 874 942 482 873 941 481 871 939 1393 876 944 483 875 943 482 873 941 1394 878 946 484 877 945 483 875 943 1395 880 948 485 879 947 484 877 945 1396 882 950 486 881 949 485 879 947 1397 884 952 487 883 951 486 881 949 1398 886 954 488 885 953 487 883 951 1399 888 956 489 887 955 488 885 953 1400 890 958 490 889 957 489 887 955 1401 892 960 491 891 959 490 889 957 1402 894 962 492 893 961 491 891 959 1403 896 964 493 895 963 492 893 961 1404 898 966 494 897 965 493 895 963 1405 900 968 495 899 967 494 897 965 1406 902 970 496 901 969 495 899 967 1407 904 972 497 903 971 496 901 969 1408 906 974 498 905 973 497 903 971 1409 908 976 499 907 975 498 905 973 1410 910 978 500 909 977 499 907 975 1411 912 980 501 911 979 500 909 977 1412 914 982 502 913 981 501 911 979 1413 916 984 503 915 983 502 913 981 1414 918 986 504 917 985 503 915 983 1415 920 988 505 919 987 504 917 985 1416 922 990 506 921 989 505 919 987 1417 924 992 507 923 991 506 921 989 1418 926 994 508 925 993 507 923 991 1419 928 996 509 927 995 508 925 993 1420 930 998 510 929 997 509 927 995 1421 932 1000 511 931 999 510 929 997 1422 934 1002 512 933 1001 511 931 999 1423 936 1004 513 935 1003 512 933 1001 1424 938 1006 514 937 1005 513 935 1003 1425 940 1008 515 939 1007 514 937 1005 1426 942 1010 516 941 1009 515 939 1007 1427 944 1012 517 943 1011 516 941 1009 1428 946 1014 518 945 1013 517 943 1011 1429 948 1016 519 947 1015 518 945 1013 1430 950 1018 520 949 1017 519 947 1015 1431 952 1020 521 951 1019 520 949 1017 1432 954 1022 522 953 1021 521 951 1019 1433 956 1024 523 955 1023 522 953 1021 1434 958 1026 524 957 1025 523 955 1023 1435 960 1028 525 959 1027 524 957 1025 1436 962 1030 526 961 1029 525 959 1027 1437 964 1032 527 963 1031 526 961 1029 1438 966 1034 528 965 1033 527 963 1031 1439 968 1036 529 967 1035 528 965 1033 1440 970 1038 530 969 1037 529 967 1035 1441 972 1040 531 971 1039 530 969 1037 1442 974 1042 532 973 1041 531 971 1039 1443 976 1044 533 975 1043 532 973 1041 1444 978 1046 534 977 1045 533 975 1043 1445 980 1048 535 979 1047 534 977 1045 1446 982 1050 536 981 1049 535 979 1047 1447 984 1052 537 983 1051 536 981 1049 1338 985 266 428 766 265 537 983 1051 1449 988 1054 1448 987 1053 538 986 0 1450 990 270 1449 988 1054 539 989 1055 1451 992 1056 1450 990 270 540 991 269 1448 987 266 1451 992 1056 541 993 1057 1453 996 1058 1452 995 1053 542 994 0 1454 998 1060 1453 996 1058 543 997 1059 1455 1000 1062 1454 998 1060 544 999 1061 1456 1002 1064 1455 1000 1062 545 1001 1063 1457 1004 1066 1456 1002 1064 546 1003 1065 1458 1006 1068 1457 1004 1066 547 1005 1067 1459 1008 1070 1458 1006 1068 548 1007 1069 1460 1010 1072 1459 1008 1070 549 1009 1071 1461 1012 1074 1460 1010 1072 550 1011 1073 1462 1014 1076 1461 1012 1074 551 1013 1075 1463 1016 1078 1462 1014 1076 552 1015 1077 1464 1018 1080 1463 1016 1078 553 1017 1079 1465 1020 1082 1464 1018 1080 554 1019 1081 1466 1022 1084 1465 1020 1082 555 1021 1083 1467 1024 1086 1466 1022 1084 556 1023 1085 1468 1026 1088 1467 1024 1086 557 1025 1087 1469 1028 1090 1468 1026 1088 558 1027 1089 1470 1030 1092 1469 1028 1090 559 1029 1091 1471 1032 1094 1470 1030 1092 560 1031 1093 1472 1034 1096 1471 1032 1094 561 1033 1095 1473 1036 1098 1472 1034 1096 562 1035 1097 1474 1038 1100 1473 1036 1098 563 1037 1099 1475 1040 1102 1474 1038 1100 564 1039 1101 1476 1042 1104 1475 1040 1102 565 1041 1103 1477 1044 1106 1476 1042 1104 566 1043 1105 1478 1046 1108 1477 1044 1106 567 1045 1107 1479 1048 1110 1478 1046 1108 568 1047 1109 1480 1050 1112 1479 1048 1110 569 1049 1111 1481 1052 1114 1480 1050 1112 570 1051 1113 1482 1054 1116 1481 1052 1114 571 1053 1115 1483 1056 1118 1482 1054 1116 572 1055 1117 1484 1058 1120 1483 1056 1118 573 1057 1119 1485 1060 1122 1484 1058 1120 574 1059 1121 1486 1062 1124 1485 1060 1122 575 1061 1123 1487 1064 1126 1486 1062 1124 576 1063 1125 1488 1066 1128 1487 1064 1126 577 1065 1127 1489 1068 1130 1488 1066 1128 578 1067 1129 1490 1070 1132 1489 1068 1130 579 1069 1131 1491 1072 1134 1490 1070 1132 580 1071 1133 1492 1074 1136 1491 1072 1134 581 1073 1135 1493 1076 1138 1492 1074 1136 582 1075 1137 1494 1078 1140 1493 1076 1138 583 1077 1139 1495 1080 1142 1494 1078 1140 584 1079 1141 1496 1082 1144 1495 1080 1142 585 1081 1143 1497 1084 1146 1496 1082 1144 586 1083 1145 1498 1086 1148 1497 1084 1146 587 1085 1147 1499 1088 1150 1498 1086 1148 588 1087 1149 1500 1090 1152 1499 1088 1150 589 1089 1151 1501 1092 1154 1500 1090 1152 590 1091 1153 1502 1094 1156 1501 1092 1154 591 1093 1155 1503 1096 1158 1502 1094 1156 592 1095 1157 1504 1098 1160 1503 1096 1158 593 1097 1159 1505 1100 1162 1504 1098 1160 594 1099 1161 1506 1102 1164 1505 1100 1162 595 1101 1163 1507 1104 1166 1506 1102 1164 596 1103 1165 1508 1106 1168 1507 1104 1166 597 1105 1167 1509 1108 1170 1508 1106 1168 598 1107 1169 1510 1110 1172 1509 1108 1170 599 1109 1171 1511 1112 1174 1510 1110 1172 600 1111 1173 1512 1114 1176 1511 1112 1174 601 1113 1175 1513 1116 1178 1512 1114 1176 602 1115 1177 1514 1118 1180 1513 1116 1178 603 1117 1179 1515 1120 1182 1514 1118 1180 604 1119 1181 1516 1122 1184 1515 1120 1182 605 1121 1183 1517 1124 1186 1516 1122 1184 606 1123 1185 1518 1126 1188 1517 1124 1186 607 1125 1187 1519 1128 1190 1518 1126 1188 608 1127 1189 1520 1130 1192 1519 1128 1190 609 1129 1191 1521 1132 1194 1520 1130 1192 610 1131 1193 1522 1134 1196 1521 1132 1194 611 1133 1195 1523 1136 1198 1522 1134 1196 612 1135 1197 1524 1138 1200 1523 1136 1198 613 1137 1199 1525 1140 1202 1524 1138 1200 614 1139 1201 1526 1142 1204 1525 1140 1202 615 1141 1203 1527 1144 1206 1526 1142 1204 616 1143 1205 1528 1146 1208 1527 1144 1206 617 1145 1207 1529 1148 1210 1528 1146 1208 618 1147 1209 1530 1150 1212 1529 1148 1210 619 1149 1211 1531 1152 1214 1530 1150 1212 620 1151 1213 1532 1154 1216 1531 1152 1214 621 1153 1215 1533 1156 1218 1532 1154 1216 622 1155 1217 1534 1158 1220 1533 1156 1218 623 1157 1219 1535 1160 1222 1534 1158 1220 624 1159 1221 1536 1162 1224 1535 1160 1222 625 1161 1223 1537 1164 1226 1536 1162 1224 626 1163 1225 1538 1166 1228 1537 1164 1226 627 1165 1227 1539 1168 1230 1538 1166 1228 628 1167 1229 1540 1170 1232 1539 1168 1230 629 1169 1231 1541 1172 1234 1540 1170 1232 630 1171 1233 1542 1174 1236 1541 1172 1234 631 1173 1235 1543 1176 1238 1542 1174 1236 632 1175 1237 1544 1178 1240 1543 1176 1238 633 1177 1239 1452 995 266 1544 1178 1240 634 1179 1241 1546 1182 1242 1545 1181 1053 635 1180 0 1547 1184 1244 1546 1182 1242 636 1183 1243 1548 1186 1246 1547 1184 1244 637 1185 1245 1549 1188 1248 1548 1186 1246 638 1187 1247 1550 1190 1250 1549 1188 1248 639 1189 1249 1551 1192 1252 1550 1190 1250 640 1191 1251 1552 1194 1254 1551 1192 1252 641 1193 1253 1553 1196 1256 1552 1194 1254 642 1195 1255 1554 1198 1258 1553 1196 1256 643 1197 1257 1555 1200 1260 1554 1198 1258 644 1199 1259 1556 1202 1262 1555 1200 1260 645 1201 1261 1557 1204 1264 1556 1202 1262 646 1203 1263 1558 1206 1266 1557 1204 1264 647 1205 1265 1559 1208 1268 1558 1206 1266 648 1207 1267 1560 1210 1270 1559 1208 1268 649 1209 1269 1561 1212 1272 1560 1210 1270 650 1211 1271 1562 1214 1274 1561 1212 1272 651 1213 1273 1563 1216 1276 1562 1214 1274 652 1215 1275 1564 1218 1278 1563 1216 1276 653 1217 1277 1565 1220 1280 1564 1218 1278 654 1219 1279 1566 1222 1282 1565 1220 1280 655 1221 1281 1567 1224 1284 1566 1222 1282 656 1223 1283 1568 1226 1286 1567 1224 1284 657 1225 1285 1569 1228 1288 1568 1226 1286 658 1227 1287 1570 1230 1290 1569 1228 1288 659 1229 1289 1571 1232 1292 1570 1230 1290 660 1231 1291 1572 1234 1294 1571 1232 1292 661 1233 1293 1573 1236 1296 1572 1234 1294 662 1235 1295 1574 1238 1298 1573 1236 1296 663 1237 1297 1575 1240 1300 1574 1238 1298 664 1239 1299 1576 1242 1302 1575 1240 1300 665 1241 1301 1577 1244 1304 1576 1242 1302 666 1243 1303 1578 1246 1306 1577 1244 1304 667 1245 1305 1579 1248 1308 1578 1246 1306 668 1247 1307 1580 1250 1310 1579 1248 1308 669 1249 1309 1581 1252 1312 1580 1250 1310 670 1251 1311 1582 1254 1314 1581 1252 1312 671 1253 1313 1583 1256 1316 1582 1254 1314 672 1255 1315 1584 1258 1318 1583 1256 1316 673 1257 1317 1585 1260 1320 1584 1258 1318 674 1259 1319 1586 1262 1322 1585 1260 1320 675 1261 1321 1587 1264 1324 1586 1262 1322 676 1263 1323 1588 1266 1326 1587 1264 1324 677 1265 1325 1589 1268 1328 1588 1266 1326 678 1267 1327 1590 1270 1330 1589 1268 1328 679 1269 1329 1591 1272 1332 1590 1270 1330 680 1271 1331 1592 1274 1334 1591 1272 1332 681 1273 1333 1593 1276 1336 1592 1274 1334 682 1275 1335 1594 1278 1338 1593 1276 1336 683 1277 1337 1595 1280 1340 1594 1278 1338 684 1279 1339 1596 1282 1342 1595 1280 1340 685 1281 1341 1597 1284 1344 1596 1282 1342 686 1283 1343 1598 1286 1346 1597 1284 1344 687 1285 1345 1599 1288 1348 1598 1286 1346 688 1287 1347 1600 1290 1350 1599 1288 1348 689 1289 1349 1601 1292 1352 1600 1290 1350 690 1291 1351 1602 1294 1354 1601 1292 1352 691 1293 1353 1603 1296 1356 1602 1294 1354 692 1295 1355 1604 1298 1358 1603 1296 1356 693 1297 1357 1605 1300 1360 1604 1298 1358 694 1299 1359 1606 1302 1362 1605 1300 1360 695 1301 1361 1607 1304 1364 1606 1302 1362 696 1303 1363 1608 1306 1366 1607 1304 1364 697 1305 1365 1609 1308 1368 1608 1306 1366 698 1307 1367 1610 1310 1370 1609 1308 1368 699 1309 1369 1611 1312 1372 1610 1310 1370 700 1311 1371 1612 1314 1374 1611 1312 1372 701 1313 1373 1613 1316 1376 1612 1314 1374 702 1315 1375 1614 1318 1378 1613 1316 1376 703 1317 1377 1615 1320 1380 1614 1318 1378 704 1319 1379 1545 1181 266 1615 1320 1380 705 1321 1381 1617 1324 1382 1616 1323 1053 706 1322 0 1618 1326 1384 1617 1324 1382 707 1325 1383 1619 1328 1386 1618 1326 1384 708 1327 1385 1620 1330 1388 1619 1328 1386 709 1329 1387 1621 1332 1390 1620 1330 1388 710 1331 1389 1622 1334 1392 1621 1332 1390 711 1333 1391 1623 1336 1394 1622 1334 1392 712 1335 1393 1624 1338 1396 1623 1336 1394 713 1337 1395 1625 1340 1398 1624 1338 1396 714 1339 1397 1626 1342 1400 1625 1340 1398 715 1341 1399 1627 1344 1402 1626 1342 1400 716 1343 1401 1628 1346 1404 1627 1344 1402 717 1345 1403 1629 1348 1406 1628 1346 1404 718 1347 1405 1630 1350 1408 1629 1348 1406 719 1349 1407 1631 1352 1410 1630 1350 1408 720 1351 1409 1632 1354 1412 1631 1352 1410 721 1353 1411 1633 1356 1414 1632 1354 1412 722 1355 1413 1634 1358 1416 1633 1356 1414 723 1357 1415 1635 1360 1418 1634 1358 1416 724 1359 1417 1636 1362 1420 1635 1360 1418 725 1361 1419 1637 1364 1422 1636 1362 1420 726 1363 1421 1638 1366 1424 1637 1364 1422 727 1365 1423 1639 1368 1426 1638 1366 1424 728 1367 1425 1640 1370 1428 1639 1368 1426 729 1369 1427 1641 1372 1430 1640 1370 1428 730 1371 1429 1642 1374 1432 1641 1372 1430 731 1373 1431 1643 1376 1434 1642 1374 1432 732 1375 1433 1644 1378 1436 1643 1376 1434 733 1377 1435 1645 1380 1438 1644 1378 1436 734 1379 1437 1646 1382 1440 1645 1380 1438 735 1381 1439 1647 1384 1442 1646 1382 1440 736 1383 1441 1648 1386 1444 1647 1384 1442 737 1385 1443 1649 1388 1446 1648 1386 1444 738 1387 1445 1650 1390 1448 1649 1388 1446 739 1389 1447 1651 1392 1450 1650 1390 1448 740 1391 1449 1652 1394 1452 1651 1392 1450 741 1393 1451 1653 1396 1454 1652 1394 1452 742 1395 1453 1654 1398 1456 1653 1396 1454 743 1397 1455 1655 1400 1458 1654 1398 1456 744 1399 1457 1656 1402 1460 1655 1400 1458 745 1401 1459 1657 1404 1462 1656 1402 1460 746 1403 1461 1658 1406 1464 1657 1404 1462 747 1405 1463 1659 1408 1466 1658 1406 1464 748 1407 1465 1660 1410 1468 1659 1408 1466 749 1409 1467 1661 1412 1470 1660 1410 1468 750 1411 1469 1662 1414 1472 1661 1412 1470 751 1413 1471 1663 1416 1474 1662 1414 1472 752 1415 1473 1664 1418 1476 1663 1416 1474 753 1417 1475 1665 1420 1478 1664 1418 1476 754 1419 1477 1666 1422 1480 1665 1420 1478 755 1421 1479 1667 1424 1482 1666 1422 1480 756 1423 1481 1668 1426 1484 1667 1424 1482 757 1425 1483 1669 1428 1486 1668 1426 1484 758 1427 1485 1670 1430 1488 1669 1428 1486 759 1429 1487 1671 1432 1490 1670 1430 1488 760 1431 1489 1672 1434 1492 1671 1432 1490 761 1433 1491 1673 1436 1494 1672 1434 1492 762 1435 1493 1674 1438 1496 1673 1436 1494 763 1437 1495 1675 1440 1498 1674 1438 1496 764 1439 1497 1676 1442 1500 1675 1440 1498 765 1441 1499 1677 1444 1502 1676 1442 1500 766 1443 1501 1678 1446 1504 1677 1444 1502 767 1445 1503 1679 1448 1506 1678 1446 1504 768 1447 1505 1680 1450 1508 1679 1448 1506 769 1449 1507 1681 1452 1510 1680 1450 1508 770 1451 1509 1682 1454 1512 1681 1452 1510 771 1453 1511 1683 1456 1514 1682 1454 1512 772 1455 1513 1616 1323 266 1683 1456 1514 773 1457 1515 1685 1460 1516 1684 1459 1053 774 1458 0 1686 1462 1518 1685 1460 1516 775 1461 1517 1687 1464 1520 1686 1462 1518 776 1463 1519 1688 1466 1522 1687 1464 1520 777 1465 1521 1689 578 1524 1688 1466 1522 778 1467 1523 1690 1468 1526 1689 578 1524 779 577 1525 1691 1470 1528 1690 1468 1526 780 1469 1527 1692 1472 1530 1691 1470 1528 781 1471 1529 1693 1474 1532 1692 1472 1530 782 1473 1531 1694 1476 1534 1693 1474 1532 783 1475 1533 1695 1478 1536 1694 1476 1534 784 1477 1535 1696 1480 1538 1695 1478 1536 785 1479 1537 1697 1482 1540 1696 1480 1538 786 1481 1539 1698 1484 1542 1697 1482 1540 787 1483 1541 1699 1486 1544 1698 1484 1542 788 1485 1543 1700 1488 1546 1699 1486 1544 789 1487 1545 1701 1490 1548 1700 1488 1546 790 1489 1547 1702 1492 1550 1701 1490 1548 791 1491 1549 1703 1494 1552 1702 1492 1550 792 1493 1551 1704 1496 1554 1703 1494 1552 793 1495 1553 1705 1498 1556 1704 1496 1554 794 1497 1555 1706 1500 1558 1705 1498 1556 795 1499 1557 1707 1502 1560 1706 1500 1558 796 1501 1559 1708 1504 1562 1707 1502 1560 797 1503 1561 1709 1506 1564 1708 1504 1562 798 1505 1563 1710 1508 1566 1709 1506 1564 799 1507 1565 1711 1510 1568 1710 1508 1566 800 1509 1567 1712 1512 1570 1711 1510 1568 801 1511 1569 1713 1514 1572 1712 1512 1570 802 1513 1571 1714 1516 1574 1713 1514 1572 803 1515 1573 1715 1518 1576 1714 1516 1574 804 1517 1575 1716 1520 1578 1715 1518 1576 805 1519 1577 1717 1522 1580 1716 1520 1578 806 1521 1579 1718 1524 1582 1717 1522 1580 807 1523 1581 1719 1526 1584 1718 1524 1582 808 1525 1583 1720 1528 1586 1719 1526 1584 809 1527 1585 1721 1530 1588 1720 1528 1586 810 1529 1587 1722 1532 1590 1721 1530 1588 811 1531 1589 1723 1534 1592 1722 1532 1590 812 1533 1591 1724 1536 1594 1723 1534 1592 813 1535 1593 1725 1538 1596 1724 1536 1594 814 1537 1595 1726 1472 1598 1725 1538 1596 815 1539 1597 1727 1540 1600 1726 1472 1598 816 1473 1599 1728 1542 1602 1727 1540 1600 817 1541 1601 1729 1544 1604 1728 1542 1602 818 1543 1603 1730 1546 1606 1729 1544 1604 819 1545 1605 1731 1548 1608 1730 1546 1606 820 1547 1607 1732 1550 1610 1731 1548 1608 821 1549 1609 1733 1552 1612 1732 1550 1610 822 1551 1611 1734 1554 1614 1733 1552 1612 823 1553 1613 1735 1556 1616 1734 1554 1614 824 1555 1615 1736 1558 1618 1735 1556 1616 825 1557 1617 1737 1560 1620 1736 1558 1618 826 1559 1619 1738 1562 1622 1737 1560 1620 827 1561 1621 1739 1564 1624 1738 1562 1622 828 1563 1623 1740 1566 1626 1739 1564 1624 829 1565 1625 1741 1568 1628 1740 1566 1626 830 1567 1627 1742 1570 1630 1741 1568 1628 831 1569 1629 1743 1572 1632 1742 1570 1630 832 1571 1631 1744 1574 1634 1743 1572 1632 833 1573 1633 1745 1576 1636 1744 1574 1634 834 1575 1635 1746 1578 1638 1745 1576 1636 835 1577 1637 1747 1580 1640 1746 1578 1638 836 1579 1639 1748 1582 1642 1747 1580 1640 837 1581 1641 1749 1584 1644 1748 1582 1642 838 1583 1643 1750 1586 1646 1749 1584 1644 839 1585 1645 1751 1588 1648 1750 1586 1646 840 1587 1647 1752 1590 1650 1751 1588 1648 841 1589 1649 1753 1592 1652 1752 1590 1650 842 1591 1651 1754 1594 1654 1753 1592 1652 843 1593 1653 1755 1596 1656 1754 1594 1654 844 1595 1655 1756 1532 1658 1755 1596 1656 845 1597 1657 1757 1534 1660 1756 1532 1658 846 1533 1659 1758 1536 1662 1757 1534 1660 847 1535 1661 1759 1538 1664 1758 1536 1662 848 1537 1663 1760 1598 1666 1759 1538 1664 849 1539 1665 1761 1540 1668 1760 1598 1666 850 1599 1667 1762 1601 1670 1761 1540 1668 851 1600 1669 1763 1603 1672 1762 1601 1670 852 1602 1671 1764 1605 1674 1763 1603 1672 853 1604 1673 1765 1607 1676 1764 1605 1674 854 1606 1675 1766 1609 1678 1765 1607 1676 855 1608 1677 1767 1611 1680 1766 1609 1678 856 1610 1679 1768 1613 1682 1767 1611 1680 857 1612 1681 1769 1615 1684 1768 1613 1682 858 1614 1683 1770 1617 1686 1769 1615 1684 859 1616 1685 1771 1619 1688 1770 1617 1686 860 1618 1687 1772 1621 1690 1771 1619 1688 861 1620 1689 1773 1623 1692 1772 1621 1690 862 1622 1691 1774 1625 1694 1773 1623 1692 863 1624 1693 1775 1627 1696 1774 1625 1694 864 1626 1695 1776 1629 1698 1775 1627 1696 865 1628 1697 1777 1631 1700 1776 1629 1698 866 1630 1699 1778 1633 1702 1777 1631 1700 867 1632 1701 1779 1635 1704 1778 1633 1702 868 1634 1703 1780 1637 1706 1779 1635 1704 869 1636 1705 1781 1639 1708 1780 1637 1706 870 1638 1707 1782 1641 1710 1781 1639 1708 871 1640 1709 1783 1643 1712 1782 1641 1710 872 1642 1711 1784 1645 1714 1783 1643 1712 873 1644 1713 1785 1647 1716 1784 1645 1714 874 1646 1715 1786 1649 1718 1785 1647 1716 875 1648 1717 1787 1651 1720 1786 1649 1718 876 1650 1719 1788 1653 1722 1787 1651 1720 877 1652 1721 1789 1655 1724 1788 1653 1722 878 1654 1723 1790 1657 1726 1789 1655 1724 879 1656 1725 1791 1659 1728 1790 1657 1726 880 1658 1727 1792 1661 1730 1791 1659 1728 881 1660 1729 1793 1663 1732 1792 1661 1730 882 1662 1731 1794 1665 1734 1793 1663 1732 883 1664 1733 1795 1667 1736 1794 1665 1734 884 1666 1735 1796 1669 1738 1795 1667 1736 885 1668 1737 1797 1671 1740 1796 1669 1738 886 1670 1739 1798 1673 1742 1797 1671 1740 887 1672 1741 1799 1675 1744 1798 1673 1742 888 1674 1743 1800 1677 1746 1799 1675 1744 889 1676 1745 1801 1679 1748 1800 1677 1746 890 1678 1747 1802 1681 1750 1801 1679 1748 891 1680 1749 1803 1683 1752 1802 1681 1750 892 1682 1751 1804 1685 1754 1803 1683 1752 893 1684 1753 1805 1687 1756 1804 1685 1754 894 1686 1755 1806 1689 1758 1805 1687 1756 895 1688 1757 1807 1691 1760 1806 1689 1758 896 1690 1759 1808 1693 1762 1807 1691 1760 897 1692 1761 1809 1695 1764 1808 1693 1762 898 1694 1763 1810 1697 1766 1809 1695 1764 899 1696 1765 1811 1699 1768 1810 1697 1766 900 1698 1767 1812 1701 1770 1811 1699 1768 901 1700 1769 1813 1703 1772 1812 1701 1770 902 1702 1771 1814 1705 1774 1813 1703 1772 903 1704 1773 1815 1707 1776 1814 1705 1774 904 1706 1775 1816 1709 1778 1815 1707 1776 905 1708 1777 1817 1711 1780 1816 1709 1778 906 1710 1779 1818 1713 1782 1817 1711 1780 907 1712 1781 1819 1715 1784 1818 1713 1782 908 1714 1783 1684 1459 266 1819 1715 1784 909 1716 1785 4 7 0 11 21 0 0 0 0 12 23 0 132 243 0 0 0 0 4 7 0 0 0 0 1 1 0 13 25 0 131 241 0 132 243 0 14 27 0 130 239 0 131 241 0 15 29 0 129 237 0 130 239 0 16 31 0 128 235 0 129 237 0 17 33 0 127 233 0 128 235 0 18 35 0 126 231 0 127 233 0 125 229 0 126 231 0 18 35 0 124 227 0 125 229 0 19 37 0 123 225 0 124 227 0 20 39 0 122 223 0 123 225 0 22 43 0 21 41 0 22 43 0 123 225 0 121 221 0 122 223 0 23 45 0 25 49 0 120 219 0 121 221 0 26 51 0 119 217 0 120 219 0 27 53 0 118 215 0 119 217 0 28 55 0 117 213 0 118 215 0 29 57 0 116 211 0 117 213 0 30 59 0 115 209 0 116 211 0 30 59 0 114 207 0 115 209 0 31 61 0 113 205 0 114 207 0 31 61 0 112 203 0 113 205 0 32 63 0 111 201 0 112 203 0 32 63 0 110 199 0 111 201 0 33 65 0 109 197 0 110 199 0 34 67 0 108 195 0 109 197 0 107 193 0 108 195 0 34 67 0 106 191 0 107 193 0 44 79 0 36 71 0 44 79 0 107 193 0 45 81 0 105 189 0 106 191 0 46 83 0 104 187 0 105 189 0 47 85 0 103 185 0 104 187 0 102 183 0 103 185 0 48 87 0 47 85 0 48 87 0 103 185 0 49 89 0 101 181 0 102 183 0 50 91 0 100 179 0 101 181 0 51 93 0 99 177 0 100 179 0 98 175 0 99 177 0 51 93 0 2 3 0 3 5 0 4 7 0 97 173 0 98 175 0 52 95 0 5 9 0 6 11 0 7 13 0 96 171 0 97 173 0 53 97 0 7 13 0 8 15 0 10 19 0 55 101 0 95 169 0 96 171 0 8 15 0 9 17 0 10 19 0 56 103 0 94 167 0 95 169 0 5 9 0 10 19 0 11 21 0 57 105 0 93 165 0 94 167 0 38 75 0 39 11 0 40 13 0 58 107 0 92 163 0 93 165 0 40 13 0 41 15 0 43 77 0 59 109 0 91 161 0 92 163 0 41 15 0 42 17 0 43 77 0 60 111 0 90 159 0 91 161 0 36 71 0 37 73 0 44 79 0 61 113 0 89 157 0 90 159 0 62 115 0 88 155 0 89 157 0 63 117 0 87 153 0 88 155 0 43 77 0 44 79 0 37 73 0 64 119 0 86 151 0 87 153 0 65 121 0 85 149 0 86 151 0 71 75 0 72 11 0 73 13 0 65 121 0 84 147 0 85 149 0 73 13 0 74 15 0 76 77 0 65 121 0 83 145 0 84 147 0 66 123 0 82 143 0 83 145 0 74 15 0 75 17 0 76 77 0 66 123 0 81 141 0 82 143 0 76 77 0 77 133 0 70 131 0 67 125 0 80 139 0 81 141 0 68 127 0 79 137 0 80 139 0 77 133 0 78 135 0 69 129 0 78 135 0 79 137 0 68 127 0 135 249 0 136 251 0 133 246 0 140 254 0 137 1 0 138 3 0 144 15 0 145 17 0 146 77 0 141 75 0 142 11 0 143 13 0 146 77 0 137 1 0 140 254 0 143 13 0 144 15 0 146 77 0 158 257 0 159 259 0 147 256 0 159 259 0 220 375 0 147 256 0 151 7 0 147 256 0 148 1 0 160 261 0 219 373 0 220 375 0 218 371 0 219 373 0 160 261 0 217 369 0 218 371 0 161 263 0 216 367 0 217 369 0 162 265 0 163 267 0 215 365 0 216 367 0 164 269 0 214 363 0 215 365 0 213 361 0 214 363 0 164 269 0 212 359 0 213 361 0 165 271 0 211 357 0 212 359 0 166 273 0 210 355 0 211 357 0 167 275 0 209 353 0 210 355 0 168 277 0 208 351 0 209 353 0 170 281 0 1339 768 0 1338 985 0 1451 992 0 169 279 0 170 281 0 209 353 0 1520 1130 0 1451 992 0 1338 985 0 207 349 0 208 351 0 171 283 0 1518 1126 0 1519 1128 0 1338 985 0 206 347 0 207 349 0 172 285 0 1517 1124 0 1518 1126 0 1338 985 0 205 345 0 206 347 0 173 287 0 1516 1122 0 1517 1124 0 1338 985 0 1516 1122 0 1338 985 0 1431 952 0 204 343 0 205 345 0 174 289 0 203 341 0 204 343 0 175 291 0 149 3 0 150 5 0 151 7 0 177 295 0 202 339 0 203 341 0 152 9 0 153 11 0 154 13 0 177 295 0 201 337 0 202 339 0 154 13 0 155 15 0 157 19 0 178 297 0 200 335 0 201 337 0 179 299 0 199 333 0 200 335 0 155 15 0 156 17 0 157 19 0 180 301 0 198 331 0 199 333 0 152 9 0 157 19 0 158 257 0 180 301 0 197 329 0 198 331 0 181 303 0 196 327 0 197 329 0 186 9 0 187 11 0 188 313 0 182 305 0 195 325 0 196 327 0 189 315 0 191 317 0 186 9 0 182 305 0 194 323 0 195 325 0 189 315 0 190 17 0 191 317 0 183 307 0 193 321 0 194 323 0 1432 954 0 1431 952 0 1338 985 0 184 309 0 185 311 0 192 319 0 184 309 0 192 319 0 193 321 0 191 317 0 192 319 0 185 311 0 1448 987 0 1340 770 0 1339 768 0 1448 987 0 1341 772 0 1340 770 0 1448 987 0 1342 774 0 1341 772 0 1448 987 0 1343 776 0 1342 774 0 1448 987 0 1344 778 0 1343 776 0 1448 987 0 1345 780 0 1344 778 0 1448 987 0 1346 782 0 1345 780 0 1448 987 0 1347 784 0 1346 782 0 1448 987 0 1348 786 0 1347 784 0 1448 987 0 1349 788 0 1348 786 0 1448 987 0 1350 790 0 1349 788 0 1448 987 0 1351 792 0 1350 790 0 223 1 0 224 381 0 221 378 0 228 254 0 225 1 0 226 3 0 232 15 0 233 17 0 234 77 0 1448 987 0 1352 794 0 1351 792 0 229 75 0 230 11 0 231 13 0 234 77 0 225 1 0 228 254 0 231 13 0 232 15 0 234 77 0 1448 987 0 1353 796 0 1352 794 0 1448 987 0 1354 798 0 1353 796 0 1448 987 0 1355 800 0 1354 798 0 1356 802 0 1355 800 0 1448 987 0 1357 804 0 1356 802 0 1449 988 0 1358 806 0 1357 804 0 1394 878 0 1541 1172 0 1394 878 0 1357 804 0 1539 1168 0 1540 1170 0 1357 804 0 1538 1166 0 1539 1168 0 1357 804 0 1537 1164 0 1538 1166 0 1357 804 0 1359 808 0 1358 806 0 1393 876 0 1391 872 0 1360 810 0 1359 808 0 1361 812 0 1360 810 0 1391 872 0 1361 812 0 1390 870 0 1389 868 0 1362 814 0 1388 866 0 1387 864 0 1389 868 0 1388 866 0 1362 814 0 1363 816 0 1387 864 0 1386 862 0 1364 818 0 1385 860 0 1384 858 0 1386 862 0 1385 860 0 1364 818 0 1365 820 0 1384 858 0 1383 856 0 1366 822 0 1383 856 0 1382 854 0 1381 852 0 1380 850 0 1367 824 0 1368 826 0 1367 824 0 1380 850 0 1369 828 0 1368 826 0 1379 848 0 1370 830 0 1369 828 0 1378 846 0 1371 832 0 1370 830 0 1377 844 0 1372 834 0 1371 832 0 1376 842 0 1375 840 0 1373 836 0 1372 834 0 1375 840 0 1374 838 0 1373 836 0 1395 880 0 1394 878 0 1691 1470 0 1547 1184 0 1691 1470 0 1394 878 0 1546 1182 0 1547 1184 0 1394 878 0 1545 1181 0 1546 1182 0 1394 878 0 1615 1320 0 1545 1181 0 1394 878 0 1614 1318 0 1615 1320 0 1394 878 0 1613 1316 0 1614 1318 0 1394 878 0 1612 1314 0 1613 1316 0 1394 878 0 1611 1312 0 1612 1314 0 1394 878 0 1544 1178 0 1452 995 0 1394 878 0 1543 1176 0 1544 1178 0 1394 878 0 1542 1174 0 1543 1176 0 1394 878 0 1541 1172 0 1542 1174 0 1394 878 0 1760 1598 0 1396 882 0 1395 880 0 1726 1472 0 1759 1538 0 1395 880 0 1725 1538 0 1726 1472 0 1395 880 0 1692 1472 0 1725 1538 0 1395 880 0 1760 1598 0 1397 884 0 1396 882 0 1760 1598 0 1398 886 0 1397 884 0 1760 1598 0 1399 888 0 1398 886 0 1760 1598 0 1400 890 0 1399 888 0 1760 1598 0 1401 892 0 1400 890 0 1760 1598 0 1402 894 0 1401 892 0 1760 1598 0 1403 896 0 1402 894 0 1760 1598 0 1404 898 0 1403 896 0 1760 1598 0 1405 900 0 1404 898 0 1760 1598 0 1406 902 0 1405 900 0 1760 1598 0 1407 904 0 1406 902 0 1760 1598 0 1408 906 0 1407 904 0 1760 1598 0 1409 908 0 1408 906 0 1760 1598 0 1410 910 0 1409 908 0 1760 1598 0 1411 912 0 1410 910 0 1412 914 0 1411 912 0 1760 1598 0 1413 916 0 1412 914 0 1761 1540 0 1775 1627 0 1414 918 0 1413 916 0 1773 1623 0 1774 1625 0 1413 916 0 1772 1621 0 1773 1623 0 1413 916 0 1771 1619 0 1772 1621 0 1413 916 0 1770 1617 0 1771 1619 0 1413 916 0 1769 1615 0 1770 1617 0 1413 916 0 1768 1613 0 1769 1615 0 1413 916 0 1767 1611 0 1768 1613 0 1413 916 0 1766 1609 0 1767 1611 0 1413 916 0 1765 1607 0 1766 1609 0 1413 916 0 1764 1605 0 1765 1607 0 1413 916 0 1763 1603 0 1764 1605 0 1413 916 0 1775 1627 0 1415 920 0 1414 918 0 1775 1627 0 1416 922 0 1415 920 0 1775 1627 0 1417 924 0 1416 922 0 1775 1627 0 1418 926 0 1417 924 0 1775 1627 0 1419 928 0 1418 926 0 1776 1629 0 1420 930 0 1419 928 0 1776 1629 0 1421 932 0 1420 930 0 521 951 0 428 766 0 606 1123 0 522 953 0 537 983 0 428 766 0 607 1125 0 606 1123 0 428 766 0 669 1249 0 520 949 0 521 951 0 608 1127 0 607 1125 0 428 766 0 530 969 0 531 971 0 528 965 0 609 1129 0 608 1127 0 428 766 0 531 971 0 532 973 0 527 963 0 610 1131 0 609 1129 0 428 766 0 532 973 0 533 975 0 526 961 0 541 993 0 428 766 0 429 767 0 533 975 0 534 977 0 525 959 0 536 981 0 537 983 0 522 953 0 534 977 0 535 979 0 524 957 0 535 979 0 536 981 0 523 955 0 670 1251 0 669 1249 0 521 951 0 671 1253 0 670 1251 0 521 951 0 542 994 0 699 1309 0 698 1307 0 542 994 0 700 1311 0 699 1309 0 542 994 0 701 1313 0 700 1311 0 1776 1629 0 1422 934 0 1421 932 0 1776 1629 0 1423 936 0 1422 934 0 1776 1629 0 1424 938 0 1423 936 0 1776 1629 0 1425 940 0 1424 938 0 1776 1629 0 1426 942 0 1425 940 0 1776 1629 0 1427 944 0 1426 942 0 1776 1629 0 1428 946 0 1427 944 0 1776 1629 0 1429 948 0 1428 946 0 1430 950 0 1429 948 0 1776 1629 0 1579 1248 0 1431 952 0 1430 950 0 1578 1246 0 1579 1248 0 1430 950 0 1686 1462 0 1578 1246 0 1430 950 0 1685 1460 0 1686 1462 0 1430 950 0 672 1255 0 671 1253 0 521 951 0 786 1481 0 785 1479 0 812 1533 0 812 1533 0 788 1485 0 787 1483 0 812 1533 0 789 1487 0 788 1485 0 790 1489 0 789 1487 0 812 1533 0 811 1531 0 791 1491 0 790 1489 0 792 1493 0 791 1491 0 811 1531 0 810 1529 0 793 1495 0 792 1493 0 1810 1697 0 1685 1460 0 1430 950 0 829 1565 0 828 1563 0 843 1593 0 830 1567 0 829 1565 0 842 1591 0 831 1569 0 830 1567 0 841 1589 0 832 1571 0 831 1569 0 840 1587 0 834 1575 0 833 1573 0 840 1587 0 1809 1695 0 1810 1697 0 1430 950 0 481 871 0 482 873 0 449 807 0 1808 1693 0 1809 1695 0 1430 950 0 542 994 0 698 1307 0 697 1305 0 595 1101 0 672 1255 0 521 951 0 597 1105 0 596 1103 0 521 951 0 598 1107 0 597 1105 0 521 951 0 599 1109 0 598 1107 0 521 951 0 600 1111 0 599 1109 0 521 951 0 601 1113 0 600 1111 0 521 951 0 602 1115 0 601 1113 0 521 951 0 603 1117 0 602 1115 0 521 951 0 604 1119 0 603 1117 0 521 951 0 605 1121 0 604 1119 0 521 951 0 866 1630 0 519 947 0 520 949 0 785 1479 0 784 1477 0 783 1475 0 868 1634 0 867 1632 0 520 949 0 869 1636 0 868 1634 0 520 949 0 870 1638 0 869 1636 0 520 949 0 871 1640 0 870 1638 0 520 949 0 872 1642 0 871 1640 0 520 949 0 873 1644 0 872 1642 0 520 949 0 1807 1691 0 1808 1693 0 1430 950 0 649 1209 0 648 1207 0 780 1469 0 650 1211 0 649 1209 0 780 1469 0 651 1213 0 650 1211 0 780 1469 0 638 1187 0 637 1185 0 781 1471 0 639 1189 0 638 1187 0 781 1471 0 640 1191 0 639 1189 0 781 1471 0 641 1193 0 640 1191 0 781 1471 0 642 1195 0 641 1193 0 781 1471 0 643 1197 0 642 1195 0 781 1471 0 644 1199 0 643 1197 0 781 1471 0 783 1475 0 782 1473 0 815 1539 0 783 1475 0 814 1537 0 812 1533 0 895 1688 0 873 1644 0 520 949 0 647 1205 0 646 1203 0 780 1469 0 896 1690 0 895 1688 0 520 949 0 897 1692 0 896 1690 0 520 949 0 898 1694 0 897 1692 0 520 949 0 899 1696 0 898 1694 0 520 949 0 900 1698 0 899 1696 0 520 949 0 775 1461 0 900 1698 0 520 949 0 776 1463 0 775 1461 0 520 949 0 668 1247 0 776 1463 0 520 949 0 669 1249 0 668 1247 0 520 949 0 866 1630 0 518 945 0 519 947 0 866 1630 0 517 943 0 518 945 0 866 1630 0 516 941 0 517 943 0 866 1630 0 515 939 0 516 941 0 866 1630 0 514 937 0 515 939 0 866 1630 0 513 935 0 514 937 0 866 1630 0 512 933 0 513 935 0 866 1630 0 511 931 0 512 933 0 454 817 0 475 859 0 476 861 0 1806 1689 0 1807 1691 0 1430 950 0 538 986 0 430 769 0 431 771 0 1805 1687 0 1806 1689 0 1430 950 0 646 1203 0 645 1201 0 780 1469 0 1783 1643 0 1805 1687 0 1430 950 0 592 1095 0 581 1073 0 580 1071 0 592 1095 0 582 1075 0 581 1073 0 592 1095 0 583 1077 0 582 1075 0 592 1095 0 584 1079 0 583 1077 0 592 1095 0 585 1081 0 584 1079 0 888 1674 0 878 1654 0 877 1652 0 890 1678 0 889 1676 0 877 1652 0 1782 1641 0 1783 1643 0 1430 950 0 866 1630 0 510 929 0 511 931 0 850 1599 0 486 881 0 487 883 0 1781 1639 0 1782 1641 0 1430 950 0 1780 1637 0 1781 1639 0 1430 950 0 1779 1635 0 1780 1637 0 1430 950 0 1778 1633 0 1779 1635 0 1430 950 0 1777 1631 0 1778 1633 0 1430 950 0 509 927 0 510 929 0 866 1630 0 850 1599 0 487 883 0 488 885 0 865 1628 0 508 925 0 509 927 0 865 1628 0 507 923 0 508 925 0 850 1599 0 489 887 0 490 889 0 850 1599 0 488 885 0 489 887 0 865 1628 0 506 921 0 507 923 0 865 1628 0 505 919 0 506 921 0 850 1599 0 490 889 0 491 891 0 865 1628 0 504 917 0 505 919 0 503 915 0 504 917 0 865 1628 0 850 1599 0 491 891 0 492 893 0 851 1600 0 502 913 0 503 915 0 850 1599 0 492 893 0 493 895 0 854 1606 0 853 1604 0 503 915 0 855 1608 0 854 1606 0 503 915 0 850 1599 0 493 895 0 494 897 0 856 1610 0 855 1608 0 503 915 0 850 1599 0 494 897 0 495 899 0 857 1612 0 856 1610 0 503 915 0 850 1599 0 495 899 0 496 901 0 858 1614 0 857 1612 0 503 915 0 859 1616 0 858 1614 0 503 915 0 850 1599 0 496 901 0 497 903 0 860 1618 0 859 1616 0 503 915 0 850 1599 0 497 903 0 498 905 0 861 1620 0 860 1618 0 503 915 0 850 1599 0 498 905 0 499 907 0 862 1622 0 861 1620 0 503 915 0 850 1599 0 499 907 0 500 909 0 863 1624 0 862 1622 0 503 915 0 850 1599 0 500 909 0 501 911 0 864 1626 0 863 1624 0 503 915 0 850 1599 0 501 911 0 502 913 0 1514 1118 0 1515 1120 0 1431 952 0 1513 1116 0 1514 1118 0 1431 952 0 1512 1114 0 1513 1116 0 1431 952 0 1511 1112 0 1512 1114 0 1431 952 0 485 879 0 486 881 0 850 1599 0 1510 1110 0 1511 1112 0 1431 952 0 781 1471 0 484 877 0 485 879 0 1509 1108 0 1510 1110 0 1431 952 0 815 1539 0 782 1473 0 485 879 0 816 1473 0 815 1539 0 485 879 0 849 1539 0 816 1473 0 485 879 0 701 1313 0 542 994 0 484 877 0 703 1317 0 702 1315 0 484 877 0 704 1319 0 703 1317 0 484 877 0 705 1321 0 704 1319 0 484 877 0 635 1180 0 705 1321 0 484 877 0 636 1183 0 635 1180 0 484 877 0 637 1185 0 636 1183 0 484 877 0 781 1471 0 637 1185 0 484 877 0 448 805 0 483 875 0 484 877 0 447 803 0 484 877 0 631 1173 0 632 1175 0 631 1173 0 484 877 0 633 1177 0 632 1175 0 484 877 0 634 1179 0 633 1177 0 484 877 0 542 994 0 634 1179 0 484 877 0 1508 1106 0 1509 1108 0 1431 952 0 1507 1104 0 1508 1106 0 1431 952 0 1506 1102 0 1507 1104 0 1431 952 0 1505 1100 0 1506 1102 0 1431 952 0 1581 1252 0 1582 1254 0 1431 952 0 1580 1250 0 1581 1252 0 1431 952 0 449 807 0 482 873 0 483 875 0 836 1579 0 835 1577 0 834 1575 0 838 1583 0 837 1581 0 840 1587 0 848 1537 0 847 1535 0 846 1533 0 853 1604 0 852 1602 0 851 1600 0 894 1686 0 874 1646 0 873 1644 0 893 1684 0 875 1648 0 874 1646 0 892 1682 0 876 1650 0 875 1648 0 890 1678 0 877 1652 0 876 1650 0 892 1682 0 891 1680 0 876 1650 0 451 811 0 480 869 0 481 871 0 543 997 0 690 1291 0 689 1289 0 543 997 0 691 1293 0 690 1291 0 543 997 0 692 1295 0 691 1293 0 543 997 0 693 1297 0 692 1295 0 543 997 0 694 1299 0 693 1297 0 542 994 0 695 1301 0 694 1299 0 542 994 0 696 1303 0 695 1301 0 542 994 0 697 1305 0 696 1303 0 479 867 0 480 869 0 451 811 0 593 1097 0 684 1279 0 683 1277 0 593 1097 0 685 1281 0 684 1279 0 593 1097 0 686 1283 0 685 1281 0 593 1097 0 687 1285 0 686 1283 0 593 1097 0 688 1287 0 687 1285 0 543 997 0 689 1289 0 688 1287 0 452 813 0 478 865 0 479 867 0 683 1277 0 682 1275 0 594 1099 0 477 863 0 478 865 0 452 813 0 594 1099 0 681 1273 0 680 1271 0 594 1099 0 682 1275 0 681 1273 0 476 861 0 477 863 0 453 815 0 594 1099 0 675 1261 0 674 1259 0 594 1099 0 676 1263 0 675 1261 0 594 1099 0 677 1265 0 676 1263 0 594 1099 0 678 1267 0 677 1265 0 594 1099 0 679 1269 0 678 1267 0 594 1099 0 680 1271 0 679 1269 0 886 1670 0 879 1656 0 878 1654 0 888 1674 0 887 1672 0 878 1654 0 884 1666 0 880 1658 0 879 1656 0 886 1670 0 885 1668 0 879 1656 0 883 1664 0 881 1660 0 880 1658 0 883 1664 0 882 1662 0 881 1660 0 673 1257 0 672 1255 0 595 1101 0 594 1099 0 674 1259 0 673 1257 0 474 857 0 475 859 0 454 817 0 1579 1248 0 1580 1250 0 1431 952 0 538 986 0 431 771 0 432 773 0 473 855 0 474 857 0 455 819 0 1446 982 0 1433 956 0 1432 954 0 472 853 0 473 855 0 456 821 0 471 851 0 472 853 0 457 823 0 458 825 0 469 847 0 470 849 0 459 827 0 468 845 0 469 847 0 460 829 0 467 843 0 468 845 0 461 831 0 466 841 0 467 843 0 538 986 0 433 775 0 434 777 0 462 833 0 465 839 0 466 841 0 463 835 0 464 837 0 465 839 0 538 986 0 434 777 0 435 779 0 462 833 0 463 835 0 465 839 0 628 1167 0 627 1165 0 447 803 0 538 986 0 435 779 0 436 781 0 629 1169 0 628 1167 0 447 803 0 538 986 0 436 781 0 437 783 0 630 1171 0 629 1169 0 447 803 0 538 986 0 437 783 0 438 785 0 539 989 0 446 801 0 447 803 0 538 986 0 438 785 0 439 787 0 538 986 0 445 799 0 446 801 0 538 986 0 439 787 0 440 789 0 538 986 0 444 797 0 445 799 0 538 986 0 443 795 0 444 797 0 538 986 0 440 789 0 441 791 0 538 986 0 442 793 0 443 795 0 538 986 0 441 791 0 442 793 0 538 986 0 432 773 0 433 775 0 538 986 0 429 767 0 430 769 0 1445 980 0 1434 958 0 1433 956 0 781 1471 0 780 1469 0 645 1201 0 909 1716 0 775 1461 0 774 1458 0 1444 978 0 1435 960 0 1434 958 0 901 1700 0 900 1698 0 775 1461 0 902 1702 0 901 1700 0 775 1461 0 903 1704 0 902 1702 0 775 1461 0 904 1706 0 903 1704 0 775 1461 0 905 1708 0 904 1706 0 775 1461 0 906 1710 0 905 1708 0 775 1461 0 779 577 0 778 1467 0 653 1217 0 907 1712 0 906 1710 0 775 1461 0 908 1714 0 907 1712 0 775 1461 0 660 1231 0 659 1229 0 777 1465 0 909 1716 0 908 1714 0 775 1461 0 660 1231 0 777 1465 0 776 1463 0 659 1229 0 658 1227 0 777 1465 0 662 1235 0 661 1233 0 776 1463 0 658 1227 0 657 1225 0 777 1465 0 663 1237 0 662 1235 0 776 1463 0 657 1225 0 656 1223 0 777 1465 0 664 1239 0 663 1237 0 776 1463 0 656 1223 0 655 1221 0 777 1465 0 665 1241 0 664 1239 0 776 1463 0 666 1243 0 665 1241 0 776 1463 0 667 1245 0 666 1243 0 776 1463 0 668 1247 0 667 1245 0 776 1463 0 1443 976 0 1436 962 0 1435 960 0 778 1467 0 777 1465 0 654 1219 0 655 1221 0 654 1219 0 777 1465 0 651 1213 0 780 1469 0 779 577 0 648 1207 0 647 1205 0 780 1469 0 794 1497 0 793 1495 0 810 1529 0 828 1563 0 827 1561 0 844 1595 0 795 1499 0 794 1497 0 809 1527 0 844 1595 0 827 1561 0 826 1559 0 796 1501 0 795 1499 0 808 1525 0 826 1559 0 825 1557 0 845 1597 0 797 1503 0 796 1501 0 807 1523 0 824 1555 0 823 1553 0 846 1533 0 845 1597 0 825 1557 0 824 1555 0 798 1505 0 797 1503 0 806 1521 0 846 1533 0 822 1551 0 821 1549 0 846 1533 0 823 1553 0 822 1551 0 799 1507 0 798 1505 0 805 1519 0 846 1533 0 820 1547 0 819 1545 0 846 1533 0 821 1549 0 820 1547 0 804 1517 0 801 1511 0 800 1509 0 817 1541 0 848 1537 0 846 1533 0 819 1545 0 818 1543 0 817 1541 0 802 1513 0 801 1511 0 804 1517 0 817 1541 0 816 1473 0 849 1539 0 814 1537 0 813 1535 0 812 1533 0 592 1095 0 544 999 0 543 997 0 592 1095 0 545 1001 0 544 999 0 1442 974 0 1437 964 0 1436 962 0 592 1095 0 546 1003 0 545 1001 0 592 1095 0 547 1005 0 546 1003 0 548 1007 0 547 1005 0 592 1095 0 549 1009 0 548 1007 0 563 1037 0 550 1011 0 549 1009 0 562 1035 0 551 1013 0 550 1011 0 561 1033 0 552 1015 0 551 1013 0 560 1031 0 553 1017 0 552 1015 0 559 1029 0 557 1025 0 554 1019 0 553 1017 0 556 1023 0 555 1021 0 554 1019 0 1441 972 0 1438 966 0 1437 964 0 592 1095 0 564 1039 0 563 1037 0 592 1095 0 565 1041 0 564 1039 0 592 1095 0 566 1043 0 565 1041 0 592 1095 0 567 1045 0 566 1043 0 592 1095 0 568 1047 0 567 1045 0 1440 970 0 1439 968 0 1438 966 0 592 1095 0 569 1049 0 568 1047 0 592 1095 0 570 1051 0 569 1049 0 592 1095 0 571 1053 0 570 1051 0 592 1095 0 572 1055 0 571 1053 0 592 1095 0 573 1057 0 572 1055 0 592 1095 0 574 1059 0 573 1057 0 592 1095 0 586 1083 0 585 1081 0 592 1095 0 575 1061 0 574 1059 0 592 1095 0 576 1063 0 575 1061 0 592 1095 0 577 1065 0 576 1063 0 592 1095 0 578 1067 0 577 1065 0 592 1095 0 579 1069 0 578 1067 0 592 1095 0 580 1071 0 579 1069 0 592 1095 0 587 1085 0 586 1083 0 1685 1460 0 1819 1715 0 1684 1459 0 588 1087 0 587 1085 0 592 1095 0 592 1095 0 590 1091 0 589 1089 0 592 1095 0 591 1093 0 590 1091 0 541 993 0 611 1133 0 610 1131 0 541 993 0 612 1135 0 611 1133 0 1685 1460 0 1818 1713 0 1819 1715 0 613 1137 0 612 1135 0 541 993 0 539 989 0 625 1161 0 624 1159 0 540 991 0 614 1139 0 613 1137 0 539 989 0 624 1159 0 623 1157 0 540 991 0 615 1141 0 614 1139 0 539 989 0 623 1157 0 622 1155 0 540 991 0 616 1143 0 615 1141 0 539 989 0 622 1155 0 621 1153 0 540 991 0 617 1145 0 616 1143 0 540 991 0 620 1151 0 619 1149 0 539 989 0 621 1153 0 620 1151 0 540 991 0 618 1147 0 617 1145 0 540 991 0 619 1149 0 618 1147 0 539 989 0 626 1163 0 625 1161 0 539 989 0 627 1165 0 626 1163 0 1685 1460 0 1817 1711 0 1818 1713 0 1685 1460 0 1816 1709 0 1817 1711 0 1685 1460 0 1815 1707 0 1816 1709 0 1685 1460 0 1814 1705 0 1815 1707 0 1685 1460 0 1813 1703 0 1814 1705 0 1685 1460 0 1812 1701 0 1813 1703 0 1685 1460 0 1811 1699 0 1812 1701 0 1685 1460 0 1810 1697 0 1811 1699 0 1804 1685 0 1805 1687 0 1783 1643 0 1803 1683 0 1804 1685 0 1784 1645 0 1802 1681 0 1803 1683 0 1785 1647 0 1786 1649 0 1801 1679 0 1802 1681 0 1800 1677 0 1801 1679 0 1786 1649 0 1787 1651 0 1799 1675 0 1800 1677 0 1798 1673 0 1799 1675 0 1787 1651 0 1788 1653 0 1797 1671 0 1798 1673 0 1796 1669 0 1797 1671 0 1788 1653 0 1789 1655 0 1795 1667 0 1796 1669 0 1794 1665 0 1795 1667 0 1789 1655 0 1793 1663 0 1794 1665 0 1790 1657 0 1791 1659 0 1792 1661 0 1793 1663 0 1761 1540 0 1762 1601 0 1763 1603 0 1758 1536 0 1759 1538 0 1726 1472 0 1756 1532 0 1757 1534 0 1758 1536 0 1756 1532 0 1758 1536 0 1727 1540 0 1734 1554 0 1755 1596 0 1756 1532 0 1732 1550 0 1733 1552 0 1756 1532 0 1731 1548 0 1732 1550 0 1756 1532 0 1730 1546 0 1731 1548 0 1756 1532 0 1729 1544 0 1730 1546 0 1756 1532 0 1736 1558 0 1754 1594 0 1755 1596 0 1734 1554 0 1735 1556 0 1755 1596 0 1738 1562 0 1753 1592 0 1754 1594 0 1736 1558 0 1737 1560 0 1754 1594 0 1739 1564 0 1752 1590 0 1753 1592 0 1740 1566 0 1751 1588 0 1752 1590 0 1741 1568 0 1750 1586 0 1751 1588 0 1748 1582 0 1749 1584 0 1750 1586 0 1744 1574 0 1747 1580 0 1750 1586 0 1742 1570 0 1743 1572 0 1750 1586 0 1746 1578 0 1747 1580 0 1744 1574 0 1727 1540 0 1728 1542 0 1729 1544 0 1724 1536 0 1725 1538 0 1692 1472 0 1722 1532 0 1723 1534 0 1724 1536 0 1722 1532 0 1724 1536 0 1693 1474 0 1700 1488 0 1721 1530 0 1722 1532 0 767 1445 0 706 1322 0 773 1457 0 1698 1484 0 1699 1486 0 1722 1532 0 713 1337 0 707 1325 0 706 1322 0 713 1337 0 767 1445 0 766 1443 0 712 1335 0 708 1327 0 707 1325 0 711 1333 0 710 1331 0 709 1329 0 711 1333 0 709 1329 0 708 1327 0 1697 1482 0 1698 1484 0 1722 1532 0 714 1339 0 766 1443 0 765 1441 0 1696 1480 0 1697 1482 0 1722 1532 0 715 1341 0 765 1441 0 764 1439 0 1702 1492 0 1720 1528 0 1721 1530 0 716 1343 0 764 1439 0 763 1437 0 1700 1488 0 1701 1490 0 1721 1530 0 717 1345 0 763 1437 0 762 1435 0 1704 1496 0 1719 1526 0 1720 1528 0 718 1347 0 762 1435 0 761 1433 0 1702 1492 0 1703 1494 0 1720 1528 0 719 1349 0 761 1433 0 760 1431 0 1705 1498 0 1718 1524 0 1719 1526 0 720 1351 0 760 1431 0 759 1429 0 1706 1500 0 1717 1522 0 1718 1524 0 721 1353 0 759 1429 0 758 1427 0 1707 1502 0 1716 1520 0 1717 1522 0 722 1355 0 758 1427 0 757 1425 0 1708 1504 0 1715 1518 0 1716 1520 0 756 1423 0 724 1359 0 723 1357 0 755 1421 0 725 1361 0 724 1359 0 1714 1516 0 1715 1518 0 1710 1508 0 754 1419 0 726 1363 0 725 1361 0 1709 1506 0 1710 1508 0 1715 1518 0 753 1417 0 727 1365 0 726 1363 0 1712 1512 0 1713 1514 0 1714 1516 0 752 1415 0 728 1367 0 727 1365 0 1693 1474 0 1694 1476 0 1695 1478 0 751 1413 0 729 1369 0 728 1367 0 1555 1200 0 1690 1468 0 1691 1470 0 750 1411 0 730 1371 0 729 1369 0 1553 1196 0 1554 1198 0 1691 1470 0 749 1409 0 731 1373 0 730 1371 0 1552 1194 0 1553 1196 0 1691 1470 0 748 1407 0 732 1375 0 731 1373 0 1551 1192 0 1552 1194 0 1691 1470 0 747 1405 0 733 1377 0 732 1375 0 1550 1190 0 1551 1192 0 1691 1470 0 739 1389 0 734 1379 0 733 1377 0 1549 1188 0 1550 1190 0 1691 1470 0 740 1391 0 733 1377 0 747 1405 0 744 1399 0 743 1397 0 742 1395 0 1548 1186 0 1549 1188 0 1691 1470 0 738 1387 0 735 1381 0 734 1379 0 742 1395 0 741 1393 0 745 1401 0 737 1385 0 736 1383 0 735 1381 0 741 1393 0 740 1391 0 746 1403 0 772 1455 0 769 1449 0 768 1447 0 1547 1184 0 1548 1186 0 1691 1470 0 771 1453 0 770 1451 0 769 1449 0 1689 578 0 1690 1468 0 1561 1212 0 1560 1210 0 1561 1212 0 1690 1468 0 1559 1208 0 1560 1210 0 1690 1468 0 1558 1206 0 1559 1208 0 1690 1468 0 1557 1204 0 1558 1206 0 1690 1468 0 1556 1202 0 1557 1204 0 1690 1468 0 1555 1200 0 1556 1202 0 1690 1468 0 1563 1216 0 1688 1466 0 1689 578 0 923 26 0 922 24 0 1042 244 0 1564 1218 0 1687 1464 0 1688 1466 0 922 24 0 921 22 0 910 245 0 1686 1462 0 1687 1464 0 1570 1230 0 911 2 0 910 245 0 914 8 0 921 22 0 914 8 0 910 245 0 914 8 0 913 6 0 912 4 0 920 20 0 919 18 0 918 16 0 915 10 0 914 8 0 921 22 0 1569 1228 0 1570 1230 0 1687 1464 0 917 14 0 916 12 0 915 10 0 917 14 0 915 10 0 920 20 0 924 28 0 923 26 0 1041 242 0 925 30 0 924 28 0 1040 240 0 1568 1226 0 1569 1228 0 1687 1464 0 926 32 0 925 30 0 1039 238 0 1567 1224 0 1568 1226 0 1687 1464 0 927 34 0 926 32 0 1038 236 0 1566 1222 0 1567 1224 0 1687 1464 0 928 36 0 927 34 0 1037 234 0 1565 1220 0 1566 1222 0 1687 1464 0 1035 230 0 929 38 0 928 36 0 1564 1218 0 1565 1220 0 1687 1464 0 1034 228 0 930 40 0 929 38 0 1577 1244 0 1578 1246 0 1686 1462 0 1576 1242 0 1577 1244 0 1686 1462 0 1033 226 0 931 42 0 930 40 0 1575 1240 0 1576 1242 0 1686 1462 0 1033 226 0 932 44 0 931 42 0 1574 1238 0 1575 1240 0 1686 1462 0 1032 224 0 933 46 0 932 44 0 1031 222 0 934 48 0 933 46 0 1573 1236 0 1574 1238 0 1686 1462 0 935 50 0 934 48 0 1031 222 0 1572 1234 0 1573 1236 0 1686 1462 0 936 52 0 935 50 0 1030 220 0 937 54 0 936 52 0 1029 218 0 1571 1232 0 1572 1234 0 1686 1462 0 938 56 0 937 54 0 1028 216 0 1452 995 0 1610 1310 0 1611 1312 0 939 58 0 938 56 0 1027 214 0 1452 995 0 1609 1308 0 1610 1310 0 940 60 0 939 58 0 1026 212 0 1452 995 0 1608 1306 0 1609 1308 0 941 62 0 940 60 0 1024 208 0 1452 995 0 1607 1304 0 1608 1306 0 1025 210 0 1024 208 0 940 60 0 1452 995 0 1606 1302 0 1607 1304 0 1452 995 0 1605 1300 0 1606 1302 0 942 64 0 941 62 0 1022 204 0 1604 1298 0 1605 1300 0 1452 995 0 1453 996 0 1603 1296 0 1604 1298 0 1023 206 0 1022 204 0 941 62 0 1453 996 0 1602 1294 0 1603 1296 0 1453 996 0 1601 1292 0 1602 1294 0 943 66 0 942 64 0 1020 200 0 1453 996 0 1600 1290 0 1601 1292 0 1021 202 0 1020 200 0 942 64 0 1453 996 0 1599 1288 0 1600 1290 0 1598 1286 0 1599 1288 0 1453 996 0 944 68 0 943 66 0 1019 198 0 1017 194 0 945 70 0 944 68 0 1503 1096 0 1597 1284 0 1598 1286 0 946 72 0 945 70 0 1017 194 0 950 14 0 948 76 0 953 78 0 954 80 0 947 74 0 946 72 0 1503 1096 0 1596 1282 0 1597 1284 0 953 78 0 948 76 0 947 74 0 950 14 0 949 12 0 948 76 0 953 78 0 952 18 0 951 16 0 1503 1096 0 1595 1280 0 1596 1282 0 1016 192 0 955 82 0 954 80 0 1503 1096 0 1594 1278 0 1595 1280 0 956 84 0 955 82 0 1015 190 0 1503 1096 0 1593 1276 0 1594 1278 0 1016 192 0 1015 190 0 955 82 0 1504 1098 0 1592 1274 0 1593 1276 0 957 86 0 956 84 0 1014 188 0 1504 1098 0 1591 1272 0 1592 1274 0 1013 186 0 958 88 0 957 86 0 1504 1098 0 1590 1270 0 1591 1272 0 1012 184 0 959 90 0 958 88 0 1504 1098 0 1589 1268 0 1590 1270 0 960 92 0 959 90 0 1011 182 0 1504 1098 0 1588 1266 0 1589 1268 0 1504 1098 0 1587 1264 0 1588 1266 0 1012 184 0 1011 182 0 959 90 0 1504 1098 0 1586 1262 0 1587 1264 0 961 94 0 960 92 0 1010 180 0 1504 1098 0 1585 1260 0 1586 1262 0 1008 176 0 962 96 0 961 94 0 1007 174 0 963 98 0 962 96 0 1504 1098 0 1584 1258 0 1585 1260 0 1006 172 0 964 100 0 963 98 0 1504 1098 0 1583 1256 0 1584 1258 0 965 102 0 964 100 0 1006 172 0 1505 1100 0 1582 1254 0 1583 1256 0 966 104 0 965 102 0 1005 170 0 1449 988 0 1536 1162 0 1537 1164 0 967 106 0 966 104 0 1004 168 0 1449 988 0 1535 1160 0 1536 1162 0 968 108 0 967 106 0 1003 166 0 1449 988 0 1534 1158 0 1535 1160 0 969 110 0 968 108 0 1002 164 0 1449 988 0 1533 1156 0 1534 1158 0 970 112 0 969 110 0 1001 162 0 1449 988 0 1532 1154 0 1533 1156 0 971 114 0 970 112 0 1000 160 0 1449 988 0 1531 1152 0 1532 1154 0 972 116 0 971 114 0 999 158 0 1530 1150 0 1531 1152 0 1449 988 0 973 118 0 972 116 0 998 156 0 1450 990 0 1529 1148 0 1530 1150 0 1450 990 0 1528 1146 0 1529 1148 0 1450 990 0 1527 1144 0 1528 1146 0 974 120 0 973 118 0 997 154 0 986 78 0 985 18 0 984 16 0 1450 990 0 1526 1142 0 1527 1144 0 975 122 0 974 120 0 996 152 0 983 14 0 981 76 0 986 78 0 976 124 0 975 122 0 993 146 0 986 78 0 981 76 0 980 132 0 983 14 0 982 12 0 981 76 0 994 148 0 993 146 0 975 122 0 987 134 0 980 132 0 979 130 0 995 150 0 994 148 0 975 122 0 988 136 0 979 130 0 978 128 0 977 126 0 976 124 0 991 142 0 1450 990 0 1525 1140 0 1526 1142 0 992 144 0 991 142 0 976 124 0 978 128 0 977 126 0 990 140 0 1045 250 0 1044 248 0 1043 253 0 1450 990 0 1524 1138 0 1525 1140 0 1048 4 0 1047 2 0 1050 255 0 1450 990 0 1523 1136 0 1524 1138 0 1050 255 0 1047 2 0 1056 78 0 1053 14 0 1052 12 0 1051 76 0 1053 14 0 1051 76 0 1056 78 0 1451 992 0 1522 1134 0 1523 1136 0 1056 78 0 1055 18 0 1054 16 0 1451 992 0 1521 1132 0 1522 1134 0 1070 262 0 1069 260 0 1130 376 0 1451 992 0 1520 1130 0 1521 1132 0 1057 377 0 1069 260 0 1068 258 0 1502 1094 0 1503 1096 0 1453 996 0 1130 376 0 1069 260 0 1057 377 0 1058 2 0 1057 377 0 1061 8 0 1061 8 0 1060 6 0 1059 4 0 1067 20 0 1066 18 0 1065 16 0 1062 10 0 1061 8 0 1068 258 0 1454 998 0 1455 1000 0 1502 1094 0 1064 14 0 1063 12 0 1062 10 0 1064 14 0 1062 10 0 1067 20 0 1128 372 0 1071 264 0 1070 262 0 1127 370 0 1072 266 0 1071 264 0 1500 1090 0 1501 1092 0 1502 1094 0 1499 1088 0 1500 1090 0 1502 1094 0 1126 368 0 1073 268 0 1072 266 0 1498 1086 0 1499 1088 0 1502 1094 0 1074 270 0 1073 268 0 1125 366 0 1496 1082 0 1497 1084 0 1502 1094 0 1126 368 0 1125 366 0 1073 268 0 1495 1080 0 1496 1082 0 1502 1094 0 1123 362 0 1075 272 0 1074 270 0 1494 1078 0 1495 1080 0 1502 1094 0 1493 1076 0 1494 1078 0 1502 1094 0 1122 360 0 1076 274 0 1075 272 0 1492 1074 0 1493 1076 0 1502 1094 0 1121 358 0 1077 276 0 1076 274 0 1491 1072 0 1492 1074 0 1502 1094 0 1120 356 0 1078 278 0 1077 276 0 1490 1070 0 1491 1072 0 1502 1094 0 1119 354 0 1079 280 0 1078 278 0 1489 1068 0 1490 1070 0 1502 1094 0 1119 354 0 1080 282 0 1079 280 0 1118 352 0 1081 284 0 1080 282 0 1488 1066 0 1489 1068 0 1502 1094 0 1117 350 0 1082 286 0 1081 284 0 1487 1064 0 1488 1066 0 1502 1094 0 1116 348 0 1083 288 0 1082 286 0 1486 1062 0 1487 1064 0 1502 1094 0 1115 346 0 1084 290 0 1083 288 0 1485 1060 0 1486 1062 0 1502 1094 0 1114 344 0 1085 292 0 1084 290 0 1484 1058 0 1485 1060 0 1502 1094 0 1113 342 0 1086 294 0 1085 292 0 1483 1056 0 1484 1058 0 1502 1094 0 1087 296 0 1086 294 0 1113 342 0 1088 298 0 1087 296 0 1111 338 0 1482 1054 0 1483 1056 0 1502 1094 0 1481 1052 0 1482 1054 0 1502 1094 0 1112 340 0 1111 338 0 1087 296 0 1480 1050 0 1481 1052 0 1502 1094 0 1089 300 0 1088 298 0 1110 336 0 1479 1048 0 1480 1050 0 1502 1094 0 1090 302 0 1089 300 0 1109 334 0 1478 1046 0 1479 1048 0 1502 1094 0 1477 1044 0 1478 1046 0 1502 1094 0 1091 304 0 1090 302 0 1107 330 0 1476 1042 0 1477 1044 0 1502 1094 0 1108 332 0 1107 330 0 1090 302 0 1475 1040 0 1476 1042 0 1502 1094 0 1474 1038 0 1475 1040 0 1502 1094 0 1092 306 0 1091 304 0 1106 328 0 1101 318 0 1100 18 0 1099 316 0 1093 308 0 1092 306 0 1104 324 0 1098 314 0 1097 12 0 1096 10 0 1105 326 0 1104 324 0 1092 306 0 1096 10 0 1101 318 0 1099 316 0 1473 1036 0 1474 1038 0 1502 1094 0 1094 310 0 1093 308 0 1103 322 0 1102 320 0 1095 312 0 1094 310 0 1101 318 0 1096 10 0 1095 312 0 1133 2 0 1132 380 0 1131 383 0 1458 1006 0 1473 1036 0 1502 1094 0 1136 4 0 1135 2 0 1138 255 0 1456 1002 0 1457 1004 0 1502 1094 0 1138 255 0 1135 2 0 1144 78 0 1141 14 0 1140 12 0 1139 76 0 1141 14 0 1139 76 0 1144 78 0 1455 1000 0 1456 1002 0 1502 1094 0 1144 78 0 1143 18 0 1142 16 0 1459 1008 0 1472 1034 0 1473 1036 0 1460 1010 0 1471 1032 0 1472 1034 0 1461 1012 0 1470 1030 0 1471 1032 0 1462 1014 0 1469 1028 0 1470 1030 0 1463 1016 0 1468 1026 0 1469 1028 0 1467 1024 0 1468 1026 0 1463 1016 0 1466 1022 0 1467 1024 0 1464 1018 0 1683 1456 0 1616 1323 0 1677 1444 0 1623 1336 0 1677 1444 0 1616 1323 0 1682 1454 0 1683 1456 0 1678 1446 0 1681 1452 0 1682 1454 0 1679 1448 0 1676 1442 0 1677 1444 0 1623 1336 0 1675 1440 0 1676 1442 0 1624 1338 0 1674 1438 0 1675 1440 0 1625 1340 0 1673 1436 0 1674 1438 0 1626 1342 0 1672 1434 0 1673 1436 0 1627 1344 0 1671 1432 0 1672 1434 0 1628 1346 0 1670 1430 0 1671 1432 0 1629 1348 0 1669 1428 0 1670 1430 0 1630 1350 0 1668 1426 0 1669 1428 0 1631 1352 0 1667 1424 0 1668 1426 0 1632 1354 0 1666 1422 0 1667 1424 0 1633 1356 0 1665 1420 0 1666 1422 0 1634 1358 0 1664 1418 0 1665 1420 0 1635 1360 0 1663 1416 0 1664 1418 0 1636 1362 0 1662 1414 0 1663 1416 0 1637 1364 0 1661 1412 0 1662 1414 0 1638 1366 0 1660 1410 0 1661 1412 0 1639 1368 0 1659 1408 0 1660 1410 0 1640 1370 0 1658 1406 0 1659 1408 0 1641 1372 0 1657 1404 0 1658 1406 0 1642 1374 0 1650 1390 0 1656 1402 0 1657 1404 0 1651 1392 0 1655 1400 0 1656 1402 0 1652 1394 0 1654 1398 0 1655 1400 0 1652 1394 0 1653 1396 0 1654 1398 0 1649 1388 0 1650 1390 0 1643 1376 0 1648 1386 0 1649 1388 0 1644 1378 0 1647 1384 0 1648 1386 0 1645 1380 0 1622 1334 0 1623 1336 0 1617 1324 0 1621 1332 0 1622 1334 0 1618 1326 0 1619 1328 0 1620 1330 0 1621 1332 0 910 245 1053 911 2 2 0 0 0 911 2 2 912 4 4 1 1 1 912 4 4 913 6 6 2 3 3 913 6 6 914 8 8 3 5 5 914 8 8 915 10 10 4 7 7 915 10 10 916 12 12 5 9 9 916 12 12 917 14 14 6 11 11 917 14 14 918 16 16 7 13 13 918 16 16 919 18 18 8 15 15 919 18 18 920 20 20 9 17 17 920 20 20 921 22 22 10 19 19 921 22 22 922 24 24 11 21 21 922 24 24 923 26 26 12 23 23 923 26 26 924 28 28 13 25 25 924 28 28 925 30 30 14 27 27 925 30 30 926 32 32 15 29 29 926 32 32 927 34 34 16 31 31 927 34 34 928 36 36 17 33 33 928 36 36 929 38 38 18 35 35 929 38 38 930 40 40 19 37 37 930 40 40 931 42 42 20 39 39 931 42 42 932 44 44 21 41 41 932 44 44 933 46 46 22 43 43 933 46 46 934 48 48 23 45 45 934 48 48 935 50 50 24 47 47 935 50 50 936 52 52 25 49 49 936 52 52 937 54 54 26 51 51 937 54 54 938 56 56 27 53 53 938 56 56 939 58 58 28 55 55 939 58 58 940 60 60 29 57 57 940 60 60 941 62 62 30 59 59 941 62 62 942 64 64 31 61 61 942 64 64 943 66 66 32 63 63 943 66 66 944 68 68 33 65 65 944 68 68 945 70 70 34 67 67 945 70 70 946 72 72 35 69 69 946 72 72 947 74 74 36 71 71 947 74 74 948 76 76 37 73 73 948 76 76 949 12 78 38 75 75 949 12 78 950 14 80 39 11 77 950 14 80 951 16 82 40 13 79 951 16 82 952 18 84 41 15 81 952 18 84 953 78 86 42 17 83 953 78 86 954 80 88 43 77 85 954 80 88 955 82 90 44 79 87 955 82 90 956 84 92 45 81 89 956 84 92 957 86 94 46 83 91 957 86 94 958 88 96 47 85 93 958 88 96 959 90 98 48 87 95 959 90 98 960 92 100 49 89 97 960 92 100 961 94 102 50 91 99 961 94 102 962 96 104 51 93 101 962 96 104 963 98 106 52 95 103 963 98 106 964 100 108 53 97 105 964 100 108 965 102 110 54 99 107 965 102 110 966 104 112 55 101 109 966 104 112 967 106 114 56 103 111 967 106 114 968 108 116 57 105 113 968 108 116 969 110 118 58 107 115 969 110 118 970 112 120 59 109 117 970 112 120 971 114 122 60 111 119 971 114 122 972 116 124 61 113 121 972 116 124 973 118 126 62 115 123 973 118 126 974 120 128 63 117 125 974 120 128 975 122 130 64 119 127 975 122 130 976 124 132 65 121 129 976 124 132 977 126 134 66 123 131 977 126 134 978 128 136 67 125 133 978 128 136 979 130 138 68 127 135 979 130 138 980 132 140 69 129 137 980 132 140 981 76 142 70 131 139 981 76 142 982 12 144 71 75 141 982 12 144 983 14 146 72 11 143 983 14 146 984 16 148 73 13 145 984 16 148 985 18 150 74 15 147 985 18 150 986 78 152 75 17 149 986 78 152 987 134 154 76 77 151 987 134 154 988 136 156 77 133 153 988 136 156 989 138 158 78 135 155 989 138 158 990 140 160 79 137 157 990 140 160 991 142 162 80 139 159 991 142 162 992 144 164 81 141 161 992 144 164 993 146 166 82 143 163 993 146 166 994 148 168 83 145 165 994 148 168 995 150 170 84 147 167 995 150 170 996 152 172 85 149 169 996 152 172 997 154 174 86 151 171 997 154 174 998 156 176 87 153 173 998 156 176 999 158 178 88 155 175 999 158 178 1000 160 180 89 157 177 1000 160 180 1001 162 182 90 159 179 1001 162 182 1002 164 184 91 161 181 1002 164 184 1003 166 186 92 163 183 1003 166 186 1004 168 188 93 165 185 1004 168 188 1005 170 190 94 167 187 1005 170 190 1006 172 192 95 169 189 1006 172 192 1007 174 194 96 171 191 1007 174 194 1008 176 196 97 173 193 1008 176 196 1009 178 198 98 175 195 1009 178 198 1010 180 200 99 177 197 1010 180 200 1011 182 202 100 179 199 1011 182 202 1012 184 204 101 181 201 1012 184 204 1013 186 206 102 183 203 1013 186 206 1014 188 208 103 185 205 1014 188 208 1015 190 210 104 187 207 1015 190 210 1016 192 212 105 189 209 1016 192 212 1017 194 214 106 191 211 1017 194 214 1018 196 216 107 193 213 1018 196 216 1019 198 218 108 195 215 1019 198 218 1020 200 220 109 197 217 1020 200 220 1021 202 222 110 199 219 1021 202 222 1022 204 224 111 201 221 1022 204 224 1023 206 226 112 203 223 1023 206 226 1024 208 228 113 205 225 1024 208 228 1025 210 230 114 207 227 1025 210 230 1026 212 232 115 209 229 1026 212 232 1027 214 234 116 211 231 1027 214 234 1028 216 236 117 213 233 1028 216 236 1029 218 238 118 215 235 1029 218 238 1030 220 240 119 217 237 1030 220 240 1031 222 242 120 219 239 1031 222 242 1032 224 244 121 221 241 1032 224 244 1033 226 246 122 223 243 1033 226 246 1034 228 248 123 225 245 1034 228 248 1035 230 250 124 227 247 1035 230 250 1036 232 252 125 229 249 1036 232 252 1037 234 254 126 231 251 1037 234 254 1038 236 256 127 233 253 1038 236 256 1039 238 258 128 235 255 1039 238 258 1040 240 260 129 237 257 1040 240 260 1041 242 262 130 239 259 1041 242 262 1042 244 264 131 241 261 1042 244 264 910 245 266 132 243 263 1043 253 1053 1044 248 268 133 246 0 1044 248 268 1045 250 270 134 247 267 1045 250 270 1046 252 272 135 249 269 1046 252 272 1043 253 266 136 251 271 1047 2 1053 1048 4 274 137 1 0 1048 4 274 1049 6 276 138 3 273 1049 6 276 1050 255 278 139 5 275 1050 255 278 1051 76 280 140 254 277 1051 76 280 1052 12 282 141 75 279 1052 12 282 1053 14 284 142 11 281 1053 14 284 1054 16 286 143 13 283 1054 16 286 1055 18 288 144 15 285 1055 18 288 1056 78 290 145 17 287 1056 78 290 1047 2 266 146 77 289 1057 377 1053 1058 2 292 147 256 0 1058 2 292 1059 4 294 148 1 291 1059 4 294 1060 6 296 149 3 293 1060 6 296 1061 8 298 150 5 295 1061 8 298 1062 10 300 151 7 297 1062 10 300 1063 12 302 152 9 299 1063 12 302 1064 14 304 153 11 301 1064 14 304 1065 16 306 154 13 303 1065 16 306 1066 18 308 155 15 305 1066 18 308 1067 20 310 156 17 307 1067 20 310 1068 258 312 157 19 309 1068 258 312 1069 260 314 158 257 311 1069 260 314 1070 262 316 159 259 313 1070 262 316 1071 264 318 160 261 315 1071 264 318 1072 266 320 161 263 317 1072 266 320 1073 268 322 162 265 319 1073 268 322 1074 270 324 163 267 321 1074 270 324 1075 272 326 164 269 323 1075 272 326 1076 274 328 165 271 325 1076 274 328 1077 276 330 166 273 327 1077 276 330 1078 278 332 167 275 329 1078 278 332 1079 280 334 168 277 331 1079 280 334 1080 282 336 169 279 333 1080 282 336 1081 284 338 170 281 335 1081 284 338 1082 286 340 171 283 337 1082 286 340 1083 288 342 172 285 339 1083 288 342 1084 290 344 173 287 341 1084 290 344 1085 292 346 174 289 343 1085 292 346 1086 294 348 175 291 345 1086 294 348 1087 296 350 176 293 347 1087 296 350 1088 298 352 177 295 349 1088 298 352 1089 300 354 178 297 351 1089 300 354 1090 302 356 179 299 353 1090 302 356 1091 304 358 180 301 355 1091 304 358 1092 306 360 181 303 357 1092 306 360 1093 308 362 182 305 359 1093 308 362 1094 310 364 183 307 361 1094 310 364 1095 312 366 184 309 363 1095 312 366 1096 10 368 185 311 365 1096 10 368 1097 12 370 186 9 367 1097 12 370 1098 314 372 187 11 369 1098 314 372 1099 316 374 188 313 371 1099 316 374 1100 18 376 189 315 373 1100 18 376 1101 318 378 190 17 375 1101 318 378 1102 320 380 191 317 377 1102 320 380 1103 322 382 192 319 379 1103 322 382 1104 324 384 193 321 381 1104 324 384 1105 326 386 194 323 383 1105 326 386 1106 328 388 195 325 385 1106 328 388 1107 330 390 196 327 387 1107 330 390 1108 332 392 197 329 389 1108 332 392 1109 334 394 198 331 391 1109 334 394 1110 336 396 199 333 393 1110 336 396 1111 338 398 200 335 395 1111 338 398 1112 340 400 201 337 397 1112 340 400 1113 342 402 202 339 399 1113 342 402 1114 344 404 203 341 401 1114 344 404 1115 346 406 204 343 403 1115 346 406 1116 348 408 205 345 405 1116 348 408 1117 350 410 206 347 407 1117 350 410 1118 352 412 207 349 409 1118 352 412 1119 354 414 208 351 411 1119 354 414 1120 356 416 209 353 413 1120 356 416 1121 358 418 210 355 415 1121 358 418 1122 360 420 211 357 417 1122 360 420 1123 362 422 212 359 419 1123 362 422 1124 364 424 213 361 421 1124 364 424 1125 366 426 214 363 423 1125 366 426 1126 368 428 215 365 425 1126 368 428 1127 370 430 216 367 427 1127 370 430 1128 372 432 217 369 429 1128 372 432 1129 374 434 218 371 431 1129 374 434 1130 376 436 219 373 433 1130 376 436 1057 377 266 220 375 435 1131 383 1053 1132 380 438 221 378 0 1132 380 438 1133 2 270 222 379 437 1133 2 270 1134 382 440 223 1 269 1134 382 440 1131 383 266 224 381 439 1135 2 1053 1136 4 442 225 1 0 1136 4 442 1137 6 444 226 3 441 1137 6 444 1138 255 446 227 5 443 1138 255 446 1139 76 448 228 254 445 1139 76 448 1140 12 450 229 75 447 1140 12 450 1141 14 452 230 11 449 1141 14 452 1142 16 286 231 13 451 1142 16 286 1143 18 288 232 15 285 1143 18 288 1144 78 290 233 17 287 1144 78 290 1135 2 266 234 77 289 1338 985 1053 1339 768 836 428 766 0 1339 768 836 1340 770 838 429 767 835 1340 770 838 1341 772 840 430 769 837 1341 772 840 1342 774 842 431 771 839 1342 774 842 1343 776 844 432 773 841 1343 776 844 1344 778 846 433 775 843 1344 778 846 1345 780 848 434 777 845 1345 780 848 1346 782 850 435 779 847 1346 782 850 1347 784 852 436 781 849 1347 784 852 1348 786 854 437 783 851 1348 786 854 1349 788 856 438 785 853 1349 788 856 1350 790 858 439 787 855 1350 790 858 1351 792 860 440 789 857 1351 792 860 1352 794 862 441 791 859 1352 794 862 1353 796 864 442 793 861 1353 796 864 1354 798 866 443 795 863 1354 798 866 1355 800 868 444 797 865 1355 800 868 1356 802 870 445 799 867 1356 802 870 1357 804 872 446 801 869 1357 804 872 1358 806 874 447 803 871 1358 806 874 1359 808 876 448 805 873 1359 808 876 1360 810 878 449 807 875 1360 810 878 1361 812 880 450 809 877 1361 812 880 1362 814 882 451 811 879 1362 814 882 1363 816 884 452 813 881 1363 816 884 1364 818 886 453 815 883 1364 818 886 1365 820 888 454 817 885 1365 820 888 1366 822 890 455 819 887 1366 822 890 1367 824 892 456 821 889 1367 824 892 1368 826 894 457 823 891 1368 826 894 1369 828 896 458 825 893 1369 828 896 1370 830 898 459 827 895 1370 830 898 1371 832 900 460 829 897 1371 832 900 1372 834 902 461 831 899 1372 834 902 1373 836 904 462 833 901 1373 836 904 1374 838 906 463 835 903 1374 838 906 1375 840 908 464 837 905 1375 840 908 1376 842 910 465 839 907 1376 842 910 1377 844 912 466 841 909 1377 844 912 1378 846 914 467 843 911 1378 846 914 1379 848 916 468 845 913 1379 848 916 1380 850 918 469 847 915 1380 850 918 1381 852 920 470 849 917 1381 852 920 1382 854 922 471 851 919 1382 854 922 1383 856 924 472 853 921 1383 856 924 1384 858 926 473 855 923 1384 858 926 1385 860 928 474 857 925 1385 860 928 1386 862 930 475 859 927 1386 862 930 1387 864 932 476 861 929 1387 864 932 1388 866 934 477 863 931 1388 866 934 1389 868 936 478 865 933 1389 868 936 1390 870 938 479 867 935 1390 870 938 1391 872 940 480 869 937 1391 872 940 1392 874 942 481 871 939 1392 874 942 1393 876 944 482 873 941 1393 876 944 1394 878 946 483 875 943 1394 878 946 1395 880 948 484 877 945 1395 880 948 1396 882 950 485 879 947 1396 882 950 1397 884 952 486 881 949 1397 884 952 1398 886 954 487 883 951 1398 886 954 1399 888 956 488 885 953 1399 888 956 1400 890 958 489 887 955 1400 890 958 1401 892 960 490 889 957 1401 892 960 1402 894 962 491 891 959 1402 894 962 1403 896 964 492 893 961 1403 896 964 1404 898 966 493 895 963 1404 898 966 1405 900 968 494 897 965 1405 900 968 1406 902 970 495 899 967 1406 902 970 1407 904 972 496 901 969 1407 904 972 1408 906 974 497 903 971 1408 906 974 1409 908 976 498 905 973 1409 908 976 1410 910 978 499 907 975 1410 910 978 1411 912 980 500 909 977 1411 912 980 1412 914 982 501 911 979 1412 914 982 1413 916 984 502 913 981 1413 916 984 1414 918 986 503 915 983 1414 918 986 1415 920 988 504 917 985 1415 920 988 1416 922 990 505 919 987 1416 922 990 1417 924 992 506 921 989 1417 924 992 1418 926 994 507 923 991 1418 926 994 1419 928 996 508 925 993 1419 928 996 1420 930 998 509 927 995 1420 930 998 1421 932 1000 510 929 997 1421 932 1000 1422 934 1002 511 931 999 1422 934 1002 1423 936 1004 512 933 1001 1423 936 1004 1424 938 1006 513 935 1003 1424 938 1006 1425 940 1008 514 937 1005 1425 940 1008 1426 942 1010 515 939 1007 1426 942 1010 1427 944 1012 516 941 1009 1427 944 1012 1428 946 1014 517 943 1011 1428 946 1014 1429 948 1016 518 945 1013 1429 948 1016 1430 950 1018 519 947 1015 1430 950 1018 1431 952 1020 520 949 1017 1431 952 1020 1432 954 1022 521 951 1019 1432 954 1022 1433 956 1024 522 953 1021 1433 956 1024 1434 958 1026 523 955 1023 1434 958 1026 1435 960 1028 524 957 1025 1435 960 1028 1436 962 1030 525 959 1027 1436 962 1030 1437 964 1032 526 961 1029 1437 964 1032 1438 966 1034 527 963 1031 1438 966 1034 1439 968 1036 528 965 1033 1439 968 1036 1440 970 1038 529 967 1035 1440 970 1038 1441 972 1040 530 969 1037 1441 972 1040 1442 974 1042 531 971 1039 1442 974 1042 1443 976 1044 532 973 1041 1443 976 1044 1444 978 1046 533 975 1043 1444 978 1046 1445 980 1048 534 977 1045 1445 980 1048 1446 982 1050 535 979 1047 1446 982 1050 1447 984 1052 536 981 1049 1447 984 1052 1338 985 266 537 983 1051 539 989 1055 1449 988 1054 538 986 0 540 991 269 1450 990 270 539 989 1055 541 993 1057 1451 992 1056 540 991 269 538 986 265 1448 987 266 541 993 1057 543 997 1059 1453 996 1058 542 994 0 544 999 1061 1454 998 1060 543 997 1059 545 1001 1063 1455 1000 1062 544 999 1061 546 1003 1065 1456 1002 1064 545 1001 1063 547 1005 1067 1457 1004 1066 546 1003 1065 548 1007 1069 1458 1006 1068 547 1005 1067 549 1009 1071 1459 1008 1070 548 1007 1069 550 1011 1073 1460 1010 1072 549 1009 1071 551 1013 1075 1461 1012 1074 550 1011 1073 552 1015 1077 1462 1014 1076 551 1013 1075 553 1017 1079 1463 1016 1078 552 1015 1077 554 1019 1081 1464 1018 1080 553 1017 1079 555 1021 1083 1465 1020 1082 554 1019 1081 556 1023 1085 1466 1022 1084 555 1021 1083 557 1025 1087 1467 1024 1086 556 1023 1085 558 1027 1089 1468 1026 1088 557 1025 1087 559 1029 1091 1469 1028 1090 558 1027 1089 560 1031 1093 1470 1030 1092 559 1029 1091 561 1033 1095 1471 1032 1094 560 1031 1093 562 1035 1097 1472 1034 1096 561 1033 1095 563 1037 1099 1473 1036 1098 562 1035 1097 564 1039 1101 1474 1038 1100 563 1037 1099 565 1041 1103 1475 1040 1102 564 1039 1101 566 1043 1105 1476 1042 1104 565 1041 1103 567 1045 1107 1477 1044 1106 566 1043 1105 568 1047 1109 1478 1046 1108 567 1045 1107 569 1049 1111 1479 1048 1110 568 1047 1109 570 1051 1113 1480 1050 1112 569 1049 1111 571 1053 1115 1481 1052 1114 570 1051 1113 572 1055 1117 1482 1054 1116 571 1053 1115 573 1057 1119 1483 1056 1118 572 1055 1117 574 1059 1121 1484 1058 1120 573 1057 1119 575 1061 1123 1485 1060 1122 574 1059 1121 576 1063 1125 1486 1062 1124 575 1061 1123 577 1065 1127 1487 1064 1126 576 1063 1125 578 1067 1129 1488 1066 1128 577 1065 1127 579 1069 1131 1489 1068 1130 578 1067 1129 580 1071 1133 1490 1070 1132 579 1069 1131 581 1073 1135 1491 1072 1134 580 1071 1133 582 1075 1137 1492 1074 1136 581 1073 1135 583 1077 1139 1493 1076 1138 582 1075 1137 584 1079 1141 1494 1078 1140 583 1077 1139 585 1081 1143 1495 1080 1142 584 1079 1141 586 1083 1145 1496 1082 1144 585 1081 1143 587 1085 1147 1497 1084 1146 586 1083 1145 588 1087 1149 1498 1086 1148 587 1085 1147 589 1089 1151 1499 1088 1150 588 1087 1149 590 1091 1153 1500 1090 1152 589 1089 1151 591 1093 1155 1501 1092 1154 590 1091 1153 592 1095 1157 1502 1094 1156 591 1093 1155 593 1097 1159 1503 1096 1158 592 1095 1157 594 1099 1161 1504 1098 1160 593 1097 1159 595 1101 1163 1505 1100 1162 594 1099 1161 596 1103 1165 1506 1102 1164 595 1101 1163 597 1105 1167 1507 1104 1166 596 1103 1165 598 1107 1169 1508 1106 1168 597 1105 1167 599 1109 1171 1509 1108 1170 598 1107 1169 600 1111 1173 1510 1110 1172 599 1109 1171 601 1113 1175 1511 1112 1174 600 1111 1173 602 1115 1177 1512 1114 1176 601 1113 1175 603 1117 1179 1513 1116 1178 602 1115 1177 604 1119 1181 1514 1118 1180 603 1117 1179 605 1121 1183 1515 1120 1182 604 1119 1181 606 1123 1185 1516 1122 1184 605 1121 1183 607 1125 1187 1517 1124 1186 606 1123 1185 608 1127 1189 1518 1126 1188 607 1125 1187 609 1129 1191 1519 1128 1190 608 1127 1189 610 1131 1193 1520 1130 1192 609 1129 1191 611 1133 1195 1521 1132 1194 610 1131 1193 612 1135 1197 1522 1134 1196 611 1133 1195 613 1137 1199 1523 1136 1198 612 1135 1197 614 1139 1201 1524 1138 1200 613 1137 1199 615 1141 1203 1525 1140 1202 614 1139 1201 616 1143 1205 1526 1142 1204 615 1141 1203 617 1145 1207 1527 1144 1206 616 1143 1205 618 1147 1209 1528 1146 1208 617 1145 1207 619 1149 1211 1529 1148 1210 618 1147 1209 620 1151 1213 1530 1150 1212 619 1149 1211 621 1153 1215 1531 1152 1214 620 1151 1213 622 1155 1217 1532 1154 1216 621 1153 1215 623 1157 1219 1533 1156 1218 622 1155 1217 624 1159 1221 1534 1158 1220 623 1157 1219 625 1161 1223 1535 1160 1222 624 1159 1221 626 1163 1225 1536 1162 1224 625 1161 1223 627 1165 1227 1537 1164 1226 626 1163 1225 628 1167 1229 1538 1166 1228 627 1165 1227 629 1169 1231 1539 1168 1230 628 1167 1229 630 1171 1233 1540 1170 1232 629 1169 1231 631 1173 1235 1541 1172 1234 630 1171 1233 632 1175 1237 1542 1174 1236 631 1173 1235 633 1177 1239 1543 1176 1238 632 1175 1237 634 1179 1241 1544 1178 1240 633 1177 1239 542 994 265 1452 995 266 634 1179 1241 636 1183 1243 1546 1182 1242 635 1180 0 637 1185 1245 1547 1184 1244 636 1183 1243 638 1187 1247 1548 1186 1246 637 1185 1245 639 1189 1249 1549 1188 1248 638 1187 1247 640 1191 1251 1550 1190 1250 639 1189 1249 641 1193 1253 1551 1192 1252 640 1191 1251 642 1195 1255 1552 1194 1254 641 1193 1253 643 1197 1257 1553 1196 1256 642 1195 1255 644 1199 1259 1554 1198 1258 643 1197 1257 645 1201 1261 1555 1200 1260 644 1199 1259 646 1203 1263 1556 1202 1262 645 1201 1261 647 1205 1265 1557 1204 1264 646 1203 1263 648 1207 1267 1558 1206 1266 647 1205 1265 649 1209 1269 1559 1208 1268 648 1207 1267 650 1211 1271 1560 1210 1270 649 1209 1269 651 1213 1273 1561 1212 1272 650 1211 1271 652 1215 1275 1562 1214 1274 651 1213 1273 653 1217 1277 1563 1216 1276 652 1215 1275 654 1219 1279 1564 1218 1278 653 1217 1277 655 1221 1281 1565 1220 1280 654 1219 1279 656 1223 1283 1566 1222 1282 655 1221 1281 657 1225 1285 1567 1224 1284 656 1223 1283 658 1227 1287 1568 1226 1286 657 1225 1285 659 1229 1289 1569 1228 1288 658 1227 1287 660 1231 1291 1570 1230 1290 659 1229 1289 661 1233 1293 1571 1232 1292 660 1231 1291 662 1235 1295 1572 1234 1294 661 1233 1293 663 1237 1297 1573 1236 1296 662 1235 1295 664 1239 1299 1574 1238 1298 663 1237 1297 665 1241 1301 1575 1240 1300 664 1239 1299 666 1243 1303 1576 1242 1302 665 1241 1301 667 1245 1305 1577 1244 1304 666 1243 1303 668 1247 1307 1578 1246 1306 667 1245 1305 669 1249 1309 1579 1248 1308 668 1247 1307 670 1251 1311 1580 1250 1310 669 1249 1309 671 1253 1313 1581 1252 1312 670 1251 1311 672 1255 1315 1582 1254 1314 671 1253 1313 673 1257 1317 1583 1256 1316 672 1255 1315 674 1259 1319 1584 1258 1318 673 1257 1317 675 1261 1321 1585 1260 1320 674 1259 1319 676 1263 1323 1586 1262 1322 675 1261 1321 677 1265 1325 1587 1264 1324 676 1263 1323 678 1267 1327 1588 1266 1326 677 1265 1325 679 1269 1329 1589 1268 1328 678 1267 1327 680 1271 1331 1590 1270 1330 679 1269 1329 681 1273 1333 1591 1272 1332 680 1271 1331 682 1275 1335 1592 1274 1334 681 1273 1333 683 1277 1337 1593 1276 1336 682 1275 1335 684 1279 1339 1594 1278 1338 683 1277 1337 685 1281 1341 1595 1280 1340 684 1279 1339 686 1283 1343 1596 1282 1342 685 1281 1341 687 1285 1345 1597 1284 1344 686 1283 1343 688 1287 1347 1598 1286 1346 687 1285 1345 689 1289 1349 1599 1288 1348 688 1287 1347 690 1291 1351 1600 1290 1350 689 1289 1349 691 1293 1353 1601 1292 1352 690 1291 1351 692 1295 1355 1602 1294 1354 691 1293 1353 693 1297 1357 1603 1296 1356 692 1295 1355 694 1299 1359 1604 1298 1358 693 1297 1357 695 1301 1361 1605 1300 1360 694 1299 1359 696 1303 1363 1606 1302 1362 695 1301 1361 697 1305 1365 1607 1304 1364 696 1303 1363 698 1307 1367 1608 1306 1366 697 1305 1365 699 1309 1369 1609 1308 1368 698 1307 1367 700 1311 1371 1610 1310 1370 699 1309 1369 701 1313 1373 1611 1312 1372 700 1311 1371 702 1315 1375 1612 1314 1374 701 1313 1373 703 1317 1377 1613 1316 1376 702 1315 1375 704 1319 1379 1614 1318 1378 703 1317 1377 705 1321 1381 1615 1320 1380 704 1319 1379 635 1180 265 1545 1181 266 705 1321 1381 707 1325 1383 1617 1324 1382 706 1322 0 708 1327 1385 1618 1326 1384 707 1325 1383 709 1329 1387 1619 1328 1386 708 1327 1385 710 1331 1389 1620 1330 1388 709 1329 1387 711 1333 1391 1621 1332 1390 710 1331 1389 712 1335 1393 1622 1334 1392 711 1333 1391 713 1337 1395 1623 1336 1394 712 1335 1393 714 1339 1397 1624 1338 1396 713 1337 1395 715 1341 1399 1625 1340 1398 714 1339 1397 716 1343 1401 1626 1342 1400 715 1341 1399 717 1345 1403 1627 1344 1402 716 1343 1401 718 1347 1405 1628 1346 1404 717 1345 1403 719 1349 1407 1629 1348 1406 718 1347 1405 720 1351 1409 1630 1350 1408 719 1349 1407 721 1353 1411 1631 1352 1410 720 1351 1409 722 1355 1413 1632 1354 1412 721 1353 1411 723 1357 1415 1633 1356 1414 722 1355 1413 724 1359 1417 1634 1358 1416 723 1357 1415 725 1361 1419 1635 1360 1418 724 1359 1417 726 1363 1421 1636 1362 1420 725 1361 1419 727 1365 1423 1637 1364 1422 726 1363 1421 728 1367 1425 1638 1366 1424 727 1365 1423 729 1369 1427 1639 1368 1426 728 1367 1425 730 1371 1429 1640 1370 1428 729 1369 1427 731 1373 1431 1641 1372 1430 730 1371 1429 732 1375 1433 1642 1374 1432 731 1373 1431 733 1377 1435 1643 1376 1434 732 1375 1433 734 1379 1437 1644 1378 1436 733 1377 1435 735 1381 1439 1645 1380 1438 734 1379 1437 736 1383 1441 1646 1382 1440 735 1381 1439 737 1385 1443 1647 1384 1442 736 1383 1441 738 1387 1445 1648 1386 1444 737 1385 1443 739 1389 1447 1649 1388 1446 738 1387 1445 740 1391 1449 1650 1390 1448 739 1389 1447 741 1393 1451 1651 1392 1450 740 1391 1449 742 1395 1453 1652 1394 1452 741 1393 1451 743 1397 1455 1653 1396 1454 742 1395 1453 744 1399 1457 1654 1398 1456 743 1397 1455 745 1401 1459 1655 1400 1458 744 1399 1457 746 1403 1461 1656 1402 1460 745 1401 1459 747 1405 1463 1657 1404 1462 746 1403 1461 748 1407 1465 1658 1406 1464 747 1405 1463 749 1409 1467 1659 1408 1466 748 1407 1465 750 1411 1469 1660 1410 1468 749 1409 1467 751 1413 1471 1661 1412 1470 750 1411 1469 752 1415 1473 1662 1414 1472 751 1413 1471 753 1417 1475 1663 1416 1474 752 1415 1473 754 1419 1477 1664 1418 1476 753 1417 1475 755 1421 1479 1665 1420 1478 754 1419 1477 756 1423 1481 1666 1422 1480 755 1421 1479 757 1425 1483 1667 1424 1482 756 1423 1481 758 1427 1485 1668 1426 1484 757 1425 1483 759 1429 1487 1669 1428 1486 758 1427 1485 760 1431 1489 1670 1430 1488 759 1429 1487 761 1433 1491 1671 1432 1490 760 1431 1489 762 1435 1493 1672 1434 1492 761 1433 1491 763 1437 1495 1673 1436 1494 762 1435 1493 764 1439 1497 1674 1438 1496 763 1437 1495 765 1441 1499 1675 1440 1498 764 1439 1497 766 1443 1501 1676 1442 1500 765 1441 1499 767 1445 1503 1677 1444 1502 766 1443 1501 768 1447 1505 1678 1446 1504 767 1445 1503 769 1449 1507 1679 1448 1506 768 1447 1505 770 1451 1509 1680 1450 1508 769 1449 1507 771 1453 1511 1681 1452 1510 770 1451 1509 772 1455 1513 1682 1454 1512 771 1453 1511 773 1457 1515 1683 1456 1514 772 1455 1513 706 1322 265 1616 1323 266 773 1457 1515 775 1461 1517 1685 1460 1516 774 1458 0 776 1463 1519 1686 1462 1518 775 1461 1517 777 1465 1521 1687 1464 1520 776 1463 1519 778 1467 1523 1688 1466 1522 777 1465 1521 779 577 1525 1689 578 1524 778 1467 1523 780 1469 1527 1690 1468 1526 779 577 1525 781 1471 1529 1691 1470 1528 780 1469 1527 782 1473 1531 1692 1472 1530 781 1471 1529 783 1475 1533 1693 1474 1532 782 1473 1531 784 1477 1535 1694 1476 1534 783 1475 1533 785 1479 1537 1695 1478 1536 784 1477 1535 786 1481 1539 1696 1480 1538 785 1479 1537 787 1483 1541 1697 1482 1540 786 1481 1539 788 1485 1543 1698 1484 1542 787 1483 1541 789 1487 1545 1699 1486 1544 788 1485 1543 790 1489 1547 1700 1488 1546 789 1487 1545 791 1491 1549 1701 1490 1548 790 1489 1547 792 1493 1551 1702 1492 1550 791 1491 1549 793 1495 1553 1703 1494 1552 792 1493 1551 794 1497 1555 1704 1496 1554 793 1495 1553 795 1499 1557 1705 1498 1556 794 1497 1555 796 1501 1559 1706 1500 1558 795 1499 1557 797 1503 1561 1707 1502 1560 796 1501 1559 798 1505 1563 1708 1504 1562 797 1503 1561 799 1507 1565 1709 1506 1564 798 1505 1563 800 1509 1567 1710 1508 1566 799 1507 1565 801 1511 1569 1711 1510 1568 800 1509 1567 802 1513 1571 1712 1512 1570 801 1511 1569 803 1515 1573 1713 1514 1572 802 1513 1571 804 1517 1575 1714 1516 1574 803 1515 1573 805 1519 1577 1715 1518 1576 804 1517 1575 806 1521 1579 1716 1520 1578 805 1519 1577 807 1523 1581 1717 1522 1580 806 1521 1579 808 1525 1583 1718 1524 1582 807 1523 1581 809 1527 1585 1719 1526 1584 808 1525 1583 810 1529 1587 1720 1528 1586 809 1527 1585 811 1531 1589 1721 1530 1588 810 1529 1587 812 1533 1591 1722 1532 1590 811 1531 1589 813 1535 1593 1723 1534 1592 812 1533 1591 814 1537 1595 1724 1536 1594 813 1535 1593 815 1539 1597 1725 1538 1596 814 1537 1595 816 1473 1599 1726 1472 1598 815 1539 1597 817 1541 1601 1727 1540 1600 816 1473 1599 818 1543 1603 1728 1542 1602 817 1541 1601 819 1545 1605 1729 1544 1604 818 1543 1603 820 1547 1607 1730 1546 1606 819 1545 1605 821 1549 1609 1731 1548 1608 820 1547 1607 822 1551 1611 1732 1550 1610 821 1549 1609 823 1553 1613 1733 1552 1612 822 1551 1611 824 1555 1615 1734 1554 1614 823 1553 1613 825 1557 1617 1735 1556 1616 824 1555 1615 826 1559 1619 1736 1558 1618 825 1557 1617 827 1561 1621 1737 1560 1620 826 1559 1619 828 1563 1623 1738 1562 1622 827 1561 1621 829 1565 1625 1739 1564 1624 828 1563 1623 830 1567 1627 1740 1566 1626 829 1565 1625 831 1569 1629 1741 1568 1628 830 1567 1627 832 1571 1631 1742 1570 1630 831 1569 1629 833 1573 1633 1743 1572 1632 832 1571 1631 834 1575 1635 1744 1574 1634 833 1573 1633 835 1577 1637 1745 1576 1636 834 1575 1635 836 1579 1639 1746 1578 1638 835 1577 1637 837 1581 1641 1747 1580 1640 836 1579 1639 838 1583 1643 1748 1582 1642 837 1581 1641 839 1585 1645 1749 1584 1644 838 1583 1643 840 1587 1647 1750 1586 1646 839 1585 1645 841 1589 1649 1751 1588 1648 840 1587 1647 842 1591 1651 1752 1590 1650 841 1589 1649 843 1593 1653 1753 1592 1652 842 1591 1651 844 1595 1655 1754 1594 1654 843 1593 1653 845 1597 1657 1755 1596 1656 844 1595 1655 846 1533 1659 1756 1532 1658 845 1597 1657 847 1535 1661 1757 1534 1660 846 1533 1659 848 1537 1663 1758 1536 1662 847 1535 1661 849 1539 1665 1759 1538 1664 848 1537 1663 850 1599 1667 1760 1598 1666 849 1539 1665 851 1600 1669 1761 1540 1668 850 1599 1667 852 1602 1671 1762 1601 1670 851 1600 1669 853 1604 1673 1763 1603 1672 852 1602 1671 854 1606 1675 1764 1605 1674 853 1604 1673 855 1608 1677 1765 1607 1676 854 1606 1675 856 1610 1679 1766 1609 1678 855 1608 1677 857 1612 1681 1767 1611 1680 856 1610 1679 858 1614 1683 1768 1613 1682 857 1612 1681 859 1616 1685 1769 1615 1684 858 1614 1683 860 1618 1687 1770 1617 1686 859 1616 1685 861 1620 1689 1771 1619 1688 860 1618 1687 862 1622 1691 1772 1621 1690 861 1620 1689 863 1624 1693 1773 1623 1692 862 1622 1691 864 1626 1695 1774 1625 1694 863 1624 1693 865 1628 1697 1775 1627 1696 864 1626 1695 866 1630 1699 1776 1629 1698 865 1628 1697 867 1632 1701 1777 1631 1700 866 1630 1699 868 1634 1703 1778 1633 1702 867 1632 1701 869 1636 1705 1779 1635 1704 868 1634 1703 870 1638 1707 1780 1637 1706 869 1636 1705 871 1640 1709 1781 1639 1708 870 1638 1707 872 1642 1711 1782 1641 1710 871 1640 1709 873 1644 1713 1783 1643 1712 872 1642 1711 874 1646 1715 1784 1645 1714 873 1644 1713 875 1648 1717 1785 1647 1716 874 1646 1715 876 1650 1719 1786 1649 1718 875 1648 1717 877 1652 1721 1787 1651 1720 876 1650 1719 878 1654 1723 1788 1653 1722 877 1652 1721 879 1656 1725 1789 1655 1724 878 1654 1723 880 1658 1727 1790 1657 1726 879 1656 1725 881 1660 1729 1791 1659 1728 880 1658 1727 882 1662 1731 1792 1661 1730 881 1660 1729 883 1664 1733 1793 1663 1732 882 1662 1731 884 1666 1735 1794 1665 1734 883 1664 1733 885 1668 1737 1795 1667 1736 884 1666 1735 886 1670 1739 1796 1669 1738 885 1668 1737 887 1672 1741 1797 1671 1740 886 1670 1739 888 1674 1743 1798 1673 1742 887 1672 1741 889 1676 1745 1799 1675 1744 888 1674 1743 890 1678 1747 1800 1677 1746 889 1676 1745 891 1680 1749 1801 1679 1748 890 1678 1747 892 1682 1751 1802 1681 1750 891 1680 1749 893 1684 1753 1803 1683 1752 892 1682 1751 894 1686 1755 1804 1685 1754 893 1684 1753 895 1688 1757 1805 1687 1756 894 1686 1755 896 1690 1759 1806 1689 1758 895 1688 1757 897 1692 1761 1807 1691 1760 896 1690 1759 898 1694 1763 1808 1693 1762 897 1692 1761 899 1696 1765 1809 1695 1764 898 1694 1763 900 1698 1767 1810 1697 1766 899 1696 1765 901 1700 1769 1811 1699 1768 900 1698 1767 902 1702 1771 1812 1701 1770 901 1700 1769 903 1704 1773 1813 1703 1772 902 1702 1771 904 1706 1775 1814 1705 1774 903 1704 1773 905 1708 1777 1815 1707 1776 904 1706 1775 906 1710 1779 1816 1709 1778 905 1708 1777 907 1712 1781 1817 1711 1780 906 1710 1779 908 1714 1783 1818 1713 1782 907 1712 1781 909 1716 1785 1819 1715 1784 908 1714 1783 774 1458 265 1684 1459 266 909 1716 1785 11 21 0 12 23 0 0 0 0 2 3 0 4 7 0 1 1 0 12 23 0 13 25 0 132 243 0 13 25 0 14 27 0 131 241 0 14 27 0 15 29 0 130 239 0 15 29 0 16 31 0 129 237 0 16 31 0 17 33 0 128 235 0 17 33 0 18 35 0 127 233 0 19 37 0 125 229 0 18 35 0 20 39 0 124 227 0 19 37 0 21 41 0 123 225 0 20 39 0 23 45 0 122 223 0 22 43 0 24 47 0 121 221 0 23 45 0 24 47 0 25 49 0 121 221 0 25 49 0 26 51 0 120 219 0 26 51 0 27 53 0 119 217 0 27 53 0 28 55 0 118 215 0 28 55 0 29 57 0 117 213 0 29 57 0 30 59 0 116 211 0 30 59 0 31 61 0 114 207 0 31 61 0 32 63 0 112 203 0 32 63 0 33 65 0 110 199 0 33 65 0 34 67 0 109 197 0 35 69 0 107 193 0 34 67 0 45 81 0 106 191 0 44 79 0 35 69 0 36 71 0 107 193 0 45 81 0 46 83 0 105 189 0 46 83 0 47 85 0 104 187 0 49 89 0 102 183 0 48 87 0 49 89 0 50 91 0 101 181 0 50 91 0 51 93 0 100 179 0 52 95 0 98 175 0 51 93 0 53 97 0 97 173 0 52 95 0 54 99 0 96 171 0 53 97 0 5 9 0 7 13 0 10 19 0 54 99 0 55 101 0 96 171 0 55 101 0 56 103 0 95 169 0 4 7 0 5 9 0 11 21 0 56 103 0 57 105 0 94 167 0 57 105 0 58 107 0 93 165 0 38 75 0 40 13 0 43 77 0 58 107 0 59 109 0 92 163 0 59 109 0 60 111 0 91 161 0 60 111 0 61 113 0 90 159 0 61 113 0 62 115 0 89 157 0 62 115 0 63 117 0 88 155 0 38 75 0 43 77 0 37 73 0 63 117 0 64 119 0 87 153 0 64 119 0 65 121 0 86 151 0 71 75 0 73 13 0 76 77 0 65 121 0 66 123 0 83 145 0 71 75 0 76 77 0 70 131 0 66 123 0 67 125 0 81 141 0 67 125 0 68 127 0 80 139 0 70 131 0 77 133 0 69 129 0 69 129 0 78 135 0 68 127 0 134 247 0 135 249 0 133 246 0 139 5 0 140 254 0 138 3 0 141 75 0 146 77 0 140 254 0 141 75 0 143 13 0 146 77 0 151 7 0 158 257 0 147 256 0 149 3 0 151 7 0 148 1 0 159 259 0 160 261 0 220 375 0 161 263 0 218 371 0 160 261 0 162 265 0 217 369 0 161 263 0 163 267 0 216 367 0 162 265 0 163 267 0 164 269 0 215 365 0 165 271 0 213 361 0 164 269 0 166 273 0 212 359 0 165 271 0 167 275 0 211 357 0 166 273 0 168 277 0 210 355 0 167 275 0 169 279 0 209 353 0 168 277 0 171 283 0 208 351 0 170 281 0 1448 987 0 1339 768 0 1451 992 0 1519 1128 0 1520 1130 0 1338 985 0 172 285 0 207 349 0 171 283 0 173 287 0 206 347 0 172 285 0 174 289 0 205 345 0 173 287 0 1515 1120 0 1516 1122 0 1431 952 0 175 291 0 204 343 0 174 289 0 176 293 0 203 341 0 175 291 0 176 293 0 177 295 0 203 341 0 152 9 0 154 13 0 157 19 0 177 295 0 178 297 0 201 337 0 178 297 0 179 299 0 200 335 0 179 299 0 180 301 0 199 333 0 151 7 0 152 9 0 158 257 0 180 301 0 181 303 0 197 329 0 181 303 0 182 305 0 196 327 0 188 313 0 189 315 0 186 9 0 182 305 0 183 307 0 194 323 0 1447 984 0 1432 954 0 1338 985 0 183 307 0 184 309 0 193 321 0 186 9 0 191 317 0 185 311 0 222 379 0 223 1 0 221 378 0 227 5 0 228 254 0 226 3 0 229 75 0 234 77 0 228 254 0 229 75 0 231 13 0 234 77 0 1449 988 0 1356 802 0 1448 987 0 1537 1164 0 1357 804 0 1449 988 0 1393 876 0 1358 806 0 1394 878 0 1540 1170 0 1541 1172 0 1357 804 0 1392 874 0 1359 808 0 1393 876 0 1392 874 0 1391 872 0 1359 808 0 1390 870 0 1361 812 0 1391 872 0 1362 814 0 1361 812 0 1389 868 0 1363 816 0 1362 814 0 1387 864 0 1364 818 0 1363 816 0 1386 862 0 1365 820 0 1364 818 0 1384 858 0 1366 822 0 1365 820 0 1383 856 0 1367 824 0 1366 822 0 1382 854 0 1382 854 0 1381 852 0 1367 824 0 1379 848 0 1368 826 0 1380 850 0 1378 846 0 1369 828 0 1379 848 0 1377 844 0 1370 830 0 1378 846 0 1376 842 0 1371 832 0 1377 844 0 1375 840 0 1372 834 0 1376 842 0 1692 1472 0 1395 880 0 1691 1470 0 1452 995 0 1611 1312 0 1394 878 0 1759 1538 0 1760 1598 0 1395 880 0 1761 1540 0 1412 914 0 1760 1598 0 1763 1603 0 1413 916 0 1761 1540 0 1774 1625 0 1775 1627 0 1413 916 0 1775 1627 0 1776 1629 0 1419 928 0 605 1121 0 521 951 0 606 1123 0 521 951 0 522 953 0 428 766 0 529 967 0 530 969 0 528 965 0 528 965 0 531 971 0 527 963 0 541 993 0 610 1131 0 428 766 0 527 963 0 532 973 0 526 961 0 538 986 0 541 993 0 429 767 0 526 961 0 533 975 0 525 959 0 523 955 0 536 981 0 522 953 0 525 959 0 534 977 0 524 957 0 524 957 0 535 979 0 523 955 0 1777 1631 0 1430 950 0 1776 1629 0 787 1483 0 786 1481 0 812 1533 0 811 1531 0 790 1489 0 812 1533 0 810 1529 0 792 1493 0 811 1531 0 842 1591 0 829 1565 0 843 1593 0 841 1589 0 830 1567 0 842 1591 0 840 1587 0 831 1569 0 841 1589 0 833 1573 0 832 1571 0 840 1587 0 837 1581 0 834 1575 0 840 1587 0 450 809 0 481 871 0 449 807 0 596 1103 0 595 1101 0 521 951 0 867 1632 0 866 1630 0 520 949 0 814 1537 0 783 1475 0 815 1539 0 785 1479 0 783 1475 0 812 1533 0 889 1676 0 888 1674 0 877 1652 0 865 1628 0 509 927 0 866 1630 0 864 1626 0 503 915 0 865 1628 0 853 1604 0 851 1600 0 503 915 0 851 1600 0 850 1599 0 502 913 0 849 1539 0 485 879 0 850 1599 0 782 1473 0 781 1471 0 485 879 0 702 1315 0 701 1313 0 484 877 0 447 803 0 448 805 0 484 877 0 630 1171 0 447 803 0 631 1173 0 1582 1254 0 1505 1100 0 1431 952 0 448 805 0 449 807 0 483 875 0 837 1581 0 836 1579 0 834 1575 0 839 1585 0 838 1583 0 840 1587 0 895 1688 0 894 1686 0 873 1644 0 894 1686 0 893 1684 0 874 1646 0 893 1684 0 892 1682 0 875 1648 0 891 1680 0 890 1678 0 876 1650 0 450 809 0 451 811 0 481 871 0 543 997 0 542 994 0 694 1299 0 452 813 0 479 867 0 451 811 0 593 1097 0 543 997 0 688 1287 0 593 1097 0 683 1277 0 594 1099 0 453 815 0 477 863 0 452 813 0 454 817 0 476 861 0 453 815 0 887 1672 0 886 1670 0 878 1654 0 885 1668 0 884 1666 0 879 1656 0 884 1666 0 883 1664 0 880 1658 0 594 1099 0 673 1257 0 595 1101 0 455 819 0 474 857 0 454 817 0 456 821 0 473 855 0 455 819 0 1447 984 0 1446 982 0 1432 954 0 457 823 0 472 853 0 456 821 0 470 849 0 471 851 0 457 823 0 457 823 0 458 825 0 470 849 0 458 825 0 459 827 0 469 847 0 459 827 0 460 829 0 468 845 0 460 829 0 461 831 0 467 843 0 461 831 0 462 833 0 466 841 0 627 1165 0 539 989 0 447 803 0 539 989 0 538 986 0 446 801 0 1446 982 0 1445 980 0 1433 956 0 644 1199 0 781 1471 0 645 1201 0 1445 980 0 1444 978 0 1434 958 0 652 1215 0 779 577 0 653 1217 0 661 1233 0 660 1231 0 776 1463 0 1444 978 0 1443 976 0 1435 960 0 653 1217 0 778 1467 0 654 1219 0 652 1215 0 651 1213 0 779 577 0 809 1527 0 794 1497 0 810 1529 0 843 1593 0 828 1563 0 844 1595 0 808 1525 0 795 1499 0 809 1527 0 807 1523 0 796 1501 0 808 1525 0 844 1595 0 826 1559 0 845 1597 0 806 1521 0 797 1503 0 807 1523 0 845 1597 0 824 1555 0 846 1533 0 805 1519 0 798 1505 0 806 1521 0 800 1509 0 799 1507 0 805 1519 0 805 1519 0 804 1517 0 800 1509 0 819 1545 0 817 1541 0 846 1533 0 803 1515 0 802 1513 0 804 1517 0 848 1537 0 817 1541 0 849 1539 0 593 1097 0 592 1095 0 543 997 0 1443 976 0 1442 974 0 1436 962 0 563 1037 0 548 1007 0 592 1095 0 562 1035 0 549 1009 0 563 1037 0 561 1033 0 550 1011 0 562 1035 0 560 1031 0 551 1013 0 561 1033 0 559 1029 0 552 1015 0 560 1031 0 558 1027 0 553 1017 0 559 1029 0 558 1027 0 557 1025 0 553 1017 0 557 1025 0 556 1023 0 554 1019 0 1442 974 0 1441 972 0 1437 964 0 1441 972 0 1440 970 0 1438 966 0 589 1089 0 588 1087 0 592 1095 0 540 991 0 613 1137 0 541 993 0 540 991 0 539 989 0 620 1151 0 1784 1645 0 1804 1685 0 1783 1643 0 1785 1647 0 1803 1683 0 1784 1645 0 1786 1649 0 1802 1681 0 1785 1647 0 1787 1651 0 1800 1677 0 1786 1649 0 1788 1653 0 1798 1673 0 1787 1651 0 1789 1655 0 1796 1669 0 1788 1653 0 1790 1657 0 1794 1665 0 1789 1655 0 1791 1659 0 1793 1663 0 1790 1657 0 1727 1540 0 1758 1536 0 1726 1472 0 1729 1544 0 1756 1532 0 1727 1540 0 1733 1552 0 1734 1554 0 1756 1532 0 1735 1556 0 1736 1558 0 1755 1596 0 1737 1560 0 1738 1562 0 1754 1594 0 1738 1562 0 1739 1564 0 1753 1592 0 1739 1564 0 1740 1566 0 1752 1590 0 1740 1566 0 1741 1568 0 1751 1588 0 1747 1580 0 1748 1582 0 1750 1586 0 1743 1572 0 1744 1574 0 1750 1586 0 1741 1568 0 1742 1570 0 1750 1586 0 1745 1576 0 1746 1578 0 1744 1574 0 1693 1474 0 1724 1536 0 1692 1472 0 1695 1478 0 1722 1532 0 1693 1474 0 1699 1486 0 1700 1488 0 1722 1532 0 768 1447 0 767 1445 0 773 1457 0 767 1445 0 713 1337 0 706 1322 0 714 1339 0 713 1337 0 766 1443 0 713 1337 0 712 1335 0 707 1325 0 712 1335 0 711 1333 0 708 1327 0 715 1341 0 714 1339 0 765 1441 0 1695 1478 0 1696 1480 0 1722 1532 0 716 1343 0 715 1341 0 764 1439 0 1701 1490 0 1702 1492 0 1721 1530 0 717 1345 0 716 1343 0 763 1437 0 718 1347 0 717 1345 0 762 1435 0 1703 1494 0 1704 1496 0 1720 1528 0 719 1349 0 718 1347 0 761 1433 0 720 1351 0 719 1349 0 760 1431 0 1704 1496 0 1705 1498 0 1719 1526 0 721 1353 0 720 1351 0 759 1429 0 1705 1498 0 1706 1500 0 1718 1524 0 722 1355 0 721 1353 0 758 1427 0 1706 1500 0 1707 1502 0 1717 1522 0 723 1357 0 722 1355 0 757 1425 0 1707 1502 0 1708 1504 0 1716 1520 0 757 1425 0 756 1423 0 723 1357 0 756 1423 0 755 1421 0 724 1359 0 1711 1510 0 1714 1516 0 1710 1508 0 755 1421 0 754 1419 0 725 1361 0 1708 1504 0 1709 1506 0 1715 1518 0 754 1419 0 753 1417 0 726 1363 0 1711 1510 0 1712 1512 0 1714 1516 0 753 1417 0 752 1415 0 727 1365 0 752 1415 0 751 1413 0 728 1367 0 1554 1198 0 1555 1200 0 1691 1470 0 751 1413 0 750 1411 0 729 1369 0 750 1411 0 749 1409 0 730 1371 0 749 1409 0 748 1407 0 731 1373 0 748 1407 0 747 1405 0 732 1375 0 740 1391 0 739 1389 0 733 1377 0 746 1403 0 740 1391 0 747 1405 0 739 1389 0 738 1387 0 734 1379 0 744 1399 0 742 1395 0 745 1401 0 738 1387 0 737 1385 0 735 1381 0 745 1401 0 741 1393 0 746 1403 0 773 1457 0 772 1455 0 768 1447 0 772 1455 0 771 1453 0 769 1449 0 1562 1214 0 1689 578 0 1561 1212 0 1562 1214 0 1563 1216 0 1689 578 0 1041 242 0 923 26 0 1042 244 0 1563 1216 0 1564 1218 0 1688 1466 0 1042 244 0 922 24 0 910 245 0 1571 1232 0 1686 1462 0 1570 1230 0 912 4 0 911 2 0 914 8 0 920 20 0 915 10 0 921 22 0 918 16 0 917 14 0 920 20 0 1040 240 0 924 28 0 1041 242 0 1039 238 0 925 30 0 1040 240 0 1038 236 0 926 32 0 1039 238 0 1037 234 0 927 34 0 1038 236 0 1036 232 0 928 36 0 1037 234 0 1036 232 0 1035 230 0 928 36 0 1035 230 0 1034 228 0 929 38 0 1034 228 0 1033 226 0 930 40 0 1033 226 0 1032 224 0 932 44 0 1032 224 0 1031 222 0 933 46 0 1030 220 0 935 50 0 1031 222 0 1029 218 0 936 52 0 1030 220 0 1028 216 0 937 54 0 1029 218 0 1027 214 0 938 56 0 1028 216 0 1026 212 0 939 58 0 1027 214 0 1025 210 0 940 60 0 1026 212 0 1023 206 0 941 62 0 1024 208 0 1021 202 0 942 64 0 1022 204 0 1453 996 0 1604 1298 0 1452 995 0 1019 198 0 943 66 0 1020 200 0 1503 1096 0 1598 1286 0 1453 996 0 1018 196 0 944 68 0 1019 198 0 1018 196 0 1017 194 0 944 68 0 954 80 0 946 72 0 1017 194 0 951 16 0 950 14 0 953 78 0 954 80 0 953 78 0 947 74 0 1017 194 0 1016 192 0 954 80 0 1014 188 0 956 84 0 1015 190 0 1503 1096 0 1504 1098 0 1593 1276 0 1013 186 0 957 86 0 1014 188 0 1013 186 0 1012 184 0 958 88 0 1010 180 0 960 92 0 1011 182 0 1009 178 0 961 94 0 1010 180 0 1009 178 0 1008 176 0 961 94 0 1008 176 0 1007 174 0 962 96 0 1007 174 0 1006 172 0 963 98 0 1005 170 0 965 102 0 1006 172 0 1504 1098 0 1505 1100 0 1583 1256 0 1004 168 0 966 104 0 1005 170 0 1003 166 0 967 106 0 1004 168 0 1002 164 0 968 108 0 1003 166 0 1001 162 0 969 110 0 1002 164 0 1000 160 0 970 112 0 1001 162 0 999 158 0 971 114 0 1000 160 0 998 156 0 972 116 0 999 158 0 1450 990 0 1530 1150 0 1449 988 0 997 154 0 973 118 0 998 156 0 996 152 0 974 120 0 997 154 0 995 150 0 975 122 0 996 152 0 984 16 0 983 14 0 986 78 0 992 144 0 976 124 0 993 146 0 987 134 0 986 78 0 980 132 0 988 136 0 987 134 0 979 130 0 989 138 0 988 136 0 978 128 0 990 140 0 977 126 0 991 142 0 989 138 0 978 128 0 990 140 0 1046 252 0 1045 250 0 1043 253 0 1049 6 0 1048 4 0 1050 255 0 1051 76 0 1050 255 0 1056 78 0 1054 16 0 1053 14 0 1056 78 0 1450 990 0 1451 992 0 1523 1136 0 1129 374 0 1070 262 0 1130 376 0 1061 8 0 1057 377 0 1068 258 0 1454 998 0 1502 1094 0 1453 996 0 1059 4 0 1058 2 0 1061 8 0 1067 20 0 1062 10 0 1068 258 0 1065 16 0 1064 14 0 1067 20 0 1129 374 0 1128 372 0 1070 262 0 1128 372 0 1127 370 0 1071 264 0 1127 370 0 1126 368 0 1072 266 0 1497 1084 0 1498 1086 0 1502 1094 0 1124 364 0 1074 270 0 1125 366 0 1124 364 0 1123 362 0 1074 270 0 1123 362 0 1122 360 0 1075 272 0 1122 360 0 1121 358 0 1076 274 0 1121 358 0 1120 356 0 1077 276 0 1120 356 0 1119 354 0 1078 278 0 1119 354 0 1118 352 0 1080 282 0 1118 352 0 1117 350 0 1081 284 0 1117 350 0 1116 348 0 1082 286 0 1116 348 0 1115 346 0 1083 288 0 1115 346 0 1114 344 0 1084 290 0 1114 344 0 1113 342 0 1085 292 0 1112 340 0 1087 296 0 1113 342 0 1110 336 0 1088 298 0 1111 338 0 1109 334 0 1089 300 0 1110 336 0 1108 332 0 1090 302 0 1109 334 0 1106 328 0 1091 304 0 1107 330 0 1105 326 0 1092 306 0 1106 328 0 1103 322 0 1093 308 0 1104 324 0 1098 314 0 1096 10 0 1099 316 0 1102 320 0 1094 310 0 1103 322 0 1102 320 0 1101 318 0 1095 312 0 1134 382 0 1133 2 0 1131 383 0 1457 1004 0 1458 1006 0 1502 1094 0 1137 6 0 1136 4 0 1138 255 0 1139 76 0 1138 255 0 1144 78 0 1142 16 0 1141 14 0 1144 78 0 1458 1006 0 1459 1008 0 1473 1036 0 1459 1008 0 1460 1010 0 1472 1034 0 1460 1010 0 1461 1012 0 1471 1032 0 1461 1012 0 1462 1014 0 1470 1030 0 1462 1014 0 1463 1016 0 1469 1028 0 1464 1018 0 1467 1024 0 1463 1016 0 1465 1020 0 1466 1022 0 1464 1018 0 1678 1446 0 1683 1456 0 1677 1444 0 1617 1324 0 1623 1336 0 1616 1323 0 1679 1448 0 1682 1454 0 1678 1446 0 1680 1450 0 1681 1452 0 1679 1448 0 1624 1338 0 1676 1442 0 1623 1336 0 1625 1340 0 1675 1440 0 1624 1338 0 1626 1342 0 1674 1438 0 1625 1340 0 1627 1344 0 1673 1436 0 1626 1342 0 1628 1346 0 1672 1434 0 1627 1344 0 1629 1348 0 1671 1432 0 1628 1346 0 1630 1350 0 1670 1430 0 1629 1348 0 1631 1352 0 1669 1428 0 1630 1350 0 1632 1354 0 1668 1426 0 1631 1352 0 1633 1356 0 1667 1424 0 1632 1354 0 1634 1358 0 1666 1422 0 1633 1356 0 1635 1360 0 1665 1420 0 1634 1358 0 1636 1362 0 1664 1418 0 1635 1360 0 1637 1364 0 1663 1416 0 1636 1362 0 1638 1366 0 1662 1414 0 1637 1364 0 1639 1368 0 1661 1412 0 1638 1366 0 1640 1370 0 1660 1410 0 1639 1368 0 1641 1372 0 1659 1408 0 1640 1370 0 1642 1374 0 1658 1406 0 1641 1372 0 1643 1376 0 1657 1404 0 1642 1374 0 1643 1376 0 1650 1390 0 1657 1404 0 1650 1390 0 1651 1392 0 1656 1402 0 1651 1392 0 1652 1394 0 1655 1400 0 1644 1378 0 1649 1388 0 1643 1376 0 1645 1380 0 1648 1386 0 1644 1378 0 1646 1382 0 1647 1384 0 1645 1380 0 1618 1326 0 1622 1334 0 1617 1324 0 1619 1328 0 1621 1332 0 1618 1326 0</p>
                            </polylist>
                            <polylist count="764" material="Material2">
                                <input offset="0" semantic="VERTEX" source="#ID18"/>
                                <input offset="1" semantic="NORMAL" source="#ID14"/>
                                <input offset="2" semantic="TEXCOORD" source="#ID16" set="0"/>
                                <vcount>3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3</vcount>
                                <p>1146 386 454 236 385 453 235 384 0 1147 388 456 237 387 455 236 385 453 1148 390 458 238 389 457 237 387 455 1149 392 460 239 391 459 238 389 457 1150 394 462 240 393 461 239 391 459 1151 396 464 241 395 463 240 393 461 1152 398 466 242 397 465 241 395 463 1153 400 468 243 399 467 242 397 465 1154 402 470 244 401 469 243 399 467 1155 404 472 245 403 471 244 401 469 1156 406 474 246 405 473 245 403 471 1157 408 476 247 407 475 246 405 473 1158 410 478 248 409 477 247 407 475 1159 412 480 249 411 479 248 409 477 1160 414 482 250 413 481 249 411 479 1161 416 484 251 415 483 250 413 481 1162 418 486 252 417 485 251 415 483 1163 420 488 253 419 487 252 417 485 1164 422 490 254 421 489 253 419 487 1165 424 492 255 423 491 254 421 489 1166 426 494 256 425 493 255 423 491 1167 428 496 257 427 495 256 425 493 1168 430 498 258 429 497 257 427 495 1169 432 500 259 431 499 258 429 497 1170 434 502 260 433 501 259 431 499 1171 436 504 261 435 503 260 433 501 1172 438 506 262 437 505 261 435 503 1173 440 508 263 439 507 262 437 505 1174 442 510 264 441 509 263 439 507 1175 444 512 265 443 511 264 441 509 1176 446 514 266 445 513 265 443 511 1177 448 516 267 447 515 266 445 513 1178 450 518 268 449 517 267 447 515 1179 452 520 269 451 519 268 449 517 1180 454 522 270 453 521 269 451 519 1181 456 524 271 455 523 270 453 521 1182 458 526 272 457 525 271 455 523 1183 460 528 273 459 527 272 457 525 1184 462 530 274 461 529 273 459 527 1185 464 532 275 463 531 274 461 529 1186 466 534 276 465 533 275 463 531 1187 468 536 277 467 535 276 465 533 1188 470 538 278 469 537 277 467 535 1189 472 540 279 471 539 278 469 537 1190 474 542 280 473 541 279 471 539 1191 476 544 281 475 543 280 473 541 1192 478 546 282 477 545 281 475 543 1193 480 548 283 479 547 282 477 545 1194 482 550 284 481 549 283 479 547 1195 484 552 285 483 551 284 481 549 1196 486 554 286 485 553 285 483 551 1197 488 556 287 487 555 286 485 553 1198 490 558 288 489 557 287 487 555 1199 492 560 289 491 559 288 489 557 1200 494 562 290 493 561 289 491 559 1201 496 564 291 495 563 290 493 561 1202 498 566 292 497 565 291 495 563 1203 500 568 293 499 567 292 497 565 1204 502 570 294 501 569 293 499 567 1205 504 572 295 503 571 294 501 569 1206 506 574 296 505 573 295 503 571 1207 508 576 297 507 575 296 505 573 1208 510 578 298 509 577 297 507 575 1209 512 580 299 511 579 298 509 577 1210 514 582 300 513 581 299 511 579 1211 516 584 301 515 583 300 513 581 1212 518 586 302 517 585 301 515 583 1213 520 588 303 519 587 302 517 585 1214 522 590 304 521 589 303 519 587 1215 524 592 305 523 591 304 521 589 1216 526 594 306 525 593 305 523 591 1217 528 596 307 527 595 306 525 593 1218 530 598 308 529 597 307 527 595 1219 532 600 309 531 599 308 529 597 1220 534 602 310 533 601 309 531 599 1221 536 604 311 535 603 310 533 601 1222 538 606 312 537 605 311 535 603 1223 540 608 313 539 607 312 537 605 1224 542 610 314 541 609 313 539 607 1225 544 612 315 543 611 314 541 609 1226 546 614 316 545 613 315 543 611 1227 548 616 317 547 615 316 545 613 1228 550 618 318 549 617 317 547 615 1229 552 620 319 551 619 318 549 617 1230 554 622 320 553 621 319 551 619 1231 556 624 321 555 623 320 553 621 1232 558 626 322 557 625 321 555 623 1233 560 628 323 559 627 322 557 625 1234 562 630 324 561 629 323 559 627 1235 564 632 325 563 631 324 561 629 1236 566 634 326 565 633 325 563 631 1237 568 636 327 567 635 326 565 633 1238 570 638 328 569 637 327 567 635 1239 572 640 329 571 639 328 569 637 1240 574 642 330 573 641 329 571 639 1145 575 266 235 384 265 330 573 641 1242 578 644 332 577 643 331 576 0 1243 580 646 333 579 645 332 577 643 1244 582 648 334 581 647 333 579 645 1245 584 650 335 583 649 334 581 647 1246 586 652 336 585 651 335 583 649 1247 255 654 337 254 653 336 585 651 1248 588 656 338 587 655 337 254 653 1249 590 658 339 589 657 338 587 655 1250 592 660 340 591 659 339 589 657 1251 594 662 341 593 661 340 591 659 1252 596 664 342 595 663 341 593 661 1253 598 666 343 597 665 342 595 663 1254 600 668 344 599 667 343 597 665 1255 602 670 345 601 669 344 599 667 1256 604 672 346 603 671 345 601 669 1257 606 674 347 605 673 346 603 671 1258 608 676 348 607 675 347 605 673 1259 610 678 349 609 677 348 607 675 1260 612 680 350 611 679 349 609 677 1261 614 682 351 613 681 350 611 679 1262 616 684 352 615 683 351 613 681 1263 618 686 353 617 685 352 615 683 1264 620 688 354 619 687 353 617 685 1265 622 690 355 621 689 354 619 687 1266 624 692 356 623 691 355 621 689 1267 626 694 357 625 693 356 623 691 1268 628 696 358 627 695 357 625 693 1269 630 698 359 629 697 358 627 695 1270 632 700 360 631 699 359 629 697 1271 634 702 361 633 701 360 631 699 1272 636 704 362 635 703 361 633 701 1273 638 706 363 637 705 362 635 703 1274 640 708 364 639 707 363 637 705 1275 642 710 365 641 709 364 639 707 1276 644 712 366 643 711 365 641 709 1277 646 714 367 645 713 366 643 711 1278 648 716 368 647 715 367 645 713 1279 650 718 369 649 717 368 647 715 1280 652 720 370 651 719 369 649 717 1281 654 722 371 653 721 370 651 719 1282 656 724 372 655 723 371 653 721 1283 658 726 373 657 725 372 655 723 1284 660 728 374 659 727 373 657 725 1285 662 730 375 661 729 374 659 727 1286 664 732 376 663 731 375 661 729 1287 666 734 377 665 733 376 663 731 1288 668 736 378 667 735 377 665 733 1289 670 738 379 669 737 378 667 735 1290 672 740 380 671 739 379 669 737 1291 674 742 381 673 741 380 671 739 1292 676 744 382 675 743 381 673 741 1293 678 746 383 677 745 382 675 743 1294 680 748 384 679 747 383 677 745 1295 484 750 385 483 749 384 679 747 1296 682 752 386 681 751 385 483 749 1297 684 754 387 683 753 386 681 751 1298 686 756 388 685 755 387 683 753 1299 688 758 389 687 757 388 685 755 1300 690 760 390 689 759 389 687 757 1301 692 762 391 691 761 390 689 759 1302 694 764 392 693 763 391 691 761 1303 696 766 393 695 765 392 693 763 1304 698 768 394 697 767 393 695 765 1305 700 770 395 699 769 394 697 767 1306 702 772 396 701 771 395 699 769 1307 704 774 397 703 773 396 701 771 1308 706 776 398 705 775 397 703 773 1309 708 778 399 707 777 398 705 775 1310 710 780 400 709 779 399 707 777 1311 712 782 401 711 781 400 709 779 1312 714 784 402 713 783 401 711 781 1313 716 786 403 715 785 402 713 783 1314 718 788 404 717 787 403 715 785 1315 720 790 405 719 789 404 717 787 1316 722 792 406 721 791 405 719 789 1317 724 794 407 723 793 406 721 791 1318 726 796 408 725 795 407 723 793 1319 728 798 409 727 797 408 725 795 1320 730 800 410 729 799 409 727 797 1321 732 802 411 731 801 410 729 799 1322 734 804 412 733 803 411 731 801 1323 736 806 413 735 805 412 733 803 1324 738 808 414 737 807 413 735 805 1325 740 810 415 739 809 414 737 807 1326 742 812 416 741 811 415 739 809 1327 744 814 417 743 813 416 741 811 1328 746 816 418 745 815 417 743 813 1329 748 818 419 747 817 418 745 815 1330 750 820 420 749 819 419 747 817 1331 752 822 421 751 821 420 749 819 1332 754 824 422 753 823 421 751 821 1333 756 826 423 755 825 422 753 823 1334 758 828 424 757 827 423 755 825 1335 760 830 425 759 829 424 757 827 1336 762 832 426 761 831 425 759 829 1337 764 834 427 763 833 426 761 831 1241 765 266 331 576 265 427 763 833 1204 502 0 1179 452 0 1178 450 0 1203 500 0 1180 454 0 1179 452 0 1181 456 0 1180 454 0 1203 500 0 1182 458 0 1181 456 0 1202 498 0 1201 496 0 1183 460 0 1182 458 0 1200 494 0 1184 462 0 1183 460 0 1200 494 0 1185 464 0 1184 462 0 1199 492 0 1186 466 0 1185 464 0 1199 492 0 1187 468 0 1186 466 0 1188 470 0 1187 468 0 1199 492 0 1198 490 0 1189 472 0 1188 470 0 1197 488 0 1190 474 0 1189 472 0 1197 488 0 1191 476 0 1190 474 0 1197 488 0 1192 478 0 1191 476 0 1196 486 0 1193 480 0 1192 478 0 1195 484 0 1194 482 0 1193 480 0 1242 578 0 1241 765 0 1248 588 0 1337 764 0 1248 588 0 1241 765 0 1244 582 0 1243 580 0 1242 578 0 1244 582 0 1242 578 0 1247 255 0 1247 255 0 1246 586 0 1245 584 0 1249 590 0 1248 588 0 1337 764 0 1336 762 0 1250 592 0 1249 590 0 1336 762 0 1251 594 0 1250 592 0 1335 760 0 1252 596 0 1251 594 0 1253 598 0 1252 596 0 1335 760 0 1334 758 0 1254 600 0 1253 598 0 1333 756 0 1255 602 0 1254 600 0 1332 754 0 1256 604 0 1255 602 0 1331 752 0 1257 606 0 1256 604 0 1330 750 0 1258 608 0 1257 606 0 1259 610 0 1258 608 0 1330 750 0 1260 612 0 1259 610 0 1329 748 0 1261 614 0 1260 612 0 1328 746 0 1262 616 0 1261 614 0 1327 744 0 1263 618 0 1262 616 0 1325 740 0 1326 742 0 1325 740 0 1262 616 0 1323 736 0 1264 620 0 1263 618 0 1322 734 0 1265 622 0 1264 620 0 1266 624 0 1265 622 0 1321 732 0 1322 734 0 1321 732 0 1265 622 0 1267 626 0 1266 624 0 1320 730 0 1268 628 0 1267 626 0 1319 728 0 1317 724 0 1269 630 0 1268 628 0 1270 632 0 1269 630 0 1316 722 0 1317 724 0 1316 722 0 1269 630 0 1314 718 0 1271 634 0 1270 632 0 1313 716 0 1272 636 0 1271 634 0 1311 712 0 1273 638 0 1272 636 0 1313 716 0 1312 714 0 1272 636 0 1310 710 0 1274 640 0 1273 638 0 1309 708 0 1275 642 0 1274 640 0 1308 706 0 1276 644 0 1275 642 0 1306 702 0 1277 646 0 1276 644 0 1308 706 0 1307 704 0 1276 644 0 1305 700 0 1278 648 0 1277 646 0 1304 698 0 1279 650 0 1278 648 0 1303 696 0 1280 652 0 1279 650 0 1281 654 0 1280 652 0 1303 696 0 1282 656 0 1281 654 0 1302 694 0 1301 692 0 1283 658 0 1282 656 0 1284 660 0 1283 658 0 1301 692 0 1300 690 0 1285 662 0 1284 660 0 1300 690 0 1286 664 0 1285 662 0 1299 688 0 1287 666 0 1286 664 0 1299 688 0 1288 668 0 1287 666 0 1299 688 0 1289 670 0 1288 668 0 1298 686 0 1290 672 0 1289 670 0 1298 686 0 1291 674 0 1290 672 0 1297 684 0 1292 676 0 1291 674 0 1293 678 0 1292 676 0 1297 684 0 1295 484 0 1294 680 0 1293 678 0 238 389 0 329 571 0 330 573 0 237 387 0 330 573 0 235 384 0 328 569 0 329 571 0 238 389 0 327 567 0 328 569 0 239 391 0 241 395 0 326 565 0 327 567 0 242 397 0 325 563 0 326 565 0 324 561 0 325 563 0 243 399 0 242 397 0 243 399 0 325 563 0 323 559 0 324 561 0 244 401 0 322 557 0 323 559 0 245 403 0 322 557 0 246 405 0 247 407 0 321 555 0 247 407 0 248 409 0 320 553 0 248 409 0 249 411 0 319 551 0 249 411 0 250 413 0 318 549 0 250 413 0 251 415 0 317 547 0 251 415 0 252 417 0 315 543 0 316 545 0 252 417 0 253 419 0 314 541 0 315 543 0 314 541 0 253 419 0 254 421 0 312 537 0 313 539 0 254 421 0 255 423 0 311 535 0 312 537 0 311 535 0 255 423 0 256 425 0 310 533 0 256 425 0 257 427 0 309 531 0 257 427 0 258 429 0 308 529 0 258 429 0 259 431 0 306 525 0 307 527 0 259 431 0 260 433 0 305 523 0 306 525 0 261 435 0 304 521 0 305 523 0 303 519 0 304 521 0 261 435 0 302 517 0 303 519 0 262 437 0 263 439 0 301 515 0 302 517 0 300 513 0 301 515 0 263 439 0 299 511 0 300 513 0 264 441 0 298 509 0 299 511 0 265 443 0 297 507 0 298 509 0 266 445 0 267 447 0 296 505 0 297 507 0 295 503 0 296 505 0 267 447 0 294 501 0 295 503 0 268 449 0 293 499 0 294 501 0 269 451 0 271 455 0 292 497 0 293 499 0 272 457 0 291 495 0 292 497 0 290 493 0 291 495 0 273 459 0 272 457 0 273 459 0 291 495 0 285 483 0 286 485 0 283 479 0 289 491 0 290 493 0 275 463 0 280 473 0 281 475 0 287 487 0 274 461 0 275 463 0 290 493 0 278 469 0 279 471 0 288 489 0 286 485 0 287 487 0 282 477 0 281 475 0 282 477 0 287 487 0 278 469 0 288 489 0 289 491 0 287 487 0 288 489 0 279 471 0 276 465 0 277 467 0 289 491 0 338 587 0 331 576 0 332 577 0 338 587 0 427 763 0 331 576 0 339 589 0 426 761 0 427 763 0 425 759 0 426 761 0 341 593 0 340 591 0 341 593 0 426 761 0 339 589 0 340 591 0 426 761 0 343 597 0 424 757 0 425 759 0 423 755 0 424 757 0 344 599 0 343 597 0 344 599 0 424 757 0 422 753 0 423 755 0 345 601 0 421 751 0 422 753 0 346 603 0 420 749 0 421 751 0 347 605 0 420 749 0 348 607 0 349 609 0 419 747 0 349 609 0 350 611 0 418 745 0 350 611 0 351 613 0 417 743 0 351 613 0 352 615 0 352 615 0 415 739 0 416 741 0 415 739 0 352 615 0 353 617 0 413 735 0 414 737 0 353 617 0 412 733 0 413 735 0 354 619 0 355 621 0 411 731 0 412 733 0 411 731 0 355 621 0 356 623 0 410 729 0 356 623 0 357 625 0 409 727 0 357 625 0 358 627 0 407 723 0 408 725 0 358 627 0 359 629 0 406 721 0 407 723 0 360 631 0 405 719 0 406 721 0 404 717 0 405 719 0 360 631 0 403 715 0 404 717 0 361 633 0 362 635 0 402 713 0 403 715 0 401 711 0 402 713 0 362 635 0 400 709 0 401 711 0 363 637 0 399 707 0 400 709 0 364 639 0 398 705 0 399 707 0 365 641 0 366 643 0 397 703 0 398 705 0 396 701 0 397 703 0 366 643 0 395 699 0 396 701 0 367 645 0 332 577 0 333 579 0 334 581 0 394 697 0 395 699 0 368 647 0 337 254 0 332 577 0 334 581 0 335 583 0 336 585 0 337 254 0 393 695 0 394 697 0 369 649 0 383 677 0 386 681 0 387 683 0 385 483 0 386 681 0 383 677 0 371 653 0 392 693 0 393 695 0 377 665 0 378 667 0 389 687 0 387 683 0 388 685 0 381 673 0 380 671 0 381 673 0 388 685 0 372 655 0 391 691 0 392 693 0 388 685 0 389 687 0 379 669 0 378 667 0 379 669 0 389 687 0 374 659 0 390 689 0 391 691 0 375 661 0 376 663 0 390 689 0 374 659 0 375 661 0 390 689 0 372 655 0 373 657 0 391 691 0 389 687 0 390 689 0 376 663 0 1147 388 0 1146 386 0 1145 575 0 1148 390 0 1147 388 0 1240 574 0 1238 570 0 1149 392 0 1148 390 0 1237 568 0 1150 394 0 1149 392 0 1151 396 0 1150 394 0 1237 568 0 1152 398 0 1151 396 0 1236 566 0 1235 564 0 1153 400 0 1152 398 0 1234 562 0 1154 402 0 1153 400 0 1233 560 0 1155 404 0 1154 402 0 1232 558 0 1156 406 0 1155 404 0 1157 408 0 1156 406 0 1232 558 0 1158 410 0 1157 408 0 1231 556 0 1159 412 0 1158 410 0 1230 554 0 1160 414 0 1159 412 0 1229 552 0 1161 416 0 1160 414 0 1228 550 0 1162 418 0 1161 416 0 1227 548 0 1225 544 0 1163 420 0 1162 418 0 1164 422 0 1163 420 0 1224 542 0 1225 544 0 1224 542 0 1163 420 0 1222 538 0 1165 424 0 1164 422 0 1166 426 0 1165 424 0 1221 536 0 1222 538 0 1221 536 0 1165 424 0 1167 428 0 1166 426 0 1220 534 0 1168 430 0 1167 428 0 1219 532 0 1169 432 0 1168 430 0 1218 530 0 1216 526 0 1170 434 0 1169 432 0 1171 436 0 1170 434 0 1215 524 0 1216 526 0 1215 524 0 1170 434 0 1213 520 0 1172 438 0 1171 436 0 1212 518 0 1173 440 0 1172 438 0 1210 514 0 1174 442 0 1173 440 0 1212 518 0 1211 516 0 1173 440 0 1209 512 0 1175 444 0 1174 442 0 1208 510 0 1176 446 0 1175 444 0 1207 508 0 1177 448 0 1176 446 0 1205 504 0 1178 450 0 1177 448 0 1207 508 0 1206 506 0 1177 448 0 1145 575 1053 1146 386 454 235 384 0 1146 386 454 1147 388 456 236 385 453 1147 388 456 1148 390 458 237 387 455 1148 390 458 1149 392 460 238 389 457 1149 392 460 1150 394 462 239 391 459 1150 394 462 1151 396 464 240 393 461 1151 396 464 1152 398 466 241 395 463 1152 398 466 1153 400 468 242 397 465 1153 400 468 1154 402 470 243 399 467 1154 402 470 1155 404 472 244 401 469 1155 404 472 1156 406 474 245 403 471 1156 406 474 1157 408 476 246 405 473 1157 408 476 1158 410 478 247 407 475 1158 410 478 1159 412 480 248 409 477 1159 412 480 1160 414 482 249 411 479 1160 414 482 1161 416 484 250 413 481 1161 416 484 1162 418 486 251 415 483 1162 418 486 1163 420 488 252 417 485 1163 420 488 1164 422 490 253 419 487 1164 422 490 1165 424 492 254 421 489 1165 424 492 1166 426 494 255 423 491 1166 426 494 1167 428 496 256 425 493 1167 428 496 1168 430 498 257 427 495 1168 430 498 1169 432 500 258 429 497 1169 432 500 1170 434 502 259 431 499 1170 434 502 1171 436 504 260 433 501 1171 436 504 1172 438 506 261 435 503 1172 438 506 1173 440 508 262 437 505 1173 440 508 1174 442 510 263 439 507 1174 442 510 1175 444 512 264 441 509 1175 444 512 1176 446 514 265 443 511 1176 446 514 1177 448 516 266 445 513 1177 448 516 1178 450 518 267 447 515 1178 450 518 1179 452 520 268 449 517 1179 452 520 1180 454 522 269 451 519 1180 454 522 1181 456 524 270 453 521 1181 456 524 1182 458 526 271 455 523 1182 458 526 1183 460 528 272 457 525 1183 460 528 1184 462 530 273 459 527 1184 462 530 1185 464 532 274 461 529 1185 464 532 1186 466 534 275 463 531 1186 466 534 1187 468 536 276 465 533 1187 468 536 1188 470 538 277 467 535 1188 470 538 1189 472 540 278 469 537 1189 472 540 1190 474 542 279 471 539 1190 474 542 1191 476 544 280 473 541 1191 476 544 1192 478 546 281 475 543 1192 478 546 1193 480 548 282 477 545 1193 480 548 1194 482 550 283 479 547 1194 482 550 1195 484 552 284 481 549 1195 484 552 1196 486 554 285 483 551 1196 486 554 1197 488 556 286 485 553 1197 488 556 1198 490 558 287 487 555 1198 490 558 1199 492 560 288 489 557 1199 492 560 1200 494 562 289 491 559 1200 494 562 1201 496 564 290 493 561 1201 496 564 1202 498 566 291 495 563 1202 498 566 1203 500 568 292 497 565 1203 500 568 1204 502 570 293 499 567 1204 502 570 1205 504 572 294 501 569 1205 504 572 1206 506 574 295 503 571 1206 506 574 1207 508 576 296 505 573 1207 508 576 1208 510 578 297 507 575 1208 510 578 1209 512 580 298 509 577 1209 512 580 1210 514 582 299 511 579 1210 514 582 1211 516 584 300 513 581 1211 516 584 1212 518 586 301 515 583 1212 518 586 1213 520 588 302 517 585 1213 520 588 1214 522 590 303 519 587 1214 522 590 1215 524 592 304 521 589 1215 524 592 1216 526 594 305 523 591 1216 526 594 1217 528 596 306 525 593 1217 528 596 1218 530 598 307 527 595 1218 530 598 1219 532 600 308 529 597 1219 532 600 1220 534 602 309 531 599 1220 534 602 1221 536 604 310 533 601 1221 536 604 1222 538 606 311 535 603 1222 538 606 1223 540 608 312 537 605 1223 540 608 1224 542 610 313 539 607 1224 542 610 1225 544 612 314 541 609 1225 544 612 1226 546 614 315 543 611 1226 546 614 1227 548 616 316 545 613 1227 548 616 1228 550 618 317 547 615 1228 550 618 1229 552 620 318 549 617 1229 552 620 1230 554 622 319 551 619 1230 554 622 1231 556 624 320 553 621 1231 556 624 1232 558 626 321 555 623 1232 558 626 1233 560 628 322 557 625 1233 560 628 1234 562 630 323 559 627 1234 562 630 1235 564 632 324 561 629 1235 564 632 1236 566 634 325 563 631 1236 566 634 1237 568 636 326 565 633 1237 568 636 1238 570 638 327 567 635 1238 570 638 1239 572 640 328 569 637 1239 572 640 1240 574 642 329 571 639 1240 574 642 1145 575 266 330 573 641 1241 765 1053 1242 578 644 331 576 0 1242 578 644 1243 580 646 332 577 643 1243 580 646 1244 582 648 333 579 645 1244 582 648 1245 584 650 334 581 647 1245 584 650 1246 586 652 335 583 649 1246 586 652 1247 255 654 336 585 651 1247 255 654 1248 588 656 337 254 653 1248 588 656 1249 590 658 338 587 655 1249 590 658 1250 592 660 339 589 657 1250 592 660 1251 594 662 340 591 659 1251 594 662 1252 596 664 341 593 661 1252 596 664 1253 598 666 342 595 663 1253 598 666 1254 600 668 343 597 665 1254 600 668 1255 602 670 344 599 667 1255 602 670 1256 604 672 345 601 669 1256 604 672 1257 606 674 346 603 671 1257 606 674 1258 608 676 347 605 673 1258 608 676 1259 610 678 348 607 675 1259 610 678 1260 612 680 349 609 677 1260 612 680 1261 614 682 350 611 679 1261 614 682 1262 616 684 351 613 681 1262 616 684 1263 618 686 352 615 683 1263 618 686 1264 620 688 353 617 685 1264 620 688 1265 622 690 354 619 687 1265 622 690 1266 624 692 355 621 689 1266 624 692 1267 626 694 356 623 691 1267 626 694 1268 628 696 357 625 693 1268 628 696 1269 630 698 358 627 695 1269 630 698 1270 632 700 359 629 697 1270 632 700 1271 634 702 360 631 699 1271 634 702 1272 636 704 361 633 701 1272 636 704 1273 638 706 362 635 703 1273 638 706 1274 640 708 363 637 705 1274 640 708 1275 642 710 364 639 707 1275 642 710 1276 644 712 365 641 709 1276 644 712 1277 646 714 366 643 711 1277 646 714 1278 648 716 367 645 713 1278 648 716 1279 650 718 368 647 715 1279 650 718 1280 652 720 369 649 717 1280 652 720 1281 654 722 370 651 719 1281 654 722 1282 656 724 371 653 721 1282 656 724 1283 658 726 372 655 723 1283 658 726 1284 660 728 373 657 725 1284 660 728 1285 662 730 374 659 727 1285 662 730 1286 664 732 375 661 729 1286 664 732 1287 666 734 376 663 731 1287 666 734 1288 668 736 377 665 733 1288 668 736 1289 670 738 378 667 735 1289 670 738 1290 672 740 379 669 737 1290 672 740 1291 674 742 380 671 739 1291 674 742 1292 676 744 381 673 741 1292 676 744 1293 678 746 382 675 743 1293 678 746 1294 680 748 383 677 745 1294 680 748 1295 484 750 384 679 747 1295 484 750 1296 682 752 385 483 749 1296 682 752 1297 684 754 386 681 751 1297 684 754 1298 686 756 387 683 753 1298 686 756 1299 688 758 388 685 755 1299 688 758 1300 690 760 389 687 757 1300 690 760 1301 692 762 390 689 759 1301 692 762 1302 694 764 391 691 761 1302 694 764 1303 696 766 392 693 763 1303 696 766 1304 698 768 393 695 765 1304 698 768 1305 700 770 394 697 767 1305 700 770 1306 702 772 395 699 769 1306 702 772 1307 704 774 396 701 771 1307 704 774 1308 706 776 397 703 773 1308 706 776 1309 708 778 398 705 775 1309 708 778 1310 710 780 399 707 777 1310 710 780 1311 712 782 400 709 779 1311 712 782 1312 714 784 401 711 781 1312 714 784 1313 716 786 402 713 783 1313 716 786 1314 718 788 403 715 785 1314 718 788 1315 720 790 404 717 787 1315 720 790 1316 722 792 405 719 789 1316 722 792 1317 724 794 406 721 791 1317 724 794 1318 726 796 407 723 793 1318 726 796 1319 728 798 408 725 795 1319 728 798 1320 730 800 409 727 797 1320 730 800 1321 732 802 410 729 799 1321 732 802 1322 734 804 411 731 801 1322 734 804 1323 736 806 412 733 803 1323 736 806 1324 738 808 413 735 805 1324 738 808 1325 740 810 414 737 807 1325 740 810 1326 742 812 415 739 809 1326 742 812 1327 744 814 416 741 811 1327 744 814 1328 746 816 417 743 813 1328 746 816 1329 748 818 418 745 815 1329 748 818 1330 750 820 419 747 817 1330 750 820 1331 752 822 420 749 819 1331 752 822 1332 754 824 421 751 821 1332 754 824 1333 756 826 422 753 823 1333 756 826 1334 758 828 423 755 825 1334 758 828 1335 760 830 424 757 827 1335 760 830 1336 762 832 425 759 829 1336 762 832 1337 764 834 426 761 831 1337 764 834 1241 765 266 427 763 833 1205 504 0 1204 502 0 1178 450 0 1204 502 0 1203 500 0 1179 452 0 1202 498 0 1181 456 0 1203 500 0 1201 496 0 1182 458 0 1202 498 0 1201 496 0 1200 494 0 1183 460 0 1200 494 0 1199 492 0 1185 464 0 1198 490 0 1188 470 0 1199 492 0 1198 490 0 1197 488 0 1189 472 0 1197 488 0 1196 486 0 1192 478 0 1196 486 0 1195 484 0 1193 480 0 1247 255 0 1242 578 0 1248 588 0 1245 584 0 1244 582 0 1247 255 0 1336 762 0 1249 590 0 1337 764 0 1336 762 0 1335 760 0 1251 594 0 1334 758 0 1253 598 0 1335 760 0 1334 758 0 1333 756 0 1254 600 0 1333 756 0 1332 754 0 1255 602 0 1332 754 0 1331 752 0 1256 604 0 1331 752 0 1330 750 0 1257 606 0 1329 748 0 1259 610 0 1330 750 0 1328 746 0 1260 612 0 1329 748 0 1327 744 0 1261 614 0 1328 746 0 1326 742 0 1262 616 0 1327 744 0 1324 738 0 1263 618 0 1325 740 0 1324 738 0 1323 736 0 1263 618 0 1323 736 0 1322 734 0 1264 620 0 1320 730 0 1266 624 0 1321 732 0 1319 728 0 1267 626 0 1320 730 0 1318 726 0 1268 628 0 1319 728 0 1318 726 0 1317 724 0 1268 628 0 1315 720 0 1270 632 0 1316 722 0 1315 720 0 1314 718 0 1270 632 0 1314 718 0 1313 716 0 1271 634 0 1312 714 0 1311 712 0 1272 636 0 1311 712 0 1310 710 0 1273 638 0 1310 710 0 1309 708 0 1274 640 0 1309 708 0 1308 706 0 1275 642 0 1307 704 0 1306 702 0 1276 644 0 1306 702 0 1305 700 0 1277 646 0 1305 700 0 1304 698 0 1278 648 0 1304 698 0 1303 696 0 1279 650 0 1302 694 0 1281 654 0 1303 696 0 1301 692 0 1282 656 0 1302 694 0 1300 690 0 1284 660 0 1301 692 0 1300 690 0 1299 688 0 1286 664 0 1299 688 0 1298 686 0 1289 670 0 1298 686 0 1297 684 0 1291 674 0 1296 682 0 1293 678 0 1297 684 0 1296 682 0 1295 484 0 1293 678 0 237 387 0 238 389 0 330 573 0 236 385 0 237 387 0 235 384 0 239 391 0 328 569 0 238 389 0 240 393 0 327 567 0 239 391 0 240 393 0 241 395 0 327 567 0 241 395 0 242 397 0 326 565 0 244 401 0 324 561 0 243 399 0 245 403 0 323 559 0 244 401 0 246 405 0 322 557 0 245 403 0 321 555 0 322 557 0 247 407 0 320 553 0 321 555 0 248 409 0 319 551 0 320 553 0 249 411 0 318 549 0 319 551 0 250 413 0 317 547 0 318 549 0 251 415 0 316 545 0 317 547 0 252 417 0 253 419 0 315 543 0 252 417 0 313 539 0 314 541 0 254 421 0 255 423 0 312 537 0 254 421 0 310 533 0 311 535 0 256 425 0 309 531 0 310 533 0 257 427 0 308 529 0 309 531 0 258 429 0 307 527 0 308 529 0 259 431 0 260 433 0 306 525 0 259 431 0 260 433 0 261 435 0 305 523 0 262 437 0 303 519 0 261 435 0 263 439 0 302 517 0 262 437 0 264 441 0 300 513 0 263 439 0 265 443 0 299 511 0 264 441 0 266 445 0 298 509 0 265 443 0 267 447 0 297 507 0 266 445 0 268 449 0 295 503 0 267 447 0 269 451 0 294 501 0 268 449 0 270 453 0 293 499 0 269 451 0 270 453 0 271 455 0 293 499 0 271 455 0 272 457 0 292 497 0 274 461 0 290 493 0 273 459 0 284 481 0 285 483 0 283 479 0 276 465 0 289 491 0 275 463 0 283 479 0 286 485 0 282 477 0 277 467 0 278 469 0 289 491 0 280 473 0 287 487 0 279 471 0 337 254 0 338 587 0 332 577 0 338 587 0 339 589 0 427 763 0 342 595 0 425 759 0 341 593 0 342 595 0 343 597 0 425 759 0 345 601 0 423 755 0 344 599 0 346 603 0 422 753 0 345 601 0 347 605 0 421 751 0 346 603 0 348 607 0 420 749 0 347 605 0 419 747 0 420 749 0 349 609 0 418 745 0 419 747 0 350 611 0 417 743 0 418 745 0 351 613 0 416 741 0 417 743 0 352 615 0 414 737 0 415 739 0 353 617 0 354 619 0 413 735 0 353 617 0 355 621 0 412 733 0 354 619 0 410 729 0 411 731 0 356 623 0 409 727 0 410 729 0 357 625 0 408 725 0 409 727 0 358 627 0 359 629 0 407 723 0 358 627 0 359 629 0 360 631 0 406 721 0 361 633 0 404 717 0 360 631 0 362 635 0 403 715 0 361 633 0 363 637 0 401 711 0 362 635 0 364 639 0 400 709 0 363 637 0 365 641 0 399 707 0 364 639 0 366 643 0 398 705 0 365 641 0 367 645 0 396 701 0 366 643 0 368 647 0 395 699 0 367 645 0 369 649 0 394 697 0 368 647 0 335 583 0 337 254 0 334 581 0 370 651 0 393 695 0 369 649 0 382 675 0 383 677 0 387 683 0 384 679 0 385 483 0 383 677 0 370 651 0 371 653 0 393 695 0 382 675 0 387 683 0 381 673 0 371 653 0 372 655 0 392 693 0 380 671 0 388 685 0 379 669 0 373 657 0 374 659 0 391 691 0 377 665 0 389 687 0 376 663 0 1240 574 0 1147 388 0 1145 575 0 1239 572 0 1148 390 0 1240 574 0 1239 572 0 1238 570 0 1148 390 0 1238 570 0 1237 568 0 1149 392 0 1236 566 0 1151 396 0 1237 568 0 1235 564 0 1152 398 0 1236 566 0 1235 564 0 1234 562 0 1153 400 0 1234 562 0 1233 560 0 1154 402 0 1233 560 0 1232 558 0 1155 404 0 1231 556 0 1157 408 0 1232 558 0 1230 554 0 1158 410 0 1231 556 0 1229 552 0 1159 412 0 1230 554 0 1228 550 0 1160 414 0 1229 552 0 1227 548 0 1161 416 0 1228 550 0 1226 546 0 1162 418 0 1227 548 0 1226 546 0 1225 544 0 1162 418 0 1223 540 0 1164 422 0 1224 542 0 1223 540 0 1222 538 0 1164 422 0 1220 534 0 1166 426 0 1221 536 0 1219 532 0 1167 428 0 1220 534 0 1218 530 0 1168 430 0 1219 532 0 1217 528 0 1169 432 0 1218 530 0 1217 528 0 1216 526 0 1169 432 0 1214 522 0 1171 436 0 1215 524 0 1214 522 0 1213 520 0 1171 436 0 1213 520 0 1212 518 0 1172 438 0 1211 516 0 1210 514 0 1173 440 0 1210 514 0 1209 512 0 1174 442 0 1209 512 0 1208 510 0 1175 444 0 1208 510 0 1207 508 0 1176 446 0 1206 506 0 1205 504 0 1177 448 0</p>
                            </polylist>
                        </mesh>
                    </geometry>
                </library_geometries>
                <library_visual_scenes>
                    <visual_scene id="ID9">
                        <node id="ID10" name="miniCG">
                            <translate sid="translate">0 0 -0</translate>
                            <rotate sid="rotateY">0 1 0 0</rotate>
                            <rotate sid="rotateX">1 0 0 0</rotate>
                            <rotate sid="rotateZ">0 0 1 -0</rotate>
                            <scale sid="scale">1 1 1</scale>
                            <instance_geometry url="#ID11">
                                <bind_material>
                                    <technique_common>
                                        <instance_material symbol="Material1" target="#ID7">
                                            <bind_vertex_input semantic="UVSET0" input_semantic="TEXCOORD" input_set="0"/>
                                        </instance_material>
                                        <instance_material symbol="Material2" target="#ID5">
                                            <bind_vertex_input semantic="UVSET0" input_semantic="TEXCOORD" input_set="0"/>
                                        </instance_material>
                                    </technique_common>
                                </bind_material>
                            </instance_geometry>
                        </node>
                    </visual_scene>
                </library_visual_scenes>
                <scene>
                    <instance_visual_scene url="#ID9"/>
                </scene>
            </COLLADA>;
        }
    }
}