/**
 * Copyright nenjiru ( http://wonderfl.net/user/nenjiru )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Pnx
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import net.hires.debug.Stats;
    
    [SWF(frameRate="60", width="465", height="465")]
    
    /**
     * キャラクターチップの実装実験 その3
     * drawRectでフレームアニメーションを行うシェイプ型キャラクターチップを、3000体生成
     * 
     * @author nenjiru
     */
    public class CharacterShapeTest extends Sprite 
    {
        private static const URL:String = "http://assets.wonderfl.net/images/related_images/f/f0/f0d9/f0d908a88f90364e927c41c65ec84590247aeee3";
        
        public function CharacterShapeTest():void 
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE , complete);
            loader.load(new URLRequest(URL), new LoaderContext(true));
        }
        
        private function complete(event:Event):void 
        {
            var loaderInfo:LoaderInfo = event.target as LoaderInfo;
            loaderInfo.removeEventListener(Event.COMPLETE , complete);
            var source:Bitmap = loaderInfo.content as Bitmap;
            draw(source.bitmapData);
            
            source.bitmapData.dispose();
            addChild(new Stats());
        }
        
        private function draw(source:BitmapData):void 
        {
            var chara:CharacterShape;
            var charas:Vector.<CharacterShape> = new Vector.<CharacterShape>();
            
            //3000体生成
            for (var i:int = 0; i < 3000; i++) 
            {
                chara = new CharacterShape(source, 4, 3);
                chara.x = 7 * (i % 65);
                chara.y = 9 * (i / 65 >> 0);
                chara.pattern = 1;
                addChild(chara);
                charas.push(chara);
            }
            
            stage.addEventListener(Event.ENTER_FRAME, function (e:Event):void 
            {
                for (var i:int = 0, n:int = charas.length; i < n; i++) 
                {
                    charas[i].update();
                }
            });
        }
    }
}

import flash.display.BitmapData;
import flash.display.Shape;
import flash.geom.Matrix;

/**
 * キャラクターチップ表示オブジェクト
 * 
 * @author nenjiru
 */
class CharacterShape extends Shape 
{
    private var _row:int;
    private var _col:int;
    private var _frame:int;
    private var _pattern:int;
    
    private var _width:int;
    private var _height:int;
    
    private var _source:BitmapData;
    private var _matrix:Matrix;
    
    /**
     * キャラクターチップ画像と、行列数を指定
     * 
     * @param    source キャラクターチップ画像
     * @param    row 画像の横列（方向パターン）
     * @param    col 画像の縦列（アニメーションフレーム）
     */
    public function CharacterShape(source:BitmapData, row:int, col:int)
    {
        _width = source.width / col >> 0;
        _height = source.height / row >> 0;
        
        _row = row;
        _col = col;
        _source = source.clone();
        
        _matrix = new Matrix(1, 0, 0, 1, 0, 0);
    }
    
    /**
     * 表示横列を示す
     * 
     * アニメーションパターンに相当する
     * 指定行を表示（反映）させるには、 update メソッドを実行する
     */
    public function get pattern():int 
    {
        return _pattern;
    }
    
    public function set pattern(value:int):void 
    {
        if (0 <= value && _row > value)
        {
            _pattern = value;
        }
    }
    
    /**
     * フレームの更新
     * 
     * メソッドを実行するごとに、チップセットの縦列を繰り返し描画してアニメーション表示
     */
    public function update():void 
    {
        _matrix.tx = -(_frame++ % _col) * _width;
        _matrix.ty = -(_pattern * _height);
        
        graphics.clear();
        graphics.beginBitmapFill(_source, _matrix, false);
        graphics.drawRect(0, 0, _width, _height);
        graphics.endFill();
    }
}
