/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4PKD
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.net.*
    import flash.text.*;
    
    public class Main extends Sprite {
        private var txt1:TextField = new TextField(); 
        private var ar:Array;
        private var logar:Array;
        private var gs:GroupSpecifier;//接続グループ機能制限
        private var nc:NetConnection;
        private var group:NetGroup;
        private var reqflg:Boolean;
        private var groupName:String;
        
        private var NETCANVAS_CMD_1LINE:String = "1line";//通信コマンド
        
        private var btn:Btn;
        private var map1:ozmap = new ozmap();
        private var s:Sprite = new Sprite();

        public function Main() {
            
            btn = new Btn();
            btn.init({type:1,width:60});
            btn.text = "scrool";
            btn.x = 125;
            btn.y = 400;
            map1.addChild(btn);
            
            btn.addEventListener(MouseEvent.CLICK,function():void{
                if(btn.text == "scrool"){
                    btn.text = "write";
                    map1.Enabled = true;
                    //マウスイベント
                    map1.field.removeEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
                    map1.field.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
                    map1.field.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
                }
                else{
                    btn.text = "scrool";
                    map1.Enabled = false;
                    //マウスイベント
                    map1.field.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
                    map1.field.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
                    map1.field.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
                }
            });
            
            var btn2:Btn = new Btn();
            btn2.init({typw:1,width:80});
            btn2.text = "full screen";
            btn2.x = 50;
            btn2.y = 400;
            map1.addChild(btn2);
            btn2.addEventListener(MouseEvent.CLICK,function():void{
                if(btn2.text == "full screen"){
                    btn2.text = "normal";
                    stage.displayState = StageDisplayState.FULL_SCREEN;
                }
                else{
                    btn2.text = "full screen";
                    stage.displayState = StageDisplayState.NORMAL;
                }


            });

            
            
            txt1.text = "aaa!;";
            
            // グループ機能制限
            groupName = new String();
            groupName = "net.wonderfl.ozmap.test"
            gs = new GroupSpecifier(groupName);//接続グループ名
            gs.postingEnabled = true;//ポスティング許可
            gs.ipMulticastMemberUpdatesEnabled = true;//IP情報のマルチキャスト許可
            gs.multicastEnabled = true;//NetStreamによるストリーミング許可
            gs.objectReplicationEnabled = true;//オブジェクトの複製許可
            gs.routingEnabled = true;//NetGroupでの転送メソッド許可
            gs.serverChannelEnabled = true;//メンバーへサーバーチャンネルを開く権限を付与
            
            // RTMFPコネクション
            nc = new NetConnection();
            //イベント NET_STATUS
            nc.addEventListener(NetStatusEvent.NET_STATUS, procNetStatus);
            //接続
            nc.connect("rtmfp://p2p.rtmfp.net/3ea2ccfc17227d122a776d41-31e9e4d71a17/");
            logar = new Array();
            reqflg = false;
            

        }
        
        private function initCanvas():void {
            addChild(map1);
            map1.field.addChild(s);
            addChild(txt1);
            txt1.text = group.estimatedMemberCount.toString();
            txt1.width = 400;
            //txt1.text = nc.nearID.toString();
            //txt1.appendText("\n"+nc.nearNonce.toString());
            
            map1.field.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            map1.field.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            map1.field.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            map1.Enabled = false;


            
        }
        
        //マウスダウン　描画開始
        private function onMouseDown(e:MouseEvent):void {
            ar = new Array();
            //ar.push(e.stageX);
            //ar.push(e.stageY);
            ar.push(map1.field.mouseX);
            ar.push(map1.field.mouseY);
            s.graphics.lineStyle(2,0x000000);
            //s.graphics.moveTo(e.stageX, e.stageY);
            s.graphics.moveTo(map1.field.mouseX,map1.field.mouseY);
        }
        //マウス移動　描画
        private function onMouseMove(e:MouseEvent):void {
            if (e.buttonDown) {
                //ar.push(e.stageX);
                //ar.push(e.stageY);
                ar.push(map1.field.mouseX);
                ar.push(map1.field.mouseY);
                s.graphics.lineStyle(2,0x000000);
                //s.graphics.moveTo(e.stageX, e.stageY);
                s.graphics.lineTo(map1.field.mouseX,map1.field.mouseY);
                
            }
        }
        //マウスアップ　描画終了
        private function onMouseUp(e:MouseEvent):void {
            
            group.post({cmd: NETCANVAS_CMD_1LINE, msg: ar});//メッセージ送信
            logar.push(ar);//ログ追加
            ar = null;//クリア
            if (!reqflg) {
                group.addHaveObjects(0, 0);
            }
        }
        //通信イベント
        private function procNetStatus(e:NetStatusEvent):void {
            
           
            var i:int;
            var j:int;
            switch (e.info.code) {
                case "NetConnection.Connect.Success"://接続確立
                    group = new NetGroup(nc, gs.groupspecWithAuthorizations());
                    group.addEventListener(NetStatusEvent.NET_STATUS, procNetStatus);
                    break;
                case "NetGroup.Connect.Success"://グループ接続確立
                    initCanvas();//開始
                    break;
                case "NetGroup.Neighbor.Connect"://メンバー接続
                    if (logar.length == 0) {
                        reqflg = true;
                        group.addWantObjects(0, 0);//同期
                     }
                    break;
                case "NetGroup.Posting.Notify"://メンバーからのポスト受信
                    var obj:Object = e.info.message;//メッセージオブジェクト
                    var ar1:Array = obj.msg;//メッセージ
                    var cmd:String = obj.cmd;//コマンド
                    logar.push(ar1);//メッセージをログに追記
                    group.addHaveObjects(0, 0);//同期
                    if (cmd == NETCANVAS_CMD_1LINE) {
                        var shape:Shape = new Shape();
                        shape.graphics.lineStyle(2, 0x000000);
                        shape.graphics.moveTo(ar1[0], ar1[1]);//ライン開始点
                        for (j = 2; j < ar1.length; j += 2) {
                            shape.graphics.lineTo(ar1[j], ar1[j+1]);
                        }
                        map1.field.addChild(shape);
                    }
                    break;
                case "NetGroup.Replication.Request"://隣接ノードからの要求
                    if (e.info.index == 0) {
                        group.writeRequestedObject(e.info.requestID, {log: logar});
                    }
                    break;
                case "NetGroup.Replication.Fetch.Result"://隣接ノードが要求を満たした
                    if (e.info.index == 0) {
                        reqflg = false;
                        logar = e.info.object.log;
                        group.addHaveObjects(0, 0);
                        var shape0:Shape = new Shape();
                        shape0.graphics.lineStyle(2, 0x000000);
                        for (i = 0; i < logar.length; ++i) {
                            var ar:Array = logar[i];
                            shape0.graphics.moveTo(ar[0], ar[1]);
                            for (j = 2; j < ar.length; j += 2) {
                                shape0.graphics.lineTo(ar[j], ar[j+1]);
                            }
                        }
                        map1.field.addChild(shape0);
                    }
                    break;

            }
        }
    }
}




    import flash.geom.Point;
    import flash.display.*;
    import flash.events.*;
    import flash.utils.*;
    import flash.filters.*;

    class ozmap extends Sprite{
        public var scale:Number = 1;
        
        public var zoom:int;//ホイール回転量反映
        private var scale_A:Number = 1.0;//拡大率
        public var field:Sprite;//フィールド
        
        private var mapFocusX:Number=0;
        private var mapFocusY:Number=0;
        private var scrFocusX:int=0; 
        private var scrFocusY:int=0; 
        private var mX:int=0; 
        private var mY:int=0; 
        
        private var scalingPanel:Sprite;
        private var base:Sprite; 
              
        private var mapscale:int=0;
        private var dragPanel:Shape = new Shape();
        private var onMouseBtn:Boolean;
        private var msk:Sprite = new Sprite();
        
        private var mapMode:Boolean;//マップモード　true:マップ操作ON false:マップ操作OFF
        
        public function get Enabled():Boolean{
            return mapMode;
        }
        public function set Enabled(sw:Boolean):void{
            if(mapMode == sw)return;
            
            mapMode = sw;
            if(mapMode == true){
                field.addEventListener(MouseEvent.MOUSE_DOWN,down1);
                field.addEventListener(MouseEvent.MOUSE_UP,up1);
            }
            else{
                field.removeEventListener(MouseEvent.MOUSE_DOWN,down1);
                field.removeEventListener(MouseEvent.MOUSE_UP,up1);
            }


            
        }


      

        //コンストラクタ 
        public function ozmap():void {
            //カーソル位置描画
            scalingPanel = new Sprite();//ズーム中心 
            addChild(scalingPanel);
            
            
            //マップ基準座標
            base = new Sprite();     
            scalingPanel.addChild(base);
            
            //マップ上への配置
            field = new Sprite();
            field.addEventListener(MouseEvent.MOUSE_DOWN,down1);
            field.addEventListener(MouseEvent.MOUSE_UP,up1);
            mapMode = true;

            addEventListener(MouseEvent.MOUSE_WHEEL,on_wheel);//ホイール操作 
            field.addEventListener(MouseEvent.MOUSE_DOWN,stopZoom);//ズーム停止
            addEventListener(Event.ENTER_FRAME, onFrame);//メインループ
 
            base.addChildAt(field,0); 
            field.addChild(dragPanel);
            
            aaaa();
        }

        public function get fieldScale():int {
            return mapscale;
        }
        
        public function setAreaRect(x:Number,y:Number,width:Number,height:Number):void{
           this.addChild(msk);
           this.x = x;
           this.y = y;
           msk.graphics.beginFill(0xff0000);
           msk.graphics.drawRect(0,0,width,height);
           msk.graphics.endFill();
           this.mask = msk;
        }
        
        
        //ズーム停止
        private function stopZoom(e:MouseEvent):void{
            zoom = 0;
        }



  
        //マップドラッグ
        private var scrOn:Boolean;
        private function down1(e:MouseEvent):void{
            
            scrOn=false;
            onMouseBtn=true;
            e.currentTarget.startDrag();
            addEventListener(MouseEvent.MOUSE_MOVE, onMove);
            e.stopPropagation();//イベントの伝播を止める
        }
        private function up1(e:MouseEvent):void{
            
            onMouseBtn=false;
            e.currentTarget.stopDrag();
            removeEventListener(MouseEvent.MOUSE_MOVE,onMove);
            
           // e.stopPropagation();//イベントの伝播を止める
        }
        
        private function onMove(e:MouseEvent):void{
            aaaa();
        }
    
        //ホイール操作
        private function on_wheel(e:MouseEvent):void {
            zoom += e.delta;
            e.stopPropagation();
        }
  
        //メインループ
        private function onFrame(e:Event):void {
            on_zoom();
            //フルスクリーンでのスクロールモード

            if(stage.displayState == StageDisplayState.FULL_SCREEN){
                var size:Number = 50;
                if(scrOn==true && onMouseBtn==false){
                    if(stage.mouseY < size)field.y -= (stage.mouseY-size)/scale_A/5;
                    else if(this.root.loaderInfo.height-size < stage.mouseY){
                        field.y -= (size+stage.mouseY-this.root.loaderInfo.height)/scale_A/5;                    
                    }
                    if(stage.mouseX < 10)field.x -= (stage.mouseX-10)/scale_A/10;
                    else if(this.root.loaderInfo.width-10 < stage.mouseX){
                        field.x -= (10+stage.mouseX-this.root.loaderInfo.width)/scale_A/10;                    
                    }
                }
                else{
                    if(stage.mouseY < size)scrOn=false;
                    else if(this.root.loaderInfo.height-size < stage.mouseY)scrOn=false;
                    else if(stage.mouseX < 10)scrOn=false;
                    else if(this.root.loaderInfo.width-10 < stage.mouseX)scrOn=false;
                    else scrOn=true;
                }

            }
        }
        
        
        //マップスクロール基準点の更新
        private function aaaa():void{

            if (0 <= zoom) {
                
                
                mX = mouseX; mY = mouseY;//カーソル位置
                //ズーム中心
                scalingPanel.x = mouseX; scalingPanel.y = mouseY; 
                //マップ位置
                base.x -= (mX-scrFocusX)/scale_A; base.y -= (mY-scrFocusY)/scale_A;
                //フォーカス位置
                scrFocusX = mX; scrFocusY = mY;
            }
            else{
                mX = this.root.loaderInfo.width/2; mY = this.root.loaderInfo.height/2;//カーソル位置
                //ズーム中心
                scalingPanel.x =this.root.loaderInfo.width/2; scalingPanel.y = this.root.loaderInfo.height/2; 
                //マップ位置
                base.x -= (mX-scrFocusX)/scale_A; base.y -= (mY-scrFocusY)/scale_A;
                //フォーカス位置
                scrFocusX = mX; scrFocusY = mY;
            }

            //フィールドドラッグ用
            dragPanel.graphics.clear();
            dragPanel.graphics.beginFill(0xff0000,0);
            dragPanel.graphics.drawCircle(-(field.x+field.parent.x)/field.scaleX,-(field.y+field.parent.y)/field.scaleY,600/field.scaleX);
            dragPanel.graphics.endFill();
        }

        
        
        private function on_zoom():void{
            if (zoom != 0) {
                
                aaaa();//基準点更新
                if (zoom < 0) {
                    scale_A *= 1 + (0.005 * zoom);
                }
                else if (0 < zoom) {
                    scale_A *= 1 + (0.005 * zoom);
                }
                
                
                if(2 < scale_A){

                    field.scaleX *= 2;
                    field.scaleY *= 2;
                    scale_A /= 2;
                    field.x += field.x+base.x;
                    field.y += field.y+base.y;
                    
                    mapscale--;
                
                }
                else if(scale_A < 1.0){
             
                    field.x -= (field.x+base.x)/2;
                    field.y -= (field.y+base.y)/2;
                    scale_A *= 2;
                    field.scaleX /= 2;
                    field.scaleY /= 2;
                    
                    mapscale++;
                    
                }
                scale = field.scaleX * scale_A;
                scalingPanel.scaleX = scale_A;
                scalingPanel.scaleY = scale_A;        
            }
          
        }
        
    }
    

    
//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////


import flash.display.*;
import flash.text.*;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var gColor:uint = 0x00ff00;
    private var blueGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function Btn() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        draw();
    }
    private function draw():void {
        
        switch (type) {//カラーパターン
        case 1 ://　White
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :// Black
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        
        blueGlow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(txt);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [blueGlow];
        createBase(base, _width, _height, corner, bColor);
        txt.x = -_width*0.5;
        txt.y = -_height*0.5;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.text = label;
        enabled = true;
        mouseChildren = false;
    }
    
    
    public function get text():String{
        return txt.text;
    }
    public function set text(str:String):void{
        txt.text = str;
    }


    
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        txt.y = -_height*0.5;
        txt.textColor = upColor;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        txt.y = -_height*0.5;
        txt.textColor = overColor;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = overColor;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = offColor;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        enabled = !_clicked;
        if (_clicked) {
            _down();
        } else {
            _up();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}

