/**
 * Copyright GreekFellows ( http://wonderfl.net/user/GreekFellows )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4P5B
 */

package 
{
    import adobe.utils.CustomActions;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.GeolocationEvent;
    import flash.events.MouseEvent;
    import flash.filters.GlowFilter;
    import flash.geom.Matrix3D;
    import flash.geom.Vector3D;
    
    /**
     * ...
     * @author Greek Fellows
     */
    public class Main extends Sprite 
    {
        private var sprite:Sprite;
        private var core:Sprite;
        
        private var array:Array;
        private var colors:Array;
        private var radii:Array;
        private var zsorted:Array;
        
        private var parameters:Array;
        
        private var field:Number;
        
        public function Main():void 
        {
            this.array = [];
            this.colors = [];
            this.radii = [];
            this.zsorted = [];
            
            this.parameters = [];
            
            this.field = 400;
            
            init();
            
            var bg:Sprite = new Sprite();
            bg.graphics.beginFill(0xffffff, 0);
            bg.graphics.drawRect(0, 0, 465, 465);
            bg.graphics.endFill();
            this.addChild(bg);
            
            this.sprite = new Sprite();
            this.sprite.x = 465/2;
            this.sprite.y = 465/2;
            this.sprite.z = 0;
            this.addChild(this.sprite);
            
            this.core=new Sprite();
            this.core.x = 0;
            this.core.y = 0;
            this.core.z = 0;
            this.sprite.addChild(this.core);
            
            this.addEventListener(Event.ENTER_FRAME, spin);
            this.addEventListener(Event.ENTER_FRAME, orbitalize);
        }
        
        private function init():void {
            // change array here
            this.array = [];
            
            for (var creation:int = 0; creation < 50; creation++) {
                this.array.push( { vector:new Vector3D(Math.floor(Math.random() * this.field) - this.field / 2, Math.floor(Math.random() * this.field) - this.field / 2, Math.floor(Math.random() * this.field) - this.field / 2), color:Math.floor(Math.random() * 0xffffff / 5) * 5, radius:Math.random() * 45 + 5 } );
                this.parameters.push( { a:Math.floor(Math.random() * 360), b:Math.floor(Math.random() * 360), c:Math.floor(Math.random() * 360), d:Math.random() * 2, e:Math.random() * 3, f:Math.random() * 2.5 } );
            }
        }
        
        private    function spin(e:Event):void {
            this.core.transform.matrix3D.appendRotation((mouseY - 300) / 100, Vector3D.X_AXIS);
            this.core.transform.matrix3D.appendRotation((mouseX - 400) / 100, Vector3D.Y_AXIS);
            
            this.sprite.graphics.clear();
            
            sortbyZ();
            
            for (var a:int = 0; a < this.zsorted.length; a++) {
                this.sprite.graphics.beginFill(this.zsorted[a].color, .75);
                this.sprite.graphics.drawCircle(graph(this.zsorted[a].vector, false).x, graph(this.zsorted[a].vector, false).y, this.zsorted[a].radius);
                this.sprite.graphics.endFill();
            }
        }
        
        private function orbitalize(e:Event):void {
            for (var ex:int = 0; ex < this.array.length; ex++) {
                this.array[ex].vector.x = Math.sin(this.parameters[ex].a * Math.PI / 180) * field * 4 / 10;
                this.array[ex].vector.y = Math.sin(this.parameters[ex].b * Math.PI / 180) * field * 4 / 10;
                this.array[ex].vector.z = Math.sin(this.parameters[ex].c * Math.PI / 180) * field * 4 / 10;
                this.parameters[ex].a += this.parameters[ex].d;
                this.parameters[ex].b += this.parameters[ex].e;
                this.parameters[ex].c += this.parameters[ex].f;
            }
        }
        
        private function graph(vector:Vector3D,transformVector:Boolean=true):Vector3D {
            var mat:Matrix3D = this.core.transform.matrix3D.clone();
            
            var xy:Vector3D = vector;
            if (transformVector) xy = mat.transformVector(vector);
            xy.w = (750 + xy.z) / 750;
            xy.project();
            
            return xy;
        }
        
        private function sortbyZ():void {
            this.zsorted = [];
            var mat:Matrix3D = this.core.transform.matrix3D.clone();
            
            for (var b:int = 0; b < this.array.length; b++) {
                this.zsorted.push( { vector:mat.transformVector(this.array[b].vector), color:this.array[b].color, radius:this.array[b].radius, z:mat.transformVector(this.array[b].vector).z } );
            }
            
            this.zsorted.sortOn("z", Array.NUMERIC | Array.DESCENDING);
        }
        
    }
    
}