/**
 * Copyright dimitris.1972g ( http://wonderfl.net/user/dimitris.1972g )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4OmI
 */

// forked from ProjectNya's FLVPlayer Test (1)
////////////////////////////////////////////////////////////////////////////////
// FLVPlayer Test (1)
//
// [AS3.0] FLVPlayerに挑戦！ (3)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1432
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.system.Security;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.events.TweenEvent;
    import org.libspark.betweenas3.easing.*;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var player:FLVPlayer;
        private var playPauseBtn:PlayPauseBtn;
        private var stopBtn:StopBtn;
        private var muteBtn:MuteBtn;
        private var seekBar:SeekBar;
        private var timeLabel:TimeLabel;
        private var loading:Sprite;
        private static var basePath:String = "http://www.project-nya.jp/images/flash/";
        private static var flvPath:String = "flv/movie.flv";

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            var label:Label = new Label(200, 20, 16);
            addChild(label);
            label.textColor = 0x333333;
            label.text = "FLVPlayer";
            label.x = 36;
            label.y = 48;
            //
            Security.allowDomain("www.project-nya.jp");
            Security.loadPolicyFile("http://www.project-nya.jp/crossdomain.xml");
            //
            player = new FLVPlayer(400, 300);
            addChild(player);
            player.x = 32;
            player.y = 72;
            controller();
            player.playPauseBtn = playPauseBtn;
            player.stopBtn = stopBtn;
            player.muteBtn = muteBtn;
            seekBar.initialize(280);
            player.seekBar = seekBar;
            player.timeLabel = timeLabel;
            player.autoPlay = false;
            player.addEventListener(Event.INIT, initialize, false, 0, true);
            player.source = basePath + flvPath;
        }
        private function initialize(evt:Event):void {
            player.removeEventListener(Event.INIT, initialize);
            fade();
        }
        private function fade():void {
            var itween:ITween = BetweenAS3.to(loading, {alpha: 0, visible: 0}, 0.8, Linear.easeNone);
            itween.addEventListener(TweenEvent.COMPLETE, faded, false, 0, true);
            itween.play();
        }
        private function faded(evt:TweenEvent):void {
            evt.target.removeEventListener(TweenEvent.COMPLETE, faded);
            removeChild(loading);
            loading = null;
            player.start();
        }
        private function controller():void {
            playPauseBtn = new PlayPauseBtn();
            addChild(playPauseBtn);
            playPauseBtn.x = 48;
            playPauseBtn.y = 394;
            //
            stopBtn = new StopBtn();
            addChild(stopBtn);
            stopBtn.x = 84;
            stopBtn.y = 394;
            //
            muteBtn = new MuteBtn();
            addChild(muteBtn);
            muteBtn.x = 416;
            muteBtn.y = 394;
            //
            seekBar = new SeekBar();
            addChild(seekBar);
            seekBar.x = 110;
            seekBar.y = 390;
            //
            timeLabel = new TimeLabel();
            addChild(timeLabel);
            timeLabel.x = 316;
            timeLabel.y = 394;
            //
            loading = new Sprite();
            addChild(loading);
            loading.x = 32;
            loading.y = 72;
            loading.graphics.beginFill(0xEEEEEE);
            loading.graphics.drawRect(0, 0, 400, 300);
            loading.graphics.endFill();
        }
        
    }

}


//////////////////////////////////////////////////
// FLVPlayerクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.net.NetConnection;
import flash.net.NetStream;
import flash.media.Video;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.events.NetStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.events.AsyncErrorEvent;

class FLVPlayer extends Sprite {
    public var id:uint;
    private var _connection:NetConnection;
    private var _stream:NetStream;
    private var _client:StreamClient;
    private var flvPath:String;
    private var vw:uint;
    private var vh:uint;
    private var _video:Video;
    private var _playPauseBtn:PlayPauseBtn;
    private var _stopBtn:StopBtn;
    private var _muteBtn:MuteBtn;
    private var _seekBar:SeekBar;
    private var _timeLabel:TimeLabel;
    private var initialized:Boolean = false;
    private var duration:Number = 0;
    private var _percent:Number = 0;
    private var completed:Boolean = false;
    public var autoPlay:Boolean = false;
    public var autoRewind:Boolean = false;
    public var autoLoop:Boolean = false;

    public function FLVPlayer(w:uint, h:uint) {
        vw = w;
        vh = h;
        init();
    }

    private function init():void {
        _video = new Video(vw, vh);
        addChild(_video);
        _video.smoothing = true;
        _connection = new NetConnection();
        _connection.addEventListener(NetStatusEvent.NET_STATUS, ncNetStatus, false, 0, true);
        _connection.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityError, false, 0, true);
        //_connection.connect(null);
    }
    public function set playPauseBtn(btn:PlayPauseBtn):void {
        _playPauseBtn = btn;
        _playPauseBtn.addEventListener(MouseEvent.CLICK, playPause, false, 0, true);
        _playPauseBtn.enabled = false;
    }
    public function set stopBtn(btn:StopBtn):void {
        _stopBtn = btn;
        _stopBtn.addEventListener(MouseEvent.CLICK, stop, false, 0, true);
        _stopBtn.enabled = false;
    }
    public function set muteBtn(btn:MuteBtn):void {
        _muteBtn = btn;
        _muteBtn.enabled = true;
    }
    public function set seekBar(bar:SeekBar):void {
        _seekBar = bar;
        _seekBar.addEventListener(SeekBar.PRESS, press, false, 0, true);
        _seekBar.addEventListener(SeekBar.DRAG, drag, false, 0, true);
        _seekBar.addEventListener(SeekBar.RELEASE, release, false, 0, true);
        _seekBar.enabled = false;
    }
    public function set timeLabel(label:TimeLabel):void {
        _timeLabel = label;
    }
    public function set source(path:String):void {
        flvPath = path;
        _connection.connect(null);
    }
    private function ncNetStatus(evt:NetStatusEvent):void {
        switch (evt.info.code) {
            case "NetConnection.Connect.Success" :    //接続成功
                initialize();
                break;
            case "NetConnection.Connect.Failed" :    //接続失敗
                break;
            case "NetConnection.Connect.Rejected" :    //接続拒否
                break;
            case "NetConnection.Connect.Closed" :    //接続(正常)切断
                break;
        }
    }
    private function securityError(evt:SecurityErrorEvent):void {
        trace(evt.text);
    }
    private function initialize():void {
        _client = new StreamClient();
        _client.addEventListener(Event.INIT, onMetaData, false, 0, true);
        _stream = new NetStream(_connection);
        _stream.bufferTime = 5;
        _stream.addEventListener(NetStatusEvent.NET_STATUS, nsNetStatus, false, 0, true);
        _stream.addEventListener(AsyncErrorEvent.ASYNC_ERROR, asyncError, false, 0, true);
        _stream.client = _client;
        _video.attachNetStream(_stream);
        load();
    }
    private function onMetaData(evt:Event):void {
        duration = evt.target.duration;
        setup();
    }
    private function load():void {
        _stream.play(flvPath);
        _stream.pause();
        addEventListener(Event.ENTER_FRAME, progress, false, 0, true);
    }
    private function progress(evt:Event):void {
        var loaded:Number = _stream.bytesLoaded/_stream.bytesTotal;
        _seekBar.progress = loaded;
        if (loaded >= 1) {
            removeEventListener(Event.ENTER_FRAME, progress);
        }
    }
    private function nsNetStatus(evt:NetStatusEvent):void {
        switch (evt.info.code) {
            case "NetStream.Buffer.Full" :
                break;
            case "NetStream.Buffer.Flush" :
                break;
            case "NetStream.Buffer.Empty" :
                break;
            case "NetStream.Play.Start" :
                setup();
                break;
            case "NetStream.Play.Stop" :
                complete();
                break;
            case "NetStream.Play.StreamNotFound" :
                break;
            case "NetStream.Pause.Notify" :
                break;
            case "NetStream.Seek.Notify" :
                break;
            case "NetStream.Seek.InvalidTime" :
                break;
        }
    }
    private function asyncError(evt:AsyncErrorEvent):void {
        trace(evt.text);
    }
    private function setup():void {
        if (duration > 0) {
            if (!initialized) {
                _muteBtn.setup(_stream);
                _timeLabel.initialize(duration);
                initialized = true;
                dispatchEvent(new Event(Event.INIT));
            }
        }
    }
    public function start():void {
        _playPauseBtn.enabled = true;
        _seekBar.enabled = true;
        stop();
        if (autoPlay) play();
    }
    private function playPause(evt:MouseEvent):void {
        if (!_playPauseBtn.playing) {
            play();
        } else {
            pause();
        }
    }
    private function play():void {
        _playPauseBtn.playing = true;
        _stopBtn.enabled = true;
        if (completed) rewind();
        _stream.resume();
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    private function pause():void {
        removeEventListener(Event.ENTER_FRAME, update);
        _playPauseBtn.playing = false;
        _stopBtn.enabled = true;
        _stream.pause();
    }
    private function stop(evt:MouseEvent = null):void {
        removeEventListener(Event.ENTER_FRAME, update);
        _playPauseBtn.playing = false;
        _stopBtn.enabled = false;
        _stream.pause();
        rewind();
    }
    private function complete():void {
        removeEventListener(Event.ENTER_FRAME, update);
        if (!autoLoop) {
            _playPauseBtn.playing = false;
            _stopBtn.enabled = false;
            percent = 1;
        } else {
            rewind();
            play();
        }
    }
    private function seek(p:Number):void {
        _stream.seek(duration*p);
        percent = p;
    }
    private function rewind():void {
        _stream.pause();
        seek(0);
    }
    private function update(evt:Event):void {
        percent = _stream.time/duration;
    }
    private function press(evt:Event):void {
        removeEventListener(Event.ENTER_FRAME, update);
        _stream.pause();
    }
    private function drag(evt:Event):void {
        percent = _seekBar.percent;
    }
    private function release(evt:Event):void {
        seek(percent = _seekBar.percent);
        if (_playPauseBtn.playing) {
            play();
        } else {
            pause();
        }
    }
    private function get percent():Number {
        return _percent;
    }
    private function set percent(param:Number):void {
        _percent = param;
        if (_percent >= 1) {
            _percent = 1;
            completed = true;
        } else {
            completed = false;
        }
        _seekBar.percent = _percent;
        _timeLabel.setup(duration*_percent);
    }

}


//////////////////////////////////////////////////
// StreamClientクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.events.Event;

class StreamClient extends EventDispatcher {
    public var duration:Number;

    public function StreamClient() {
    }

    public function onMetaData(info:Object):void {
        duration = info.duration;
        dispatchEvent(new Event(Event.INIT));
    }

}


//////////////////////////////////////////////////
// PlayPauseBtnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.events.MouseEvent;
import flash.geom.ColorTransform;

class PlayPauseBtn extends Sprite {
    public var id:uint;
    private var base:Shape;
    private var playIcon:Shape;
    private var pauseIcon:Shape;
    private static var baseColor:uint = 0x000000;
    private static var iconColor:uint = 0xFFFFFF;
    private static var upColor:uint = 0x333333;
    private static var overColor:uint = 0x666666;
    private static var offColor:uint = 0xCCCCCC;
    private static var upColorTrans:ColorTransform;
    private static var overColorTrans:ColorTransform;
    private static var offColorTrans:ColorTransform;
    private var _enabled:Boolean = true;
    private var _playing:Boolean = false;

    public function PlayPauseBtn() {
        init();
    }

    private function init():void {
        upColorTrans = new ColorTransform();
        upColorTrans.color = upColor;
        overColorTrans = new ColorTransform();
        overColorTrans.color = overColor;
        offColorTrans = new ColorTransform();
        offColorTrans.color = offColor;
        draw();
        up();
        enabled = true;
        mouseChildren = false;
        playing = false;
    }
    private function rollOver(evt:MouseEvent = null):void {
        //gotoAndStop("over");
        over();
    }
    private function rollOut(evt:MouseEvent = null):void {
        //gotoAndStop("up");
        up();
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            //gotoAndStop("up");
            up();
        } else {
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            //gotoAndStop("disable");
            disable();
        }
    }
    public function get playing():Boolean {
        return _playing;
    }
    public function set playing(param:Boolean):void {
        _playing = param;
        playIcon.visible = !_playing;
        pauseIcon.visible = _playing;
    }
    private function up():void {
        base.transform.colorTransform = upColorTrans;
    }
    private function over():void {
        base.transform.colorTransform = overColorTrans;
    }
    private function disable():void {
        base.transform.colorTransform = offColorTrans;
    }
    private function draw():void {
        base = new Shape();
        addChild(base);
        base.graphics.beginFill(baseColor);
        base.graphics.drawRect(-16, -12, 32, 24);
        base.graphics.endFill();
        //
        playIcon = new Shape();
        addChild(playIcon);
        playIcon.graphics.beginFill(iconColor);
        playIcon.graphics.moveTo(-2, -5);
        playIcon.graphics.lineTo(-2, 5);
        playIcon.graphics.lineTo(4, 0);
        playIcon.graphics.lineTo(-2, -5);
        playIcon.graphics.endFill();
        pauseIcon = new Shape();
        addChild(pauseIcon);
        pauseIcon.graphics.beginFill(iconColor);
        pauseIcon.graphics.drawRect(-3, -4, 2, 8);
        pauseIcon.graphics.drawRect(1, -4, 2, 8);
        pauseIcon.graphics.endFill();
    }

}


//////////////////////////////////////////////////
// StopBtnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.events.MouseEvent;
import flash.geom.ColorTransform;

class StopBtn extends Sprite {
    public var id:uint;
    private var base:Shape;
    private var stopIcon:Shape;
    private static var baseColor:uint = 0x000000;
    private static var iconColor:uint = 0xFFFFFF;
    private static var upColor:uint = 0x333333;
    private static var overColor:uint = 0x666666;
    private static var offColor:uint = 0xCCCCCC;
    private static var upColorTrans:ColorTransform;
    private static var overColorTrans:ColorTransform;
    private static var offColorTrans:ColorTransform;
    private var _enabled:Boolean = true;

    public function StopBtn() {
        init();
    }

    private function init():void {
        upColorTrans = new ColorTransform();
        upColorTrans.color = upColor;
        overColorTrans = new ColorTransform();
        overColorTrans.color = overColor;
        offColorTrans = new ColorTransform();
        offColorTrans.color = offColor;
        draw();
        up();
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent = null):void {
        //gotoAndStop("over");
        over();
    }
    private function rollOut(evt:MouseEvent = null):void {
        //gotoAndStop("up");
        up();
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            //gotoAndStop("up");
            up();
        } else {
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            //gotoAndStop("disable");
            disable();
        }
    }
    private function draw():void {
        base = new Shape();
        addChild(base);
        base.graphics.beginFill(baseColor);
        base.graphics.drawRect(-16, -12, 32, 24);
        base.graphics.endFill();
        //
        stopIcon = new Shape();
        addChild(stopIcon);
        stopIcon.graphics.beginFill(iconColor);
        stopIcon.graphics.drawRect(-3, -3, 6, 6);
        stopIcon.graphics.endFill();
    }
    private function up():void {
        base.transform.colorTransform = upColorTrans;
    }
    private function over():void {
        base.transform.colorTransform = overColorTrans;
    }
    private function disable():void {
        base.transform.colorTransform = offColorTrans;
    }

}


//////////////////////////////////////////////////
// MuteBtnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.events.MouseEvent;
import flash.net.NetStream;
import flash.media.SoundTransform;
import flash.geom.ColorTransform;

class MuteBtn extends Sprite {
    public var id:uint;
    private var base:Shape;
    private var onIcon:Shape;
    private var offIcon:Shape;
    private static var baseColor:uint = 0x000000;
    private static var iconColor:uint = 0xFFFFFF;
    private static var upColor:uint = 0x333333;
    private static var overColor:uint = 0x666666;
    private static var offColor:uint = 0xCCCCCC;
    private static var upColorTrans:ColorTransform;
    private static var overColorTrans:ColorTransform;
    private static var offColorTrans:ColorTransform;
    private var _enabled:Boolean = true;
    private var _mute:Boolean = false;
    private var stream:NetStream;

    public function MuteBtn() {
        init();
    }

    private function init():void {
        upColorTrans = new ColorTransform();
        upColorTrans.color = upColor;
        overColorTrans = new ColorTransform();
        overColorTrans.color = overColor;
        offColorTrans = new ColorTransform();
        offColorTrans.color = offColor;
        draw();
        up();
        enabled = true;
        mouseChildren = false;
        mute = false;
    }
    public function setup(ns:NetStream):void {
        stream = ns;
        mute = _mute;
    }
    private function rollOver(evt:MouseEvent = null):void {
        //gotoAndStop("over");
        over();
    }
    private function rollOut(evt:MouseEvent = null):void {
        //gotoAndStop("up");
        up();
    }
    private function click(evt:MouseEvent = null):void {
        mute = !mute;
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
            //gotoAndStop("up");
            up();
        } else {
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.CLICK, click);
            //gotoAndStop("disable");
            disable();
        }
    }
    public function get mute():Boolean {
        return _mute;
    }
    public function set mute(param:Boolean):void {
        _mute = param;
        onIcon.visible = !_mute;
        offIcon.visible = _mute;
        if (_mute) {
            if (stream) stream.soundTransform = new SoundTransform(0);
        } else {
            if (stream) stream.soundTransform = new SoundTransform(1);
        }
    }
    private function up():void {
        base.transform.colorTransform = upColorTrans;
    }
    private function over():void {
        base.transform.colorTransform = overColorTrans;
    }
    private function disable():void {
        base.transform.colorTransform = offColorTrans;
    }
    private function draw():void {
        base = new Shape();
        addChild(base);
        base.graphics.beginFill(baseColor);
        base.graphics.drawRect(-16, -12, 32, 24);
        base.graphics.endFill();
        //
        onIcon = new SoundIcon(true);
        addChild(onIcon);
        offIcon = new SoundIcon(false);
        addChild(offIcon);
    }

}


class SoundIcon extends Shape {
    private var type:Boolean;
    private static var iconColor:uint = 0xFFFFFF;
    private var ring:Ring;

    public function SoundIcon(t:Boolean) {
        type = t;
        draw();
    }

    private function draw():void {
        graphics.beginFill(iconColor);
        graphics.moveTo(-9, -3);
        graphics.lineTo(-6, -3);
        graphics.lineTo(-2, -6);
        graphics.lineTo(-2, 6);
        graphics.lineTo(-6, 3);
        graphics.lineTo(-9, 3);
        graphics.endFill();
        if (type) drawLine();
    }
    private function drawLine():void {
        ring = new Ring(graphics);
        ring.draw(iconColor, -8, 0, 10, 9, 50, -25);
        ring.draw(iconColor, -8, 0, 12.5, 11.5, 50, -25);
        ring.draw(iconColor, -8, 0, 15, 14, 50, -25);
    }

}

import flash.display.Graphics;
import flash.geom.Point;

class Ring {
    private var target:Graphics;

    public function Ring(g:Graphics) {
        target = g;
    }

    public function draw(color:uint, x:Number, y:Number, outerRadius:Number, innerRadius:Number, degree:Number=360, fromDegree:Number=0, split:Number=36):void {
        var points:Array = getRingPoints(x, y, outerRadius, innerRadius, degree, fromDegree, split);
        target.beginFill(color);
        drawLines(points, true);
        target.endFill();
    }
    private function drawLines(points:Array, close:Boolean=false):void {
        var max:Number = points.length;
        target.moveTo(points[0].x, points[0].y);
        for (var n:uint = 1; n < max; n++) {
            target.lineTo(points[n].x, points[n].y);
        }
        if (close) target.lineTo(points[0].x, points[0].y);
    }
    private function getRingPoints(x:Number, y:Number, outerRadius:Number, innerRadius:Number, degree:Number=360, fromDegree:Number=0, split:Number=36):Array {
        var fromRad:Number = fromDegree * Math.PI/180;
        var dr:Number = (degree* Math.PI/180)/split;
        var pt:Point;
        var max:int = split +1;
        var rad:Number;
        var points:Array = new Array();
        for (var n:uint = 0; n < max; n++) {
            pt = new Point();
            rad = fromRad + dr*n;
            pt.x = Math.cos(rad)*outerRadius + x;
            pt.y = Math.sin(rad)*outerRadius + y;
            points.push(pt);
        }
        var points2:Array = new Array();
        for (n = 0; n < max; n++) {
            pt = new Point();
            rad = fromRad + dr*n;
            pt.x = Math.cos(rad)*innerRadius + x;
            pt.y = Math.sin(rad)*innerRadius + y;
            points2.push(pt);
        }
        points2.reverse();
        points = points.concat(points2);
        return points;
    }

}


//////////////////////////////////////////////////
// SeekBarクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;

class SeekBar extends Sprite {
    public var id:uint;
    private var base:Sprite;
    private var thumb:Sprite;
    private var prog:Sprite;
    private var bar:Sprite;
    private static var baseColor:uint = 0x333333;
    private static var progColor:uint = 0x00FFFFF;
    private static var barColor:uint = 0xFFFFFFF;
    private var _width:uint = 0;
    private var _progress:Number = 0;
    private var _percent:Number = 0;
    private var _enabled:Boolean = true;
    private var clickPoint:Number;
    public static const PRESS:String = "press";
    public static const DRAG:String = "drag";
    public static const RELEASE:String = "release";

    public function SeekBar() {
        //init();
    }

    private function init():void {
        enabled = true;
        thumb.mouseChildren = false;
        bar.mouseChildren = false;
        bar.mouseEnabled = false;
        prog.mouseChildren = false;
        prog.mouseEnabled = false;
        base.buttonMode = false;
        base.mouseChildren = false;
        base.useHandCursor = false;
        progress = 0;
        percent = 0;
        clickPoint = 0;
    }
    public function initialize(w:uint):void {
        _width = w;
        draw();
        init();
    }
    private function press(evt:MouseEvent):void {
        thumb.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        stage.addEventListener(MouseEvent.MOUSE_UP, releaseOutside, false, 0, true);
        stage.addEventListener(Event.MOUSE_LEAVE, leave, false, 0, true);
        clickPoint = thumb.mouseX;
        stage.addEventListener(MouseEvent.MOUSE_MOVE, drag, false, 0, true);
        dispatchEvent(new Event(PRESS));
    }
    private function release(evt:MouseEvent = null):void {
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, drag);
        dispatchEvent(new Event(RELEASE));
    }
    private function releaseOutside(evt:MouseEvent):void {
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, drag);
        dispatchEvent(new Event(RELEASE));
    }
    private function leave(evt:Event):void {
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, drag);
        dispatchEvent(new Event(RELEASE));
    }
    private function drag(evt:MouseEvent):void {
        thumb.x = thumb.parent.mouseX - clickPoint;
        if (thumb.x < 0) thumb.x = 0;
        if (thumb.x > _width) thumb.x = _width;
        percent = thumb.x/_width;
        evt.updateAfterEvent();
        dispatchEvent(new Event(DRAG));
    }
    private function click(evt:MouseEvent):void {
        percent = thumb.parent.mouseX/_width;
        if (thumb.x < 0) thumb.x = 0;
        if (thumb.x > _width) thumb.x = _width;
        percent = thumb.x/_width;
        dispatchEvent(new Event(RELEASE));
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        thumb.buttonMode = _enabled;
        thumb.mouseEnabled = _enabled;
        thumb.useHandCursor = _enabled;
        base.mouseEnabled = _enabled;
        if (_enabled) {
            thumb.addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            base.addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            thumb.removeEventListener(MouseEvent.MOUSE_DOWN, press);
            base.removeEventListener(MouseEvent.CLICK, click);
        }
    }
    public function get progress():Number {
        return _progress;
    }
    public function set progress(param:Number):void {
        _progress = param;
        prog.scaleX = _progress;
    }
    public function get percent():Number {
        return _percent;
    }
    public function set percent(param:Number):void {
        _percent = param;
        bar.scaleX = _percent;
        thumb.x = _width*_percent;
    }
    private function draw():void {
        base = new Sprite();
        addChild(base);
        base.graphics.beginFill(baseColor);
        base.graphics.drawRect(-2, -4, _width + 4, 8);
        base.graphics.endFill();
        //
        thumb = new Sprite();
        addChild(thumb);
        thumb.graphics.beginFill(barColor, 0);
        thumb.graphics.drawRect(-10, -15, 20, 30);
        thumb.graphics.endFill();
        prog = new Sprite();
        addChild(prog);
        prog.graphics.beginFill(progColor, 0.3);
        prog.graphics.drawRect(0, -2, _width, 4);
        prog.graphics.endFill();
        bar = new Sprite();
        addChild(bar);
        bar.graphics.beginFill(barColor);
        bar.graphics.drawRect(0, -2, _width, 4);
        bar.graphics.endFill();
    }

}


//////////////////////////////////////////////////
// TimeLabelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;

class TimeLabel extends Sprite {
    private var time:Label;
    private var total:Label;
    private static var tColor:uint = 0x333333;
    private static var fontType:String = "_ゴシック";
    private static var _height:uint = 12;

    public function TimeLabel() {
        init();
    }

    private function init():void {
        draw();
        time.text = "00:00";
        total.text = "00:00";
    }
    public function set textColor(param:uint):void {
        time.textColor = param;
        total.textColor = param;
    }
    public function initialize(param:Number):void {
        total.text = getTime(param);
    }
    public function setup(param:Number):void {
        time.text = getTime(param);
    }
    private function getTime(param:Number):String {
        var minutes:uint = uint(param/60);
        var seconds:uint = uint(param%60);
        var time:String = fixTime(minutes) + ":" + fixTime(seconds);
        return time;
    }
    private function fixTime(param:uint):String {
        var time:String = String("0" + param).substr(-2);
        return time;
    }
    private function draw():void {
        time = new Label(32, 20, 10);
        addChild(time);
        time.x = 0;
        time.textColor = tColor;
        var label:Label = new Label(4, 20, 10);
        addChild(label);
        label.x = 32;
        label.textColor = tColor;
        label.text = "/";
        total = new Label(32, 20, 10);
        addChild(total);
        total.x = 40;
        total.textColor = tColor;
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}
