/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Nmx
 */

// forked from zahir's 速度測定テンプレート2
package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.utils.getTimer;

    [SWF(width="465",height="465")]
    public class Instrumentation extends Sprite
    {
        private var event:Event;
        private var runsLen:int = 10;
        private var runCount:int = 0;
        private var t:TextField;
        private var recodes:Array;
        
        private const LOOP:int = 100000000;
        
        private function exec(first:Boolean = false):void
        {
            var i:int = 0;
            var time1:int;
            var time2:int;
            var count:int = 0;
            
            if(first) recodes = [];
            
            // ここから処理
            var a:Number = 1;
            var n:Number = 0;
            
            time1 = getTimer();
            for(i=0;i<LOOP;i++)
            {
                n = a * -1;
            }
            time2 = getTimer() - time1;
            if(first) recodes[count++] = new RecodeData( "a * -1", time2, n + "" );
            else (recodes[count++] as RecodeData).time = time2;
            
            time1 = getTimer();
            for(i=0;i<LOOP;i++)
            {
                n = -a;
            }
            time2 = getTimer() - time1;
            if(first) recodes[count++] = new RecodeData( "-a", time2, n + "" );
            else (recodes[count++] as RecodeData).time = time2;
            
            // ここまで処理
            
            /* TEMPLETE
            
            time1 = getTimer();
            for(i=0;i<LOOP;i++)
            {
                
            }
            time2 = getTimer() - time1;
            if(first) recodes[count++] = new RecodeData( "", time2, "" );
            else (recodes[count++] as RecodeData).time = time2;
            
            //*/
            runCount++;
            var _loop:String = LOOP.toString().replace( /([0-9]+?)(?=(?:[0-9]{3})+$)/g , "$1," );
            t.text = "各 " + _loop + " 回ループ を " + runCount  + " 回実行しました。\n\n";
            
            if( recodes.length ) listUp();
            
            t.appendText("clickで再計算");
            
            if(event){
                runsLen--;
                trace(runsLen);
                if(runsLen <= 0) return;
                dispatchEvent( event );
            }
        }
        
        public function Instrumentation()
        {
            addChild( (t = new TextField() ) ).width = t.height = 465;
            
            addEventListener( MouseEvent.CLICK, onClick);
            
            /* ある程度回数を回したいとき用
            
            addEventListener("ex", onRun);
            event = new Event("ex");
            
            //*/
            
            exec(true);
        }
        private function onClick( e:MouseEvent ):void
        {
            exec();
        }
        
        private function onRun(e:Event):void
        {
            exec();
        }
        
        private function listUp():void
        {
            var str:String = "";
            var recode:Array = copy();
            recode.sortOn( "time", Array.NUMERIC );
            
            var max:int = (recode[ recode.length - 1 ] as RecodeData).time;
            for( var i:int = 0, len:int = recode.length; i<len; i++)
            {
                var data:RecodeData = recode[i] as RecodeData;
                var n:int = max / data.time * 100;
                str += data.title + " :: " + data.time + " ms\n\t\t最低速に比べて約 " + n + " %高速 \n";
                if(data.message == "") str += "\n";
                else str += "\t\t" + data.message  + "\n\n";
            }
            t.appendText( str );
        }
        
        private function copy():Array
        {
            var arr:Array = [];
            for(var i:int = 0, len:int = recodes.length; i<len; i++){
                arr[i] = recodes[i];
            }
            return arr;
        }
    }
}
class RecodeData
{
    private var count:int = 0;
    public var title:String = "";
    private var _time:uint;
    public var message:String = "";
    
    public function RecodeData( title:String, time:int, message:String = "" )
    {
        this.title = title;
        this.time = time;
        this.message = message;
    }
    
    public function get time():int
    {
        return _time / count;
    }
    
    public function set time( value:int ):void
    {
        _time += value;
        count++;
    }
}