/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4Nld
 */


package {
    import flash.ui.Keyboard;
    import flash.geom.*;
    import flash.display.*;
    import flash.utils.ByteArray;
    import flash.events.*;
    import flash.text.TextField;
    import com.adobe.utils.AGALMiniAssembler;
    import flash.display3D.*;
    import flash.display3D.textures.Texture;
    
    public class FlashTest extends Sprite {
        
      
        
        public function FlashTest() {
 
          var i:int;
           var a:xActor;
           var k:int;
           
           
            colmap = new xColMap();
          
            colmap.initGrid(32,32);
          
            vecAct = new Vector.<xActor>(0, false);
            
            k = 0;
           for (i = 0; i < 32; i++)
           {
             a = new xActor();
             k += 1; if (k > 8) { k = 0;}
             a.cx = k * 32;
             a.cy = 32 + (i % 8)*32;
             a.colmap = colmap;
             a.id = i;
             vecAct.push(a);
           }//nexti
          
          stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public var colmap:xColMap;
        public var vecAct:Vector.<xActor>;
        
      
        
        public function onEnter(e:Event):void
        {
        
            graphics.clear();
            graphics.lineStyle(2,0);
            
            var mx:Number;
            var my:Number;
            
            mx = stage.mouseX;
            my = stage.mouseY;
            
            graphics.drawCircle(mx, my, 8);
            
            var i:int;
            var num:int;
            var a:xActor;
            
            num = vecAct.length;
            
            for (i = 0; i < num; i++)
            {
              a = vecAct[i];
              
              a.fx = mx;
              a.fy = my;
              
              a.update();
              
              graphics.drawCircle(a.cx, a.cy, 4);
            
            }//nexti
        
        }//onenter
      
      
    }//classend
}

import flash.display.Bitmap;
import flash.display.BitmapData;

internal class xColMap
{
  public var vecGrid:Vector.<int>;
  public var mwidth:int = 0;
  public var mheight:int = 0;
  public var cw:Number = 32;
  public var ch:Number = 32;
  
  public function xColMap()
  {}//ctor
  
  
  public function clear():void
  {
    vecGrid = null; mwidth = 0; mheight = 0;
  }//clear
  
  
  public function initGrid(mw:int, mh:int):void
  {
    var num:int;
    
    mwidth = mw;
    mheight = mh;
    num = mwidth * mheight;
    
    vecGrid = new Vector.<int>(num, false);
  }//initgrid
  
  
  public function setBlock(wx:Number, wy:Number, id:int):void
  {
    var tx:int;
    var ty:int;
    var t:int;
    
    tx = Math.floor(wx / cw);
    ty = Math.floor(wy / ch);
  
    if (tx < 0) { return ; }
    if (tx >= mwidth) { return ; }
    if (ty < 0) { return ; }
    if (ty >= mheight) { return ; }
  
    t = tx + (ty * mwidth);
   
    vecGrid[t] = id;
  }//setblock

  
  public function getBlock(wx:Number, wy:Number):int
  {
    var tx:int;
    var ty:int;
    var t:int;
    
    tx = Math.floor(wx / cw);
    ty = Math.floor(wy / ch);
  
    if (tx < 0) { return 0; }
    if (tx >= mwidth) { return 0; }
    if (ty < 0) { return 0; }
    if (ty >= mheight) { return 0; }
  
    t = tx + (ty * mwidth);
   
    return vecGrid[t];
  }//getblock
  

}//colmap



internal class xActor
{
  public var cx:Number = 0;
  public var cy:Number = 0;
  public var vx:Number = 0;
  public var vy:Number = 0;
  public var id:int = 0;
  
  
  
  public var colmap:xColMap = null; //ptr to a collision map
  
  public var fx:Number = 0;
  public var fy:Number = 0;
  
  
  public function xActor()
  {
  
  }//ctor

  public function update():void
  {
  
    if (cx < fx -16) { vx = 1;}
    else if (cx > fx +16) { vx = -1; }
    else { vx = 0;}
    
    if (cy < fy -16) { vy = 1;}
    else if (cy > fy +16) { vy = -1; }
    else { vy = 0;}
    
  
    var dx:Number;
    var dy:Number;
    var d:int;
    
    dx = cx + vx;
    dy = cy + vy;
    
    d = colmap.getBlock(dx, dy);
    
    if (d != 0 && d != id )
    {
        return;
    }
    else 
    {
     colmap.setBlock(cx, cy, 0);
      cx = dx;
      cy = dy;
     colmap.setBlock(cx, cy, id);
    }
    
  }//update



}//xactor

