/**
 * Copyright hacker_iqf76yye ( http://wonderfl.net/user/hacker_iqf76yye )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/4NW9
 */

// forked from actionscriptbible's Chapter 38 Example 2
package {
  import flash.display.*;
  import flash.events.Event;
  import flash.events.MouseEvent;
  import flash.filters.ShaderFilter;
  import flash.geom.Point;
  import flash.media.*;
  import flash.net.*;
  import flash.utils.getTimer;
  
  [SWF(width="500",height="500",frameRate="30",backgroundColor="#000000")]
  public class Orenoclass extends Sprite {
    protected var holder:Sprite;
    protected var video:Video;
    protected var testPattern:Loader;
    protected var noise:BitmapData;
    
    protected var shader:Shader;
    protected var shaderFilter:ShaderFilter;
    
    protected var smoothRandomNoise:BitmapData;
    protected var pointers:Vector.<Point>;
    protected var rands:Vector.<Number>;
    
    public function Orenoclass() {
      noise = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0);
      holder = new Sprite();
      video = new Video(stage.stageWidth/2, stage.stageHeight/2);
      video.scaleX = video.scaleY = 2;
      var webcamu:Camera = Camera.getCamera();
      webcamu.setMode(stage.stageWidth/2, stage.stageWidth/2, stage.frameRate, false);
      video.attachCamera(webcamu);
      testPattern = new Loader();
      testPattern.blendMode = BlendMode.ADD;
      testPattern.alpha = 0;
      holder.addChild(video);
      holder.addChild(testPattern);
      addChild(holder);
      stage.quality = StageQuality.HIGH;
      
      smoothRandomNoise = new BitmapData(300, 10, false, 0);
      smoothRandomNoise.perlinNoise(Math.random()*100, Math.random()*100, 4,
        int((new Date()).date) * int(1000*Math.random()), true, true, 7);
      pointers = new Vector.<Point>(12);
      rands = new Vector.<Number>(12);
      for (var i:int = 0; i < 12; i++)
        pointers[i] = (new Point(
          Math.random()*smoothRandomNoise.width,
          Math.random()*smoothRandomNoise.height));
      
      var PBJURL:String = "http://actionscriptbible.com/files/badreception.pbj";
      var loader:URLLoader = new URLLoader(new URLRequest(PBJURL));
      loader.dataFormat = URLLoaderDataFormat.BINARY;
      loader.addEventListener(Event.COMPLETE, onBytecodeLoaded);
      
      var IMGURL:String = "http://actionscriptbible.com/files/testpattern.jpg";
      testPattern.load(new URLRequest(IMGURL));
      testPattern.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageLoaded);
    }
    protected function onBytecodeLoaded(event:Event):void {
      shader = new Shader(URLLoader(event.target).data);
      shaderFilter = new ShaderFilter(shader);
      shader.data.noiseImage.input = noise;
      shader.data.srcImage.input = noise; 
      shader.data.dimensions.value = [noise.width, noise.height];

      stage.fullScreenSourceRect = noise.rect;
      stage.addEventListener(Event.ENTER_FRAME, go);
    }
    protected function onImageLoaded(event:Event):void {
      testPattern.width = noise.width;
      testPattern.height = noise.height;
    }

    protected function go(event:Event):void {
      noise.noise(getTimer(), 0, 255, 7, true);
      for (var i:int = 0; i < pointers.length; i++) {
        var p:Point = pointers[i];
        p.x = (int(p.x) + 2*(1+i)) % smoothRandomNoise.width;
        rands[i] = smoothRandomNoise.getPixel(p.x, p.y) / 0x00ffffff;
      }
      
      var sd:ShaderData = shader.data;
      testPattern.alpha = Math.max(0, rands[6] * 3 - 2);
      sd.noisyHDisplace.value = [Math.pow(rands[2],4)*40];
      sd.vRoll.value = [rands[0] * 80 - 20];
      sd.channelSplit.value = [rands[3] * 40 - 10];
      sd.sinHDisplaceAmplitudes.value = [20.0, 2.0, 1.0];
      sd.sinHDisplaceFrequencies.value = [rands[2]*2+0.4, rands[10]*4+4, rands[11]*8+8];
      sd.sinHDisplace.value = [Math.pow(rands[2], 8) * 100];
      sd.noiseLayer.value = [Math.pow(rands[10], 4) * 0.8];
      sd.blackoutThresh.value = [rands[2]*0.3];
      holder.filters = [shaderFilter];
    }
  }
}